/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.coverage;

import com.google.common.base.Preconditions;
import com.intellij.javascript.testFramework.coverage.LcovCoverageReport;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CoverageSerializationUtils {
    private static final String SOURCE_FILE_PREFIX = "SF:";
    private static final String LINE_HIT_PREFIX = "DA:";
    private static final String END_OF_RECORD = "end_of_record";

    public static LcovCoverageReport readLCOV(@Nullable File baseDir, @NotNull File lcovFile) throws IOException {
        if (lcovFile == null) {
            CoverageSerializationUtils.$$$reportNull$$$0(0);
        }
        return CoverageSerializationUtils.readLCOV(lcovFile, baseDir, (Function<? super String, String>)FunctionUtil.id());
    }

    public static LcovCoverageReport readLCOV(@NotNull File lcovFile, @Nullable File localBaseDir, @NotNull Function<? super String, String> toLocalPathConvertor) throws IOException {
        if (lcovFile == null) {
            CoverageSerializationUtils.$$$reportNull$$$0(1);
        }
        if (toLocalPathConvertor == null) {
            CoverageSerializationUtils.$$$reportNull$$$0(2);
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(lcovFile));){
            String line;
            String currentFileName = null;
            ArrayList<LcovCoverageReport.LineHits> lineDataList = null;
            LcovCoverageReport report = new LcovCoverageReport();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(SOURCE_FILE_PREFIX)) {
                    currentFileName = (String)toLocalPathConvertor.fun((Object)line.substring(SOURCE_FILE_PREFIX.length()));
                    lineDataList = new ArrayList<LcovCoverageReport.LineHits>();
                    continue;
                }
                if (line.startsWith(LINE_HIT_PREFIX)) {
                    if (lineDataList == null) {
                        throw new RuntimeException("lineDataList is null!");
                    }
                    String[] values = line.substring(LINE_HIT_PREFIX.length()).split(",");
                    Preconditions.checkState((values.length == 2 ? 1 : 0) != 0);
                    int lineNum = Integer.parseInt(values[0]);
                    int hitCount = Integer.parseInt(values[1]);
                    LcovCoverageReport.LineHits lineHits = new LcovCoverageReport.LineHits(lineNum, hitCount);
                    lineDataList.add(lineHits);
                    continue;
                }
                if (!END_OF_RECORD.equals(line)) continue;
                if (lineDataList == null) {
                    throw new RuntimeException("lineDataList is null!");
                }
                Preconditions.checkNotNull((Object)currentFileName);
                report.mergeFileReport(localBaseDir, currentFileName, lineDataList);
                currentFileName = null;
                lineDataList = null;
            }
            Preconditions.checkState((lineDataList == null ? 1 : 0) != 0);
            LcovCoverageReport lcovCoverageReport = report;
            return lcovCoverageReport;
        }
    }

    public static void writeLCOV(@NotNull LcovCoverageReport report, @NotNull File outputFile) throws IOException {
        if (report == null) {
            CoverageSerializationUtils.$$$reportNull$$$0(3);
        }
        if (outputFile == null) {
            CoverageSerializationUtils.$$$reportNull$$$0(4);
        }
        try (PrintWriter out = new PrintWriter(outputFile);){
            for (Map.Entry<String, List<LcovCoverageReport.LineHits>> entry : report.getInfo().entrySet()) {
                out.print(SOURCE_FILE_PREFIX);
                out.println(entry.getKey());
                for (LcovCoverageReport.LineHits lineHits : entry.getValue()) {
                    out.print(LINE_HIT_PREFIX);
                    out.print(lineHits.getLineNumber());
                    out.print(',');
                    out.println(lineHits.getHits());
                }
                out.println(END_OF_RECORD);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lcovFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toLocalPathConvertor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "report";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/testFramework/coverage/CoverageSerializationUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readLCOV";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "writeLCOV";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

