/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.util;

import com.google.common.collect.ImmutableList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class JSTestNamePattern {
    private final List<Range> myRanges;

    public JSTestNamePattern(@NotNull List<Range> ranges) {
        if (ranges == null) {
            JSTestNamePattern.$$$reportNull$$$0(0);
        }
        this.myRanges = ImmutableList.copyOf(ranges);
    }

    @NotNull
    public List<Range> getRanges() {
        List<Range> list2 = this.myRanges;
        if (list2 == null) {
            JSTestNamePattern.$$$reportNull$$$0(1);
        }
        return list2;
    }

    public String toString() {
        return this.myRanges.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSTestNamePattern that = (JSTestNamePattern)o;
        return this.myRanges.equals(that.myRanges);
    }

    public int hashCode() {
        return this.myRanges.hashCode();
    }

    @NotNull
    public static JSTestNamePattern literalPattern(@NotNull String name) {
        if (name == null) {
            JSTestNamePattern.$$$reportNull$$$0(2);
        }
        return new JSTestNamePattern(Collections.singletonList(new Literal(name)));
    }

    @NotNull
    public static List<JSTestNamePattern> toLiteralList(@NotNull List<String> names) {
        if (names == null) {
            JSTestNamePattern.$$$reportNull$$$0(3);
        }
        List list2 = ContainerUtil.map(names, s -> JSTestNamePattern.literalPattern(s));
        if (list2 == null) {
            JSTestNamePattern.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    public static JSTestNamePattern normalizeAndCreate(@NotNull List<Range> ranges) {
        if (ranges == null) {
            JSTestNamePattern.$$$reportNull$$$0(5);
        }
        ArrayList<Range> result2 = new ArrayList<Range>();
        Literal currentLiteralRange = null;
        AnyText currentAnyRange = null;
        for (Range range : ranges) {
            if (range instanceof Literal) {
                Literal literalRange = (Literal)range;
                currentLiteralRange = currentLiteralRange != null ? new Literal(currentLiteralRange.getLiteral() + literalRange.getLiteral()) : literalRange;
                ContainerUtil.addIfNotNull(result2, (Object)currentAnyRange);
                currentAnyRange = null;
                continue;
            }
            AnyText anyRange = (AnyText)range;
            currentAnyRange = currentAnyRange != null ? new AnyText(currentAnyRange.myDebugPattern + "+" + anyRange.myDebugPattern) : anyRange;
            ContainerUtil.addIfNotNull(result2, (Object)currentLiteralRange);
            currentLiteralRange = null;
        }
        ContainerUtil.addIfNotNull(result2, currentAnyRange);
        ContainerUtil.addIfNotNull(result2, currentLiteralRange);
        return new JSTestNamePattern(result2);
    }

    @NotNull
    public static JSTestNamePattern pattern(Range ... ranges) {
        if (ranges == null) {
            JSTestNamePattern.$$$reportNull$$$0(6);
        }
        return new JSTestNamePattern(Arrays.asList(ranges));
    }

    @NotNull
    public static Literal literalRange(@NotNull String name) {
        if (name == null) {
            JSTestNamePattern.$$$reportNull$$$0(7);
        }
        return new Literal(name);
    }

    @NotNull
    public static AnyText anyRange(@NotNull String debugPattern) {
        if (debugPattern == null) {
            JSTestNamePattern.$$$reportNull$$$0(8);
        }
        return new AnyText(debugPattern);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/util/JSTestNamePattern";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/util/JSTestNamePattern";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRanges";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toLiteralList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "literalPattern";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toLiteralList";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "normalizeAndCreate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "pattern";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "literalRange";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "anyRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Literal
    implements Range {
        private final String myLiteral;

        public Literal(@NotNull String literal) {
            if (literal == null) {
                Literal.$$$reportNull$$$0(0);
            }
            this.myLiteral = literal;
        }

        @NotNull
        public String getLiteral() {
            String string = this.myLiteral;
            if (string == null) {
                Literal.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Literal literal = (Literal)o;
            return this.myLiteral.equals(literal.myLiteral);
        }

        public int hashCode() {
            return Objects.hash(this.myLiteral);
        }

        public String toString() {
            return "literal=" + this.myLiteral;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "literal";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/testFramework/util/JSTestNamePattern$Literal";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/testFramework/util/JSTestNamePattern$Literal";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLiteral";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class AnyText
    implements Range {
        private final String myDebugPattern;

        public AnyText(@NotNull String debugPattern) {
            if (debugPattern == null) {
                AnyText.$$$reportNull$$$0(0);
            }
            this.myDebugPattern = debugPattern;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnyText text = (AnyText)o;
            return this.myDebugPattern.equals(text.myDebugPattern);
        }

        public int hashCode() {
            return Objects.hash(this.myDebugPattern);
        }

        public String toString() {
            return "any(" + this.myDebugPattern + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugPattern", "com/intellij/javascript/testFramework/util/JSTestNamePattern$AnyText", "<init>"));
        }
    }

    public static interface Range {
    }
}

