/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.web.webTypes;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.javascript.nodejs.npm.AvailablePackageVersions;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryService;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.javascript.web.symbols.WebSymbolsRegistryManager;
import com.intellij.javascript.web.symbols.impl.WebSymbolsRegistryManagerImpl;
import com.intellij.javascript.web.webTypes.WebTypesJsonFilesCache;
import com.intellij.javascript.web.webTypes.WebTypesLoadUtilKt;
import com.intellij.javascript.web.webTypes.WebTypesNpmLoader;
import com.intellij.javascript.web.webTypes.WebTypesNpmLoader$getWebTypes$;
import com.intellij.javascript.web.webTypes.WebTypesVersionsRegistry;
import com.intellij.javascript.web.webTypes.json.WebTypes;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.text.SemVer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="WebTypesNpmLoader", storages={@Storage(value="web-types-npm-loader.xml")})
@Service
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\b\u0001\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003$%&B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0014\u001a\u00020\u0005H\u0002J\b\u0010\u0015\u001a\u00020\u0002H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0017\u001a\u00020\bH\u0002J\u001c\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0018\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0002H\u0016J\u0014\u0010\u001f\u001a\u0004\u0018\u00010\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\bH\u0002J\b\u0010 \u001a\u00020\u001dH\u0002J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u0005H\u0002J\b\u0010#\u001a\u00020\u001dH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R6\u0010\n\u001a*\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\f0\u000bj\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\f`\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006'"}, d2={"Lcom/intellij/javascript/web/webTypes/WebTypesNpmLoader;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "()V", "myState", "Lcom/intellij/javascript/web/webTypes/WebTypesNpmLoader$State;", "pluginCache", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "", "Lcom/intellij/javascript/web/webTypes/json/WebTypes;", "pluginLoadMap", "Ljava/util/HashMap;", "Lcom/intellij/javascript/web/webTypes/WebTypesNpmLoader$FutureResultProvider;", "Lkotlin/collections/HashMap;", "stateTimestamp", "", "webTypesEnabledPackages", "", "getWebTypesEnabledPackages", "()Ljava/util/Set;", "createNewState", "getState", "getWebTypes", "fileUrl", "packageName", "packageVersion", "Lcom/intellij/util/text/SemVer;", "getWebTypesNoCache", "loadState", "", "stateElement", "normalizePackageName", "triggerUpdateIfNeeded", "updateState", "state", "updated", "Companion", "FutureResultProvider", "State", "intellij.javascript.web"})
public final class WebTypesNpmLoader
implements PersistentStateComponent<Element> {
    private State myState = new State(new WebTypesVersionsRegistry<String>(), SetsKt.emptySet());
    private volatile long stateTimestamp;
    private HashMap<String, FutureResultProvider<WebTypes>> pluginLoadMap = new HashMap();
    private LoadingCache<String, WebTypes> pluginCache;
    @NotNull
    public static final String WEB_TYPES_FILE_SUFFIX = ".web-types.json";
    private static final Logger LOG;
    private static final String WEB_TYPES_ENABLED_PACKAGES_URL = "https://raw.githubusercontent.com/JetBrains/web-types/master/packages/registry.json";
    private static final Regex WEB_TYPES_PKG_NAME_REPLACE_PATTERN;
    private static final String PACKAGE_PREFIX = "@web-types";
    private static final long STATE_UPDATE_INTERVAL;
    @NotNull
    public static final Companion Companion;

    private final Set<String> getWebTypesEnabledPackages() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.myState.getEnabledPackages();
    }

    @NotNull
    public Element getState() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.myState.toElement();
    }

    public void loadState(@NotNull Element stateElement) {
        Intrinsics.checkNotNullParameter((Object)stateElement, (String)"stateElement");
        this.updateState(new State(stateElement));
    }

    private final void updateState(State state2) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (Intrinsics.areEqual((Object)this.myState, (Object)state2) ^ true) {
            Application application = ApplicationManager.getApplication();
            Function0<Unit> $fun$replaceStateAndNotify$1 = new Function0<Unit>(this, state2){
                final /* synthetic */ WebTypesNpmLoader this$0;
                final /* synthetic */ State $state;

                public final void invoke() {
                    WebTypesNpmLoader.access$setMyState$p(this.this$0, this.$state);
                    WebTypesNpmLoader.access$updated(this.this$0);
                }
                {
                    this.this$0 = webTypesNpmLoader;
                    this.$state = state2;
                    super(0);
                }
            };
            Application application2 = application;
            Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"application");
            if (application2.isWriteAccessAllowed()) {
                $fun$replaceStateAndNotify$1.invoke();
            } else {
                Function0 function0 = (Function0)new Function0<Unit>($fun$replaceStateAndNotify$1){
                    final /* synthetic */ updateState.1 $replaceStateAndNotify$1;

                    public final void invoke() {
                        this.$replaceStateAndNotify$1.invoke();
                    }
                    {
                        this.$replaceStateAndNotify$1 = var1_1;
                        super(0, null, "replaceStateAndNotify", "invoke()V", 0);
                    }
                };
                application.invokeLaterOnWriteThread(new Runnable(function0){
                    private final /* synthetic */ Function0 function;
                    {
                        this.function = function0;
                    }

                    public final /* synthetic */ void run() {
                        Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
                    }
                });
            }
        }
    }

    private final WebTypes getWebTypes(String packageName, SemVer packageVersion) {
        WebTypes webTypes;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        String webTypesPackageName = this.normalizePackageName(packageName);
        this.triggerUpdateIfNeeded();
        String string = this.myState.getAvailableVersions().get("@web-types/" + webTypesPackageName, packageVersion);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            webTypes = this.getWebTypes(it);
        } else {
            webTypes = null;
        }
        return webTypes;
    }

    private final String normalizePackageName(String packageName) {
        String string;
        String string2 = packageName;
        if (string2 != null) {
            CharSequence charSequence = string2;
            Regex regex = WEB_TYPES_PKG_NAME_REPLACE_PATTERN;
            String string3 = "at-$1-$2";
            boolean bl = false;
            string = regex.replace(charSequence, string3);
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final WebTypes getWebTypes(String fileUrl) {
        FutureResultProvider<WebTypes> futureResultProvider;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        Object object = this.pluginLoadMap;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            void loadingSkipped;
            block8: {
                boolean bl3 = false;
                WebTypes webTypes = (WebTypes)this.pluginCache.getIfPresent((Object)fileUrl);
                if (webTypes == null) break block8;
                WebTypes webTypes2 = webTypes;
                boolean bl4 = false;
                boolean bl5 = false;
                WebTypes it = webTypes2;
                boolean bl6 = false;
                this.pluginLoadMap.remove(fileUrl);
                WebTypes webTypes3 = it;
                return webTypes3;
            }
            futureResultProvider = this.pluginLoadMap.computeIfAbsent(fileUrl, new Function(this, fileUrl, (Ref.BooleanRef)loadingSkipped){
                final /* synthetic */ WebTypesNpmLoader this$0;
                final /* synthetic */ String $fileUrl$inlined;
                final /* synthetic */ Ref.BooleanRef $loadingSkipped$inlined;
                {
                    this.this$0 = webTypesNpmLoader;
                    this.$fileUrl$inlined = string;
                    this.$loadingSkipped$inlined = booleanRef;
                }

                @NotNull
                public final FutureResultProvider<WebTypes> apply(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return new FutureResultProvider<WebTypes>(new Callable(this){
                        final /* synthetic */ getWebTypes$$inlined$synchronized$lambda$1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final WebTypes call() {
                            void var1_1;
                            Object object = WebTypesNpmLoader.access$getPluginCache$p(this.this$0.this$0).get((Object)this.this$0.$fileUrl$inlined);
                            Intrinsics.checkNotNull((Object)object);
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pluginCache.get(fileUrl)!!");
                            WebTypes result2 = (WebTypes)object;
                            if (this.this$0.$loadingSkipped$inlined.element) {
                                WebTypesNpmLoader.access$updated(this.this$0.this$0);
                            }
                            return var1_1;
                        }
                    });
                }
            });
        }
        WebTypes webTypes = futureResultProvider.getResult();
        if (webTypes != null) {
            object = webTypes;
            bl = false;
            boolean bl7 = false;
            Object it = object;
            boolean bl8 = false;
            HashMap<String, FutureResultProvider<WebTypes>> hashMap = this.pluginLoadMap;
            boolean bl9 = false;
            boolean bl10 = false;
            synchronized (hashMap) {
                boolean bl11 = false;
                FutureResultProvider<WebTypes> futureResultProvider2 = this.pluginLoadMap.remove(fileUrl);
            }
            return it;
        }
        loadingSkipped.element = true;
        return null;
    }

    private final void updated() {
        ProjectManager projectManager = ProjectManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
        Project[] projectArray = projectManager.getOpenProjects();
        int n = projectArray.length;
        for (int j = 0; j < n; ++j) {
            Project project;
            Project project2 = project = projectArray[j];
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
            WebSymbolsRegistryManager webSymbolsRegistryManager = WebSymbolsRegistryManager.Companion.getInstance(project2);
            if (webSymbolsRegistryManager == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.javascript.web.symbols.impl.WebSymbolsRegistryManagerImpl");
            }
            ((WebSymbolsRegistryManagerImpl)webSymbolsRegistryManager).scheduleRefresh();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final WebTypes getWebTypesNoCache(String fileUrl) {
        String string = fileUrl;
        Object object = string;
        if (string == null) return null;
        String string2 = object;
        boolean bl = false;
        boolean bl2 = false;
        String it = string2;
        boolean bl3 = false;
        InputStream inputStream = WebTypesJsonFilesCache.Companion.getWebTypesJson(it);
        object = inputStream;
        if (inputStream == null) return null;
        WebTypes webTypes = WebTypesLoadUtilKt.readWebTypes((InputStream)object);
        return webTypes;
    }

    private final void triggerUpdateIfNeeded() {
        block3: {
            block2: {
                if (this.stateTimestamp + STATE_UPDATE_INTERVAL >= System.currentTimeMillis()) break block2;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                if (!application.isUnitTestMode()) break block3;
            }
            return;
        }
        this.stateTimestamp = System.currentTimeMillis();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this){
            final /* synthetic */ WebTypesNpmLoader this$0;

            public final void run() {
                State state2;
                try {
                    state2 = WebTypesNpmLoader.access$createNewState(this.this$0);
                }
                catch (IOException e) {
                    WebTypesNpmLoader.access$getLOG$cp().warn(e.getMessage());
                    return;
                }
                State newState = state2;
                ReadAction.run((ThrowableRunnable)new ThrowableRunnable(this, newState){
                    final /* synthetic */ triggerUpdateIfNeeded.1 this$0;
                    final /* synthetic */ State $newState;

                    public final void run() {
                        WebTypesNpmLoader.access$updateState(this.this$0.this$0, this.$newState);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$newState = state2;
                    }
                });
            }
            {
                this.this$0 = webTypesNpmLoader;
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    private final State createNewState() {
        v0 = ApplicationManager.getApplication().executeOnPooledThread((Callable)createNewState.enabledPackagesFuture.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"ApplicationManager.getAp\u2026\n        e\n      }\n    })");
        enabledPackagesFuture = v0;
        var3_2 = false;
        packageInfo = new ArrayList<E>();
        NpmRegistryService.getInstance().findPackages(null, NpmRegistryService.fullTextSearch("@web-types"), 50, (Condition<NodePackageBasicInfo>)((Condition)createNewState.1.INSTANCE), (Consumer<NodePackageBasicInfo>)new Consumer(packageInfo){
            final /* synthetic */ List $packageInfo;

            public final void consume(NodePackageBasicInfo it) {
                NodePackageBasicInfo nodePackageBasicInfo = it;
                Intrinsics.checkNotNullExpressionValue((Object)nodePackageBasicInfo, (String)"it");
                this.$packageInfo.add(nodePackageBasicInfo);
            }
            {
                this.$packageInfo = list2;
            }
        });
        packagesInfo = ((StreamEx)StreamEx.of((Collection)packageInfo).parallel()).map((Function)createNewState.packagesInfo.1.INSTANCE).mapToEntry((Function)createNewState.packagesInfo.2.INSTANCE).nonNullValues().toList();
        availableVersions = new WebTypesVersionsRegistry<String>();
        v1 = packagesInfo;
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"packagesInfo");
        $this$forEach$iv = v1;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            $dstr$pkgName$value = (Map.Entry)element$iv;
            $i$a$-forEach-WebTypesNpmLoader$createNewState$3 = false;
            var11_15 = $dstr$pkgName$value;
            var12_16 = false;
            var13_17 = (String)var11_15.getKey();
            var11_15 = $dstr$pkgName$value;
            var12_16 = false;
            v2 = value = (AvailablePackageVersions)var11_15.getValue();
            Intrinsics.checkNotNull((Object)v2);
            v3 = EntryStream.of((Map)v2.getVersionsInfo()).filter((Predicate)createNewState.3.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"EntryStream.of(value!!.v\u2026ted && info.url != null }");
            var11_15 = (Iterable)v3;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                $dstr$version$info = (Map.Entry)element$iv;
                $i$a$-forEach-WebTypesNpmLoader$createNewState$3$2 = false;
                var19_23 = $dstr$version$info;
                var20_24 = false;
                var21_25 = (SemVer)var19_23.getKey();
                var19_23 = $dstr$version$info;
                var20_24 = false;
                info = (AvailablePackageVersions.VersionInfo)var19_23.getValue();
                v4 = pkgName;
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"pkgName");
                v5 = version;
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"version");
                v6 = info;
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"info");
                v7 = v6.getUrl();
                Intrinsics.checkNotNull((Object)v7);
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"info.url!!");
                availableVersions.put((String)v4, (SemVer)v5, v7);
            }
        }
        v8 = (Serializable)enabledPackagesFuture.get();
        if (v8 == null) ** GOTO lbl-1000
        var6_8 = v8;
        var7_10 = false;
        var8_12 = false;
        it = var6_8;
        $i$a$-let-WebTypesNpmLoader$createNewState$enabledPackages$1 = false;
        var11_15 = it;
        if (var11_15 instanceof Exception) {
            throw (Throwable)it;
        }
        if (var11_15 instanceof String) {
            v9 = new ObjectMapper().readTree((String)it);
            if (!(v9 instanceof ObjectNode)) {
                v9 = null;
            }
            v10 = (ObjectNode)v9;
        } else {
            v10 = null;
        }
        v8 = v10;
        if (v10 != null && (v8 = v8.fields()) != null && (v8 = SequencesKt.asSequence((Iterator)v8)) != null && (v8 = SequencesKt.mapNotNull((Sequence)v8, (Function1)createNewState.enabledPackages.2.INSTANCE)) != null && (v8 = SequencesKt.flatMap((Sequence)v8, (Function1)createNewState.enabledPackages.3.INSTANCE)) != null && (v8 = SequencesKt.mapNotNull((Sequence)v8, (Function1)createNewState.enabledPackages.4.INSTANCE)) != null) {
            v11 = SequencesKt.toSet((Sequence)v8);
        } else lbl-1000:
        // 2 sources

        {
            v11 = null;
        }
        if ((v12 = (enabledPackages = v11)) == null) {
            v12 = SetsKt.emptySet();
        }
        return new State(availableVersions, v12);
    }

    public WebTypesNpmLoader() {
        LoadingCache loadingCache = Caffeine.newBuilder().maximumSize(20L).expireAfterAccess(30L, TimeUnit.MINUTES).build(new CacheLoader(this){
            final /* synthetic */ WebTypesNpmLoader this$0;

            @Nullable
            public final WebTypes load(String it) {
                return WebTypesNpmLoader.access$getWebTypesNoCache(this.this$0, it);
            }
            {
                this.this$0 = webTypesNpmLoader;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"Caffeine.newBuilder()\n  \u2026 getWebTypesNoCache(it) }");
        this.pluginCache = loadingCache;
        this.triggerUpdateIfNeeded();
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(WebTypesNpmLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(WebTypesNpmLoader::class.java)");
        LOG = logger;
        WEB_TYPES_PKG_NAME_REPLACE_PATTERN = new Regex("^@(.*)/(.*)$");
        STATE_UPDATE_INTERVAL = TimeUnit.MINUTES.toMillis(10L);
    }

    public static final /* synthetic */ State access$getMyState$p(WebTypesNpmLoader $this) {
        return $this.myState;
    }

    public static final /* synthetic */ void access$setMyState$p(WebTypesNpmLoader $this, State state2) {
        $this.myState = state2;
    }

    public static final /* synthetic */ void access$updated(WebTypesNpmLoader $this) {
        $this.updated();
    }

    public static final /* synthetic */ LoadingCache access$getPluginCache$p(WebTypesNpmLoader $this) {
        return $this.pluginCache;
    }

    public static final /* synthetic */ void access$setPluginCache$p(WebTypesNpmLoader $this, LoadingCache loadingCache) {
        $this.pluginCache = loadingCache;
    }

    public static final /* synthetic */ State access$createNewState(WebTypesNpmLoader $this) {
        return $this.createNewState();
    }

    public static final /* synthetic */ void access$updateState(WebTypesNpmLoader $this, State state2) {
        $this.updateState(state2);
    }

    public static final /* synthetic */ WebTypes access$getWebTypesNoCache(WebTypesNpmLoader $this, String fileUrl) {
        return $this.getWebTypesNoCache(fileUrl);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B#\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0006\u0010\u0014\u001a\u00020\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/intellij/javascript/web/webTypes/WebTypesNpmLoader$State;", "", "availableVersions", "Lcom/intellij/javascript/web/webTypes/WebTypesVersionsRegistry;", "", "enabledPackages", "", "(Lcom/intellij/javascript/web/webTypes/WebTypesVersionsRegistry;Ljava/util/Set;)V", "root", "Lorg/jdom/Element;", "(Lorg/jdom/Element;)V", "getAvailableVersions", "()Lcom/intellij/javascript/web/webTypes/WebTypesVersionsRegistry;", "getEnabledPackages", "()Ljava/util/Set;", "equals", "", "other", "hashCode", "", "toElement", "Companion", "intellij.javascript.web"})
    private static final class State {
        @NotNull
        private final WebTypesVersionsRegistry<String> availableVersions;
        @NotNull
        private final Set<String> enabledPackages;
        @NotNull
        public static final String WEB_TYPES_ELEMENT = "web-types";
        @NotNull
        public static final String ENABLED_ELEMENT = "enabled";
        @NotNull
        public static final String PACKAGE_ELEMENT = "package";
        @NotNull
        public static final String VERSION_ELEMENT = "version";
        @NotNull
        public static final String NAME_ATTR = "name";
        @NotNull
        public static final String VALUE_ATTR = "value";
        @NotNull
        public static final String URL_ATTR = "url";
        @NotNull
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final WebTypesVersionsRegistry<String> getAvailableVersions() {
            return this.availableVersions;
        }

        @NotNull
        public final Set<String> getEnabledPackages() {
            return this.enabledPackages;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Element toElement() {
            Element root = new Element(WEB_TYPES_ELEMENT);
            Map<String, Map<SemVer, String>> map = this.availableVersions.getVersions();
            boolean bl = false;
            for (Map.Entry<String, Map<SemVer, String>> entry : map.entrySet()) {
                Element versionsEl = new Element(PACKAGE_ELEMENT);
                versionsEl.setAttribute(NAME_ATTR, entry.getKey());
                Map<SemVer, String> map2 = entry.getValue();
                boolean bl2 = false;
                for (Map.Entry<SemVer, String> versionEntry : map2.entrySet()) {
                    Element versionEl = new Element(VERSION_ELEMENT);
                    versionEl.setAttribute(VALUE_ATTR, versionEntry.getKey().getRawVersion());
                    versionEl.setAttribute(URL_ATTR, versionEntry.getValue());
                    versionsEl.addContent(versionEl);
                }
                root.addContent(versionsEl);
            }
            Element enabledList = new Element(ENABLED_ELEMENT);
            for (String name : this.enabledPackages) {
                void it;
                Element element = new Element(PACKAGE_ELEMENT);
                boolean bl3 = false;
                boolean bl4 = false;
                Element element2 = element;
                Element element3 = enabledList;
                boolean bl5 = false;
                it.setAttribute(NAME_ATTR, name);
                Unit unit = Unit.INSTANCE;
                element3.addContent(element);
            }
            root.addContent(enabledList);
            return root;
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof State && Intrinsics.areEqual(this.availableVersions, ((State)other).availableVersions) && Intrinsics.areEqual(this.enabledPackages, ((State)other).enabledPackages);
        }

        public int hashCode() {
            int result2 = this.availableVersions.hashCode();
            result2 = 31 * result2 + ((Object)this.enabledPackages).hashCode();
            return result2;
        }

        public State(@NotNull WebTypesVersionsRegistry<String> availableVersions, @NotNull Set<String> enabledPackages2) {
            Intrinsics.checkNotNullParameter(availableVersions, (String)"availableVersions");
            Intrinsics.checkNotNullParameter(enabledPackages2, (String)"enabledPackages");
            this.availableVersions = availableVersions;
            this.enabledPackages = enabledPackages2;
        }

        public State(@NotNull Element root) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            this.availableVersions = new WebTypesVersionsRegistry();
            boolean bl = false;
            this.enabledPackages = new LinkedHashSet();
            for (Element versions : root.getChildren(PACKAGE_ELEMENT)) {
                if (versions.getAttributeValue(NAME_ATTR) == null) {
                    continue;
                }
                for (Element version : versions.getChildren(VERSION_ELEMENT)) {
                    String url;
                    String name;
                    String string = version.getAttributeValue(VALUE_ATTR);
                    if (string == null) continue;
                    String string2 = string;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    String it = string2;
                    boolean bl4 = false;
                    string = SemVer.parseFromText((String)it);
                    if (string == null) {
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"version.getAttributeValu\u2026romText(it) } ?: continue");
                    String ver = string;
                    if (version.getAttributeValue(URL_ATTR) == null) {
                        continue;
                    }
                    this.availableVersions.put(name, (SemVer)ver, url);
                }
            }
            Object object = root.getChild(ENABLED_ELEMENT);
            if (object == null || (object = object.getChildren(PACKAGE_ELEMENT)) == null) {
                object = CollectionsKt.emptyList();
            }
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string;
                Element enabled = (Element)iterator.next();
                if (enabled.getAttributeValue(NAME_ATTR) == null) continue;
                boolean bl5 = false;
                boolean bl6 = false;
                String it = string;
                boolean bl7 = false;
                this.enabledPackages.add(it);
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/javascript/web/webTypes/WebTypesNpmLoader$State$Companion;", "", "()V", "ENABLED_ELEMENT", "", "NAME_ATTR", "PACKAGE_ELEMENT", "URL_ATTR", "VALUE_ATTR", "VERSION_ELEMENT", "WEB_TYPES_ELEMENT", "intellij.javascript.web"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\b\u0002\u0018\u0000 \u000f*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u000fB\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u0004\u0018\u00018\u00008F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/intellij/javascript/web/webTypes/WebTypesNpmLoader$FutureResultProvider;", "T", "", "operation", "Ljava/util/concurrent/Callable;", "(Ljava/util/concurrent/Callable;)V", "myFuture", "Ljava/util/concurrent/Future;", "myLock", "Ljava/lang/Object;", "myRetryTime", "", "result", "getResult", "()Ljava/lang/Object;", "Companion", "intellij.javascript.web"})
    private static final class FutureResultProvider<T> {
        private final Object myLock;
        private Future<?> myFuture;
        private long myRetryTime;
        private final Callable<T> operation;
        private static final long CHECK_TIMEOUT;
        private static final long EDT_TIMEOUT;
        private static final long EDT_RETRY_INTERVAL;
        private static final long NON_EDT_TIMEOUT;
        private static final long NON_EDT_RETRY_INTERVAL;
        @NotNull
        public static final Companion Companion;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final T getResult() {
            Application app;
            Future<?> future = null;
            Object object = this.myLock;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                block25: {
                    boolean bl3 = false;
                    if (this.myRetryTime <= System.currentTimeMillis()) break block25;
                    T t = null;
                    return t;
                }
                if (this.myFuture == null) {
                    this.myFuture = ApplicationManager.getApplication().executeOnPooledThread(new Callable(this, future){
                        final /* synthetic */ FutureResultProvider this$0;
                        final /* synthetic */ Future $future$inlined;
                        {
                            this.this$0 = futureResultProvider;
                            this.$future$inlined = future;
                        }

                        @Nullable
                        public final Object call() {
                            Exception exception;
                            try {
                                exception = FutureResultProvider.access$getOperation$p(this.this$0).call();
                            }
                            catch (Exception e) {
                                exception = e;
                            }
                            return exception;
                        }
                    });
                }
                Future<?> future2 = this.myFuture;
                Intrinsics.checkNotNull(future2);
                future = future2;
                Unit unit = Unit.INSTANCE;
            }
            Application application = app = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
            boolean edt = application.isDispatchThread() && !app.isUnitTestMode();
            long timeout = edt ? EDT_TIMEOUT : NON_EDT_TIMEOUT;
            try {
                while (true) {
                    ProgressManager.checkCanceled();
                    try {
                        Object result2 = future.get(CHECK_TIMEOUT, TimeUnit.MILLISECONDS);
                        if (result2 instanceof ProcessCanceledException) {
                            Object object2 = this.myLock;
                            boolean bl4 = false;
                            boolean bl5 = false;
                            synchronized (object2) {
                                boolean bl6 = false;
                                this.myFuture = null;
                                Unit unit = Unit.INSTANCE;
                            }
                            return null;
                        }
                        if (result2 instanceof ExecutionException) {
                            throw (Throwable)result2;
                        }
                        if (result2 instanceof Exception) {
                            throw (Throwable)new ExecutionException((Throwable)result2);
                        }
                        return (T)result2;
                    }
                    catch (TimeoutException e2) {
                        if ((timeout -= CHECK_TIMEOUT) > 0L) continue;
                        Object e2 = this.myLock;
                        boolean bl7 = false;
                        boolean bl8 = false;
                        synchronized (e2) {
                            boolean bl9 = false;
                            long bl6 = this.myRetryTime;
                            long l = System.currentTimeMillis() + (edt ? EDT_RETRY_INTERVAL : NON_EDT_RETRY_INTERVAL);
                            boolean bl10 = false;
                            this.myRetryTime = Math.max(bl6, l);
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                    break;
                }
            }
            catch (Exception e) {
                if (!(e instanceof ExecutionException) && !(e instanceof CompletionException)) {
                    throw (Throwable)e;
                }
                if (e.getCause() instanceof IOException) {
                    LOG.warn(e.getMessage());
                } else {
                    LOG.error((Throwable)e);
                }
                Object object3 = this.myLock;
                boolean bl11 = false;
                boolean bl12 = false;
                synchronized (object3) {
                    boolean bl13 = false;
                    long l = this.myRetryTime;
                    long l2 = System.currentTimeMillis() + NON_EDT_RETRY_INTERVAL;
                    boolean bl14 = false;
                    this.myRetryTime = Math.max(l, l2);
                    this.myFuture = null;
                    Unit unit = Unit.INSTANCE;
                }
            }
            return null;
        }

        public FutureResultProvider(@NotNull Callable<T> operation) {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            this.operation = operation;
            this.myLock = new Object();
        }

        static {
            Companion = new Companion(null);
            CHECK_TIMEOUT = TimeUnit.MILLISECONDS.toMillis(1L);
            EDT_TIMEOUT = TimeUnit.MILLISECONDS.toMillis(5L);
            EDT_RETRY_INTERVAL = TimeUnit.SECONDS.toMillis(1L);
            NON_EDT_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
            NON_EDT_RETRY_INTERVAL = TimeUnit.MINUTES.toMillis(1L);
        }

        public static final /* synthetic */ Callable access$getOperation$p(FutureResultProvider $this) {
            return $this.operation;
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/javascript/web/webTypes/WebTypesNpmLoader$FutureResultProvider$Companion;", "", "()V", "CHECK_TIMEOUT", "", "EDT_RETRY_INTERVAL", "EDT_TIMEOUT", "NON_EDT_RETRY_INTERVAL", "NON_EDT_TIMEOUT", "intellij.javascript.web"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u000e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001d"}, d2={"Lcom/intellij/javascript/web/webTypes/WebTypesNpmLoader$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PACKAGE_PREFIX", "", "STATE_UPDATE_INTERVAL", "", "WEB_TYPES_ENABLED_PACKAGES_URL", "WEB_TYPES_FILE_SUFFIX", "WEB_TYPES_PKG_NAME_REPLACE_PATTERN", "Lkotlin/text/Regex;", "instance", "Lcom/intellij/javascript/web/webTypes/WebTypesNpmLoader;", "getInstance$intellij_javascript_web", "()Lcom/intellij/javascript/web/webTypes/WebTypesNpmLoader;", "webTypesEnabledPackages", "", "getWebTypesEnabledPackages", "()Ljava/util/Set;", "forPackage", "Lcom/intellij/javascript/web/webTypes/json/WebTypes;", "packageName", "packageVersion", "Lcom/intellij/util/text/SemVer;", "fromUrlNoCache", "url", "intellij.javascript.web"})
    public static final class Companion {
        @NotNull
        public final WebTypes fromUrlNoCache(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return WebTypesLoadUtilKt.readWebTypes(WebTypesJsonFilesCache.Companion.getWebTypesJson(url));
        }

        @Nullable
        public final WebTypes forPackage(@NotNull String packageName, @Nullable SemVer packageVersion) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            return this.getInstance$intellij_javascript_web().getWebTypes(packageName, packageVersion);
        }

        @NotNull
        public final Set<String> getWebTypesEnabledPackages() {
            return Companion.getInstance$intellij_javascript_web().getWebTypesEnabledPackages();
        }

        @NotNull
        public final WebTypesNpmLoader getInstance$intellij_javascript_web() {
            boolean $i$f$service = false;
            Class<WebTypesNpmLoader> serviceClass$iv = WebTypesNpmLoader.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            return (WebTypesNpmLoader)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

