/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.web.webTypes.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.intellij.javascript.web.webTypes.json.Css;
import com.intellij.javascript.web.webTypes.json.GenericContributionsHost;
import com.intellij.javascript.web.webTypes.json.Html;
import com.intellij.javascript.web.webTypes.json.HtmlAttribute;
import com.intellij.javascript.web.webTypes.json.Js;
import com.intellij.javascript.web.webTypes.json.NamePatternRoot;
import com.intellij.javascript.web.webTypes.json.Reference;
import com.intellij.javascript.web.webTypes.json.SourceBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "description", "doc-url", "icon", "source", "deprecated", "experimental", "priority", "proximity", "virtual", "abstract", "extension", "extends", "pattern", "html", "css", "js", "attributes"})
public class BaseContribution
extends GenericContributionsHost {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Short description to be rendered in documentation popup. It will be rendered according to description-markup setting.")
    private String description;
    @JsonProperty(value="doc-url")
    @JsonPropertyDescription(value="Link to online documentation.")
    private String docUrl;
    @JsonProperty(value="icon")
    @JsonPropertyDescription(value="Relative path to icon")
    private String icon;
    @JsonProperty(value="source")
    @JsonPropertyDescription(value="Allows to specify the source of the entity. For Vue.js component this may be for instance a class.")
    private SourceBase source;
    @JsonProperty(value="deprecated")
    private Boolean deprecated = false;
    @JsonProperty(value="experimental")
    private Boolean experimental = false;
    @JsonProperty(value="priority")
    private Priority priority;
    @JsonProperty(value="proximity")
    private Integer proximity;
    @JsonProperty(value="virtual")
    private Boolean virtual;
    @JsonProperty(value="abstract")
    private Boolean _abstract;
    @JsonProperty(value="extension")
    private Boolean extension;
    @JsonProperty(value="extends")
    @JsonPropertyDescription(value="A reference to an element in web-types model.")
    private Reference _extends;
    @JsonProperty(value="pattern")
    private NamePatternRoot pattern;
    @JsonProperty(value="html")
    private Html html;
    @JsonProperty(value="css")
    private Css css;
    @JsonProperty(value="js")
    private Js js;
    @JsonProperty(value="attributes")
    private List<HtmlAttribute> attributes = new ArrayList<HtmlAttribute>();

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description2) {
        this.description = description2;
    }

    @JsonProperty(value="doc-url")
    public String getDocUrl() {
        return this.docUrl;
    }

    @JsonProperty(value="doc-url")
    public void setDocUrl(String docUrl2) {
        this.docUrl = docUrl2;
    }

    @JsonProperty(value="icon")
    public String getIcon() {
        return this.icon;
    }

    @JsonProperty(value="icon")
    public void setIcon(String icon2) {
        this.icon = icon2;
    }

    @JsonProperty(value="source")
    public SourceBase getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    public void setSource(SourceBase source2) {
        this.source = source2;
    }

    @JsonProperty(value="deprecated")
    public Boolean getDeprecated() {
        return this.deprecated;
    }

    @JsonProperty(value="deprecated")
    public void setDeprecated(Boolean deprecated2) {
        this.deprecated = deprecated2;
    }

    @JsonProperty(value="experimental")
    public Boolean getExperimental() {
        return this.experimental;
    }

    @JsonProperty(value="experimental")
    public void setExperimental(Boolean experimental2) {
        this.experimental = experimental2;
    }

    @JsonProperty(value="priority")
    public Priority getPriority() {
        return this.priority;
    }

    @JsonProperty(value="priority")
    public void setPriority(Priority priority2) {
        this.priority = priority2;
    }

    @JsonProperty(value="proximity")
    public Integer getProximity() {
        return this.proximity;
    }

    @JsonProperty(value="proximity")
    public void setProximity(Integer proximity2) {
        this.proximity = proximity2;
    }

    @JsonProperty(value="virtual")
    public Boolean getVirtual() {
        return this.virtual;
    }

    @JsonProperty(value="virtual")
    public void setVirtual(Boolean virtual) {
        this.virtual = virtual;
    }

    @JsonProperty(value="abstract")
    public Boolean getAbstract() {
        return this._abstract;
    }

    @JsonProperty(value="abstract")
    public void setAbstract(Boolean _abstract) {
        this._abstract = _abstract;
    }

    @JsonProperty(value="extension")
    public Boolean getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    public void setExtension(Boolean extension) {
        this.extension = extension;
    }

    @JsonProperty(value="extends")
    public Reference getExtends() {
        return this._extends;
    }

    @JsonProperty(value="extends")
    public void setExtends(Reference _extends) {
        this._extends = _extends;
    }

    @JsonProperty(value="pattern")
    public NamePatternRoot getPattern() {
        return this.pattern;
    }

    @JsonProperty(value="pattern")
    public void setPattern(NamePatternRoot pattern2) {
        this.pattern = pattern2;
    }

    @JsonProperty(value="html")
    public Html getHtml() {
        return this.html;
    }

    @JsonProperty(value="html")
    public void setHtml(Html html) {
        this.html = html;
    }

    @JsonProperty(value="css")
    public Css getCss() {
        return this.css;
    }

    @JsonProperty(value="css")
    public void setCss(Css css) {
        this.css = css;
    }

    @JsonProperty(value="js")
    public Js getJs() {
        return this.js;
    }

    @JsonProperty(value="js")
    public void setJs(Js js) {
        this.js = js;
    }

    @JsonProperty(value="attributes")
    public List<HtmlAttribute> getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="attributes")
    public void setAttributes(List<HtmlAttribute> attributes) {
        this.attributes = attributes;
    }

    public static enum Priority {
        LOWEST("lowest"),
        LOW("low"),
        NORMAL("normal"),
        HIGH("high"),
        HIGHEST("highest");

        private final String value;
        private static final Map<String, Priority> CONSTANTS;

        private Priority(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Priority fromValue(String value) {
            Priority constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Priority>();
            for (Priority c : Priority.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

