/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp.rc;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.lang.javascript.buildTools.gulp.GulpService;
import com.intellij.lang.javascript.buildTools.gulp.codeInsight.GulpfilePsiStructure;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpConfigurationType;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunConfiguration;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunSettings;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GulpRunConfigurationProducer
extends LazyRunConfigurationProducer<GulpRunConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = (ConfigurationFactory)ConfigurationTypeUtil.findConfigurationType(GulpConfigurationType.class);
        if (configurationFactory == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        return configurationFactory;
    }

    protected boolean setupConfigurationFromContext(@NotNull GulpRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        GulpRunSettings runSettings;
        if (configuration == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (sourceElement == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if ((runSettings = GulpRunConfigurationProducer.createRunSettingsFromContext(configuration.getRunSettings(), context, sourceElement)) == null) {
            return false;
        }
        GulpRunConfigurationProducer.setupConfigurationFromSettings(configuration, runSettings);
        return true;
    }

    public static void setupConfigurationFromSettings(@NotNull GulpRunConfiguration configuration, @NotNull GulpRunSettings runSettings) {
        if (configuration == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (runSettings == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        configuration.setRunSettings(runSettings);
        configuration.setName(GulpRunConfigurationProducer.buildName(runSettings.getTasks()));
    }

    public boolean isConfigurationFromContext(@NotNull GulpRunConfiguration configuration, @NotNull ConfigurationContext context) {
        GulpRunSettings thisRunSettings;
        if (configuration == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (context == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        if ((thisRunSettings = GulpRunConfigurationProducer.createRunSettingsFromContext(configuration.getRunSettings(), context, null)) == null) {
            return false;
        }
        return GulpService.getInstance(configuration.getProject()).isConfigurationMatched((RunConfiguration)configuration, thisRunSettings);
    }

    @Nullable
    private static GulpRunSettings createRunSettingsFromContext(@NotNull GulpRunSettings templateRunSettings, @NotNull ConfigurationContext context, @Nullable Ref<PsiElement> sourceElement) {
        JSFile leastEnclosingElement;
        PsiElement element;
        if (templateRunSettings == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(8);
        }
        if (context == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(9);
        }
        if ((element = GulpRunConfigurationProducer.getElement(context)) == null || !element.isValid()) {
            return null;
        }
        JSFile psiGulpfile = GulpRunConfigurationProducer.getGulpfile(element);
        if (psiGulpfile == null) {
            return null;
        }
        VirtualFile virtualGulpfile = psiGulpfile.getVirtualFile();
        if (virtualGulpfile == null) {
            return null;
        }
        Pair<String, JSCallExpression> taskPair = GulpfilePsiStructure.findEnclosingTask(element, psiGulpfile);
        GulpRunSettings.Builder builder = new GulpRunSettings.Builder(templateRunSettings);
        builder.setGulpfilePath(FileUtil.toSystemDependentName((String)virtualGulpfile.getPath()));
        if (taskPair != null) {
            builder.setTasks(Collections.singletonList((String)taskPair.getFirst()));
            leastEnclosingElement = (PsiElement)taskPair.getSecond();
        } else {
            builder.setTasks(Collections.singletonList("default"));
            leastEnclosingElement = psiGulpfile;
        }
        if (sourceElement != null) {
            sourceElement.set((Object)leastEnclosingElement);
        }
        return builder.build();
    }

    @Nullable
    private static PsiElement getElement(@NotNull ConfigurationContext context) {
        Location location;
        if (context == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(10);
        }
        return (location = context.getLocation()) != null ? location.getPsiElement() : null;
    }

    @Nullable
    private static JSFile getGulpfile(@NotNull PsiElement element) {
        VirtualFile file2;
        if (element == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(11);
        }
        JSFile jsFile = element instanceof PsiFile ? (JSFile)ObjectUtils.tryCast((Object)element, JSFile.class) : (JSFile)ObjectUtils.tryCast((Object)element.getContainingFile(), JSFile.class);
        VirtualFile virtualFile = file2 = jsFile != null ? jsFile.getVirtualFile() : null;
        if (file2 != null && GulpService.getInstance(element.getProject()).isBuildfile(file2)) {
            return jsFile;
        }
        return null;
    }

    private static String buildName(@NotNull List<String> tasks) {
        if (tasks == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(12);
        }
        if (tasks.isEmpty()) {
            return "default";
        }
        return StringUtil.join(tasks, (String)", ");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfigurationProducer";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runSettings";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateRunSettings";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromSettings";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createRunSettingsFromContext";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getGulpfile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

