/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSQualifiedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatementList;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSUnresolvedNamesCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        JSElement parent;
        if (parameters == null) {
            JSUnresolvedNamesCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            JSUnresolvedNamesCompletionContributor.$$$reportNull$$$0(1);
        }
        JSNamedElement initialParent = parent = JSUnresolvedNamesCompletionContributor.getNamedParent(parameters.getPosition());
        if (parent instanceof JSVariable && JSDestructuringUtil.isDestructuring(parent.getParent())) {
            return;
        }
        if (parent instanceof JSVariable && !(parent instanceof JSParameter)) {
            parent = ((JSVariable)parent).getStatement();
        }
        if (parent == null) {
            return;
        }
        MultiMap strings = MultiMap.createSet();
        if (parent instanceof JSParameter) {
            PsiElement psiElement;
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof JSParameterList && (psiElement = grandParent.getParent()) instanceof JSFunction) {
                JSUnresolvedNamesCompletionContributor.collectForFunction((JSFunction)psiElement, (PsiElement)initialParent, (MultiMap<String, PossibleEntityKind>)strings);
            }
        } else if (parent instanceof JSClassExpression) {
            JSUnresolvedNamesCompletionContributor.collectIfExportDefault((PsiElement)parent, (PsiElement)initialParent, (MultiMap<String, PossibleEntityKind>)strings);
            for (JSElement jSElement : ((JSClassExpression)parent).getMembers()) {
                if (jSElement instanceof JSFunction) {
                    JSUnresolvedNamesCompletionContributor.collectForFunction((JSFunction)jSElement, (PsiElement)initialParent, (MultiMap<String, PossibleEntityKind>)strings);
                    continue;
                }
                JSUnresolvedNamesCompletionContributor.collectUnresolvedNames((PsiElement)jSElement, (PsiElement)initialParent, (MultiMap<String, PossibleEntityKind>)strings);
            }
        } else if (parent instanceof JSFunctionExpression) {
            JSUnresolvedNamesCompletionContributor.collectIfExportDefault((PsiElement)parent, (PsiElement)initialParent, (MultiMap<String, PossibleEntityKind>)strings);
            JSUnresolvedNamesCompletionContributor.collectForFunction((JSFunction)parent, (PsiElement)initialParent, (MultiMap<String, PossibleEntityKind>)strings);
        } else if (parent instanceof JSSourceElement && !(parent instanceof JSExpression)) {
            JSUnresolvedNamesCompletionContributor.collectNamesForSourceElement((JSSourceElement)parent, (PsiElement)initialParent, (MultiMap<String, PossibleEntityKind>)strings);
        }
        for (Map.Entry entry : strings.entrySet()) {
            Collection possibleEntityKinds;
            String string = (String)entry.getKey();
            if (string == null || !JSUnresolvedNamesCompletionContributor.isValidForParent(possibleEntityKinds = (Collection)entry.getValue(), (PsiElement)parent)) continue;
            result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)string).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE), (double)-2.0));
        }
    }

    private static void collectIfExportDefault(@NotNull PsiElement parent, @NotNull PsiElement initialParent, @NotNull MultiMap<String, PossibleEntityKind> strings) {
        PsiElement grandParent;
        if (parent == null) {
            JSUnresolvedNamesCompletionContributor.$$$reportNull$$$0(2);
        }
        if (initialParent == null) {
            JSUnresolvedNamesCompletionContributor.$$$reportNull$$$0(3);
        }
        if (strings == null) {
            JSUnresolvedNamesCompletionContributor.$$$reportNull$$$0(4);
        }
        if ((grandParent = parent.getParent()) instanceof ES6ExportDefaultAssignment) {
            JSUnresolvedNamesCompletionContributor.collectNamesForSourceElement((JSSourceElement)grandParent, initialParent, strings);
        }
    }

    private static void collectNamesForSourceElement(@NotNull JSSourceElement parent, @NotNull PsiElement initialParent, @NotNull MultiMap<String, PossibleEntityKind> strings) {
        PsiElement grandParent;
        if (parent == null) {
            JSUnresolvedNamesCompletionContributor.$$$reportNull$$$0(5);
        }
        if (initialParent == null) {
            JSUnresolvedNamesCompletionContributor.$$$reportNull$$$0(6);
        }
        if (strings == null) {
            JSUnresolvedNamesCompletionContributor.$$$reportNull$$$0(7);
        }
        if ((grandParent = parent.getParent()) instanceof JSStatementList) {
            boolean parentEncountered = false;
            boolean canReferenceBefore = parent instanceof JSFunction || parent instanceof JSVarStatement && ((JSVarStatement)parent).getVarKeyword() == JSVarStatement.VarKeyword.VAR;
            for (JSSourceElement item : ((JSStatementList)grandParent).getStatementListItems()) {
                if (item == parent) {
                    parentEncountered = true;
                    continue;
                }
                if (!canReferenceBefore && !parentEncountered) continue;
                JSUnresolvedNamesCompletionContributor.collectUnresolvedNames((PsiElement)item, initialParent, strings);
            }
        }
    }

    private static void collectForFunction(@NotNull JSFunction parent, @NotNull PsiElement initialParent, @NotNull MultiMap<String, PossibleEntityKind> strings) {
        JSBlockStatement block;
        if (parent == null) {
            JSUnresolvedNamesCompletionContributor.$$$reportNull$$$0(8);
        }
        if (initialParent == null) {
            JSUnresolvedNamesCompletionContributor.$$$reportNull$$$0(9);
        }
        if (strings == null) {
            JSUnresolvedNamesCompletionContributor.$$$reportNull$$$0(10);
        }
        if ((block = parent.getBlock()) != null) {
            JSUnresolvedNamesCompletionContributor.collectUnresolvedNames(block, initialParent, strings);
        } else {
            JSExpression expression = JSPsiImplUtils.tryGetArrowFunctionReturnExpression(parent);
            if (expression != null) {
                JSUnresolvedNamesCompletionContributor.collectUnresolvedNames((PsiElement)expression, initialParent, strings);
            }
        }
    }

    private static boolean isValidForParent(@NotNull Collection<PossibleEntityKind> kinds, @NotNull PsiElement parent) {
        if (kinds == null) {
            JSUnresolvedNamesCompletionContributor.$$$reportNull$$$0(11);
        }
        if (parent == null) {
            JSUnresolvedNamesCompletionContributor.$$$reportNull$$$0(12);
        }
        if (parent instanceof TypeScriptCompileTimeType) {
            return kinds.contains((Object)PossibleEntityKind.Type);
        }
        if (parent instanceof JSFunction) {
            return kinds.contains((Object)PossibleEntityKind.Function);
        }
        if (parent instanceof JSClass) {
            return kinds.contains((Object)PossibleEntityKind.Variable) || kinds.contains((Object)PossibleEntityKind.Type);
        }
        return kinds.contains((Object)PossibleEntityKind.Variable);
    }

    private static void collectUnresolvedNames(@NotNull PsiElement item, @NotNull PsiElement parent, @NotNull MultiMap<String, PossibleEntityKind> strings) {
        if (item == null) {
            JSUnresolvedNamesCompletionContributor.$$$reportNull$$$0(13);
        }
        if (parent == null) {
            JSUnresolvedNamesCompletionContributor.$$$reportNull$$$0(14);
        }
        if (strings == null) {
            JSUnresolvedNamesCompletionContributor.$$$reportNull$$$0(15);
        }
        SyntaxTraverser traverser = SyntaxTraverser.psiTraverser((PsiElement)item);
        if (!DialectDetector.isTypeScript(item)) {
            if (item instanceof JSFunction) {
                return;
            }
            traverser = (SyntaxTraverser)traverser.forceIgnore(Conditions.instanceOf((Class[])new Class[]{JSFunction.class, JSClass.class}));
        }
        traverser.filter(JSReferenceExpression.class).filter(r -> r.getQualifier() == null).filter(r -> !JSResolveUtil.isSelfReference((PsiElement)r)).filter(r -> r.multiResolve(true).length == 0).forEach(r -> strings.putValue((Object)r.getReferenceName(), (Object)JSUnresolvedNamesCompletionContributor.guessEntityKind(r)));
    }

    @NotNull
    private static PossibleEntityKind guessEntityKind(@NotNull JSReferenceExpression referenceExpression) {
        PsiElement parent;
        if (referenceExpression == null) {
            JSUnresolvedNamesCompletionContributor.$$$reportNull$$$0(16);
        }
        if ((parent = referenceExpression.getParent()) instanceof JSQualifiedExpression) {
            PossibleEntityKind possibleEntityKind = PossibleEntityKind.Variable;
            if (possibleEntityKind == null) {
                JSUnresolvedNamesCompletionContributor.$$$reportNull$$$0(17);
            }
            return possibleEntityKind;
        }
        if (parent instanceof JSCallLikeExpression && ((JSCallLikeExpression)parent).getMethodExpression() == referenceExpression) {
            PossibleEntityKind possibleEntityKind = parent instanceof JSNewExpression ? PossibleEntityKind.Variable : PossibleEntityKind.Function;
            if (possibleEntityKind == null) {
                JSUnresolvedNamesCompletionContributor.$$$reportNull$$$0(18);
            }
            return possibleEntityKind;
        }
        if (JSResolveUtil.isExprInStrictTypeContext(referenceExpression)) {
            PossibleEntityKind possibleEntityKind = PossibleEntityKind.Type;
            if (possibleEntityKind == null) {
                JSUnresolvedNamesCompletionContributor.$$$reportNull$$$0(19);
            }
            return possibleEntityKind;
        }
        PossibleEntityKind possibleEntityKind = PossibleEntityKind.Variable;
        if (possibleEntityKind == null) {
            JSUnresolvedNamesCompletionContributor.$$$reportNull$$$0(20);
        }
        return possibleEntityKind;
    }

    @Contract(value="null -> null")
    @Nullable
    static JSNamedElement getNamedParent(@Nullable PsiElement position) {
        if (!(position instanceof LeafPsiElement) || ((LeafPsiElement)position).getElementType() != JSTokenTypes.IDENTIFIER) {
            return null;
        }
        PsiElement parent = position.getParent();
        if (!(parent instanceof JSNamedElement) && parent instanceof JSReferenceExpression) {
            position = parent;
            parent = parent.getParent();
        }
        if (!(parent instanceof JSNamedElement) || ((JSNamedElement)parent).getNameIdentifier() != position) {
            return null;
        }
        return (JSNamedElement)parent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialParent";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSUnresolvedNamesCompletionContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSUnresolvedNamesCompletionContributor";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "guessEntityKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectIfExportDefault";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectNamesForSourceElement";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectForFunction";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isValidForParent";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectUnresolvedNames";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "guessEntityKind";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum PossibleEntityKind {
        Variable,
        Function,
        Type;

    }
}

