/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptArrayType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTupleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TypeScriptModifiersUtil {
    private static final TokenSet ALLOW_GLOBAL_CLASS_MODIFIERS = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.EXPORT_KEYWORD});
    private static final TokenSet ALLOW_CLASS_FIELD_MODIFIERS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.ACCESS_MODIFIERS, TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.STATIC_KEYWORD, JSTokenTypes.READONLY_KEYWORD, JSTokenTypes.ABSTRACT_KEYWORD, JSTokenTypes.OVERRIDE_KEYWORD, JSTokenTypes.DECLARE_KEYWORD})});
    private static final TokenSet ALLOW_CONSTRUCTOR_FIELD_MODIFIERS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.ACCESS_MODIFIERS, TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.READONLY_KEYWORD, JSTokenTypes.OVERRIDE_KEYWORD})});
    private static final TokenSet ALLOW_CLASS_METHOD_MODIFIERS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.ACCESS_MODIFIERS, TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.STATIC_KEYWORD, JSTokenTypes.OVERRIDE_KEYWORD, JSTokenTypes.ABSTRACT_KEYWORD, JSTokenTypes.ASYNC_KEYWORD})});
    private static final TokenSet ALLOW_GLOBAL_COMMON_MODIFIERS = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.EXPORT_KEYWORD});

    TypeScriptModifiersUtil() {
    }

    private static boolean isAllowClassModifier(JSClass classElement2, IElementType elementType, boolean isTopLevel) {
        if (TypeScriptModifiersUtil.isConstEnum(classElement2, elementType)) {
            return true;
        }
        if (isTopLevel && elementType == JSTokenTypes.ABSTRACT_KEYWORD && classElement2 instanceof TypeScriptClass) {
            return true;
        }
        return isTopLevel && (ALLOW_GLOBAL_CLASS_MODIFIERS.contains(elementType) || TypeScriptModifiersUtil.isCorrectDeclareModifierPlace(classElement2, elementType));
    }

    private static boolean isConstEnum(JSClass element, IElementType elementType) {
        return elementType == JSTokenTypes.CONST_KEYWORD && element instanceof TypeScriptEnum;
    }

    private static boolean isCorrectDeclareModifierPlace(PsiElement element, IElementType elementType) {
        return elementType == JSTokenTypes.DECLARE_KEYWORD && !TypeScriptPsiUtil.isAmbientDeclaration(element.getParent());
    }

    private static boolean isAllowVariableModifier(PsiElement variableOrDeclaration, IElementType elementType, boolean isTopLevel) {
        if (variableOrDeclaration instanceof JSParameter && ALLOW_CONSTRUCTOR_FIELD_MODIFIERS.contains(elementType)) {
            JSFunction function2 = ((JSParameter)variableOrDeclaration).getDeclaringFunction();
            return function2 != null && function2.isConstructor();
        }
        if (variableOrDeclaration instanceof JSVarStatement && variableOrDeclaration.getParent() instanceof JSClass && ALLOW_CLASS_FIELD_MODIFIERS.contains(elementType)) {
            return true;
        }
        return TypeScriptModifiersUtil.isAllowCommon(variableOrDeclaration, elementType, isTopLevel);
    }

    private static boolean isAllowFunctionModifier(JSFunction function2, IElementType elementType, boolean isTopLevel) {
        if (function2.isConstructor() && elementType == JSTokenTypes.STATIC_KEYWORD) {
            return false;
        }
        if (function2.isConstructor() && function2 instanceof TypeScriptFunctionType && elementType == JSTokenTypes.ABSTRACT_KEYWORD) {
            return true;
        }
        if ((elementType == JSTokenTypes.ASYNC_KEYWORD || elementType == JSTokenTypes.MULT) && (function2.isGetProperty() || function2.isSetProperty())) {
            return false;
        }
        if (function2.getParent() instanceof JSClass && ALLOW_CLASS_METHOD_MODIFIERS.contains(elementType)) {
            return true;
        }
        return TypeScriptModifiersUtil.isAllowCommon((PsiElement)function2, elementType, isTopLevel) || elementType == JSTokenTypes.ASYNC_KEYWORD;
    }

    private static boolean isAllowTypeSignature(TypeScriptTypeMember signature, IElementType elementType, boolean isTopLevel) {
        if ((signature instanceof TypeScriptIndexSignature || signature instanceof TypeScriptPropertySignature) && elementType == JSTokenTypes.READONLY_KEYWORD) {
            return true;
        }
        if (signature instanceof TypeScriptIndexSignature && elementType == JSTokenTypes.STATIC_KEYWORD) {
            return true;
        }
        return TypeScriptModifiersUtil.isAllowCommon(signature, elementType, isTopLevel);
    }

    private static boolean isAllowCommon(PsiElement element, IElementType elementType, boolean isTopLevel) {
        if (isTopLevel && TypeScriptModifiersUtil.isCorrectDeclareModifierPlace(element, elementType)) {
            return true;
        }
        return isTopLevel && ALLOW_GLOBAL_COMMON_MODIFIERS.contains(elementType);
    }

    private static boolean isAllowImportModifier(IElementType elementType, boolean isTopLevel) {
        return isTopLevel && ALLOW_GLOBAL_COMMON_MODIFIERS.contains(elementType);
    }

    @InspectionMessage
    private static String getModifierErrorMessage(ASTNode modifierNode, boolean isTopLevel) {
        IElementType elementType = modifierNode.getElementType();
        return isTopLevel && elementType != JSTokenTypes.ABSTRACT_KEYWORD && elementType != JSTokenTypes.DECLARE_KEYWORD ? JavaScriptBundle.message("typescript.validation.message.invalid.module.member.modifier", modifierNode.getText()) : JavaScriptBundle.message("typescript.validation.message.invalid.modifier.cannot.be.here", modifierNode.getText());
    }

    @Nullable
    @InspectionMessage
    static String validateModifiers(@NotNull PsiElement container, boolean isTopLevel, boolean alreadyHasAccessModifier, @NotNull HashSet<IElementType> modifiers, @NotNull ASTNode child, @NotNull IElementType elementType) {
        if (container == null) {
            TypeScriptModifiersUtil.$$$reportNull$$$0(0);
        }
        if (modifiers == null) {
            TypeScriptModifiersUtil.$$$reportNull$$$0(1);
        }
        if (child == null) {
            TypeScriptModifiersUtil.$$$reportNull$$$0(2);
        }
        if (elementType == null) {
            TypeScriptModifiersUtil.$$$reportNull$$$0(3);
        }
        boolean isAllow = container instanceof JSClass ? TypeScriptModifiersUtil.isAllowClassModifier((JSClass)container, elementType, isTopLevel) : (container instanceof JSVariable || container instanceof JSVarStatement ? TypeScriptModifiersUtil.isAllowVariableModifier(container, elementType, isTopLevel) : (container instanceof JSFunction ? TypeScriptModifiersUtil.isAllowFunctionModifier((JSFunction)container, elementType, isTopLevel) : (container instanceof TypeScriptImportStatement ? TypeScriptModifiersUtil.isAllowImportModifier(elementType, isTopLevel) : (container instanceof TypeScriptTypeMember ? TypeScriptModifiersUtil.isAllowTypeSignature((TypeScriptTypeMember)container, elementType, isTopLevel) : (container instanceof TypeScriptArrayType || container instanceof TypeScriptTupleType ? elementType == JSTokenTypes.READONLY_KEYWORD : TypeScriptModifiersUtil.isAllowCommon(container, elementType, isTopLevel))))));
        String message = null;
        if (!isAllow) {
            message = TypeScriptModifiersUtil.getModifierErrorMessage(child, isTopLevel);
        } else if (!modifiers.add(child.getElementType())) {
            message = JavaScriptBundle.message("typescript.validation.message.duplicate.modifier", child.getText());
        } else if (alreadyHasAccessModifier && TypeScriptModifiersUtil.isAccessibilityModifier(elementType)) {
            message = JavaScriptBundle.message("typescript.validation.message.duplicate.modifier2", new Object[0]);
        }
        return message;
    }

    @Contract(pure=true)
    static boolean isAccessibilityModifier(@NotNull IElementType elementType) {
        if (elementType == null) {
            TypeScriptModifiersUtil.$$$reportNull$$$0(4);
        }
        return JSTokenTypes.ACCESS_MODIFIERS.contains(elementType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptModifiersUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "validateModifiers";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isAccessibilityModifier";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

