/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.flow.psi.impl.FlowJSTypeCastImpl;
import com.intellij.lang.javascript.frameworks.react.ReactComponent;
import com.intellij.lang.javascript.frameworks.react.tsx.TypeScriptReactComponentUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ES6QualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSPsiBasedTypeOfType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.evaluable.JSTypeWithDeclarations;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSXPropTypesUtil {
    public static final String PROPS_IS_REQUIRED_NAME = "isRequired";

    @NotNull
    public static Stream<JSPsiElementBase> resolveNamespacePropTypes(@NotNull ReactComponent reactComponent, @NotNull GlobalSearchScope scope) {
        if (reactComponent == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(1);
        }
        String namespace = reactComponent.getNamespace().replace(".props", ".propTypes");
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        JSClassResolver.getInstance().processElementsByQNameIncludingImplicit(namespace, scope, JSClassResolver.IncludeLocalMembersOptions.ALL, (Processor<? super JSPsiElementBase>)processor);
        Collection elements = processor.getResults();
        if (elements.size() == 0) {
            Stream<JSPsiElementBase> stream = Stream.empty();
            if (stream == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(2);
            }
            return stream;
        }
        Stream<JSPsiElementBase> stream = elements.stream().flatMap(element -> JSXPropTypesUtil.getPropTypesForNamespaceElement(element)).distinct();
        if (stream == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(3);
        }
        return stream;
    }

    @NotNull
    private static Stream<JSPsiElementBase> getPropTypesForNamespaceElement(@NotNull JSPsiElementBase element) {
        if (element == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(4);
        }
        Collection<PsiElement> meaningfulElements = JSStubBasedPsiTreeUtil.calculateMeaningfulElements((PsiElement)element);
        Stream<JSPsiElementBase> stream = meaningfulElements.stream().flatMap(meaningfulElement -> {
            List<JSExpression> expressions;
            JSExpression initializer;
            if (meaningfulElement instanceof JSInitializerOwner && (initializer = ((JSInitializerOwner)meaningfulElement).getInitializerOrStub()) != null) {
                meaningfulElement = initializer;
            }
            if (meaningfulElement instanceof JSDefinitionExpression) {
                String reference = JSPsiImplUtils.getInitializerReference((JSDefinitionExpression)meaningfulElement);
                if (!StringUtil.isEmptyOrSpaces((String)reference)) {
                    Collection<PsiElement> resolvedElements = new ES6QualifiedNameResolver((PsiElement)meaningfulElement, true).resolveQualifiedName(reference);
                    meaningfulElement = (PsiElement)ContainerUtil.getFirstItem(resolvedElements);
                } else {
                    JSExpression initializerOrStub = ((JSDefinitionExpression)meaningfulElement).getInitializerOrStub();
                    if (initializerOrStub != null) {
                        meaningfulElement = initializerOrStub;
                    }
                }
            }
            if (meaningfulElement instanceof JSFunction && ((JSFunction)meaningfulElement).isGetProperty() && (expressions = JSStubBasedPsiTreeUtil.findReturnedExpressions((JSFunction)meaningfulElement)).size() == 1) {
                meaningfulElement = (PsiElement)ContainerUtil.getFirstItem(expressions);
            }
            if (meaningfulElement instanceof JSObjectLiteralExpression) {
                return JSXPropTypesUtil.convertObjectLiteralToPropsType((JSObjectLiteralExpression)meaningfulElement);
            }
            return Stream.empty();
        });
        if (stream == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(5);
        }
        return stream;
    }

    @NotNull
    private static Stream<JSPsiElementBase> convertObjectLiteralToPropsType(@NotNull JSObjectLiteralExpression expression) {
        JSElement[] properties2;
        if (expression == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(6);
        }
        if ((properties2 = expression.getPropertiesIncludingSpreads()).length == 0) {
            Stream<JSPsiElementBase> stream = Stream.empty();
            if (stream == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(7);
            }
            return stream;
        }
        SmartList result2 = new SmartList();
        for (JSElement element : properties2) {
            if (element instanceof JSProperty) {
                JSXPropTypesUtil.addSimpleProperty((List<JSPsiElementBase>)result2, (JSProperty)element);
                continue;
            }
            if (!(element instanceof JSSpreadExpression)) continue;
            JSXPropTypesUtil.addSpreadProperties((List<JSPsiElementBase>)result2, (JSSpreadExpression)element);
        }
        Stream<JSPsiElementBase> stream = result2.stream();
        if (stream == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(8);
        }
        return stream;
    }

    private static void addSpreadProperties(@NotNull List<JSPsiElementBase> result2, @NotNull JSSpreadExpression element) {
        List resultsFromSpread;
        PsiFile file2;
        if (result2 == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(9);
        }
        if (element == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(10);
        }
        if ((file2 = element.getContainingFile()) == null) {
            return;
        }
        JSType type = element.getInnerExpressionType();
        if (type == null) {
            return;
        }
        JSRecordType recordType = type.asRecordType();
        Collection<JSRecordType.PropertySignature> properties2 = recordType.getProperties();
        for (JSRecordType.PropertySignature member : properties2) {
            PsiElement sourceElement = member.getMemberSource().getSingleElement();
            if (sourceElement instanceof JSProperty) {
                JSXPropTypesUtil.addSimpleProperty(result2, (JSProperty)sourceElement);
                continue;
            }
            if (!(sourceElement instanceof JSPsiElementBase)) continue;
            result2.add((JSPsiElementBase)sourceElement);
        }
        if (properties2.isEmpty() && type instanceof JSTypeWithDeclarations && (resultsFromSpread = (List)RecursionManager.doPreventingRecursion((Object)element, (boolean)false, () -> StreamEx.of(((JSTypeWithDeclarations)type).getDeclarations()).select(JSPsiElementBase.class).flatMap(JSXPropTypesUtil::getPropTypesForNamespaceElement).toList())) != null) {
            result2.addAll(resultsFromSpread);
        }
    }

    private static void addSimpleProperty(@NotNull List<JSPsiElementBase> result2, @NotNull JSProperty property) {
        Collection<JSImplicitElement> elements;
        String name;
        if (result2 == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(11);
        }
        if (property == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(12);
        }
        if ((name = property.getName()) == null) {
            return;
        }
        JSElementIndexingData data = property.getIndexingData();
        if (data != null && (elements = data.getImplicitElements()) != null) {
            for (JSImplicitElement element : elements) {
                if (!element.getQualifiedName().endsWith("props." + element.getName())) continue;
                result2.add(element);
                return;
            }
        }
        result2.add(JSXPropTypesUtil.createSimpleImplicitElement(property, name));
    }

    @NotNull
    public static JSImplicitElementImpl createImplicitReactPropsElement(@NotNull JSProperty property, @NotNull JSQualifiedName prop) {
        if (property == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(13);
        }
        if (prop == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(14);
        }
        JSImplicitElementImpl.Builder propBuilder = new JSImplicitElementImpl.Builder(prop, (PsiElement)property).setContext(JSContext.UNKNOWN).setType(JSImplicitElement.Type.Property).setNamespaceExplicitlyDeclared(true).setOptional(true);
        JSExpression value = property.getValue();
        if (value != null) {
            Pair<JSType, Boolean> pair = JSXPropTypesUtil.processPropTypesExpression(value);
            propBuilder.setTypeString(JSTypeUtils.serializeType((JSType)pair.first)).setOptional((Boolean)pair.second == false);
        }
        JSImplicitElementImpl jSImplicitElementImpl = propBuilder.toImplicitElement();
        if (jSImplicitElementImpl == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(15);
        }
        return jSImplicitElementImpl;
    }

    private static JSImplicitElement createSimpleImplicitElement(@NotNull JSProperty property, @NotNull String name) {
        if (property == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(16);
        }
        if (name == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(17);
        }
        return new JSLocalImplicitElementImpl(name, null, (PsiElement)property, JSImplicitElement.Type.Property);
    }

    @Nullable
    public static JSType getClassComponentGenericType(@NotNull JSClass contextClass, boolean isState) {
        JSTypeDeclaration typeDeclaration;
        if (contextClass == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(18);
        }
        return (typeDeclaration = JSXPropTypesUtil.getClassComponentGenericDeclaration(contextClass, isState)) != null ? typeDeclaration.getJSType() : null;
    }

    @Nullable
    public static JSTypeDeclaration getClassComponentGenericDeclaration(@NotNull JSClass contextClass, boolean isState) {
        JSReferenceList list2;
        if (contextClass == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(19);
        }
        if ((list2 = contextClass.getExtendsList()) == null) {
            return null;
        }
        for (JSReferenceListMember refMember : list2.getMembers()) {
            int startIndex;
            String text = refMember.getReferenceText();
            if (text == null || !JSXPropTypesUtil.isPossibleReactClassName(text)) continue;
            JSTypeDeclaration[] arguments = refMember.getTypeArguments();
            int argsLength = arguments.length;
            int n = startIndex = isState ? 1 : 0;
            if (argsLength <= startIndex) continue;
            return argsLength == 3 ? arguments[startIndex + 1] : arguments[startIndex];
        }
        return null;
    }

    public static boolean isPossibleReactClassName(@NotNull String text) {
        if (text == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(20);
        }
        int index = text.lastIndexOf(46) + 1;
        String className2 = text.contains(".") && index < text.length() ? text.substring(index) : text;
        return TypeScriptReactComponentUtil.REACT_COMPONENT_NAMES.contains(className2);
    }

    @NotNull
    private static @NotNull Pair<@NotNull JSType, Boolean> processPropTypesExpression(@NotNull JSExpression expression) {
        if (expression == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(21);
        }
        boolean isRequired = false;
        if (expression instanceof JSReferenceExpression && PROPS_IS_REQUIRED_NAME.equals(((JSReferenceExpression)expression).getReferenceName())) {
            isRequired = true;
            expression = ((JSReferenceExpression)expression).getQualifier();
        }
        JSTypeSource emptySource = JSTypeSource.EMPTY;
        if (expression instanceof JSReferenceExpression) {
            String name = ((JSReferenceExpression)expression).getReferenceName();
            if ("object".equals(name) || "array".equals(name) || "symbol".equals(name)) {
                Pair pair = Pair.create((Object)JSNamedTypeFactory.createType(StringUtil.capitalize((String)name), emptySource, JSContext.INSTANCE), (Object)isRequired);
                if (pair == null) {
                    JSXPropTypesUtil.$$$reportNull$$$0(22);
                }
                return pair;
            }
            if ("string".equals(name) || "number".equals(name)) {
                Pair pair = Pair.create((Object)JSNamedTypeFactory.createType(name, emptySource, JSContext.INSTANCE), (Object)isRequired);
                if (pair == null) {
                    JSXPropTypesUtil.$$$reportNull$$$0(23);
                }
                return pair;
            }
            if ("bool".equals(name)) {
                Pair pair = Pair.create((Object)JSNamedTypeFactory.createType("boolean", emptySource, JSContext.INSTANCE), (Object)isRequired);
                if (pair == null) {
                    JSXPropTypesUtil.$$$reportNull$$$0(24);
                }
                return pair;
            }
            if ("func".equals(name)) {
                Pair pair = Pair.create((Object)JSNamedTypeFactory.createFunctionType(emptySource), (Object)isRequired);
                if (pair == null) {
                    JSXPropTypesUtil.$$$reportNull$$$0(25);
                }
                return pair;
            }
        }
        if (expression instanceof JSCallExpression) {
            JSExpression methodExpression = ((JSCallExpression)expression).getMethodExpression();
            if (!(methodExpression instanceof JSReferenceExpression)) {
                Pair pair = Pair.create((Object)JSAnyType.get(emptySource), (Object)isRequired);
                if (pair == null) {
                    JSXPropTypesUtil.$$$reportNull$$$0(26);
                }
                return pair;
            }
            String name = ((JSReferenceExpression)methodExpression).getReferenceName();
            JSExpression firstArgument = (JSExpression)ArrayUtil.getFirstElement((Object[])((JSCallExpression)expression).getArguments());
            if (StringUtil.equals((CharSequence)name, (CharSequence)"instanceOf") && firstArgument instanceof JSReferenceExpression) {
                String text = firstArgument.getText();
                Pair pair = Pair.create((Object)JSNamedTypeFactory.createType(text, emptySource, JSContext.INSTANCE), (Object)isRequired);
                if (pair == null) {
                    JSXPropTypesUtil.$$$reportNull$$$0(27);
                }
                return pair;
            }
            if (StringUtil.equals((CharSequence)name, (CharSequence)"shape") && firstArgument instanceof JSObjectLiteralExpression) {
                JSObjectLiteralExpression shapeLiteral = (JSObjectLiteralExpression)firstArgument;
                ArrayList<JSRecordTypeImpl.PropertySignatureImpl> properties2 = new ArrayList<JSRecordTypeImpl.PropertySignatureImpl>();
                for (JSProperty property : shapeLiteral.getProperties()) {
                    String propertyName = property.getName();
                    JSExpression value = property.getValue();
                    if (propertyName == null || value == null) continue;
                    Pair<JSType, Boolean> pair = JSXPropTypesUtil.processPropTypesExpression(value);
                    properties2.add(new JSRecordTypeImpl.PropertySignatureImpl(propertyName, (JSType)pair.first, (boolean)((Boolean)pair.second), false));
                }
                Pair pair = Pair.create((Object)new JSRecordTypeImpl(emptySource, properties2), (Object)isRequired);
                if (pair == null) {
                    JSXPropTypesUtil.$$$reportNull$$$0(28);
                }
                return pair;
            }
            if (StringUtil.equals((CharSequence)name, (CharSequence)"oneOf") && firstArgument instanceof JSArrayLiteralExpression) {
                Object[] expressions = ((JSArrayLiteralExpression)firstArgument).getExpressions();
                List types2 = ContainerUtil.mapNotNull((Object[])expressions, e -> e instanceof JSLiteralExpression ? JSTypeEvaluator.getTypeFromConstant(e) : null);
                Pair pair = Pair.create((Object)JSCompositeTypeFactory.createUnionType(emptySource, types2), (Object)isRequired);
                if (pair == null) {
                    JSXPropTypesUtil.$$$reportNull$$$0(29);
                }
                return pair;
            }
            if (StringUtil.equals((CharSequence)name, (CharSequence)"arrayOf") && firstArgument != null) {
                Pair<JSType, Boolean> pair = JSXPropTypesUtil.processPropTypesExpression(firstArgument);
                Pair pair2 = Pair.create((Object)new JSArrayTypeImpl((JSType)pair.first, emptySource), (Object)isRequired);
                if (pair2 == null) {
                    JSXPropTypesUtil.$$$reportNull$$$0(30);
                }
                return pair2;
            }
        }
        Pair pair = Pair.create((Object)JSAnyType.get(emptySource), (Object)isRequired);
        if (pair == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(31);
        }
        return pair;
    }

    @NotNull
    public static String toPropType(String qualifier, @Nullable JSType type, @NotNull PsiElement context) {
        if (context == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(32);
        }
        if (JSNamedType.isNamedTypeWithName(type, "JSX.Element")) {
            String string = qualifier + ".element";
            if (string == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(33);
            }
            return string;
        }
        if (JSNamedType.isNamedTypeWithName(type, "ReactNode")) {
            String string = qualifier + ".node";
            if (string == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(34);
            }
            return string;
        }
        if (JSTypeUtils.getFunctionType(type, false, context).anyMatch(t -> !JSTypeUtils.isNullOrAny(t))) {
            String string = qualifier + ".func";
            if (string == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(35);
            }
            return string;
        }
        if ((type = JSTypeUtils.unwrapType(type)) instanceof JSRecordType) {
            String string = qualifier + String.format(".shape({%s})", StringUtil.join(((JSRecordType)type).getTypeMembers(), t -> {
                if (t instanceof JSRecordType.PropertySignature) {
                    return ((JSRecordType.PropertySignature)t).getMemberName() + ":" + JSXPropTypesUtil.toPropType(qualifier, ((JSRecordType.PropertySignature)t).getJSType(), context);
                }
                return "";
            }, (String)","));
            if (string == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(36);
            }
            return string;
        }
        if (type instanceof JSBooleanType) {
            String string = qualifier + ".bool";
            if (string == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(37);
            }
            return string;
        }
        if (type instanceof JSStringType) {
            String string = qualifier + ".string";
            if (string == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(38);
            }
            return string;
        }
        if (type instanceof JSNumberType) {
            String string = qualifier + ".number";
            if (string == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(39);
            }
            return string;
        }
        if (type instanceof JSArrayType) {
            String string = qualifier + String.format(".arrayOf(%s)", JSXPropTypesUtil.toPropType(qualifier, ((JSArrayType)type).getType(), context));
            if (string == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(40);
            }
            return string;
        }
        String string = qualifier + ".any";
        if (string == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(41);
        }
        return string;
    }

    @Nullable
    public static JSType getGenericPropType(@NotNull XmlTag tag, @NotNull ReactComponent reactComponent) {
        if (tag == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(42);
        }
        if (reactComponent == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(43);
        }
        if (!DialectDetector.isJSX((PsiElement)tag)) {
            return null;
        }
        Collection<? extends PsiElement> elements = reactComponent.getElements();
        if (elements.isEmpty()) {
            return null;
        }
        SmartList results = new SmartList();
        for (PsiElement psiElement : elements) {
            results.addAll(JSXPropTypesUtil.getPropsTypeFromPsiElement(psiElement, tag));
        }
        return JSXPropTypesUtil.chooseOverload(tag, (List<JSType>)results);
    }

    @Nullable
    private static JSType chooseOverload(@NotNull XmlTag tag, @NotNull List<JSType> overloads) {
        if (tag == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(44);
        }
        if (overloads == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(45);
        }
        if (overloads.size() == 1) {
            return overloads.get(0);
        }
        XmlAttribute[] attributes = tag.getAttributes();
        HashMap specified = new HashMap();
        for (XmlAttribute attribute : attributes) {
            String name = attribute.getName();
            if (name.contains(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED)) continue;
            specified.put(name, null);
        }
        List<Object> result2 = new ArrayList();
        for (JSType overload : overloads) {
            JSRecordType type = overload.asRecordType();
            boolean allMatched = true;
            for (Map.Entry entry : specified.entrySet()) {
                String name = (String)entry.getKey();
                if (type.hasProperty(name)) continue;
                allMatched = false;
            }
            if (!allMatched) continue;
            result2.add(overload);
        }
        if (result2.size() == 1) {
            return (JSType)result2.get(0);
        }
        if (result2.size() == 0) {
            result2 = overloads;
        }
        return JSCompositeTypeFactory.createContextualUnionType(result2, JSTypeSourceFactory.createTypeSource((PsiElement)tag, false));
    }

    @Nullable
    private static JSType getTypeFromFunctionParameter(@NotNull JSFunction resolve) {
        JSParameterListElement[] parameters;
        JSType typeFromParam;
        if (resolve == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(46);
        }
        if ((typeFromParam = JSXPropTypesUtil.getPropsTypeFromParameters(parameters = resolve.getParameters())) != null) {
            return typeFromParam;
        }
        return null;
    }

    @Nullable
    private static JSType getPropsTypeFromParameters(JSParameterListElement @NotNull [] parameters) {
        if (parameters == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(47);
        }
        if (parameters.length == 0 || parameters.length > 2) {
            return null;
        }
        JSParameterListElement propParameter = parameters[0];
        boolean hasTypeElement = propParameter.getTypeElement() != null;
        JSType type = propParameter.getJSType();
        if (type != null) {
            return hasTypeElement ? type : type.copyWithStrict(false);
        }
        return DialectDetector.isTypeScript((PsiElement)propParameter) ? JSResolveUtil.getElementJSType((PsiElement)propParameter) : null;
    }

    @NotNull
    private static List<JSType> getPropsTypeFromPsiElementImpl(@Nullable PsiElement elementOrExpression, @NotNull XmlTag tag) {
        JSTypeDeclaration type;
        JSExpression initializerOrStub;
        if (tag == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(48);
        }
        if (elementOrExpression == null) {
            List<JSType> list2 = Collections.emptyList();
            if (list2 == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(49);
            }
            return list2;
        }
        if (elementOrExpression instanceof JSDefinitionExpression && (initializerOrStub = ((JSDefinitionExpression)elementOrExpression).getInitializerOrStub()) != null) {
            elementOrExpression = initializerOrStub;
        }
        if (elementOrExpression instanceof FlowJSTypeCastImpl && (type = ((FlowJSTypeCastImpl)elementOrExpression).getResultType()) != null) {
            JSType jsType2 = type.getJSType();
            return JSXPropTypesUtil.getPropsTypeFromJsType(jsType2);
        }
        if (elementOrExpression instanceof JSClass) {
            return JSXPropTypesUtil.getPropsTypeFromClass((JSClass)elementOrExpression);
        }
        if (elementOrExpression instanceof JSFunction) {
            return JSXPropTypesUtil.getPropsTypeFromFunction((JSFunction)elementOrExpression);
        }
        JSType varType = JSXPropTypesUtil.evaluateStubSafe(elementOrExpression, tag);
        if (varType != null) {
            JSType genericStatelessArg;
            if (varType instanceof JSGenericTypeImpl && (genericStatelessArg = JSTypeUtils.getSingleGenericArgTypeFromGenericType((JSGenericTypeImpl)varType, JSXPropTypesUtil::isReactSingleVariantComponent, true)) != null) {
                List<JSType> list3 = Collections.singletonList(genericStatelessArg);
                if (list3 == null) {
                    JSXPropTypesUtil.$$$reportNull$$$0(50);
                }
                return list3;
            }
            return JSXPropTypesUtil.getPropsTypeFromJsType(varType);
        }
        List<JSType> list4 = Collections.emptyList();
        if (list4 == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(51);
        }
        return list4;
    }

    @Nullable
    private static JSType evaluateStubSafe(@Nullable PsiElement elementOrExpression, @NotNull XmlTag tag) {
        if (tag == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(52);
        }
        return elementOrExpression == null ? null : new JSPsiBasedTypeOfType(elementOrExpression, new JSEvaluateContext(tag.getContainingFile()).withAstAccessForbidden()).substituteOrNull();
    }

    @NotNull
    private static List<JSType> getPropsTypeFromClass(@NotNull JSClass componentClass) {
        if (componentClass == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(53);
        }
        JSType props = JSXPropTypesUtil.getPropsFieldType(componentClass);
        JSType propTypes = JSXPropTypesUtil.getPropTypesStaticFieldType(componentClass);
        List list2 = StreamEx.of((Object[])new JSType[]{props, propTypes}).nonNull().toList();
        if (list2 == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(54);
        }
        return list2;
    }

    @Nullable
    private static JSType getPropTypesStaticFieldType(@NotNull JSClass componentClass) {
        JSField propTypes;
        if (componentClass == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(55);
        }
        if ((propTypes = componentClass.findFieldByName("propTypes")) == null || propTypes.getTypeElement() == null) {
            return null;
        }
        JSType type = JSTypeUtils.getValuableType(propTypes.getJSType());
        if (type == null) {
            return null;
        }
        return type;
    }

    @Nullable
    private static JSType getPropsFieldType(@NotNull JSClass componentClass) {
        JSType result2;
        JSRecordType type;
        if (componentClass == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(56);
        }
        if (!(type = TypeScriptTypeParser.buildTypeFromClass(componentClass, false)).hasMembers()) {
            return null;
        }
        JSRecordType.PropertySignature signature = type.findPropertySignature("props");
        if (signature != null && (result2 = signature.getJSType()) != null && !(result2 instanceof JSAnyType)) {
            return result2;
        }
        JSType genericsType = JSXPropTypesUtil.getClassComponentGenericType(componentClass, false);
        if (genericsType != null && !(genericsType instanceof JSAnyType)) {
            return genericsType;
        }
        return null;
    }

    @NotNull
    private static List<JSType> getPropsTypeFromJsType(@Nullable JSType type) {
        JSRecordType.PropertySignature types2;
        if (type == null) {
            List<JSType> list2 = Collections.emptyList();
            if (list2 == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(57);
            }
            return list2;
        }
        JSRecordType recordType = type.asRecordType();
        List<JSRecordType.CallSignature> signatures = recordType.getCallSignatures();
        ArrayList<JSType> calls = new ArrayList<JSType>();
        for (JSRecordType.CallSignature signature : signatures) {
            if (signature.hasNew()) {
                calls.addAll(JSXPropTypesUtil.getPropsTypeFromNewSignatureType(signature.getReturnType()));
                continue;
            }
            JSFunctionType functionType = signature.getFunctionType();
            JSType result2 = JSXPropTypesUtil.getPropsTypeFromCallSignatureType(functionType.getParameters());
            if (result2 == null) continue;
            calls.add(result2);
        }
        if (calls.isEmpty() && (types2 = recordType.findPropertySignature("propTypes")) != null) {
            List list3 = ContainerUtil.createMaybeSingletonList((Object)types2.getJSType());
            if (list3 == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(58);
            }
            return list3;
        }
        ArrayList<JSType> arrayList = calls;
        if (arrayList == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(59);
        }
        return arrayList;
    }

    @Nullable
    private static JSType getPropsTypeFromCallSignatureType(@NotNull List<JSParameterTypeDecorator> parameters) {
        if (parameters == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(60);
        }
        if (parameters.isEmpty()) {
            return null;
        }
        JSParameterTypeDecorator props = parameters.get(0);
        return props.getSimpleType();
    }

    @NotNull
    private static List<JSType> getPropsTypeFromNewSignatureType(@Nullable JSType returnType) {
        String className2;
        List<JSType> candidates;
        JSResolvedTypeInfo info;
        JSClass resolved;
        if (returnType == null) {
            List<JSType> list2 = Collections.emptyList();
            if (list2 == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(61);
            }
            return list2;
        }
        if (returnType instanceof JSResolvableType && (resolved = (info = ((JSResolvableType)returnType).resolveType()).getDeclarationOfType(JSClass.class)) != null && !(candidates = JSXPropTypesUtil.getPropsTypeFromClass(resolved)).isEmpty()) {
            List<JSType> list3 = candidates;
            if (list3 == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(62);
            }
            return list3;
        }
        if (!(returnType instanceof JSGenericTypeImpl)) {
            List<JSType> list4 = Collections.emptyList();
            if (list4 == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(63);
            }
            return list4;
        }
        JSGenericTypeImpl genericType = (JSGenericTypeImpl)returnType;
        JSType innerType = genericType.getType();
        if (!(innerType instanceof JSResolvableType)) {
            List<JSType> list5 = Collections.emptyList();
            if (list5 == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(64);
            }
            return list5;
        }
        JSResolvedTypeInfo info2 = ((JSResolvableType)innerType).resolveType();
        JSClass aClass = info2.getDeclarationOfType(JSClass.class);
        String string = className2 = aClass == null ? null : aClass.getName();
        if (className2 == null) {
            String string2 = className2 = innerType instanceof JSNamedType ? innerType.getTypeText() : null;
        }
        if (TypeScriptReactComponentUtil.REACT_COMPONENT_NAMES.contains(className2)) {
            JSRecordType.PropertySignature signature = returnType.asRecordType().findPropertySignature("props");
            if (signature != null) {
                List list6 = ContainerUtil.createMaybeSingletonList((Object)signature.getJSType());
                if (list6 == null) {
                    JSXPropTypesUtil.$$$reportNull$$$0(65);
                }
                return list6;
            }
            List list7 = ContainerUtil.createMaybeSingletonList((Object)((JSType)ContainerUtil.getFirstItem(genericType.getArguments())));
            if (list7 == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(66);
            }
            return list7;
        }
        List<JSType> list8 = Collections.emptyList();
        if (list8 == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(67);
        }
        return list8;
    }

    @NotNull
    private static List<JSType> getPropsTypeFromFunction(@NotNull JSFunction resolvedElementOrExpression) {
        if (resolvedElementOrExpression == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(68);
        }
        if (resolvedElementOrExpression instanceof TypeScriptFunction && ((TypeScriptFunction)resolvedElementOrExpression).isOverloadImplementation()) {
            ArrayList<JSType> allTypes = new ArrayList<JSType>();
            for (TypeScriptFunction overload : ((TypeScriptFunction)resolvedElementOrExpression).getOverloadDeclarations()) {
                JSType typeFromParam;
                if (overload.isOverloadImplementation() || (typeFromParam = JSXPropTypesUtil.getTypeFromFunctionParameter(overload)) == null) continue;
                allTypes.add(typeFromParam);
            }
            if (allTypes.size() >= 1) {
                ArrayList<JSType> arrayList = allTypes;
                if (arrayList == null) {
                    JSXPropTypesUtil.$$$reportNull$$$0(69);
                }
                return arrayList;
            }
        }
        List list2 = ContainerUtil.createMaybeSingletonList((Object)JSXPropTypesUtil.getTypeFromFunctionParameter(resolvedElementOrExpression));
        if (list2 == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(70);
        }
        return list2;
    }

    @Contract(value="null -> false")
    private static boolean isReactSingleVariantComponent(@Nullable JSType t) {
        if (!(t instanceof JSResolvableType)) {
            return false;
        }
        JSResolvedTypeInfo info = ((JSResolvableType)t).resolveType();
        JSClass declaration = info.getDeclarationOfType(TypeScriptInterface.class);
        if (declaration == null) {
            declaration = info.getDeclarationOfType(TypeScriptTypeAlias.class);
        }
        return declaration != null && TypeScriptReactComponentUtil.REACT_SINGLE_VARIANT_COMPONENT_NAMES.contains(declaration.getName());
    }

    @NotNull
    private static List<JSType> getPropsTypeFromPsiElement(@Nullable PsiElement resolve, @NotNull XmlTag tag) {
        if (tag == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(71);
        }
        List<JSType> result2 = JSXPropTypesUtil.getPropsTypeFromPsiElementImpl(resolve, tag);
        List list2 = ContainerUtil.map(result2, el -> JSTypeUtils.applyGenericArguments(el, TypeScriptReactComponentUtil.getGenericSubstitutorForTag(resolve, tag)));
        if (list2 == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(72);
        }
        return list2;
    }

    @Nullable
    public static JSImplicitElement substitutePropTypesPropDeclaration(@NotNull JSProperty property) {
        if (property == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(73);
        }
        if (JSXPropTypesUtil.isNamespaceMember(property, "propTypes")) {
            Collection<JSImplicitElement> implicitElements;
            JSElementIndexingData indexingData = property.getIndexingData();
            Collection<JSImplicitElement> collection = implicitElements = indexingData != null ? indexingData.getImplicitElements() : null;
            if (implicitElements == null) {
                return null;
            }
            for (JSImplicitElement element : implicitElements) {
                if (!JSXPropTypesUtil.isNamespaceMember(element, "props")) continue;
                return element;
            }
            return null;
        }
        if (JSXPropTypesUtil.isNamespaceMember(property, "defaultProps", "getDefaultProps")) {
            JSQualifiedName namespace = property.getNamespace();
            assert (namespace != null);
            JSQualifiedName parent = namespace.getParent();
            assert (parent != null);
            Collection<JSPsiElementBase> elements = JSClassResolver.getInstance().findElementsByQNameIncludingImplicit(parent.getQualifiedName() + ".props." + property.getName(), property.getResolveScope());
            for (JSPsiElementBase element : elements) {
                if (!(element instanceof JSImplicitElement)) continue;
                return (JSImplicitElement)element;
            }
        }
        return null;
    }

    public static boolean isNamespaceMember(@NotNull JSPsiElementBase element, String ... namespaceNames) {
        JSQualifiedName namespace;
        if (element == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(74);
        }
        if (namespaceNames == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(75);
        }
        return (namespace = element.getNamespace()) != null && ArrayUtil.contains((String)namespace.getName(), (String[])namespaceNames) && namespace.getParent() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 72: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 72: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reactComponent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/JSXPropTypesUtil";
                break;
            }
            case 4: 
            case 10: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 12: 
            case 13: 
            case 16: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prop";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextClass";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 42: 
            case 44: 
            case 48: 
            case 52: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overloads";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolve";
                break;
            }
            case 47: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 53: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentClass";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedElementOrExpression";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/JSXPropTypesUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveNamespacePropTypes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropTypesForNamespaceElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "convertObjectLiteralToPropsType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createImplicitReactPropsElement";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "processPropTypesExpression";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "toPropType";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropsTypeFromPsiElementImpl";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropsTypeFromClass";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropsTypeFromJsType";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropsTypeFromNewSignatureType";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropsTypeFromFunction";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropsTypeFromPsiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveNamespacePropTypes";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 72: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPropTypesForNamespaceElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertObjectLiteralToPropsType";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addSpreadProperties";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addSimpleProperty";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createImplicitReactPropsElement";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleImplicitElement";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getClassComponentGenericType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getClassComponentGenericDeclaration";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isPossibleReactClassName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processPropTypesExpression";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "toPropType";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getGenericPropType";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "chooseOverload";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromFunctionParameter";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getPropsTypeFromParameters";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getPropsTypeFromPsiElementImpl";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "evaluateStubSafe";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getPropsTypeFromClass";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getPropTypesStaticFieldType";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getPropsFieldType";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getPropsTypeFromCallSignatureType";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getPropsTypeFromFunction";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getPropsTypeFromPsiElement";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "substitutePropTypesPropDeclaration";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "isNamespaceMember";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 72: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

