/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.imports;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.imports.JSModuleImportOptimizerBase;
import com.intellij.lang.javascript.imports.JSOptimizeImportUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.typescript.imports.ES6UnusedImportsHelper;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportOptimizer
extends JSModuleImportOptimizerBase {
    public final boolean supports(@NotNull PsiFile file2) {
        if (file2 == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(0);
        }
        if (!(file2 instanceof JSFile)) {
            return false;
        }
        return this.checkDialect(DialectDetector.dialectOfElement((PsiElement)file2));
    }

    @Override
    @NotNull
    public Collection<JSModuleImportOptimizerBase.UnusedModuleInfo> getModulesInfo(@NotNull PsiElement scope) {
        List<ES6ImportDeclaration> rawDeclarations;
        if (scope == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(1);
        }
        if ((rawDeclarations = ES6ImportPsiUtil.getImportDeclarations(scope)).isEmpty()) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                ES6ImportOptimizer.$$$reportNull$$$0(2);
            }
            return list2;
        }
        final List declarations = ContainerUtil.filter(rawDeclarations, el -> !PsiTreeUtil.hasErrorElements((PsiElement)el));
        final ArrayList<ES6UnusedImportsHelper.UnusedInfo> infos = new ArrayList<ES6UnusedImportsHelper.UnusedInfo>();
        for (ES6ImportDeclaration declaration : declarations) {
            ES6UnusedImportsHelper.UnusedInfo info;
            if (PsiTreeUtil.hasErrorElements((PsiElement)declaration) || !(info = ES6UnusedImportsHelper.getInfo(declaration)).isSideEffectImport() && ES6ImportPsiUtil.getFromClauseText(declaration) == null) continue;
            infos.add(info);
        }
        final List<String> importTexts = this.buildNewImportsText(scope, infos);
        JSModuleImportOptimizerBase.UnusedModuleInfo info = new JSModuleImportOptimizerBase.UnusedModuleInfo(){

            @Override
            @NotNull
            public List<String> getImportTexts() {
                List list2 = importTexts;
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list2;
            }

            @Override
            public PsiElement getAnchor() {
                ES6UnusedImportsHelper.UnusedInfo item = (ES6UnusedImportsHelper.UnusedInfo)ContainerUtil.getFirstItem((List)infos);
                if (item != null) {
                    return item.getDeclaration();
                }
                return (PsiElement)ContainerUtil.getFirstItem((List)declarations);
            }

            @Override
            @NotNull
            public List<PsiElement> getOldImports() {
                List list2 = ContainerUtil.map((Collection)infos, el -> el.getDeclaration());
                if (list2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return list2;
            }

            @Override
            public List<PsiElement> getImportsForScope(@NotNull PsiElement scope) {
                if (scope == null) {
                    1.$$$reportNull$$$0(2);
                }
                return new ArrayList<ES6ImportDeclaration>(ES6ImportPsiUtil.getImportDeclarations(scope));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/imports/ES6ImportOptimizer$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scope";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getImportTexts";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getOldImports";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/imports/ES6ImportOptimizer$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getImportsForScope";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        List list3 = ContainerUtil.createMaybeSingletonList((Object)info);
        if (list3 == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(3);
        }
        return list3;
    }

    @NotNull
    private List<String> buildNewImportsText(@NotNull PsiElement module, @NotNull List<ES6UnusedImportsHelper.UnusedInfo> infos) {
        if (module == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(4);
        }
        if (infos == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(5);
        }
        MultiMap<String, ES6UnusedImportsHelper.UnusedInfo> result2 = ES6ImportOptimizer.groupByFromClause(infos);
        boolean merge = JSCodeStyleSettings.isMergeImports(module);
        ArrayList<String> importsResult = new ArrayList<String>();
        HashSet<String> visitedImports = new HashSet<String>();
        HashSet<String> visitedSideEffectImports = new HashSet<String>();
        Document document2 = PsiDocumentManager.getInstance((Project)module.getProject()).getDocument(module.getContainingFile());
        ArrayList<ES6UnusedImportsHelper.UnusedInfo> toProcessInfos = new ArrayList<ES6UnusedImportsHelper.UnusedInfo>(infos);
        ES6ImportOptimizer.sortByModuleName(module, toProcessInfos);
        for (ES6UnusedImportsHelper.UnusedInfo info : toProcessInfos) {
            Collection importsToMerge;
            ES6ImportDeclaration declaration = info.getDeclaration();
            if (info.isSideEffectImport()) {
                if (!visitedSideEffectImports.add(declaration.getImportModuleText())) continue;
                ArrayList<String> sideEffectImportWithComments = new ArrayList<String>();
                List<String> comments = JSOptimizeImportUtil.getPrevCommentsAsStrings(JSOptimizeImportUtil.getPrevComments(document2, (PsiElement)declaration));
                ES6ImportOptimizer.addEmptyImport(module, document2, sideEffectImportWithComments, info, comments, true);
                JSOptimizeImportUtil.fillImportsWithNewLines(importsResult, ES6ImportOptimizer.getContextForWhitespaces(document2, declaration), sideEffectImportWithComments);
                continue;
            }
            String fromText = ES6ImportPsiUtil.getUnquotedFromClauseText(declaration);
            if (fromText == null || !visitedImports.add(fromText) || (importsToMerge = result2.get((Object)fromText)).isEmpty()) continue;
            ArrayList<String> currentImportsAndComments = new ArrayList<String>();
            List<MergedImports> mergedImportsList = this.getMergedImports(module, importsToMerge, document2, fromText, merge);
            for (MergedImports text : mergedImportsList) {
                Collection<ES6UnusedImportsHelper.UnusedInfo> currentImportInfos = text.myMergedImports;
                List<PsiElement> prevComments = text.myPrevComments;
                List<String> sortedCommentsAsString = JSOptimizeImportUtil.getPrevCommentsAsStrings(prevComments);
                List<String> currentTexts = text.myNewImportTexts;
                if (!currentTexts.isEmpty()) {
                    currentImportsAndComments.addAll(sortedCommentsAsString);
                    currentImportsAndComments.addAll(currentTexts);
                    continue;
                }
                ES6UnusedImportsHelper.UnusedInfo emptyImportInfo = ES6ImportOptimizer.getSuppressedEmptyImport(currentImportInfos);
                if (emptyImportInfo != null) {
                    ES6ImportOptimizer.addEmptyImport(module, document2, currentImportsAndComments, emptyImportInfo, sortedCommentsAsString, false);
                    continue;
                }
                currentImportsAndComments.addAll(sortedCommentsAsString);
            }
            JSOptimizeImportUtil.fillImportsWithNewLines(importsResult, ES6ImportOptimizer.getContextForWhitespaces(document2, declaration), currentImportsAndComments);
        }
        ArrayList<String> arrayList = importsResult;
        if (arrayList == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    private static PsiElement getContextForWhitespaces(Document document2, ES6ImportDeclaration declaration) {
        List<PsiElement> comments = JSOptimizeImportUtil.getPrevComments(document2, (PsiElement)declaration);
        ES6ImportDeclaration eS6ImportDeclaration = comments.isEmpty() ? declaration : comments.get(0);
        if (eS6ImportDeclaration == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(7);
        }
        return eS6ImportDeclaration;
    }

    @NotNull
    protected List<MergedImports> getMergedImports(@NotNull PsiElement module, Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports, Document document2, String fromText, boolean merge) {
        if (module == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(8);
        }
        if (merge) {
            List<MergedImports> list2 = this.getMergedImports(module, document2, fromText, mergedImports);
            if (list2 == null) {
                ES6ImportOptimizer.$$$reportNull$$$0(9);
            }
            return list2;
        }
        HashSet<String> visitedBindings = new HashSet<String>();
        HashSet<String> visitedSpecifiers = new HashSet<String>();
        ArrayList<MergedImports> result2 = new ArrayList<MergedImports>();
        for (ES6UnusedImportsHelper.UnusedInfo info : mergedImports) {
            List<MergedImports> importBodyText = this.getImportBodyText(module, document2, Collections.singleton(info), fromText, visitedBindings, visitedSpecifiers);
            result2.addAll(importBodyText);
        }
        ArrayList<MergedImports> arrayList = result2;
        if (arrayList == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @Nullable
    private static ES6UnusedImportsHelper.UnusedInfo getSuppressedEmptyImport(@NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports) {
        if (mergedImports == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(11);
        }
        return mergedImports.stream().filter(el -> el.isEmpty() && ES6UnusedImportsHelper.isES6SuppressedUnused(el.getDeclaration())).findAny().orElse(null);
    }

    private static void sortByModuleName(@NotNull PsiElement module, @NotNull List<ES6UnusedImportsHelper.UnusedInfo> infos) {
        if (module == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(12);
        }
        if (infos == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(13);
        }
        JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings(module);
        if (!settings.IMPORT_SORT_MODULE_NAME) {
            return;
        }
        Comparator<String> comparator = ES6ImportPsiUtil.getStringImportFromComparator();
        ContainerUtil.sort(infos, (o1, o2) -> {
            ES6ImportDeclaration declaration1 = o1.getDeclaration();
            ES6ImportDeclaration declaration2 = o2.getDeclaration();
            String fromClauseText1 = ES6ImportPsiUtil.getUnquotedFromClauseOrModuleText(declaration1);
            String fromClauseText2 = ES6ImportPsiUtil.getUnquotedFromClauseOrModuleText(declaration2);
            return comparator.compare(fromClauseText1, fromClauseText2);
        });
    }

    protected List<MergedImports> getMergedImports(@NotNull PsiElement module, @Nullable Document document2, @NotNull String fromText, @NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports) {
        if (module == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(14);
        }
        if (fromText == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(15);
        }
        if (mergedImports == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(16);
        }
        return this.getImportBodyText(module, document2, mergedImports, fromText);
    }

    private static void addEmptyImport(@NotNull PsiElement module, @Nullable Document document2, @NotNull List<String> importsResult, @NotNull ES6UnusedImportsHelper.UnusedInfo info, @NotNull List<String> prevComments, boolean isSideEffect) {
        String name;
        if (module == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(17);
        }
        if (importsResult == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(18);
        }
        if (info == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(19);
        }
        if (prevComments == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(20);
        }
        ES6ImportDeclaration declaration = info.getDeclaration();
        String string = name = isSideEffect ? declaration.getImportModuleText() : ES6ImportPsiUtil.getFromClauseText(declaration);
        if (!StringUtil.isEmpty((String)name)) {
            importsResult.addAll(prevComments);
            StringBuilder builder = new StringBuilder();
            builder.append("import ");
            ImportStyle style = ES6ImportOptimizer.getImportStyle(module, declaration);
            String moduleName = StringUtil.unquoteString((String)name);
            if (isSideEffect) {
                ES6ImportOptimizer.addFromPartWithoutKeyword(style, moduleName, builder);
            } else {
                builder.append("{}");
                ES6ImportOptimizer.addFromPart(style, moduleName, builder);
            }
            JSOptimizeImportUtil.addSameLineComments(document2, (PsiElement)declaration, builder);
            importsResult.add(builder.toString());
        }
    }

    @NotNull
    private static MultiMap<String, ES6UnusedImportsHelper.UnusedInfo> groupByFromClause(@NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> infos) {
        if (infos == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(21);
        }
        MultiMap results = MultiMap.createLinked();
        for (ES6UnusedImportsHelper.UnusedInfo info : infos) {
            ES6ImportDeclaration declaration = info.getDeclaration();
            String text = ES6ImportPsiUtil.getUnquotedFromClauseText(declaration);
            if (text == null) continue;
            results.putValue((Object)text, (Object)info);
        }
        MultiMap multiMap = results;
        if (multiMap == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(22);
        }
        return multiMap;
    }

    @NotNull
    protected List<MergedImports> getImportBodyText(@NotNull PsiElement module, @Nullable Document document2, @NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports, @NotNull String fromPart) {
        if (module == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(23);
        }
        if (mergedImports == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(24);
        }
        if (fromPart == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(25);
        }
        HashSet<String> bindings = new HashSet<String>();
        HashSet<String> specifiers = new HashSet<String>();
        List<MergedImports> list2 = this.getImportBodyText(module, document2, mergedImports, fromPart, bindings, specifiers);
        if (list2 == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(26);
        }
        return list2;
    }

    @NotNull
    private static <PartType extends ES6ImportExportDeclarationPart> MultiMap<PartType, ES6ImportDeclaration> getUniqueImportParts(@NotNull List<PartType> parts, @NotNull Collection<String> visitedNames) {
        if (parts == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(27);
        }
        if (visitedNames == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(28);
        }
        MultiMap mergedParts = MultiMap.createLinked();
        HashMap names = new HashMap();
        for (ES6ImportExportDeclarationPart importPart : parts) {
            String name = importPart.getDeclaredName();
            if (name == null || visitedNames.contains(name)) continue;
            ES6ImportExportDeclarationPart storedPart = (ES6ImportExportDeclarationPart)ContainerUtil.getOrCreate(names, (Object)name, (Object)importPart);
            mergedParts.putValue((Object)storedPart, (Object)((ES6ImportDeclaration)importPart.getDeclaration()));
        }
        visitedNames.addAll(names.keySet());
        MultiMap multiMap = mergedParts;
        if (multiMap == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(29);
        }
        return multiMap;
    }

    protected List<MergedImports> getImportBodyText(@NotNull PsiElement context, @Nullable Document document2, @NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports, @NotNull String fromPart, @NotNull Collection<String> visitedBindingNames, @NotNull Collection<String> visitedSpecifierNames) {
        if (context == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(30);
        }
        if (mergedImports == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(31);
        }
        if (fromPart == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(32);
        }
        if (visitedBindingNames == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(33);
        }
        if (visitedSpecifierNames == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(34);
        }
        ArrayList<ES6ImportedBinding> bindings = new ArrayList<ES6ImportedBinding>();
        ArrayList<ES6ImportSpecifier> specifiers = new ArrayList<ES6ImportSpecifier>();
        ArrayList<PsiElement> prevCommentsToProcess = new ArrayList<PsiElement>();
        HashMap<ES6ImportDeclaration, PsiElement> lineCommentsToProcess = new HashMap<ES6ImportDeclaration, PsiElement>();
        for (ES6UnusedImportsHelper.UnusedInfo importInfo : mergedImports) {
            ES6ImportDeclaration declaration = importInfo.getDeclaration();
            ES6ImportOptimizer.fillUsedBindingsAndSpecifiers(bindings, specifiers, importInfo, declaration);
            PsiElement comment = JSOptimizeImportUtil.getLineComment(document2, (PsiElement)declaration);
            if (comment != null) {
                lineCommentsToProcess.put(declaration, comment);
            }
            prevCommentsToProcess.addAll(JSOptimizeImportUtil.getPrevComments(document2, (PsiElement)declaration));
        }
        ES6ImportOptimizer.sortSpecifiers(context, specifiers);
        MultiMap uniqueBindings = ES6ImportOptimizer.getUniqueImportParts(bindings, visitedBindingNames);
        MultiMap<ES6ImportSpecifier, ES6ImportDeclaration> uniqueSpecifiers = ES6ImportOptimizer.getUniqueImportParts(specifiers, visitedSpecifierNames);
        ImportBuilder importBuilder = new ImportBuilder(ES6ImportOptimizer.getImportStyle(context, mergedImports), this.getImportPrefix(mergedImports), fromPart);
        ArrayList<String> resultListOfImportTexts = new ArrayList<String>();
        importBuilder = ES6ImportOptimizer.appendBindings(uniqueBindings, importBuilder, lineCommentsToProcess, resultListOfImportTexts);
        ES6ImportOptimizer.appendSpecifiers(uniqueSpecifiers, importBuilder, lineCommentsToProcess);
        if (!importBuilder.isEmpty()) {
            resultListOfImportTexts.add(importBuilder.createImportString());
        }
        return Collections.singletonList(new MergedImports(mergedImports, resultListOfImportTexts, prevCommentsToProcess));
    }

    private static void sortSpecifiers(@NotNull PsiElement context, @NotNull List<ES6ImportSpecifier> specifiers) {
        if (context == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(35);
        }
        if (specifiers == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(36);
        }
        if (JSCodeStyleSettings.getSettings((PsiElement)context).IMPORT_SORT_MEMBERS) {
            Comparator<ES6ImportSpecifier> comparator = ES6ImportPsiUtil.getImportMemberComparator(context);
            ContainerUtil.sort(specifiers, comparator);
        }
    }

    private static ImportBuilder appendBindings(@NotNull MultiMap<ES6ImportedBinding, ES6ImportDeclaration> uniqueBindings, @NotNull ImportBuilder importBuilder, @NotNull Map<ES6ImportDeclaration, PsiElement> lineCommentsToProcess, @NotNull List<String> listOfImports) {
        if (uniqueBindings == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(37);
        }
        if (importBuilder == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(38);
        }
        if (lineCommentsToProcess == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(39);
        }
        if (listOfImports == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(40);
        }
        int bindingCount = 0;
        boolean lastIsAll = false;
        for (Map.Entry bindingWithDeclarations : uniqueBindings.entrySet()) {
            ES6ImportedBinding binding = (ES6ImportedBinding)bindingWithDeclarations.getKey();
            if (bindingCount > 0) {
                if (bindingCount == 1 && !lastIsAll && binding.isNamespaceImport()) {
                    importBuilder.append(", ");
                } else {
                    listOfImports.add(importBuilder.createImportString());
                    importBuilder = importBuilder.cloneBuilder();
                    bindingCount = 0;
                }
            }
            ++bindingCount;
            ImportBuilder finalImportBuilder = importBuilder;
            ((Collection)bindingWithDeclarations.getValue()).forEach(decl -> ES6ImportOptimizer.addLineCommentsToBuilder(lineCommentsToProcess, finalImportBuilder, decl));
            importBuilder.append(binding.getText());
            lastIsAll = binding.isNamespaceImport();
        }
        if (lastIsAll) {
            listOfImports.add(importBuilder.createImportString());
            return importBuilder.cloneBuilder();
        }
        return importBuilder;
    }

    private static void appendSpecifiers(@NotNull MultiMap<ES6ImportSpecifier, ES6ImportDeclaration> uniqueSpecifiers, @NotNull ImportBuilder importBuilder, @NotNull Map<ES6ImportDeclaration, PsiElement> lineCommentsToProcess) {
        if (uniqueSpecifiers == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(41);
        }
        if (importBuilder == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(42);
        }
        if (lineCommentsToProcess == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(43);
        }
        if (uniqueSpecifiers.isEmpty()) {
            return;
        }
        if (!importBuilder.isEmpty()) {
            importBuilder.append(", ");
        }
        importBuilder.append("{");
        String specifierList = StringUtil.join((Collection)uniqueSpecifiers.entrySet(), el -> {
            ES6ImportSpecifier specifier = (ES6ImportSpecifier)el.getKey();
            ((Collection)el.getValue()).forEach(decl -> ES6ImportOptimizer.addLineCommentsToBuilder(lineCommentsToProcess, importBuilder, decl));
            return specifier.getText();
        }, (String)", ");
        importBuilder.append(specifierList);
        if (importBuilder.myStyle.myAddTrailingComma) {
            importBuilder.append(", ");
        }
        importBuilder.append("}");
    }

    private static void addLineCommentsToBuilder(@NotNull Map<ES6ImportDeclaration, PsiElement> lineCommentsToProcess, @NotNull ImportBuilder builder, @NotNull ES6ImportDeclaration declaration) {
        PsiElement comment;
        if (lineCommentsToProcess == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(44);
        }
        if (builder == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(45);
        }
        if (declaration == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(46);
        }
        if ((comment = lineCommentsToProcess.remove(declaration)) != null) {
            builder.addLineComment(comment);
        }
    }

    private static void fillUsedBindingsAndSpecifiers(List<ES6ImportedBinding> bindings, List<ES6ImportSpecifier> specifiers, ES6UnusedImportsHelper.UnusedInfo importInfo, ES6ImportDeclaration declaration) {
        boolean isSuppressedUnused = ES6UnusedImportsHelper.isES6SuppressedUnused(declaration);
        ES6ImportOptimizer.fillUsedSpecifiers(specifiers, importInfo, declaration, isSuppressedUnused);
        ES6ImportOptimizer.fillUsedBindings(bindings, importInfo, declaration, isSuppressedUnused);
    }

    private static void fillUsedBindings(@NotNull List<ES6ImportedBinding> bindings, @NotNull ES6UnusedImportsHelper.UnusedInfo importInfo, @NotNull ES6ImportDeclaration declaration, boolean isSuppressedUnused) {
        if (bindings == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(47);
        }
        if (importInfo == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(48);
        }
        if (declaration == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(49);
        }
        ES6ImportedBinding[] currentBindings = declaration.getImportedBindings();
        Collection<Object> unusedBindings = isSuppressedUnused ? new ArrayList() : importInfo.getUnusedBindings();
        bindings.addAll(Arrays.stream(currentBindings).filter(el -> !unusedBindings.contains(el)).collect(Collectors.toList()));
    }

    private static void fillUsedSpecifiers(@NotNull List<ES6ImportSpecifier> specifiers, @NotNull ES6UnusedImportsHelper.UnusedInfo importInfo, @NotNull ES6ImportDeclaration declaration, boolean isSuppressedUnused) {
        if (specifiers == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(50);
        }
        if (importInfo == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(51);
        }
        if (declaration == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(52);
        }
        ES6ImportSpecifier[] currentSpecifiers = declaration.getImportSpecifiers();
        Collection<Object> unusedSpecifiers = isSuppressedUnused ? new ArrayList() : importInfo.getUnusedSpecifiers();
        specifiers.addAll(Arrays.stream(currentSpecifiers).filter(el -> !unusedSpecifiers.contains(el)).collect(Collectors.toList()));
    }

    @NotNull
    protected String getImportPrefix(@NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> imports) {
        if (imports == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(53);
        }
        return "import ";
    }

    private static void addFromPart(@NotNull ImportStyle style, @NotNull String fromPart, @NotNull StringBuilder importBody) {
        if (style == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(54);
        }
        if (fromPart == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(55);
        }
        if (importBody == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(56);
        }
        importBody.append(" from ");
        ES6ImportOptimizer.addFromPartWithoutKeyword(style, fromPart, importBody);
    }

    @NotNull
    private static ImportStyle getImportStyle(@NotNull PsiElement context, @NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports) {
        ES6UnusedImportsHelper.UnusedInfo item;
        if (context == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(57);
        }
        if (mergedImports == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(58);
        }
        if ((item = (ES6UnusedImportsHelper.UnusedInfo)ContainerUtil.getFirstItem(mergedImports)) == null) {
            return ES6ImportOptimizer.getDefaultImportStyle(context);
        }
        ES6ImportDeclaration declaration = item.getDeclaration();
        return ES6ImportOptimizer.getImportStyle(context, declaration);
    }

    @NotNull
    private static ImportStyle getDefaultImportStyle(@NotNull PsiElement context) {
        if (context == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(59);
        }
        return new ImportStyle(JSCodeStyleSettings.getQuote(context), false, JSCodeStyleSettings.getSemicolon(context));
    }

    @NotNull
    private static ImportStyle getImportStyle(@NotNull PsiElement context, @NotNull ES6ImportDeclaration declaration) {
        if (context == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(60);
        }
        if (declaration == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(61);
        }
        String semicolon = ES6ImportOptimizer.getSemicolon(context, declaration);
        String quote = ES6ImportOptimizer.getQuote(context, declaration);
        boolean shouldAddTrailingCommaToSpecifiers = ES6ImportOptimizer.shouldAddTrailingCommaToSpecifiers(context, declaration);
        return new ImportStyle(quote, shouldAddTrailingCommaToSpecifiers, semicolon);
    }

    private static boolean shouldAddTrailingCommaToSpecifiers(@NotNull PsiElement context, @NotNull ES6ImportDeclaration declaration) {
        ES6ImportSpecifier[] specifiers;
        if (context == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(62);
        }
        if (declaration == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(63);
        }
        if ((specifiers = declaration.getImportSpecifiers()).length == 0) {
            return false;
        }
        JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings(context);
        if (settings.ENFORCE_TRAILING_COMMA == JSCodeStyleSettings.TrailingCommaOption.Remove) {
            return false;
        }
        ES6ImportSpecifier lastSpecifier = specifiers[specifiers.length - 1];
        PsiElement sibling = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)lastSpecifier);
        return sibling != null && sibling.getNode().getElementType() == JSTokenTypes.COMMA;
    }

    @NotNull
    private static String getQuote(@NotNull PsiElement context, @NotNull ES6ImportDeclaration declaration) {
        if (context == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(64);
        }
        if (declaration == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(65);
        }
        ASTNode declarationNode = declaration.getNode();
        ES6FromClause clause = declaration.getFromClause();
        ASTNode parentNode = clause == null ? declarationNode : clause.getNode();
        ASTNode stringLiteral = parentNode.findChildByType(JSTokenTypes.STRING_LITERAL);
        String string = ES6ImportPsiUtil.getQuote(context, stringLiteral);
        if (string == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(66);
        }
        return string;
    }

    private static String getSemicolon(@NotNull PsiElement context, @NotNull ES6ImportDeclaration declaration) {
        if (context == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(67);
        }
        if (declaration == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(68);
        }
        JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings(context);
        if (settings.FORCE_SEMICOLON_STYLE) {
            return JSCodeStyleSettings.getSemicolon(context);
        }
        ASTNode declarationNode = declaration.getNode();
        ASTNode semicolonNode = declarationNode.findChildByType(JSTokenTypes.SEMICOLON);
        return semicolonNode == null ? "" : semicolonNode.getText();
    }

    private static void addFromPartWithoutKeyword(@NotNull ImportStyle style, @NotNull String fromPart, @NotNull StringBuilder importBody) {
        if (style == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(69);
        }
        if (fromPart == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(70);
        }
        if (importBody == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(71);
        }
        String quote = style.myQuote;
        importBody.append(quote);
        importBody.append(fromPart);
        importBody.append(quote);
        importBody.append(style.mySemicolon);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 22: 
            case 26: 
            case 29: 
            case 66: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 22: 
            case 26: 
            case 29: 
            case 66: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 22: 
            case 26: 
            case 29: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/imports/ES6ImportOptimizer";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 14: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 11: 
            case 16: 
            case 24: 
            case 31: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergedImports";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromText";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importsResult";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevComments";
                break;
            }
            case 25: 
            case 32: 
            case 55: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromPart";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedNames";
                break;
            }
            case 30: 
            case 35: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedBindingNames";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedSpecifierNames";
                break;
            }
            case 36: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifiers";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uniqueBindings";
                break;
            }
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importBuilder";
                break;
            }
            case 39: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineCommentsToProcess";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOfImports";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uniqueSpecifiers";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 46: 
            case 49: 
            case 52: 
            case 61: 
            case 63: 
            case 65: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindings";
                break;
            }
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importInfo";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imports";
                break;
            }
            case 54: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 56: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importBody";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/imports/ES6ImportOptimizer";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNewImportsText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextForWhitespaces";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergedImports";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "groupByFromClause";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportBodyText";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueImportParts";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "supports";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getModulesInfo";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 22: 
            case 26: 
            case 29: 
            case 66: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildNewImportsText";
                break;
            }
            case 8: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getMergedImports";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressedEmptyImport";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "sortByModuleName";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addEmptyImport";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "groupByFromClause";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getImportBodyText";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueImportParts";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "sortSpecifiers";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "appendBindings";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "appendSpecifiers";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "addLineCommentsToBuilder";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "fillUsedBindings";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "fillUsedSpecifiers";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getImportPrefix";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "addFromPart";
                break;
            }
            case 57: 
            case 58: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getImportStyle";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultImportStyle";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddTrailingCommaToSpecifiers";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getQuote";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getSemicolon";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "addFromPartWithoutKeyword";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 22: 
            case 26: 
            case 29: 
            case 66: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class MergedImports {
        @NotNull
        private final Collection<ES6UnusedImportsHelper.UnusedInfo> myMergedImports;
        @NotNull
        private final List<String> myNewImportTexts;
        @NotNull
        private final List<PsiElement> myPrevComments;

        public MergedImports(@NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports, @NotNull List<String> newImportTexts, @NotNull List<PsiElement> prevComments) {
            if (mergedImports == null) {
                MergedImports.$$$reportNull$$$0(0);
            }
            if (newImportTexts == null) {
                MergedImports.$$$reportNull$$$0(1);
            }
            if (prevComments == null) {
                MergedImports.$$$reportNull$$$0(2);
            }
            this.myMergedImports = mergedImports;
            this.myNewImportTexts = newImportTexts;
            this.myPrevComments = prevComments;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mergedImports";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "newImportTexts";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "prevComments";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/imports/ES6ImportOptimizer$MergedImports";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ImportBuilder {
        @NotNull
        private final ImportStyle myStyle;
        @NotNull
        private final String myImportPrefix;
        @NotNull
        private final String myFromPart;
        @NotNull
        private final StringBuilder myCurrentText;
        @NotNull
        private final List<PsiElement> myLineComments;

        ImportBuilder(@NotNull ImportStyle style, @NotNull String importPrefix, @NotNull String fromPart) {
            if (style == null) {
                ImportBuilder.$$$reportNull$$$0(0);
            }
            if (importPrefix == null) {
                ImportBuilder.$$$reportNull$$$0(1);
            }
            if (fromPart == null) {
                ImportBuilder.$$$reportNull$$$0(2);
            }
            this.myStyle = style;
            this.myImportPrefix = importPrefix;
            this.myFromPart = fromPart;
            this.myCurrentText = new StringBuilder();
            this.myLineComments = new ArrayList<PsiElement>();
        }

        private void append(@NotNull String text) {
            if (text == null) {
                ImportBuilder.$$$reportNull$$$0(3);
            }
            this.myCurrentText.append(text);
        }

        private boolean isEmpty() {
            return this.myCurrentText.length() == 0;
        }

        private void addLineComment(@NotNull PsiElement comment) {
            if (comment == null) {
                ImportBuilder.$$$reportNull$$$0(4);
            }
            this.myLineComments.add(comment);
        }

        @NotNull
        private String createImportString() {
            assert (!this.isEmpty());
            ES6ImportOptimizer.addFromPart(this.myStyle, this.myFromPart, this.myCurrentText);
            JSOptimizeImportUtil.addSameLineComments(this.myCurrentText, JSOptimizeImportUtil.getPsiElementsAsStrings(this.myLineComments));
            String string = this.myImportPrefix + this.myCurrentText;
            if (string == null) {
                ImportBuilder.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        private ImportBuilder cloneBuilder() {
            return new ImportBuilder(this.myStyle, this.myImportPrefix, this.myFromPart);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "style";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importPrefix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fromPart";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/imports/ES6ImportOptimizer$ImportBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/imports/ES6ImportOptimizer$ImportBuilder";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createImportString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "append";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addLineComment";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ImportStyle {
        private final String mySemicolon;
        private final String myQuote;
        private final boolean myAddTrailingComma;

        ImportStyle(String quote, boolean addTrailingComma, String semicolon) {
            this.mySemicolon = semicolon;
            this.myQuote = quote;
            this.myAddTrailingComma = addTrailingComma;
        }
    }
}

