/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.JSRecursiveWalkingElementSkippingNestedFunctionsVisitor;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSStatementWithLabelReference;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeGuard;
import com.intellij.lang.javascript.psi.util.ExpressionUtil;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.util.JSFunctionsRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSConvertLoopsUtils {
    @NotNull
    private static final String INDEXED_FOR_IN_TEXT = "for (let %s = 0; %s < %s; %s++){}";
    @NotNull
    private static final String FOR_OF_TEXT = "for (%s %s of %s) {}";
    @NotNull
    private static final String INDEX_TEXT = "%s %s = %s.indexOf(%s)%s";
    @NotNull
    private static final String ITEM_TEXT = "%s = %s[%s]%s";
    @NotNull
    private static final String ITEM_DEFAULT_NAME = "item";
    @NotNull
    private static final String INDEX_DEFAULT_NAME = "i";

    @NotNull
    private static JSLoopStatement getPlainIndexedForInStatement(@NotNull String collectionExpressionText, @NotNull String indexText, @NotNull PsiElement context) {
        if (collectionExpressionText == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(0);
        }
        if (indexText == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(1);
        }
        if (context == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(2);
        }
        String collectionExpressionLengthText = collectionExpressionText + ".length";
        String text = String.format(INDEXED_FOR_IN_TEXT, indexText, indexText, collectionExpressionLengthText, indexText);
        JSLoopStatement jSLoopStatement = JSPsiElementFactory.createJSStatement(text, context, JSForStatement.class);
        if (jSLoopStatement == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(3);
        }
        return jSLoopStatement;
    }

    @NotNull
    private static JSLoopStatement createPlainForInStatement(@NotNull String collectionExpressionText, @NotNull String itemText, @NotNull String varKeyword, @NotNull PsiElement context) {
        if (collectionExpressionText == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(4);
        }
        if (itemText == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(5);
        }
        if (varKeyword == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(6);
        }
        if (context == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(7);
        }
        String text = String.format(FOR_OF_TEXT, varKeyword, itemText, collectionExpressionText);
        JSLoopStatement jSLoopStatement = JSPsiElementFactory.createJSStatement(text, context, JSForInStatement.class);
        if (jSLoopStatement == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(8);
        }
        return jSLoopStatement;
    }

    @NotNull
    private static JSBlockStatement updateArrayForEachCallBody(@NotNull JSElement expression, @NotNull ArrayFunctionInfo functionInfo, @NotNull JSBlockStatement loopBody) {
        if (expression == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(9);
        }
        if (functionInfo == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(10);
        }
        if (loopBody == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(11);
        }
        if (!(expression instanceof JSCallExpression)) {
            JSBlockStatement jSBlockStatement = loopBody;
            if (jSBlockStatement == null) {
                JSConvertLoopsUtils.$$$reportNull$$$0(12);
            }
            return jSBlockStatement;
        }
        if (((JSCallExpression)expression).getArguments()[0] instanceof JSReferenceExpression) {
            JSStatement callStatement = JSConvertLoopsUtils.createFunctionCallStatementFromReference((JSCallExpression)expression, functionInfo.buildParametersToString());
            JSChangeUtil.doAddAfter(loopBody, (PsiElement)callStatement, loopBody.getFirstChild());
        } else {
            functionInfo.renameParameterUsages();
            loopBody = JSFunctionsRefactoringUtil.copyFunctionBody(functionInfo.getDeclaration(), loopBody);
            JSConvertLoopsUtils.replaceReturnWithContinue(loopBody);
        }
        JSBlockStatement jSBlockStatement = loopBody;
        if (jSBlockStatement == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(13);
        }
        return jSBlockStatement;
    }

    private static void updateArrayMapCallBody(@NotNull String outputCollectionReference, @NotNull JSElement expression, @NotNull ArrayFunctionInfo functionInfo, @NotNull JSBlockStatement loopBody) {
        if (outputCollectionReference == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(14);
        }
        if (expression == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(15);
        }
        if (functionInfo == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(16);
        }
        if (loopBody == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(17);
        }
        if (!(expression instanceof JSCallExpression)) {
            return;
        }
        if (((JSCallExpression)expression).getArguments()[0] instanceof JSReferenceExpression) {
            JSExpression callExpression = JSConvertLoopsUtils.createFunctionCallExpressionFromReference((JSCallExpression)expression, functionInfo.buildParametersToString());
            JSStatement arrayMethodCall = JSConvertLoopsUtils.createArrayMethodCall(outputCollectionReference, callExpression, "push");
            JSChangeUtil.doAddAfter(loopBody, (PsiElement)arrayMethodCall, loopBody.getFirstChild());
        } else {
            functionInfo.renameParameterUsages();
            JSBlockStatement functionBody = JSFunctionsRefactoringUtil.copyFunctionBody(functionInfo.getDeclaration(), loopBody);
            Collection<JSReturnStatement> returnStatements = JSConvertLoopsUtils.getReturnStatements(functionBody);
            if (returnStatements.size() > 1) {
                return;
            }
            JSReturnStatement returnStatement = (JSReturnStatement)ContainerUtil.getFirstItem(returnStatements);
            if (returnStatement == null) {
                return;
            }
            JSExpression returnExpression = returnStatement.getExpression();
            if (returnExpression == null) {
                return;
            }
            JSStatement arrayMethodCall = JSConvertLoopsUtils.createArrayMethodCall(outputCollectionReference, returnExpression, "push");
            returnStatement.replace(arrayMethodCall);
            loopBody.replace(functionBody);
        }
    }

    @NotNull
    private static JSStatement createArrayMethodCall(@NotNull String collectionExpression, @NotNull JSExpression argumentExpression, @NotNull String methodName) {
        if (collectionExpression == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(18);
        }
        if (argumentExpression == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(19);
        }
        if (methodName == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(20);
        }
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)argumentExpression);
        String callText = String.format("%s.%s(%s)%s", collectionExpression, methodName, argumentExpression.getText(), semicolon);
        JSStatement jSStatement = JSPsiElementFactory.createJSStatement(callText, (PsiElement)argumentExpression);
        if (jSStatement == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(21);
        }
        return jSStatement;
    }

    @NotNull
    private static JSStatement createFunctionCallStatementFromReference(@NotNull JSCallExpression expression, @NotNull String argumentsText) {
        if (expression == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(22);
        }
        if (argumentsText == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(23);
        }
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)expression);
        String callText = String.format("%s(%s)%s", expression.getArguments()[0].getText(), argumentsText, semicolon);
        JSStatement jSStatement = JSPsiElementFactory.createJSStatement(callText, (PsiElement)expression);
        if (jSStatement == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(24);
        }
        return jSStatement;
    }

    @NotNull
    private static JSExpression createFunctionCallExpressionFromReference(@NotNull JSCallExpression expression, @NotNull String argumentsText) {
        if (expression == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(25);
        }
        if (argumentsText == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(26);
        }
        String callText = String.format("%s(%s)", expression.getArguments()[0].getText(), argumentsText);
        JSExpression jSExpression = JSPsiElementFactory.createJSExpression(callText, (PsiElement)expression);
        if (jSExpression == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(27);
        }
        return jSExpression;
    }

    public static void addIndexStatementText(@NotNull String indexText, @NotNull String itemText, @NotNull String collectionExpressionText, @NotNull JSBlockStatement forOfBlockBody, @NotNull JSVarStatement.VarKeyword keyword) {
        if (indexText == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(28);
        }
        if (itemText == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(29);
        }
        if (collectionExpressionText == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(30);
        }
        if (forOfBlockBody == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(31);
        }
        if (keyword == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(32);
        }
        String semicolon = JSCodeStyleSettings.getSemicolon(forOfBlockBody);
        String indexStatementText = String.format(INDEX_TEXT, keyword.getText(), indexText, collectionExpressionText, itemText, semicolon);
        JSStatement indexStatement = JSPsiElementFactory.createJSStatement(indexStatementText, forOfBlockBody);
        JSChangeUtil.doAddAfter(forOfBlockBody, (PsiElement)indexStatement, forOfBlockBody.getFirstChild());
    }

    public static void replaceReturnWithContinue(@NotNull JSBlockStatement forOfBlockBody) {
        if (forOfBlockBody == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(33);
        }
        String semicolon = JSCodeStyleSettings.getSemicolon(forOfBlockBody);
        for (JSReturnStatement returnStatement : JSConvertLoopsUtils.getReturnStatements(forOfBlockBody)) {
            JSExpression returnExpression = returnStatement.getExpression();
            if (returnExpression == null) {
                JSStatement breakStatement = JSPsiElementFactory.createJSStatement("continue" + semicolon, (PsiElement)returnStatement);
                returnStatement.replace(breakStatement);
                continue;
            }
            JSStatement expressionStatement = JSPsiElementFactory.createJSStatement(returnExpression.getText() + semicolon, (PsiElement)returnStatement);
            returnStatement.replace(expressionStatement);
        }
    }

    @NotNull
    public static Collection<JSReturnStatement> getReturnStatements(@NotNull JSBlockStatement forOfBlockBody) {
        if (forOfBlockBody == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(34);
        }
        final ArrayList<JSReturnStatement> returnStatements = new ArrayList<JSReturnStatement>();
        forOfBlockBody.accept(new JSRecursiveWalkingElementSkippingNestedFunctionsVisitor(){

            @Override
            protected boolean skipLambdas() {
                return true;
            }

            @Override
            public void visitJSReturnStatement(JSReturnStatement node) {
                super.visitJSReturnStatement(node);
                returnStatements.add(node);
            }
        });
        ArrayList<JSReturnStatement> arrayList = returnStatements;
        if (arrayList == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(35);
        }
        return arrayList;
    }

    private static void addItemStatementText(@NotNull String itemText, @NotNull String indexText, @NotNull String collectionExpressionText, @NotNull JSStatement forOfBlockBody, @Nullable JSVarStatement.VarKeyword keyword) {
        if (itemText == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(36);
        }
        if (indexText == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(37);
        }
        if (collectionExpressionText == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(38);
        }
        if (forOfBlockBody == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(39);
        }
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)forOfBlockBody);
        String declarationText = keyword != null ? keyword.getText() + " %s = %s[%s]%s" : ITEM_TEXT;
        String itemStatementText = String.format(declarationText, itemText, collectionExpressionText, indexText, semicolon);
        JSStatement itemStatement = JSPsiElementFactory.createJSStatement(itemStatementText, (PsiElement)forOfBlockBody);
        JSChangeUtil.doAddAfter((PsiElement)forOfBlockBody, (PsiElement)itemStatement, forOfBlockBody.getFirstChild());
    }

    @Nullable
    public static JSExpression getCollectionExpression(@NotNull JSCallExpression callExpression) {
        JSExpression methodExpression;
        if (callExpression == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(40);
        }
        if (!((methodExpression = callExpression.getMethodExpression()) instanceof JSReferenceExpression)) {
            return null;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)methodExpression;
        return referenceExpression.getQualifier();
    }

    @Nullable
    public static JSFunction getFunction(@NotNull JSCallExpression callExpression) {
        JSExpression argument;
        if (callExpression == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(41);
        }
        if ((argument = callExpression.getArguments()[0]) instanceof JSFunctionExpression) {
            return (JSFunction)((Object)argument);
        }
        if (argument instanceof JSReferenceExpression) {
            return JSPsiImplUtils.getPossibleFunction(((JSReferenceExpression)argument).resolve());
        }
        return null;
    }

    public static boolean isCalledWithFunctionReference(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(42);
        }
        JSExpression argument = callExpression.getArguments()[0];
        return argument instanceof JSReferenceExpression;
    }

    public static boolean isForEachCall(@Nullable JSCallExpression callExpression) {
        return JSConvertLoopsUtils.isArrayMethodCall(callExpression, "forEach");
    }

    public static boolean isMapCall(@Nullable JSCallExpression callExpression) {
        return JSConvertLoopsUtils.isArrayMethodCall(callExpression, "map");
    }

    private static boolean isArrayMethodCall(@Nullable JSCallExpression callExpression, @NotNull String memberName) {
        boolean methodSignatureIsSuitable;
        if (memberName == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(43);
        }
        if (callExpression == null) {
            return false;
        }
        JSExpression methodExpression = callExpression.getMethodExpression();
        boolean bl = methodSignatureIsSuitable = methodExpression instanceof JSReferenceExpression && memberName.equals(((JSReferenceExpression)methodExpression).getReferenceName()) && ((JSReferenceExpression)methodExpression).getQualifier() != null && callExpression.getArguments().length == 1;
        if (!methodSignatureIsSuitable) {
            return false;
        }
        JSExpression expression = ((JSReferenceExpression)methodExpression).getQualifier();
        JSType type = JSResolveUtil.getExpressionJSType(expression);
        return JSConvertLoopsUtils.hasMemberInArrayLike(type, memberName);
    }

    public static boolean hasMemberInArrayLike(@Nullable JSType type, @NotNull String memberName) {
        if (memberName == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(44);
        }
        if (JSTypeUtils.isNullOrAny(type)) {
            return true;
        }
        if (!JSConvertLoopsUtils.isArrayType(type) && !JSConvertLoopsUtils.isTypeWithNames(type, JSCommonTypeNames.ARRAY_LIKE_TYPES)) {
            return false;
        }
        return type.asRecordType().hasProperty(memberName);
    }

    public static boolean isTypeWithNames(@Nullable JSType type, @NotNull Set<String> expectedTypes) {
        if (expectedTypes == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(45);
        }
        if (type instanceof JSGenericTypeImpl) {
            type = ((JSGenericTypeImpl)type).getType();
        }
        return JSNamedType.isNamedTypeWithNames(type, expectedTypes);
    }

    @NotNull
    public static JSStatement getIndexedStatementFromForOf(@NotNull JSForInStatement forInStatement) {
        String itemText;
        JSExpression collectionExpression;
        if (forInStatement == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(46);
        }
        if ((collectionExpression = forInStatement.getCollectionExpression()) == null) {
            JSForInStatement jSForInStatement = forInStatement;
            if (jSForInStatement == null) {
                JSConvertLoopsUtils.$$$reportNull$$$0(47);
            }
            return jSForInStatement;
        }
        JSStatement oldBodyBlock = forInStatement.getBody();
        if (oldBodyBlock == null) {
            JSForInStatement jSForInStatement = forInStatement;
            if (jSForInStatement == null) {
                JSConvertLoopsUtils.$$$reportNull$$$0(48);
            }
            return jSForInStatement;
        }
        String collectionExpressionText = collectionExpression.getText();
        JSVarStatement declarationStatement = forInStatement.getVarDeclaration();
        boolean needKeyword = true;
        if (declarationStatement == null) {
            JSExpression variableExpression = forInStatement.getVariableExpression();
            if (variableExpression == null) {
                JSForInStatement jSForInStatement = forInStatement;
                if (jSForInStatement == null) {
                    JSConvertLoopsUtils.$$$reportNull$$$0(49);
                }
                return jSForInStatement;
            }
            itemText = variableExpression.getText();
            needKeyword = false;
        } else {
            itemText = declarationStatement.getDeclarations()[0].getText();
        }
        JSVarStatement.VarKeyword keyword = needKeyword ? declarationStatement.getVarKeyword() : null;
        String indexTextWithoutType = JSNameSuggestionsUtil.ensureUniqueVariableName(INDEX_DEFAULT_NAME, (PsiElement)forInStatement, new HashSet<String>(), false);
        JSLoopStatement plainIndexedForInStatement = JSConvertLoopsUtils.getPlainIndexedForInStatement(collectionExpressionText, indexTextWithoutType, (PsiElement)forInStatement);
        JSStatement forOfBlockBody = plainIndexedForInStatement.getBody();
        assert (forOfBlockBody != null);
        forOfBlockBody = JSChangeUtil.replaceStatement(forOfBlockBody, (JSStatement)oldBodyBlock.copy());
        JSConvertLoopsUtils.addItemStatementText(itemText, indexTextWithoutType, collectionExpressionText, forOfBlockBody, keyword);
        JSLoopStatement jSLoopStatement = plainIndexedForInStatement;
        if (jSLoopStatement == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(50);
        }
        return jSLoopStatement;
    }

    @Nullable
    public static JSStatement getForInStatementFromForEachCall(@NotNull JSCallExpression callExpression, @NotNull JSFunction function2, @NotNull LoopType loopType) {
        String reference;
        String declaration;
        JSExpression expression;
        if (callExpression == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(51);
        }
        if (function2 == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(52);
        }
        if (loopType == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(53);
        }
        if ((expression = JSConvertLoopsUtils.getCollectionExpression(callExpression)) == null) {
            return null;
        }
        String collectionExpressionText = expression.getText();
        ArrayFunctionInfo arrayFunctionInfo = JSConvertLoopsUtils.getArrayFunctionInfo(function2, (PsiElement)callExpression);
        ArrayFunctionParameter item = arrayFunctionInfo.getItem();
        ArrayFunctionParameter index = arrayFunctionInfo.getIndex();
        if (item == null || index == null) {
            return null;
        }
        JSVarStatement.VarKeyword itemKeyword = JSConvertLoopsUtils.getDeclarationKeywordFromUsages((PsiElement)item.getOriginalElement());
        JSVarStatement.VarKeyword indexKeyword = JSConvertLoopsUtils.getDeclarationKeywordFromUsages((PsiElement)index.getOriginalElement());
        JSLoopStatement loopStatement = JSConvertLoopsUtils.createEmptyLoopStatement(arrayFunctionInfo, collectionExpressionText, loopType);
        JSBlockStatement forOfBlockBody = Objects.requireNonNull((JSBlockStatement)loopStatement.getBody());
        forOfBlockBody = JSConvertLoopsUtils.updateArrayForEachCallBody(callExpression, arrayFunctionInfo, forOfBlockBody);
        if (arrayFunctionInfo.isIndexSpecified() && loopType == LoopType.FOR_OF) {
            declaration = index.getNewVariableDeclaration();
            reference = item.getNewReference();
            if (declaration == null || reference == null) {
                return loopStatement;
            }
            JSConvertLoopsUtils.addIndexStatementText(declaration, reference, collectionExpressionText, forOfBlockBody, (JSVarStatement.VarKeyword)((Object)ObjectUtils.coalesce((Object)((Object)indexKeyword), (Object)((Object)JSVarStatement.VarKeyword.CONST))));
        }
        if (arrayFunctionInfo.isItemSpecified() && loopType == LoopType.INDEXED) {
            declaration = item.getNewVariableDeclaration();
            reference = index.getNewReference();
            if (declaration == null || reference == null) {
                return loopStatement;
            }
            JSConvertLoopsUtils.addItemStatementText(declaration, reference, collectionExpressionText, forOfBlockBody, itemKeyword);
        }
        return loopStatement;
    }

    @Nullable
    private static JSVarStatement.VarKeyword getDeclarationKeywordFromUsages(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(element);
        if (dialect == null || !dialect.hasFeature(JSLanguageFeature.LET_DEFINITIONS)) {
            return JSVarStatement.VarKeyword.VAR;
        }
        boolean hasWriteAccess = ReferencesSearch.search((PsiElement)element).anyMatch(ref -> JSReadWriteAccessDetector.ourInstance.getReferenceAccess(element, (PsiReference)ref) != ReadWriteAccessDetector.Access.Read);
        return hasWriteAccess ? JSVarStatement.VarKeyword.LET : JSVarStatement.VarKeyword.CONST;
    }

    public static void replaceMapCallWithForInStatement(@NotNull JSVarStatement varStatement, @NotNull JSCallExpression callExpression, @NotNull JSFunction function2, @NotNull LoopType loopType) {
        JSExpression expression;
        if (varStatement == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(54);
        }
        if (callExpression == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(55);
        }
        if (function2 == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(56);
        }
        if (loopType == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(57);
        }
        if ((expression = JSConvertLoopsUtils.getCollectionExpression(callExpression)) == null) {
            return;
        }
        String collectionExpressionText = expression.getText();
        ArrayFunctionInfo arrayFunctionInfo = JSConvertLoopsUtils.getArrayFunctionInfo(function2, (PsiElement)callExpression);
        Pair<String, JSStatement> arrayInitializer = JSConvertLoopsUtils.createEmptyArrayInitializer(varStatement);
        JSLoopStatement loopStatement = JSConvertLoopsUtils.createEmptyLoopStatement(arrayFunctionInfo, collectionExpressionText, loopType);
        JSBlockStatement loopBody = Objects.requireNonNull((JSBlockStatement)loopStatement.getBody());
        JSConvertLoopsUtils.updateArrayMapCallBody((String)arrayInitializer.first, callExpression, arrayFunctionInfo, loopBody);
        JSChangeUtil.doAddBefore(varStatement.getParent(), (PsiElement)arrayInitializer.second, (PsiElement)varStatement);
        varStatement.replace(loopStatement);
    }

    @NotNull
    private static JSLoopStatement createEmptyLoopStatement(@NotNull ArrayFunctionInfo arrayFunctionInfo, @NotNull String collectionExpressionText, @NotNull LoopType loopType) {
        JSLoopStatement loopStatement;
        if (arrayFunctionInfo == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(58);
        }
        if (collectionExpressionText == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(59);
        }
        if (loopType == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(60);
        }
        JSFunction function2 = arrayFunctionInfo.getDeclaration();
        switch (loopType) {
            case FOR_OF: {
                ArrayFunctionParameter item = arrayFunctionInfo.getItem();
                assert (item != null);
                JSParameterListElement itemElement = item.getOriginalElement();
                TreeElement node = (TreeElement)ObjectUtils.tryCast((Object)(itemElement != null ? itemElement.getNode() : null), TreeElement.class);
                boolean useLetKeyword = node != null && JSTreeUtil.hasLocalReassignments(node, true);
                loopStatement = JSConvertLoopsUtils.createPlainForInStatement(collectionExpressionText, Objects.requireNonNull(item.getNewReference()), useLetKeyword ? "let" : "const", (PsiElement)function2);
                break;
            }
            case INDEXED: {
                ArrayFunctionParameter index = arrayFunctionInfo.getIndex();
                assert (index != null);
                loopStatement = JSConvertLoopsUtils.getPlainIndexedForInStatement(collectionExpressionText, Objects.requireNonNull(index.getNewReference()), (PsiElement)function2);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + loopType);
            }
        }
        JSLoopStatement jSLoopStatement = loopStatement;
        if (jSLoopStatement == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(61);
        }
        return jSLoopStatement;
    }

    @NotNull
    private static Pair<String, JSStatement> createEmptyArrayInitializer(@NotNull JSVarStatement declaration) {
        if (declaration == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(62);
        }
        JSVariable variable = declaration.getVariables()[0];
        assert (variable != null);
        String variableName = variable.getName();
        JSVarStatement.VarKeyword keyword = (JSVarStatement.VarKeyword)((Object)ObjectUtils.coalesce((Object)((Object)declaration.getVarKeyword()), (Object)((Object)JSVarStatement.VarKeyword.LET)));
        String expressionText = String.format("%s %s = []%s", keyword.getText(), variableName, JSCodeStyleSettings.getSemicolon((PsiElement)declaration));
        JSStatement statement = JSPsiElementFactory.createJSStatement(expressionText, (PsiElement)declaration);
        Pair pair = Pair.create((Object)variableName, (Object)statement);
        if (pair == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(63);
        }
        return pair;
    }

    @NotNull
    private static ArrayFunctionInfo getArrayFunctionInfo(@NotNull JSFunction function2, @NotNull PsiElement scope) {
        boolean hasIndexText;
        boolean hasItemText;
        if (function2 == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(64);
        }
        if (scope == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(65);
        }
        JSParameterListElement[] parameters = function2.getParameters();
        ArrayFunctionInfo info = new ArrayFunctionInfo(function2, scope);
        boolean bl = hasItemText = parameters.length > 0;
        if (hasItemText) {
            info.createItemParameter(parameters[0]);
        } else {
            info.createItemParameter(null);
        }
        boolean bl2 = hasIndexText = parameters.length > 1;
        if (hasIndexText) {
            info.createIndexParameter(parameters[1]);
        } else {
            info.createIndexParameter(null);
        }
        ArrayFunctionInfo arrayFunctionInfo = info;
        if (arrayFunctionInfo == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(66);
        }
        return arrayFunctionInfo;
    }

    public static boolean isArrayType(@Nullable JSExpression expression) {
        if (expression instanceof JSArrayLiteralExpression) {
            return true;
        }
        return JSConvertLoopsUtils.isArrayType(JSResolveUtil.getExpressionJSType(expression));
    }

    public static boolean isArrayType(@Nullable JSType type) {
        if (type == null) {
            return false;
        }
        if (JSTypeUtils.isArrayLikeType(type)) {
            return true;
        }
        if (type instanceof JSUnionType) {
            return ((JSUnionType)type).getTypes().stream().anyMatch(JSTypeUtils::isArrayLikeType);
        }
        return false;
    }

    public static boolean canExtractLoopBodyToFunction(final @Nullable JSLoopStatement loopStatement, @Nullable JSExpression collectionExpression, final @Nullable PsiElement indexVariable) {
        if (loopStatement == null || collectionExpression == null || indexVariable == null) {
            return false;
        }
        JSStatement body = loopStatement.getBody();
        if (body == null) {
            return false;
        }
        PsiElement collectionReference = JSConvertLoopsUtils.resolveCollectionReference(collectionExpression);
        if (collectionReference == null) {
            return false;
        }
        final boolean hasArrowFunctions = DialectDetector.hasFeature((PsiElement)loopStatement, JSLanguageFeature.ARROW_FUNCTIONS);
        return new LoopBodyCollectionIndexedAccessVisitor(collectionReference, indexVariable){
            private int myFunctionNestingDepth;
            {
                super(collectionReference, indexVariable2);
                this.myFunctionNestingDepth = 0;
            }

            @Override
            public void visitJSReferenceExpression(JSReferenceExpression node) {
                super.visitJSReferenceExpression(node);
                if (this.myFunctionNestingDepth > 0 && JSPsiImplUtils.isVar(indexVariable)) {
                    this.myResult = false;
                }
            }

            @Override
            public void visitJSThisExpression(JSThisExpression node) {
                if (!hasArrowFunctions) {
                    this.myResult = false;
                }
            }

            @Override
            public void visitJSReturnStatement(JSReturnStatement node) {
                if (this.myFunctionNestingDepth == 0) {
                    this.myResult = false;
                }
            }

            @Override
            public void visitJSBreakStatement(JSBreakStatement node) {
                if (JSConvertLoopsUtils.labelsTo(node, loopStatement)) {
                    this.myResult = false;
                }
            }

            @Override
            public void visitJSYieldExpression(JSYieldExpression statement) {
                if (this.myFunctionNestingDepth == 0) {
                    this.myResult = false;
                } else {
                    super.visitJSYieldExpression(statement);
                }
            }

            @Override
            public void visitJSPrefixExpression(JSPrefixExpression node) {
                if (this.myFunctionNestingDepth == 0 && node.getOperationSign() == JSTokenTypes.AWAIT_KEYWORD) {
                    this.myResult = false;
                } else {
                    super.visitJSPrefixExpression(node);
                }
            }

            @Override
            public boolean visitAsFunction(JSFunction function2) {
                ++this.myFunctionNestingDepth;
                return false;
            }

            @Override
            protected void elementFinished(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (element instanceof JSFunction) {
                    --this.myFunctionNestingDepth;
                }
                super.elementFinished(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/JSConvertLoopsUtils$2", "elementFinished"));
            }
        }.canExtract(body);
    }

    public static boolean containsOnlyIndexedAccessToCollection(@Nullable JSStatement body, @Nullable JSExpression collectionExpression, @Nullable PsiElement indexVariable) {
        if (body == null || collectionExpression == null || indexVariable == null) {
            return false;
        }
        PsiElement collectionReference = JSConvertLoopsUtils.resolveCollectionReference(collectionExpression);
        if (collectionReference == null) {
            return false;
        }
        return new LoopBodyCollectionIndexedAccessVisitor(collectionReference, indexVariable).canExtract(body);
    }

    @Nullable
    public static PsiElement resolveCollectionReference(@Nullable JSExpression collectionExpression) {
        if (!(collectionExpression instanceof JSReferenceExpression)) {
            return null;
        }
        return ((JSReferenceExpression)collectionExpression).resolve();
    }

    @Nullable
    public static JSStatement replaceLoopWithForEachFunction(final @NotNull JSLoopStatement loopStatement, @NotNull JSExpression collectionExpression, @NotNull PsiElement indexVariable, @Nullable JSVarStatement itemAssignment) {
        JSLoopStatement oldLoopStatement;
        if (loopStatement == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(67);
        }
        if (collectionExpression == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(68);
        }
        if (indexVariable == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(69);
        }
        JSStatement body = loopStatement.getBody();
        PsiElement collectionReference = JSConvertLoopsUtils.resolveCollectionReference(collectionExpression);
        if (body == null || collectionReference == null) {
            return null;
        }
        final ArrayList continueStatements = new ArrayList();
        Collection<JSIndexedPropertyAccessExpression> propertyAccessExpressions = new ExtractCollectionIndexedAccessVisitor(collectionReference, indexVariable){

            @Override
            public void visitJSContinueStatement(JSContinueStatement node) {
                if (JSConvertLoopsUtils.labelsTo(node, loopStatement)) {
                    continueStatements.add(node);
                }
            }
        }.visitAndExtractIndexedAccess(body);
        String itemName = JSConvertLoopsUtils.getItemVariableName(itemAssignment, (PsiElement)loopStatement);
        for (JSIndexedPropertyAccessExpression jSIndexedPropertyAccessExpression : propertyAccessExpressions) {
            JSReferenceExpression referenceExpression = JSPsiElementFactory.createJSExpression(itemName, (PsiElement)jSIndexedPropertyAccessExpression, JSReferenceExpression.class);
            jSIndexedPropertyAccessExpression.replace(referenceExpression);
        }
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)loopStatement);
        for (JSContinueStatement statement : continueStatements) {
            JSStatement returnStatement = JSPsiElementFactory.createJSStatement("return" + semicolon, (PsiElement)statement);
            statement.replace(returnStatement);
        }
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)loopStatement);
        PsiFile file2 = loopStatement.getContainingFile();
        if (file2 != null && itemAssignment != null) {
            JSConvertLoopsUtils.removeItemAssignmentAndReformat(file2, itemAssignment);
        }
        if ((oldLoopStatement = (JSLoopStatement)smartPsiElementPointer.getElement()) == null) {
            return null;
        }
        body = oldLoopStatement.getBody();
        if (body == null) {
            return null;
        }
        boolean hasArrowFunctions = DialectDetector.hasFeature((PsiElement)collectionExpression, JSLanguageFeature.ARROW_FUNCTIONS);
        String source2 = String.format("%s.forEach(%s%s%s {})%s", collectionExpression.getText(), hasArrowFunctions ? "" : "function(", itemName, hasArrowFunctions ? " => " : ") ", semicolon);
        JSStatement forEachOrphan = JSPsiElementFactory.createJSStatement(source2, (PsiElement)collectionExpression);
        JSBlockStatement blockStatement = (JSBlockStatement)PsiTreeUtil.findChildOfType((PsiElement)forEachOrphan, JSBlockStatement.class);
        assert (blockStatement != null);
        blockStatement.replace(body);
        return oldLoopStatement.replace(forEachOrphan);
    }

    public static void replacePropertyAccessExpressions(@NotNull JSStatement body, @NotNull PsiElement collectionReference, @NotNull PsiElement indexVariable, @NotNull String itemName) {
        if (body == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(70);
        }
        if (collectionReference == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(71);
        }
        if (indexVariable == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(72);
        }
        if (itemName == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(73);
        }
        Collection<JSIndexedPropertyAccessExpression> propertyAccessExpressions = new ExtractCollectionIndexedAccessVisitor(collectionReference, indexVariable).visitAndExtractIndexedAccess(body);
        for (JSIndexedPropertyAccessExpression expression : propertyAccessExpressions) {
            JSReferenceExpression referenceExpression = JSPsiElementFactory.createJSExpression(itemName, (PsiElement)expression, JSReferenceExpression.class);
            expression.replace(referenceExpression);
        }
    }

    @Nullable
    public static JSVarStatement findCollectionItemAssignment(@NotNull JSStatement body, @NotNull PsiElement collectionReference, @NotNull PsiElement indexVariable) {
        if (body == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(74);
        }
        if (collectionReference == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(75);
        }
        if (indexVariable == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(76);
        }
        if (!(body instanceof JSBlockStatement)) {
            return null;
        }
        Object[] statements = ((JSBlockStatement)body).getStatementListItems();
        JSVarStatement variableDeclaration = (JSVarStatement)ContainerUtil.find((Object[])statements, s -> s instanceof JSVarStatement);
        if (variableDeclaration == null) {
            return null;
        }
        JSInitializerOwner[] declarations = variableDeclaration.getDeclarations();
        if (declarations.length != 1 || !(declarations[0] instanceof JSVariable)) {
            return null;
        }
        JSVariable variable = (JSVariable)declarations[0];
        JSExpression initializer = variable.getInitializer();
        if (!(initializer instanceof JSIndexedPropertyAccessExpression)) {
            return null;
        }
        JSExpression qualifier = ((JSIndexedPropertyAccessExpression)initializer).getQualifier();
        JSExpression indexExpression = ((JSIndexedPropertyAccessExpression)initializer).getIndexExpression();
        if (!(indexExpression instanceof JSReferenceExpression) || !(qualifier instanceof JSReferenceExpression)) {
            return null;
        }
        if (!JSConvertLoopsUtils.referencesTo((JSReferenceExpression)qualifier, collectionReference) || !JSConvertLoopsUtils.referencesTo((JSReferenceExpression)indexExpression, indexVariable)) {
            return null;
        }
        return variable.getName() != null ? variableDeclaration : null;
    }

    @NotNull
    public static String getItemVariableName(@Nullable JSVarStatement itemVariableDeclaration, @Nullable PsiElement scope) {
        if (itemVariableDeclaration != null) {
            JSVariable[] variables = itemVariableDeclaration.getVariables();
            if (variables.length != 1) {
                return ITEM_DEFAULT_NAME;
            }
            String name = variables[0].getName();
            if (name != null) {
                String string = name;
                if (string == null) {
                    JSConvertLoopsUtils.$$$reportNull$$$0(77);
                }
                return string;
            }
        }
        String string = JSNameSuggestionsUtil.ensureUniqueVariableName(ITEM_DEFAULT_NAME, scope, ContainerUtil.emptyList(), false);
        if (string == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(78);
        }
        return string;
    }

    @Nullable
    public static JSVariable getItemVariable(@Nullable JSVarStatement itemVariableDeclaration) {
        if (itemVariableDeclaration == null) {
            return null;
        }
        JSVariable[] variables = itemVariableDeclaration.getVariables();
        if (variables.length != 1) {
            return null;
        }
        return variables[0];
    }

    public static void invokeReplaceArgumentNameTemplate(@NotNull Project project, @Nullable Editor editor, @NotNull JSStatement forEachCall) {
        if (project == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(79);
        }
        if (forEachCall == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(80);
        }
        if (editor == null) {
            return;
        }
        SmartPsiElementPointer pointer = SmartPointerManager.createPointer((PsiElement)forEachCall);
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        forEachCall = (JSStatement)pointer.getElement();
        if (forEachCall == null) {
            return;
        }
        editor.getCaretModel().moveToOffset(forEachCall.getTextOffset());
        JSParameter insertedParam = (JSParameter)PsiTreeUtil.findChildOfType((PsiElement)forEachCall, JSParameter.class);
        if (insertedParam == null) {
            return;
        }
        String parameterName = insertedParam.getName();
        if (parameterName == null) {
            return;
        }
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)forEachCall);
        builder.replaceElement((PsiElement)insertedParam, parameterName, (Expression)new ConstantNode(parameterName), true);
        Collection references = ReferencesSearch.search((PsiElement)insertedParam, (SearchScope)new LocalSearchScope((PsiElement)forEachCall)).findAll();
        for (PsiReference reference : references) {
            if (!(reference instanceof JSReferenceExpression)) {
                return;
            }
            builder.replaceElement(reference, parameterName, parameterName, false);
        }
        Template template = builder.buildInlineTemplate();
        TemplateManager.getInstance((Project)project).startTemplate(editor, template);
    }

    @Nullable
    public static PsiElement resolveLoopInitializationVariable(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof JSVarStatement) {
            JSVariable[] variables = ((JSVarStatement)element).getVariables();
            return variables.length == 1 ? variables[0] : null;
        }
        if (element instanceof JSExpression) {
            JSReferenceExpression reference = null;
            if (element instanceof JSAssignmentExpression) {
                element = ((JSAssignmentExpression)element).getLOperand();
            }
            if (element instanceof JSDefinitionExpression) {
                JSExpression expression = ((JSDefinitionExpression)element).getExpression();
                if (!(expression instanceof JSReferenceExpression)) {
                    return null;
                }
                reference = (JSReferenceExpression)expression;
            }
            if (element instanceof JSReferenceExpression && ((JSReferenceExpression)element).getQualifier() == null) {
                reference = (JSReferenceExpression)element;
            }
            if (reference != null) {
                PsiElement resolved = reference.resolve();
                return resolved != null && resolved.isValid() ? resolved : null;
            }
        }
        return null;
    }

    private static boolean referencesTo(@Nullable JSReferenceExpression referenceExpression, @Nullable PsiElement target) {
        if (target == null || referenceExpression == null) {
            return false;
        }
        if (target instanceof PsiNamedElement && !StringUtil.equals((CharSequence)((PsiNamedElement)target).getName(), (CharSequence)referenceExpression.getReferenceName())) {
            return false;
        }
        return target.equals(referenceExpression.resolve());
    }

    private static boolean labelsTo(@NotNull JSStatementWithLabelReference labelOwner, @NotNull JSStatement possibleTarget) {
        JSStatement statement;
        if (labelOwner == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(81);
        }
        if (possibleTarget == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(82);
        }
        if (labelOwner instanceof JSContinueStatement) {
            statement = ((JSContinueStatement)labelOwner).getStatementToContinue();
        } else if (labelOwner instanceof JSBreakStatement) {
            statement = ((JSBreakStatement)labelOwner).getStatementToBreak();
        } else {
            return false;
        }
        if (statement instanceof JSLabeledStatement) {
            statement = ((JSLabeledStatement)statement).getStatement();
        }
        return statement != null && statement.equals(possibleTarget);
    }

    @Nullable
    public static Pair<PsiElement, JSExpression> getSequentiallyIteratedArrayIndexedFor(@NotNull JSForStatement forStatement) {
        if (forStatement == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(83);
        }
        return JSConvertLoopsUtils.getSequentiallyIteratedArrayIndexedFor(forStatement, true);
    }

    @Nullable
    public static Pair<PsiElement, JSExpression> getSequentiallyIteratedArrayIndexedFor(@NotNull JSForStatement forStatement, boolean strict) {
        JSVarStatement declaration;
        PsiElement counter;
        if (forStatement == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(84);
        }
        PsiElement psiElement = counter = (declaration = forStatement.getVarDeclaration()) != null ? JSConvertLoopsUtils.resolveLoopInitializationVariable((PsiElement)declaration) : JSConvertLoopsUtils.resolveLoopInitializationVariable((PsiElement)forStatement.getInitialization());
        if (counter == null) {
            return null;
        }
        JSExpression arrayExpression = JSConvertLoopsUtils.resolveIteratedArrayExpression(forStatement.getCondition(), counter, strict);
        if (arrayExpression == null) {
            return null;
        }
        return JSConvertLoopsUtils.isCounterIncrementedStepwise(forStatement.getUpdate(), counter) ? Pair.create((Object)counter, (Object)arrayExpression) : null;
    }

    @Nullable
    private static JSExpression resolveIteratedArrayExpression(@Nullable JSExpression expression, @NotNull PsiElement counter, boolean strict) {
        if (counter == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(85);
        }
        if (!(expression instanceof JSBinaryExpression)) {
            return null;
        }
        JSBinaryExpression binaryExpression = (JSBinaryExpression)expression;
        JSExpression counterExpression = binaryExpression.getLOperand();
        if (!(counterExpression instanceof JSReferenceExpression)) {
            return null;
        }
        if (!Objects.equals(((JSReferenceExpression)counterExpression).resolve(), counter)) {
            return null;
        }
        IElementType operator = binaryExpression.getOperationSign();
        return operator == JSTokenTypes.LT ? JSConvertLoopsUtils.resolveArrayFromLengthExpression(binaryExpression.getROperand(), strict) : null;
    }

    @Nullable
    private static JSExpression resolveArrayFromLengthExpression(@Nullable JSExpression expression, boolean strict) {
        boolean checkTypes;
        if (!(expression instanceof JSReferenceExpression)) {
            return null;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)expression;
        JSExpression collectionExpression = referenceExpression.getQualifier();
        if (collectionExpression == null || !"length".equals(referenceExpression.getReferenceName())) {
            return null;
        }
        boolean bl = checkTypes = strict || !JSTypeUtils.isNullOrAny(JSResolveUtil.getExpressionJSType(collectionExpression));
        if (checkTypes && !JSConvertLoopsUtils.isArrayType(collectionExpression)) {
            return null;
        }
        return collectionExpression;
    }

    private static boolean isCounterIncrementedStepwise(@Nullable JSExpression expression, @NotNull PsiElement counter) {
        if (counter == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(86);
        }
        if (ExpressionUtil.computeIncrementDecrementAmount((PsiElement)expression) != 1) {
            return false;
        }
        Collection referenceExpressions = PsiTreeUtil.collectElementsOfType((PsiElement)expression, (Class[])new Class[]{JSReferenceExpression.class});
        return ContainerUtil.all((Collection)referenceExpressions, expr -> Objects.equals(expr.resolve(), counter));
    }

    static void removeItemAssignmentAndReformat(@NotNull PsiFile file2, @Nullable JSVarStatement statement) {
        if (file2 == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(87);
        }
        if (statement == null || !statement.isValid()) {
            return;
        }
        PsiElement prev = PsiTreeUtil.skipWhitespacesBackward((PsiElement)statement);
        PsiElement next = PsiTreeUtil.skipWhitespacesForward((PsiElement)statement);
        if (prev == null || next == null) {
            return;
        }
        FormatFixer fixer = null;
        if (file2.isPhysical()) {
            fixer = FormatFixer.create(file2, TextRange.create((int)prev.getTextRange().getEndOffset(), (int)next.getTextRange().getStartOffset()), FormatFixer.Mode.InSpecifiedRangeMakeFormatterWorkAndLeaveWsBeforeAndAfterIntact);
        }
        statement.delete();
        if (fixer != null) {
            fixer.fixFormat();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: 
            case 12: 
            case 13: 
            case 21: 
            case 24: 
            case 27: 
            case 35: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 61: 
            case 63: 
            case 66: 
            case 77: 
            case 78: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: 
            case 12: 
            case 13: 
            case 21: 
            case 24: 
            case 27: 
            case 35: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 61: 
            case 63: 
            case 66: 
            case 77: 
            case 78: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectionExpressionText";
                break;
            }
            case 1: 
            case 28: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexText";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 8: 
            case 12: 
            case 13: 
            case 21: 
            case 24: 
            case 27: 
            case 35: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 61: 
            case 63: 
            case 66: 
            case 77: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSConvertLoopsUtils";
                break;
            }
            case 5: 
            case 29: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varKeyword";
                break;
            }
            case 9: 
            case 15: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionInfo";
                break;
            }
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loopBody";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputCollectionReference";
                break;
            }
            case 18: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectionExpression";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentExpression";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentsText";
                break;
            }
            case 31: 
            case 33: 
            case 34: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forOfBlockBody";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 51: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberName";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forInStatement";
                break;
            }
            case 52: 
            case 56: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 53: 
            case 57: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loopType";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varStatement";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayFunctionInfo";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loopStatement";
                break;
            }
            case 69: 
            case 72: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexVariable";
                break;
            }
            case 70: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 71: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectionReference";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemName";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forEachCall";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelOwner";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleTarget";
                break;
            }
            case 83: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forStatement";
                break;
            }
            case 85: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "counter";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSConvertLoopsUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlainIndexedForInStatement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createPlainForInStatement";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "updateArrayForEachCallBody";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createArrayMethodCall";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createFunctionCallStatementFromReference";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createFunctionCallExpressionFromReference";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnStatements";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexedStatementFromForOf";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyLoopStatement";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyArrayInitializer";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayFunctionInfo";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemVariableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPlainIndexedForInStatement";
                break;
            }
            case 3: 
            case 8: 
            case 12: 
            case 13: 
            case 21: 
            case 24: 
            case 27: 
            case 35: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 61: 
            case 63: 
            case 66: 
            case 77: 
            case 78: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPlainForInStatement";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateArrayForEachCallBody";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updateArrayMapCallBody";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createArrayMethodCall";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createFunctionCallStatementFromReference";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createFunctionCallExpressionFromReference";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addIndexStatementText";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "replaceReturnWithContinue";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getReturnStatements";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addItemStatementText";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getCollectionExpression";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getFunction";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isCalledWithFunctionReference";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isArrayMethodCall";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "hasMemberInArrayLike";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isTypeWithNames";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getIndexedStatementFromForOf";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getForInStatementFromForEachCall";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "replaceMapCallWithForInStatement";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyLoopStatement";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyArrayInitializer";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getArrayFunctionInfo";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "replaceLoopWithForEachFunction";
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "replacePropertyAccessExpressions";
                break;
            }
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "findCollectionItemAssignment";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "invokeReplaceArgumentNameTemplate";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "labelsTo";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getSequentiallyIteratedArrayIndexedFor";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "resolveIteratedArrayExpression";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "isCounterIncrementedStepwise";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "removeItemAssignmentAndReformat";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: 
            case 12: 
            case 13: 
            case 21: 
            case 24: 
            case 27: 
            case 35: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 61: 
            case 63: 
            case 66: 
            case 77: 
            case 78: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ArrayFunctionParameter {
        @Nullable
        private final JSParameterListElement myOriginalElement;
        @NotNull
        private final Map<String, String> myElementsToRename;
        @Nullable
        private final String myDefaultName;
        @Nullable
        private JSParameterListElement myModifiedElement;

        @NotNull
        private static ArrayFunctionParameter create(@Nullable JSParameterListElement element, @NotNull String defaultName, @NotNull JSFunction function2, @NotNull PsiElement insertionScope) {
            if (defaultName == null) {
                ArrayFunctionParameter.$$$reportNull$$$0(0);
            }
            if (function2 == null) {
                ArrayFunctionParameter.$$$reportNull$$$0(1);
            }
            if (insertionScope == null) {
                ArrayFunctionParameter.$$$reportNull$$$0(2);
            }
            if (element == null) {
                defaultName = JSNameSuggestionsUtil.ensureUniqueVariableName(defaultName, insertionScope, Collections.emptyList(), false);
                return new ArrayFunctionParameter(defaultName);
            }
            Collection<JSVariable> variables = ArrayFunctionParameter.getVariablesFromParameter(element);
            HashMap<String, String> elementsToRename = new HashMap<String, String>();
            for (JSVariable variable : variables) {
                String newName;
                String originalName = variable.getName();
                if (originalName == null || (newName = JSNameSuggestionsUtil.ensureUniqueVariableName(originalName, insertionScope, Collections.emptyList(), false, (PsiElement)function2)).equals(originalName)) continue;
                elementsToRename.put(originalName, newName);
            }
            return new ArrayFunctionParameter(element, elementsToRename);
        }

        private static Collection<JSVariable> getVariablesFromParameter(@NotNull JSParameterListElement element) {
            if (element == null) {
                ArrayFunctionParameter.$$$reportNull$$$0(3);
            }
            if (element instanceof JSDestructuringParameter) {
                return PsiTreeUtil.findChildrenOfType((PsiElement)element, JSVariable.class);
            }
            if (element instanceof JSVariable) {
                return ContainerUtil.newArrayList((Object[])new JSVariable[]{(JSVariable)((Object)element)});
            }
            return ContainerUtil.emptyList();
        }

        private ArrayFunctionParameter(@NotNull String defaultName) {
            if (defaultName == null) {
                ArrayFunctionParameter.$$$reportNull$$$0(4);
            }
            this.myOriginalElement = null;
            this.myElementsToRename = Collections.emptyMap();
            this.myDefaultName = defaultName;
        }

        private ArrayFunctionParameter(@NotNull JSParameterListElement originalElement, @NotNull Map<String, String> elementsToRename) {
            if (originalElement == null) {
                ArrayFunctionParameter.$$$reportNull$$$0(5);
            }
            if (elementsToRename == null) {
                ArrayFunctionParameter.$$$reportNull$$$0(6);
            }
            this.myOriginalElement = originalElement;
            this.myElementsToRename = elementsToRename;
            this.myDefaultName = null;
        }

        @Nullable
        private String getNewReference() {
            if (this.isDefault()) {
                return this.myDefaultName;
            }
            JSParameterListElement parameter = this.getProcessedParameter();
            return parameter != null ? parameter.getName() : this.myDefaultName;
        }

        @Nullable
        private String getNewVariableDeclaration() {
            if (this.isDefault()) {
                return this.myDefaultName;
            }
            JSParameterListElement parameter = this.getProcessedParameter();
            return parameter != null ? parameter.getText() : this.myDefaultName;
        }

        @Nullable
        private JSParameterListElement getProcessedParameter() {
            if (this.myModifiedElement != null) {
                return this.myModifiedElement;
            }
            if (this.myOriginalElement == null) {
                return null;
            }
            PsiElement declarationElement = this.myOriginalElement.getDeclarationElement();
            if (declarationElement == null) {
                return null;
            }
            PsiElement typeElement = this.myOriginalElement.getTypeElement();
            Object newElementText = declarationElement.getText();
            if (typeElement != null) {
                if (this.myOriginalElement.isOptional()) {
                    JSType newType = TypeScriptTypeGuard.wrapWithUndefined(this.myOriginalElement.getSimpleType(), JSTypeSourceFactory.createTypeSource((PsiElement)this.myOriginalElement, true));
                    if (newType != null) {
                        newElementText = (String)newElementText + ": " + newType.getTypeText(JSType.TypeTextFormat.CODE);
                    }
                } else {
                    newElementText = (String)newElementText + ": " + typeElement.getText();
                }
            }
            JSParameterListElement newElement = JSChangeUtil.createParameter((String)newElementText, (PsiElement)this.myOriginalElement);
            Collection<JSVariable> variables = ArrayFunctionParameter.getVariablesFromParameter(newElement);
            for (JSVariable variable : variables) {
                PsiElement nameIdentifier;
                String variableName = variable.getName();
                if (variableName == null || !this.myElementsToRename.containsKey(variableName) || (nameIdentifier = variable.getNameIdentifier()) == null) continue;
                JSChangeUtil.doIdentifierReplacement(nameIdentifier.getParent(), nameIdentifier, this.myElementsToRename.get(variableName));
            }
            this.myModifiedElement = newElement;
            return this.myModifiedElement;
        }

        private boolean isDefault() {
            return this.myOriginalElement == null;
        }

        @Nullable
        private JSParameterListElement getOriginalElement() {
            return this.myOriginalElement;
        }

        private boolean shouldRename() {
            return !this.isDefault() && !this.myElementsToRename.isEmpty();
        }

        private void rename(@NotNull PsiElement scope) {
            JSParameterListElement parameterElement;
            if (scope == null) {
                ArrayFunctionParameter.$$$reportNull$$$0(7);
            }
            if ((parameterElement = this.getOriginalElement()) == null) {
                return;
            }
            Collection<JSVariable> variables = ArrayFunctionParameter.getVariablesFromParameter(parameterElement);
            for (JSVariable variable : variables) {
                String variableName = variable.getName();
                if (variableName == null || !this.myElementsToRename.containsKey(variableName)) continue;
                for (PsiReference reference : ReferencesSearch.search((PsiElement)variable, (SearchScope)new LocalSearchScope(scope)).findAll()) {
                    PsiElement element = reference.getElement();
                    if (!(element instanceof JSReferenceExpression)) continue;
                    element.replace((PsiElement)JSPsiElementFactory.createJSExpression(this.myElementsToRename.get(variableName), element));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "insertionScope";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementsToRename";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/inspections/JSConvertLoopsUtils$ArrayFunctionParameter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getVariablesFromParameter";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "rename";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ArrayFunctionInfo {
        @NotNull
        private final JSFunction myFunction;
        @NotNull
        private final PsiElement myInsertionScope;
        private final ArrayFunctionParameter @NotNull [] myParameters;

        private ArrayFunctionInfo(@NotNull JSFunction function2, @NotNull PsiElement insertionScope) {
            if (function2 == null) {
                ArrayFunctionInfo.$$$reportNull$$$0(0);
            }
            if (insertionScope == null) {
                ArrayFunctionInfo.$$$reportNull$$$0(1);
            }
            this.myParameters = new ArrayFunctionParameter[2];
            this.myFunction = function2;
            this.myInsertionScope = insertionScope;
        }

        @Nullable
        private ArrayFunctionParameter getItem() {
            return this.myParameters[0];
        }

        private void createItemParameter(@Nullable JSParameterListElement element) {
            this.createParameter(0, element, JSConvertLoopsUtils.ITEM_DEFAULT_NAME);
        }

        private boolean isItemSpecified() {
            return this.getItem() != null && !this.getItem().isDefault();
        }

        @Nullable
        private ArrayFunctionParameter getIndex() {
            return this.myParameters[1];
        }

        private void createIndexParameter(@Nullable JSParameterListElement element) {
            this.createParameter(1, element, JSConvertLoopsUtils.INDEX_DEFAULT_NAME);
        }

        private boolean isIndexSpecified() {
            return this.getIndex() != null && !this.getIndex().isDefault();
        }

        @NotNull
        private JSFunction getDeclaration() {
            JSFunction jSFunction = this.myFunction;
            if (jSFunction == null) {
                ArrayFunctionInfo.$$$reportNull$$$0(2);
            }
            return jSFunction;
        }

        private void createParameter(int index, @Nullable JSParameterListElement element, @NotNull String defaultName) {
            if (defaultName == null) {
                ArrayFunctionInfo.$$$reportNull$$$0(3);
            }
            this.myParameters[index] = ArrayFunctionParameter.create(element, defaultName, this.myFunction, this.myInsertionScope);
        }

        @NotNull
        private List<ArrayFunctionParameter> getParameters() {
            ImmutableList immutableList = ContainerUtil.immutableList((Object[])this.myParameters);
            if (immutableList == null) {
                ArrayFunctionInfo.$$$reportNull$$$0(4);
            }
            return immutableList;
        }

        @NotNull
        private String buildParametersToString() {
            String string = StringUtil.join((Collection)ContainerUtil.mapNotNull((Object[])this.myParameters, arg -> arg != null && !arg.isDefault() ? arg.getNewReference() : null), (String)",");
            if (string == null) {
                ArrayFunctionInfo.$$$reportNull$$$0(5);
            }
            return string;
        }

        private void renameParameterUsages() {
            for (ArrayFunctionParameter parameter : this.getParameters()) {
                if (!parameter.shouldRename()) continue;
                parameter.rename((PsiElement)this.getDeclaration());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "insertionScope";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSConvertLoopsUtils$ArrayFunctionInfo";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSConvertLoopsUtils$ArrayFunctionInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDeclaration";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParameters";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildParametersToString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createParameter";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ExtractCollectionIndexedAccessVisitor
    extends JSRecursiveWalkingElementVisitor {
        @NotNull
        private final Collection<JSIndexedPropertyAccessExpression> myPropertyAccessExpressions;
        @NotNull
        private final PsiElement myCollectionReference;
        @NotNull
        private final PsiElement myIndexVariable;

        private ExtractCollectionIndexedAccessVisitor(@NotNull PsiElement collectionReference, @NotNull PsiElement indexVariable) {
            if (collectionReference == null) {
                ExtractCollectionIndexedAccessVisitor.$$$reportNull$$$0(0);
            }
            if (indexVariable == null) {
                ExtractCollectionIndexedAccessVisitor.$$$reportNull$$$0(1);
            }
            this.myCollectionReference = collectionReference;
            this.myIndexVariable = indexVariable;
            this.myPropertyAccessExpressions = new ArrayList<JSIndexedPropertyAccessExpression>();
        }

        @Override
        public void visitJSReferenceExpression(JSReferenceExpression node) {
            super.visitJSReferenceExpression(node);
            if (!JSConvertLoopsUtils.referencesTo(node, this.myIndexVariable)) {
                return;
            }
            PsiElement referenceParent = node.getParent();
            assert (referenceParent instanceof JSIndexedPropertyAccessExpression);
            JSExpression qualifier = ((JSIndexedPropertyAccessExpression)referenceParent).getQualifier();
            if (!(qualifier instanceof JSReferenceExpression) || !JSConvertLoopsUtils.referencesTo((JSReferenceExpression)qualifier, this.myCollectionReference)) {
                return;
            }
            this.myPropertyAccessExpressions.add((JSIndexedPropertyAccessExpression)referenceParent);
        }

        @NotNull
        public Collection<JSIndexedPropertyAccessExpression> visitAndExtractIndexedAccess(@NotNull JSElement body) {
            if (body == null) {
                ExtractCollectionIndexedAccessVisitor.$$$reportNull$$$0(2);
            }
            this.visitElement((PsiElement)body);
            Collection<JSIndexedPropertyAccessExpression> collection = this.myPropertyAccessExpressions;
            if (collection == null) {
                ExtractCollectionIndexedAccessVisitor.$$$reportNull$$$0(3);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "collectionReference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indexVariable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "body";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSConvertLoopsUtils$ExtractCollectionIndexedAccessVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSConvertLoopsUtils$ExtractCollectionIndexedAccessVisitor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visitAndExtractIndexedAccess";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitAndExtractIndexedAccess";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class LoopBodyCollectionIndexedAccessVisitor
    extends JSRecursiveWalkingElementVisitor {
        @NotNull
        private final PsiElement myCollectionReference;
        @NotNull
        private final PsiElement myIndexVariable;
        protected Boolean myResult;

        private LoopBodyCollectionIndexedAccessVisitor(@NotNull PsiElement collectionReference, @NotNull PsiElement indexVariable) {
            if (collectionReference == null) {
                LoopBodyCollectionIndexedAccessVisitor.$$$reportNull$$$0(0);
            }
            if (indexVariable == null) {
                LoopBodyCollectionIndexedAccessVisitor.$$$reportNull$$$0(1);
            }
            this.myResult = true;
            this.myIndexVariable = indexVariable;
            this.myCollectionReference = collectionReference;
        }

        @Override
        public void visitJSReferenceExpression(JSReferenceExpression node) {
            super.visitJSReferenceExpression(node);
            if (!JSConvertLoopsUtils.referencesTo(node, this.myIndexVariable)) {
                return;
            }
            PsiElement referenceParent = node.getParent();
            if (!(referenceParent instanceof JSIndexedPropertyAccessExpression)) {
                this.myResult = false;
                return;
            }
            JSExpression qualifier = ((JSIndexedPropertyAccessExpression)referenceParent).getQualifier();
            if (!(qualifier instanceof JSReferenceExpression) || !JSConvertLoopsUtils.referencesTo((JSReferenceExpression)qualifier, this.myCollectionReference)) {
                this.myResult = false;
            }
        }

        public boolean canExtract(@NotNull JSElement body) {
            if (body == null) {
                LoopBodyCollectionIndexedAccessVisitor.$$$reportNull$$$0(2);
            }
            this.visitElement((PsiElement)body);
            return this.myResult;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "collectionReference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indexVariable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "body";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/inspections/JSConvertLoopsUtils$LoopBodyCollectionIndexedAccessVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canExtract";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum LoopType {
        FOR_OF,
        INDEXED;

    }
}

