/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.inspections.JSInspectionUiService;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDeclarationsAtScopeStartInspection
extends JSInspection {
    public static final String SHORT_NAME = JSDeclarationsAtScopeStartInspection.calcShortNameFromClass(JSDeclarationsAtScopeStartInspection.class);
    public boolean myMakeSingleVarStatement;

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            JSDeclarationsAtScopeStartInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @Override
    public boolean isEnabledByDefault() {
        return false;
    }

    public JComponent createOptionsPanel() {
        return JSInspectionUiService.getInstance().createSingleCheckboxOptionsPanel(JavaScriptBundle.message("js.make.single.var.statement", new Object[0]), (InspectionProfileEntry)this, "myMakeSingleVarStatement");
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSDeclarationsAtScopeStartInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            JSDeclarationsAtScopeStartInspection.$$$reportNull$$$0(2);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSVarStatement(JSVarStatement node) {
                if (node.getVarKeyword() != JSVarStatement.VarKeyword.VAR) {
                    return;
                }
                JSStatement firstStatement = JSDeclarationsAtScopeStartInspection.findContainingFunctionFirstStatement((PsiElement)node);
                if (firstStatement != null) {
                    if (!JSDeclarationsAtScopeStartInspection.this.myMakeSingleVarStatement) {
                        while (firstStatement != null && firstStatement != node && (firstStatement instanceof JSVarStatement || !(firstStatement instanceof JSStatement))) {
                            firstStatement = firstStatement.getNextSibling();
                        }
                    }
                    if (firstStatement != node) {
                        LocalQuickFix action = JSFixFactory.getInstance().jsMoveToScopeStartIntentionAction(JSDeclarationsAtScopeStartInspection.this.myMakeSingleVarStatement);
                        holder.registerProblem((PsiElement)node, JavaScriptBundle.message("js.declaration.is.not.at.scope.start", new Object[0]), new LocalQuickFix[]{action});
                    }
                }
            }
        };
    }

    @Nullable
    public static JSStatement findContainingFunctionFirstStatement(@Nullable PsiElement element) {
        return JSPsiImplUtils.findFirstFunctionStatement((JSFunction)PsiTreeUtil.getParentOfType((PsiElement)element, JSFunction.class, (boolean)false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSDeclarationsAtScopeStartInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSDeclarationsAtScopeStartInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

