/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.intentions.JSSwitchBranchesProcessor;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSMissingSwitchBranchesInspection
extends JSInspection {
    public boolean ignoreSwitchStatementsWithDefault = true;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(JavaScriptBundle.message("js.missing.switch.branches.ignore.with.default", new Object[0]), (InspectionProfileEntry)this, "ignoreSwitchStatementsWithDefault");
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSMissingSwitchBranchesInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSMissingSwitchBranchesInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSSwitchStatement(JSSwitchStatement switchStatement) {
                this.reportMissingCases(switchStatement, JSSwitchBranchesProcessor.getAllCaseVariants(switchStatement));
            }

            private void reportMissingCases(@NotNull JSSwitchStatement switchStatement, @NotNull List<Pair<Integer, String>> allCases) {
                List missingCases;
                if (switchStatement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (allCases == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((missingCases = ContainerUtil.map((Collection)ContainerUtil.filter(allCases, c -> (Integer)c.first == -1), c -> this.fixQualifiersAndQuotes((String)c.second))).isEmpty()) {
                    return;
                }
                String missingCasesString = StringUtil.join((Collection)missingCases, (String)", ");
                ProblemHighlightType highlighting = JSMissingSwitchBranchesInspection.this.ignoreSwitchStatementsWithDefault && JSMissingSwitchBranchesInspection.hasDefault(switchStatement) ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                String message = JavaScriptBundle.message("js.missing.switch.branches.inspection.desc", missingCasesString);
                JSCreateSwitchBranchesFix fix = new JSCreateSwitchBranchesFix(allCases, missingCasesString);
                if (highlighting == ProblemHighlightType.INFORMATION || InspectionProjectProfileManager.isInformationLevel((String)JSMissingSwitchBranchesInspection.this.getShortName(), (PsiElement)switchStatement)) {
                    holder.registerProblem((PsiElement)switchStatement, message, ProblemHighlightType.INFORMATION, new LocalQuickFix[]{fix});
                } else {
                    JSMissingSwitchBranchesInspection.registerOnSwitchStatement(switchStatement, message, fix, holder, JSMissingSwitchBranchesInspection.this.myOnTheFly);
                }
            }

            @NotNull
            private String fixQualifiersAndQuotes(@NotNull String str) {
                int dot;
                if (str == null) {
                    1.$$$reportNull$$$0(2);
                }
                String result2 = (dot = str.lastIndexOf(46)) == -1 ? str : str.substring(dot + 1);
                result2 = StringUtil.unquoteString((String)result2);
                String string = "'" + result2 + "'";
                if (string == null) {
                    1.$$$reportNull$$$0(3);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "switchStatement";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "allCases";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "str";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/inspections/JSMissingSwitchBranchesInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/inspections/JSMissingSwitchBranchesInspection$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "fixQualifiersAndQuotes";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "reportMissingCases";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "fixQualifiersAndQuotes";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    static void registerOnSwitchStatement(@NotNull JSSwitchStatement switchStatement, @NotNull @InspectionMessage String message, LocalQuickFix fix, @NotNull ProblemsHolder holder, boolean onTheFly) {
        if (switchStatement == null) {
            JSMissingSwitchBranchesInspection.$$$reportNull$$$0(2);
        }
        if (message == null) {
            JSMissingSwitchBranchesInspection.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            JSMissingSwitchBranchesInspection.$$$reportNull$$$0(4);
        }
        int length = switchStatement.getFirstChild().getTextLength();
        holder.registerProblem((PsiElement)switchStatement, new TextRange(0, length), message, new LocalQuickFix[]{fix});
        if (onTheFly) {
            holder.registerProblem((PsiElement)switchStatement, message, ProblemHighlightType.INFORMATION, new TextRange(length, switchStatement.getTextLength()), new LocalQuickFix[]{fix});
        }
    }

    static boolean hasDefault(@NotNull JSSwitchStatement switchStatement) {
        if (switchStatement == null) {
            JSMissingSwitchBranchesInspection.$$$reportNull$$$0(5);
        }
        return ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)switchStatement).forceIgnore(e -> e instanceof JSSwitchStatement)).filter(JSCaseClause.class).filter(c -> c.isDefault()).isNotEmpty();
    }

    @Nullable
    static PsiElement findLBrace(@NotNull JSElement holder) {
        if (holder == null) {
            JSMissingSwitchBranchesInspection.$$$reportNull$$$0(6);
        }
        for (PsiElement child = holder.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNode().getElementType() != JSTokenTypes.LBRACE) continue;
            return child;
        }
        return null;
    }

    static JSCaseClause createCaseClause(@Nullable String variant, @NotNull PsiElement context) {
        if (context == null) {
            JSMissingSwitchBranchesInspection.$$$reportNull$$$0(7);
        }
        Object caseText = variant == null ? "default" : "case " + variant;
        return JSPsiElementFactory.createJSStatement("switch (q) {" + (String)caseText + ": break; }", context, JSSwitchStatement.class).getCaseClauses()[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchStatement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inspections/JSMissingSwitchBranchesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "registerOnSwitchStatement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "hasDefault";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findLBrace";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createCaseClause";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class JSCreateSwitchBranchesFix
    implements LocalQuickFix {
        private final List<Pair<Integer, String>> myCases;
        private final String myMissingCasesString;
        private static final int MAX_TEXT_LENGTH = 40;

        private JSCreateSwitchBranchesFix(List<Pair<Integer, String>> cases2, String missingCasesString) {
            this.myCases = cases2;
            this.myMissingCasesString = missingCasesString.length() > 40 ? JSCreateSwitchBranchesFix.trimDesc(missingCasesString) : missingCasesString;
        }

        @NotNull
        private static String trimDesc(String missingCasesString) {
            int lastFitComma = missingCasesString.indexOf(44, 40);
            String string = (lastFitComma != -1 ? missingCasesString.substring(0, lastFitComma + 1) : missingCasesString.substring(0, 40)) + " ...";
            if (string == null) {
                JSCreateSwitchBranchesFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message("js.create.switch.cases", new Object[0]);
            if (string == null) {
                JSCreateSwitchBranchesFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = JavaScriptBundle.message("js.create.switch.cases.fix", this.myMissingCasesString);
            if (string == null) {
                JSCreateSwitchBranchesFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                JSCreateSwitchBranchesFix.$$$reportNull$$$0(3);
            }
            if (descriptor2 == null) {
                JSCreateSwitchBranchesFix.$$$reportNull$$$0(4);
            }
            PsiElement element = descriptor2.getPsiElement();
            JSSwitchStatement statement = (JSSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSSwitchStatement.class, (boolean)false);
            assert (statement != null);
            TIntObjectHashMap pointers = new TIntObjectHashMap();
            PsiFile file2 = element.getContainingFile();
            for (Pair<Integer, String> variant : this.myCases) {
                JSCaseClause caseClause;
                int first = (Integer)variant.first;
                if (first == -1 || (caseClause = (JSCaseClause)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(first), JSCaseClause.class)) == null) continue;
                pointers.put(first, (Object)SmartPointerManager.createPointer((PsiElement)caseClause));
            }
            PsiElement lBrace = JSMissingSwitchBranchesInspection.findLBrace(statement);
            if (lBrace == null) {
                String statementText = statement.getText() + "{}";
                statement = (JSSwitchStatement)JSChangeUtil.replaceStatement(statement, JSPsiElementFactory.createJSStatement(statementText, (PsiElement)statement, JSSwitchStatement.class));
                lBrace = JSMissingSwitchBranchesInspection.findLBrace(statement);
            }
            int anchorOffset = -1;
            PsiElement anchor = lBrace;
            for (Pair<Integer, String> variant : this.myCases) {
                PsiElement clause;
                SmartPsiElementPointer pointer;
                if ((Integer)variant.first != -1) {
                    anchorOffset = (Integer)variant.first;
                    continue;
                }
                if (anchorOffset != -1 && (pointer = (SmartPsiElementPointer)pointers.get(anchorOffset)) != null && (clause = pointer.getElement()) instanceof JSCaseClause && JSCreateSwitchBranchesFix.exitsWithBreak((JSCaseClause)clause)) {
                    anchor = clause;
                }
                anchor = statement.addAfter(JSMissingSwitchBranchesInspection.createCaseClause((String)variant.second, (PsiElement)statement), anchor);
                anchorOffset = -1;
            }
        }

        private static boolean exitsWithBreak(@NotNull JSCaseClause clause) {
            JSSourceElement[] statements;
            if (clause == null) {
                JSCreateSwitchBranchesFix.$$$reportNull$$$0(5);
            }
            return (statements = clause.getStatementListItems()).length >= 1 && statements[statements.length - 1] instanceof JSBreakStatement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSMissingSwitchBranchesInspection$JSCreateSwitchBranchesFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clause";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "trimDesc";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSMissingSwitchBranchesInspection$JSCreateSwitchBranchesFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "exitsWithBreak";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

