/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.inspections.JSDeclarationsAtScopeStartInspection;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSMoveToScopeStartIntentionAction
implements LocalQuickFix {
    private final boolean myMakeSingleVarStatement;
    @NonNls
    private static final String VAR_STATEMENT_START = "var ";

    public JSMoveToScopeStartIntentionAction(boolean makeSingleVarStatement) {
        this.myMakeSingleVarStatement = makeSingleVarStatement;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("js.move.to.scope.start", new Object[0]);
        if (string == null) {
            JSMoveToScopeStartIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            JSMoveToScopeStartIntentionAction.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            JSMoveToScopeStartIntentionAction.$$$reportNull$$$0(2);
        }
        JSVarStatement varStatement = (JSVarStatement)descriptor2.getPsiElement();
        PsiFile file2 = varStatement.getContainingFile();
        StringBuilder assignments = new StringBuilder();
        Document document2 = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
        if (document2 == null) {
            return;
        }
        JSVariable previousVar = null;
        for (JSVariable jsVariable : varStatement.getVariables()) {
            if (jsVariable.hasInitializer()) {
                if (previousVar != null) {
                    assignments.append(document2.getText(new TextRange(previousVar.getTextRange().getEndOffset(), jsVariable.getTextRange().getStartOffset())));
                }
                assignments.append(jsVariable.getText());
            }
            previousVar = jsVariable;
        }
        if (varStatement.getNode().findChildByType(JSTokenTypes.SEMICOLON) != null && assignments.length() > 0) {
            assignments.append(";");
        }
        JSFunction function2 = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)varStatement, JSFunction.class);
        JSStatement anchor = JSDeclarationsAtScopeStartInspection.findContainingFunctionFirstStatement((PsiElement)varStatement);
        if (anchor == null) {
            return;
        }
        StringBuilder declarations = this.myMakeSingleVarStatement && anchor instanceof JSVarStatement ? JSMoveToScopeStartIntentionAction.buildDeclarations(", ", varStatement) : JSMoveToScopeStartIntentionAction.buildDeclarations(VAR_STATEMENT_START, varStatement);
        if (assignments.length() > 0) {
            document2.replaceString(varStatement.getTextRange().getStartOffset(), varStatement.getTextRange().getEndOffset(), (CharSequence)assignments);
        } else {
            FormatFixer ff = FormatFixer.create((PsiElement)varStatement, FormatFixer.Mode.FirstLinebreak);
            varStatement.delete();
            ff.fixFormat();
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        anchor = JSDeclarationsAtScopeStartInspection.findContainingFunctionFirstStatement((PsiElement)function2);
        if (this.myMakeSingleVarStatement && anchor instanceof JSVarStatement) {
            JSVarStatement firstVarStatement = (JSVarStatement)anchor;
            JSVariable[] variables = firstVarStatement.getVariables();
            JSVariable lastVar = variables[variables.length - 1];
            int endOffset = lastVar.getTextRange().getEndOffset();
            document2.insertString(endOffset, (CharSequence)declarations);
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        } else if (anchor != null) {
            declarations.append(";\n");
            JSStatement varStatementNode = JSPsiElementFactory.createJSStatement(declarations.toString(), (PsiElement)anchor);
            anchor.getParent().addBefore((PsiElement)varStatementNode, (PsiElement)anchor);
        }
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document2);
    }

    private static StringBuilder buildDeclarations(String prefix, JSVarStatement varStatement) {
        StringBuilder declarations = new StringBuilder(prefix);
        boolean firstVar = true;
        for (JSVariable jsVariable : varStatement.getVariables()) {
            String typeString;
            if (!firstVar) {
                declarations.append(", ");
            } else {
                firstVar = false;
            }
            declarations.append(jsVariable.getName());
            if (!DialectDetector.hasFeature((PsiElement)jsVariable, JSLanguageFeature.TYPES)) continue;
            JSType type = jsVariable.getJSType();
            String string = typeString = type == null ? null : type.getTypeText(JSType.TypeTextFormat.CODE);
            if (typeString == null) continue;
            declarations.append(":").append(typeString);
        }
        return declarations;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSMoveToScopeStartIntentionAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSMoveToScopeStartIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

