/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.intentions.JSSwitchBranchesProcessor;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSUnreachableSwitchBranchesInspection
extends JSInspection {
    public boolean ignoreInDynamicTypeContext = true;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(JavaScriptBundle.message("js.unreachable.switch.branches.ignore.with.dynamic", new Object[0]), (InspectionProfileEntry)this, "ignoreInDynamicTypeContext");
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSUnreachableSwitchBranchesInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSUnreachableSwitchBranchesInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSSwitchStatement(JSSwitchStatement switchStatement) {
                String quote;
                JSType typeForCases = JSSwitchBranchesProcessor.findTypeForCases(switchStatement);
                if (typeForCases == null || JSUnreachableSwitchBranchesInspection.this.ignoreInDynamicTypeContext && !typeForCases.isSourceStrict()) {
                    return;
                }
                List<Pair<Integer, JSType>> existingVariants = JSSwitchBranchesProcessor.getExistingVariants(switchStatement);
                List<Pair<Integer, String>> allCases = JSSwitchBranchesProcessor.getAllCaseVariants(typeForCases, existingVariants, quote = JSCodeStyleSettings.getQuote((PsiElement)switchStatement), true);
                if (allCases.isEmpty()) {
                    return;
                }
                ArrayList<Pair<Integer, String>> allExistingCases = new ArrayList<Pair<Integer, String>>();
                for (Pair<Integer, JSType> variant : existingVariants) {
                    allExistingCases.addAll(JSSwitchBranchesProcessor.getAllCaseVariants((JSType)variant.second, existingVariants, quote));
                }
                Set allCasesNames = ContainerUtil.map2Set(allCases, c -> (String)c.second);
                Set allExistingCasesNames = ContainerUtil.map2Set(allExistingCases, c -> (String)c.second);
                allExistingCasesNames.removeAll(allCasesNames);
                PsiFile file2 = switchStatement.getContainingFile();
                for (Pair pair : allExistingCases) {
                    for (String name : allExistingCasesNames) {
                        JSCaseClause clause;
                        if (!name.equals(pair.second) || (clause = (JSCaseClause)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(((Integer)pair.first).intValue()), JSCaseClause.class)) == null) continue;
                        holder.registerProblem((PsiElement)clause, JavaScriptBundle.message("js.unreachable.switch.branches.inspection.desc", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new RemoveUnreachableCaseBranch()});
                    }
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/inspections/JSUnreachableSwitchBranchesInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class RemoveUnreachableCaseBranch
    implements LocalQuickFix {
        private RemoveUnreachableCaseBranch() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message("js.unreachable.switch.branches.remove", new Object[0]);
            if (string == null) {
                RemoveUnreachableCaseBranch.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                RemoveUnreachableCaseBranch.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                RemoveUnreachableCaseBranch.$$$reportNull$$$0(2);
            }
            PsiElement element = descriptor2.getPsiElement();
            assert (element instanceof JSCaseClause);
            element.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSUnreachableSwitchBranchesInspection$RemoveUnreachableCaseBranch";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUnreachableSwitchBranchesInspection$RemoveUnreachableCaseBranch";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

