/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.frameworks.extjs.ExtReferenceContributor;
import com.intellij.lang.javascript.frameworks.extjs.ExtXTypeReference;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;

public class JSUnresolvedExtXTypeInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        return new JSElementVisitor(){

            @Override
            public void visitJSLiteralExpression(JSLiteralExpression node) {
                PsiReference[] references;
                if (!ExtReferenceContributor.isAcceptableExtLiteral(node)) {
                    return;
                }
                for (PsiReference reference : references = node.getReferences()) {
                    if (!(reference instanceof ExtXTypeReference) || reference.resolve() != null) continue;
                    holder.registerProblemForReference(reference, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference), new LocalQuickFix[0]);
                }
            }
        };
    }
}

