/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.parsing.JSDocParsing;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocParamReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;

public class JSValidateJSDocInspection
extends JSInspection {
    @Override
    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        return new JSElementVisitor(){

            @Override
            public void visitJSDocTagValue(JSDocTagValue tagValue) {
                JSValidateJSDocInspection.checkReferences((PsiElement)tagValue, holder);
            }

            @Override
            public void visitJSDocTag(JSDocTag tagValue) {
                JSValidateJSDocInspection.checkReferences((PsiElement)tagValue, holder);
            }

            @Override
            public void visitJSDocComment(JSDocComment docComment) {
                JSValidateJSDocInspection.checkReferences((PsiElement)docComment, holder);
            }

            public void visitErrorElement(@NotNull PsiErrorElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (JSDocParsing.isInsideJSDoc((PsiElement)element)) {
                    TextRange parentTextRange;
                    int startOffsetInParent;
                    PsiElement parent = element.getParent();
                    TextRange rangeInParent = new TextRange(startOffsetInParent, startOffsetInParent + ((startOffsetInParent = element.getStartOffsetInParent()) == (parentTextRange = parent.getTextRange()).getLength() ? 0 : 1));
                    holder.registerProblem(parent, rangeInParent, element.getErrorDescription(), new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/JSValidateJSDocInspection$1", "visitErrorElement"));
            }
        };
    }

    private static void checkReferences(PsiElement tagValue, ProblemsHolder holder) {
        for (PsiReference ref : tagValue.getReferences()) {
            if (ref instanceof JSDocParamReference || !XmlHighlightVisitor.hasBadResolve((PsiReference)ref, (boolean)false)) continue;
            holder.registerProblem(ref, ProblemsHolder.unresolvedReferenceMessage((PsiReference)ref), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
    }
}

