/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSplitDeclarationIntention
extends JavaScriptIntention {
    public JSSplitDeclarationIntention() {
        this.setText(JavaScriptBundle.message("js.split.into.multiple.declarations", new Object[0]));
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSSplitDeclarationIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSSplitDeclarationIntention.$$$reportNull$$$0(1);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        JSVarStatement varStatement = (JSVarStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSVarStatement.class);
        return varStatement != null && !(varStatement.getParent() instanceof TypeScriptEnum) && varStatement.getVarKeyword() != null && PsiTreeUtil.getChildOfType((PsiElement)varStatement, JSDestructuringElement.class) == null && varStatement.getVariables().length > 1;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSSplitDeclarationIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JSSplitDeclarationIntention.$$$reportNull$$$0(3);
        }
        JSVarStatement varStatement = (JSVarStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSVarStatement.class);
        assert (varStatement != null);
        String varModifier = varStatement.getVarKeyword().getText();
        String semicolon = JSCodeStyleSettings.getSemicolon(element);
        JSVariable[] variables = varStatement.getVariables();
        JSVarStatement anchor = varStatement;
        for (JSVariable variable : variables) {
            JSDocComment docComment = JSSplitDeclarationIntention.getDocComment(variable, varStatement);
            if (docComment != null) {
                docComment.delete();
            }
            String docCommentText = docComment != null ? docComment.getText() + "\n" : "";
            PsiElement psi = JSSplitDeclarationIntention.psiFromText(element, docCommentText + varModifier + " " + variable.getText() + semicolon);
            anchor = JSSplitDeclarationIntention.addElement(psi, (PsiElement)anchor);
            Pair<PsiElement, PsiElement> comments = JSSplitDeclarationIntention.getLeadingCommentsRange(variable);
            if (comments == null) continue;
            SharedImplUtil.addRange((PsiElement)anchor.getParent(), (PsiElement)((PsiElement)comments.first), (PsiElement)((PsiElement)comments.second), (ASTNode)anchor.getNode(), (Boolean)Boolean.TRUE);
        }
        varStatement.delete();
    }

    @Nullable
    private static PsiElement psiFromText(@NotNull PsiElement context, @NotNull String text) {
        if (context == null) {
            JSSplitDeclarationIntention.$$$reportNull$$$0(4);
        }
        if (text == null) {
            JSSplitDeclarationIntention.$$$reportNull$$$0(5);
        }
        return JSChangeUtil.createJSTreeFromTextWithContext(text, context).getPsi();
    }

    @Nullable
    private static Pair<PsiElement, PsiElement> getLeadingCommentsRange(@NotNull JSVariable variable) {
        if (variable == null) {
            JSSplitDeclarationIntention.$$$reportNull$$$0(6);
        }
        PsiElement current = variable.getPrevSibling();
        PsiElement first = null;
        PsiElement last = null;
        while (current instanceof PsiComment || current instanceof PsiWhiteSpace) {
            if (last == null) {
                last = current;
            } else {
                first = current;
            }
            current = current.getPrevSibling();
        }
        return last != null && first != null ? Pair.create((Object)first, (Object)last) : null;
    }

    @NotNull
    private static PsiElement addElement(@Nullable PsiElement psi, @NotNull PsiElement context) {
        if (context == null) {
            JSSplitDeclarationIntention.$$$reportNull$$$0(7);
        }
        if (psi == null) {
            PsiElement psiElement = context;
            if (psiElement == null) {
                JSSplitDeclarationIntention.$$$reportNull$$$0(8);
            }
            return psiElement;
        }
        PsiElement psiElement = context.getParent().addAfter(psi, context);
        if (psiElement == null) {
            JSSplitDeclarationIntention.$$$reportNull$$$0(9);
        }
        return psiElement;
    }

    @Nullable
    public static JSDocComment getDocComment(@NotNull JSVariable variable, @NotNull JSVarStatement varStatement) {
        JSVariable[] variables;
        if (variable == null) {
            JSSplitDeclarationIntention.$$$reportNull$$$0(10);
        }
        if (varStatement == null) {
            JSSplitDeclarationIntention.$$$reportNull$$$0(11);
        }
        JSVariable target = (variables = varStatement.getVariables()).length > 0 && variables[0] == variable ? varStatement : variable;
        return (JSDocComment)PsiTreeUtil.getChildOfType((PsiElement)target, JSDocComment.class);
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("js.split.declarations", new Object[0]);
        if (string == null) {
            JSSplitDeclarationIntention.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSSplitDeclarationIntention";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSSplitDeclarationIntention";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "addElement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "psiFromText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLeadingCommentsRange";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addElement";
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDocComment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

