/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.intentions.TypeScriptConvertAliasToInterfaceIntention;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptParenthesizedType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptConvertAliasToEnumIntention
extends JavaScriptIntention {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        TypeScriptTypeAlias alias;
        if (project == null) {
            TypeScriptConvertAliasToEnumIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            TypeScriptConvertAliasToEnumIntention.$$$reportNull$$$0(1);
        }
        if ((alias = TypeScriptConvertAliasToInterfaceIntention.getAlias(element)) == null) {
            return;
        }
        String aliasName = alias.getName();
        if (aliasName == null) {
            return;
        }
        List<TypeScriptLiteralType> literalTypes = TypeScriptConvertAliasToEnumIntention.getAllStringLiteralTypes(alias.getTypeDeclaration());
        if (literalTypes == null || literalTypes.size() == 0) {
            return;
        }
        HashMap<String, String> literalToEnumFieldName = new HashMap<String, String>(literalTypes.size());
        MultiMap literalToReferences = MultiMap.create();
        StringBuilder enumBody = new StringBuilder("{");
        HashSet<String> knownNames = new HashSet<String>();
        for (TypeScriptLiteralType literalType : literalTypes) {
            JSExpression expression = literalType.getExpression();
            assert (expression instanceof JSLiteralExpression);
            String stringValue = ((JSLiteralExpression)expression).getStringValue();
            assert (stringValue != null);
            String enumPropName = JSNameSuggestionsUtil.generateVariableNameFromExpression(expression, null);
            int i2 = 0;
            Object finalPropName = enumPropName;
            while (!knownNames.add((String)finalPropName)) {
                finalPropName = enumPropName + ++i2;
            }
            literalToEnumFieldName.put(stringValue, (String)finalPropName);
            enumBody.append((String)finalPropName).append(" = ").append(expression.getText()).append(",");
            PsiReference[] references = expression.getReferences();
            if (references.length != 1) {
                return;
            }
            PsiReference reference = references[0];
            if (reference == null) {
                return;
            }
            PsiElement resolve = reference.resolve();
            if (resolve == null) {
                return;
            }
            Query search = ReferencesSearch.search((PsiElement)resolve);
            literalToReferences.put((Object)stringValue, search.findAll());
        }
        String enumBodyString = StringUtil.trimEnd((String)enumBody.toString(), (String)",") + "}";
        ASTNode enumNode = JSChangeUtil.createStatementFromTextWithContext("enum " + aliasName + " " + enumBodyString, element);
        TypeScriptConvertAliasToInterfaceIntention.findChildAndReplace(JSStubElementTypes.ATTRIBUTE_LISTS, alias.getNode(), enumNode);
        THashSet filesToUpdate = new THashSet();
        for (Map.Entry entry : literalToReferences.entrySet()) {
            String key = (String)entry.getKey();
            String enumMemberName = aliasName + "." + (String)literalToEnumFieldName.get(key);
            for (PsiReference reference : (Collection)entry.getValue()) {
                PsiElement psiElement = reference.getElement();
                if (!(psiElement instanceof JSLiteralExpression) || !((JSLiteralExpression)psiElement).isStringLiteral()) continue;
                filesToUpdate.add(psiElement.getContainingFile());
                ES6CreateImportUtil.insertImport(psiElement, alias, aliasName);
                JSChangeUtil.replaceExpression((JSLiteralExpression)psiElement, (JSExpression)JSChangeUtil.createExpressionFromText(project, enumMemberName).getPsi());
            }
        }
        for (PsiFile file2 : filesToUpdate) {
            ES6CreateImportUtil.optimizeImports((PsiElement)file2);
        }
        JSChangeUtil.replaceElement(alias, (JSElement)enumNode.getPsi());
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            TypeScriptConvertAliasToEnumIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            TypeScriptConvertAliasToEnumIntention.$$$reportNull$$$0(3);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        PsiFile file2 = element.getContainingFile();
        if (!(file2 instanceof JSFile) || !DialectDetector.isTypeScript(element)) {
            return false;
        }
        TypeScriptTypeAlias alias = TypeScriptConvertAliasToInterfaceIntention.getAlias(element);
        if (alias == null || alias.getName() == null) {
            return false;
        }
        List<TypeScriptLiteralType> types2 = TypeScriptConvertAliasToEnumIntention.getAllStringLiteralTypes(alias.getTypeDeclaration());
        return types2 != null && types2.size() > 0;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("ts.convert.alias.to.enum.action.family.name", new Object[0]);
        if (string == null) {
            TypeScriptConvertAliasToEnumIntention.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message("ts.convert.alias.to.enum.action.title", new Object[0]);
        if (string == null) {
            TypeScriptConvertAliasToEnumIntention.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    private static List<TypeScriptLiteralType> getAllStringLiteralTypes(@Nullable JSTypeDeclaration declaration) {
        while (declaration instanceof TypeScriptParenthesizedType) {
            declaration = ((TypeScriptParenthesizedType)declaration).getInnerType();
        }
        if (declaration instanceof TypeScriptLiteralType) {
            JSExpression expression = ((TypeScriptLiteralType)declaration).getExpression();
            if (expression instanceof JSLiteralExpression && ((JSLiteralExpression)expression).isStringLiteral()) {
                return ContainerUtil.createMaybeSingletonList((Object)((TypeScriptLiteralType)declaration));
            }
            return null;
        }
        if (!(declaration instanceof TypeScriptUnionOrIntersectionType) || !((TypeScriptUnionOrIntersectionType)declaration).isUnionType()) {
            return null;
        }
        TypeScriptType[] types2 = ((TypeScriptUnionOrIntersectionType)declaration).getTypes();
        ArrayList<TypeScriptLiteralType> allTypes = new ArrayList<TypeScriptLiteralType>();
        for (TypeScriptType type : types2) {
            List<TypeScriptLiteralType> literalTypes = TypeScriptConvertAliasToEnumIntention.getAllStringLiteralTypes(type);
            if (literalTypes == null) {
                return null;
            }
            allTypes.addAll(literalTypes);
        }
        return allTypes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/TypeScriptConvertAliasToEnumIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/TypeScriptConvertAliasToEnumIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

