/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions.destructuring;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import gnu.trove.TDoubleArrayList;
import java.math.BigInteger;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSDestructuringIntentionBase
extends JavaScriptIntention {
    private static final int MAX_INDEXER_ALLOWED = 100;

    protected JSDestructuringIntentionBase() {
        this.setText(this.getFamilyName());
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSDestructuringIntentionBase.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSDestructuringIntentionBase.$$$reportNull$$$0(1);
        }
        return super.isAvailable(project, editor, element) && DialectDetector.hasFeature(element, JSLanguageFeature.DESTRUCTURING_ASSIGNMENT);
    }

    public static double toDouble(JSLiteralExpression expression) {
        Object value = expression.getValue();
        if (!(value instanceof Number) || value instanceof BigInteger) {
            return -1.0;
        }
        return ((Number)value).doubleValue();
    }

    private static double max(TDoubleArrayList array) {
        double maxValue = Double.NEGATIVE_INFINITY;
        for (int i2 = 0; i2 < array.size(); ++i2) {
            double v = array.get(i2);
            if (!(v > maxValue)) continue;
            maxValue = v;
        }
        return maxValue;
    }

    protected static void appendDestructuringArrayInitializer(TDoubleArrayList indices, List<String> names, StringBuilder destructuringString) {
        destructuringString.append("[");
        double max = JSDestructuringIntentionBase.max(indices);
        int i2 = 0;
        while ((double)i2 <= max) {
            int index = indices.indexOf((double)i2);
            if (index < 0) {
                destructuringString.append(",");
            } else {
                destructuringString.append(names.get(index)).append((double)i2 == max ? "" : ",");
            }
            ++i2;
        }
        destructuringString.append("]");
    }

    public static boolean isValidIndexer(JSIndexedPropertyAccessExpression indexer) {
        JSLiteralExpression single = (JSLiteralExpression)ObjectUtils.tryCast((Object)indexer.getIndexExpression(), JSLiteralExpression.class);
        if (single == null || !single.getExpressionKind(true).isInteger()) {
            return false;
        }
        return JSDestructuringIntentionBase.toDouble(single) <= 100.0;
    }

    @Nullable
    protected static JSExpression checkValidIndexerExpressionInValue(@Nullable JSExpression value) {
        JSIndexedPropertyAccessExpression indexSource = (JSIndexedPropertyAccessExpression)ObjectUtils.tryCast((Object)value, JSIndexedPropertyAccessExpression.class);
        if (indexSource == null) {
            return null;
        }
        JSLiteralExpression single = (JSLiteralExpression)ObjectUtils.tryCast((Object)indexSource.getIndexExpression(), JSLiteralExpression.class);
        if (single == null || !single.getExpressionKind(true).isInteger()) {
            return null;
        }
        return (JSExpression)ObjectUtils.tryCast((Object)indexSource.getQualifier(), JSReferenceExpression.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/intentions/destructuring/JSDestructuringIntentionBase";
        objectArray[2] = "isAvailable";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

