/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.library.ui.JSScriptingContextProvider;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.ui.Util;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.AttachRootButtonDescriptor;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.OrderRootTypePresentation;
import com.intellij.openapi.roots.libraries.ui.RootDetector;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import icons.JavaScriptLanguageIcons;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLibraryRootsComponentDescriptor
extends LibraryRootsComponentDescriptor {
    private final JSScriptingContextProvider myProvider = new JSScriptingContextProvider();
    private String myDefaultDocUrl;

    public OrderRootTypePresentation getRootTypePresentation(@NotNull OrderRootType type) {
        if (type == null) {
            JSLibraryRootsComponentDescriptor.$$$reportNull$$$0(0);
        }
        if (type == OrderRootType.CLASSES) {
            return new OrderRootTypePresentation(this.myProvider.getLibraryTypeName(OrderRootType.CLASSES), JavaScriptLanguageIcons.Library.JsCompact);
        }
        if (type == OrderRootType.SOURCES) {
            return new OrderRootTypePresentation(this.myProvider.getLibraryTypeName(OrderRootType.SOURCES), AllIcons.Nodes.Package);
        }
        if (type == OrderRootType.DOCUMENTATION) {
            return new OrderRootTypePresentation(JavaScriptBundle.message("js.library.documentation", new Object[0]), AllIcons.Nodes.JavaDocFolder);
        }
        return null;
    }

    @NotNull
    public FileChooserDescriptor createAttachFilesChooserDescriptor(String libraryName) {
        return new LibFileChooserDescriptor(true);
    }

    @NotNull
    public List<? extends RootDetector> getRootDetectors() {
        List<JSLibraryRootsDetector> list2 = Arrays.asList(new JSLibraryRootsDetector(OrderRootType.CLASSES, true), new JSLibraryRootsDetector(OrderRootType.SOURCES, false));
        if (list2 == null) {
            JSLibraryRootsComponentDescriptor.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @NotNull
    public List<? extends AttachRootButtonDescriptor> createAttachButtons() {
        ArrayList<AttachRootButtonDescriptor> myButtonDescriptors = new ArrayList<AttachRootButtonDescriptor>();
        myButtonDescriptors.add(new AttachFromButtonDescriptor(OrderRootType.SOURCES, JavaScriptBundle.message("js.library.attach.debug", new Object[0])));
        myButtonDescriptors.add(new AttachFromButtonDescriptor(OrderRootType.CLASSES, JavaScriptBundle.message("js.library.attach.release", new Object[0])));
        myButtonDescriptors.add(new AttachUrlDocDescriptor());
        ArrayList<AttachRootButtonDescriptor> arrayList = myButtonDescriptors;
        if (arrayList == null) {
            JSLibraryRootsComponentDescriptor.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private void collectFilesRecursively(final List<VirtualFile> collectedFiles, VirtualFile dir, final OrderRootType rootType) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)dir, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!file2.isDirectory() && JSLibraryRootsComponentDescriptor.this.myProvider.acceptsExtension(file2.getExtension())) {
                    OrderRootType fileRootType;
                    OrderRootType orderRootType = fileRootType = JSLibraryRootsComponentDescriptor.this.myProvider.isCompact(file2) ? OrderRootType.CLASSES : OrderRootType.SOURCES;
                    if (fileRootType == rootType) {
                        collectedFiles.add(file2);
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor$1", "visitFile"));
            }
        });
    }

    public OrderRootType[] getRootTypes() {
        ArrayList<OrderRootType> rootTypes = new ArrayList<OrderRootType>();
        rootTypes.addAll(Arrays.asList(super.getRootTypes()));
        rootTypes.addAll(Arrays.asList(this.myProvider.getLibraryKind().getAdditionalRootTypes()));
        return rootTypes.toArray(new OrderRootType[0]);
    }

    @Nullable
    private String getDefaultDocUrl(LibraryEditor libraryEditor) {
        if (this.myDefaultDocUrl == null) {
            for (OrderRootType rootType : this.getRootTypes()) {
                for (VirtualFile file2 : libraryEditor.getFiles(rootType)) {
                    ScriptingFrameworkDescriptor framework = this.myProvider.detectFramework(file2);
                    if (framework == null) continue;
                    this.myDefaultDocUrl = this.myProvider.getDefaultDocUrl(framework);
                    return this.myDefaultDocUrl;
                }
            }
        }
        return this.myDefaultDocUrl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootDetectors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttachButtons";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRootTypePresentation";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class AttachUrlDocDescriptor
    extends AttachRootButtonDescriptor {
        private AttachUrlDocDescriptor() {
            super(OrderRootType.DOCUMENTATION, ProjectBundle.message((String)"module.libraries.javadoc.url.button", (Object[])new Object[0]));
        }

        public VirtualFile[] selectFiles(@NotNull JComponent parent, @Nullable VirtualFile initialSelection, @Nullable Module contextModule, @Nullable LibraryEditor libraryEditor) {
            VirtualFile vFile;
            if (parent == null) {
                AttachUrlDocDescriptor.$$$reportNull$$$0(0);
            }
            if ((vFile = Util.showSpecifyJavadocUrlDialog((JComponent)parent, (String)JSLibraryRootsComponentDescriptor.this.getDefaultDocUrl(libraryEditor))) != null) {
                return new VirtualFile[]{vFile};
            }
            return VirtualFile.EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor$AttachUrlDocDescriptor", "selectFiles"));
        }
    }

    private class AttachFromButtonDescriptor
    extends AttachRootButtonDescriptor {
        protected AttachFromButtonDescriptor(@NotNull @NlsContexts.Button OrderRootType orderRootType, String buttonText) {
            if (orderRootType == null) {
                AttachFromButtonDescriptor.$$$reportNull$$$0(0);
            }
            if (buttonText == null) {
                AttachFromButtonDescriptor.$$$reportNull$$$0(1);
            }
            super(orderRootType, buttonText);
        }

        public VirtualFile[] selectFiles(@NotNull JComponent parent, @Nullable VirtualFile initialSelection, @Nullable Module contextModule, @Nullable LibraryEditor libraryEditor) {
            if (parent == null) {
                AttachFromButtonDescriptor.$$$reportNull$$$0(2);
            }
            ArrayList<VirtualFile> collectedFiles = new ArrayList<VirtualFile>();
            LibFileChooserDescriptor chooserDescriptor = new LibFileChooserDescriptor(false);
            chooserDescriptor.setTitle(JavaScriptBundle.message("js.library.select." + (this.getRootType() == OrderRootType.SOURCES ? "debug" : "release"), new Object[0]));
            Project project = contextModule != null ? contextModule.getProject() : null;
            VirtualFile chosenFile = FileChooser.chooseFile((FileChooserDescriptor)chooserDescriptor, (Component)parent, (Project)project, null);
            if (chosenFile != null && chosenFile.isValid()) {
                if (chosenFile.isDirectory()) {
                    JSLibraryRootsComponentDescriptor.this.collectFilesRecursively(collectedFiles, chosenFile, this.getRootType());
                } else {
                    collectedFiles.add(chosenFile);
                }
            }
            for (VirtualFile file2 : collectedFiles) {
                ScriptingFrameworkDescriptor framework = JSLibraryRootsComponentDescriptor.this.myProvider.detectFramework(file2);
                if (framework == null) continue;
                JSLibraryRootsComponentDescriptor.this.myDefaultDocUrl = JSLibraryRootsComponentDescriptor.this.myProvider.getDefaultDocUrl(framework);
                break;
            }
            return VfsUtilCore.toVirtualFileArray(collectedFiles);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "orderRootType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buttonText";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor$AttachFromButtonDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectFiles";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class LibFileChooserDescriptor
    extends FileChooserDescriptor {
        LibFileChooserDescriptor(boolean chooseMultiple) {
            super(true, true, false, true, false, chooseMultiple);
        }

        public boolean isFileSelectable(VirtualFile file2) {
            if (!file2.isDirectory() && !JSLibraryRootsComponentDescriptor.this.myProvider.acceptsExtension(file2.getExtension())) {
                return false;
            }
            return super.isFileSelectable(file2);
        }

        public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
            if (!file2.isDirectory() && !JSLibraryRootsComponentDescriptor.this.myProvider.acceptsExtension(file2.getExtension())) {
                return false;
            }
            return super.isFileVisible(file2, showHiddenFiles);
        }
    }

    private final class JSLibraryRootsDetector
    extends RootDetector {
        private final boolean myCompact;

        private JSLibraryRootsDetector(OrderRootType rootType, boolean compact) {
            super(rootType, false, JSLibraryRootsComponentDescriptor.this.myProvider.getLibraryTypeName(rootType));
            this.myCompact = compact;
        }

        @NotNull
        public Collection<VirtualFile> detectRoots(@NotNull VirtualFile rootCandidate, @NotNull ProgressIndicator progressIndicator) {
            if (rootCandidate == null) {
                JSLibraryRootsDetector.$$$reportNull$$$0(0);
            }
            if (progressIndicator == null) {
                JSLibraryRootsDetector.$$$reportNull$$$0(1);
            }
            ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
            this.collectRecursively(rootCandidate, result2, progressIndicator);
            ArrayList<VirtualFile> arrayList = result2;
            if (arrayList == null) {
                JSLibraryRootsDetector.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        private void collectRecursively(@NotNull VirtualFile file2, final @NotNull List<VirtualFile> result2, final @NotNull ProgressIndicator progressIndicator) {
            if (file2 == null) {
                JSLibraryRootsDetector.$$$reportNull$$$0(3);
            }
            if (result2 == null) {
                JSLibraryRootsDetector.$$$reportNull$$$0(4);
            }
            if (progressIndicator == null) {
                JSLibraryRootsDetector.$$$reportNull$$$0(5);
            }
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file2) {
                    if (file2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (file2.isDirectory()) {
                        progressIndicator.setText2(file2.getPresentableUrl());
                        progressIndicator.checkCanceled();
                    } else if (JSLibraryRootsComponentDescriptor.this.myProvider.acceptsExtension(file2.getExtension()) && JSLibraryRootsDetector.this.myCompact == JSLibraryRootsComponentDescriptor.this.myProvider.isCompact(file2)) {
                        result2.add(file2);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor$JSLibraryRootsDetector$1", "visitFile"));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootCandidate";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressIndicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor$JSLibraryRootsDetector";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor$JSLibraryRootsDetector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "detectRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "detectRoots";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "collectRecursively";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

