/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSDisposable;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.FileHeaderKeeper;
import com.intellij.lang.javascript.modules.ImportJSModuleBaseFix;
import com.intellij.lang.javascript.modules.JSPlaceTail;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ImportCommonJSModuleFix
extends LocalQuickFixOnPsiElement
implements ImportJSModuleBaseFix,
LocalQuickFix,
HintAction,
PriorityAction {
    @NotNull
    protected final JSImportCandidate myCandidate;
    @Nullable
    protected final JSPlaceTail myTail;
    private volatile boolean myNeedHint;

    protected ImportCommonJSModuleFix(@NotNull PsiElement node, @NotNull JSImportCandidate descriptor2, @Nullable JSPlaceTail tail) {
        if (node == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(0);
        }
        if (descriptor2 == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(1);
        }
        this(node, descriptor2, tail, false);
    }

    protected ImportCommonJSModuleFix(@NotNull PsiElement node, @NotNull JSImportCandidate descriptor2, @Nullable JSPlaceTail tail, boolean needHint) {
        if (node == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(3);
        }
        super(node);
        this.myTail = tail;
        this.myCandidate = descriptor2;
        this.myNeedHint = needHint;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(4);
        }
        return this.isAvailable() && this.myCandidate.getSingleDescriptorOrNull() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        PsiElement element = this.getStartElement();
        if (element != null) {
            FileHeaderKeeper headerKeeper = new FileHeaderKeeper(ES6CreateImportUtil.getExternalModuleScope(element));
            headerKeeper.saveStateAndCutHeader();
            try {
                this.invokeAction(element, editor);
            }
            finally {
                headerKeeper.restoreHeaderForSavedState();
            }
        }
    }

    public void invokeAction(@NotNull PsiElement element, @Nullable Editor editor) {
        if (element == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        PsiFile file2 = element.getContainingFile();
        JSEmbeddedContent embeddedContent = (JSEmbeddedContent)PsiTreeUtil.getParentOfType((PsiElement)element, JSEmbeddedContent.class, (boolean)false);
        boolean useEmbeddedContent = embeddedContent != null && (!DialectDetector.isJSX((PsiElement)embeddedContent) || !DialectDetector.isJSX((PsiElement)file2));
        JSEmbeddedContent scope = useEmbeddedContent ? embeddedContent : file2;
        this.executeImpl(element, editor, (PsiElement)scope);
        DaemonCodeAnalyzer.getInstance((Project)scope.getProject()).restart(file2);
    }

    protected abstract void executeImpl(@NotNull PsiElement var1, @Nullable Editor var2, @NotNull PsiElement var3);

    protected void replaceReferences(PsiElement element, @Nullable Editor editor) {
        if (this.myTail == null || this.myTail.getStrings().length == 0) {
            return;
        }
        this.replaceWithNewReference(element, editor, this.myTail.getLast());
    }

    protected void replaceWithNewReference(@NotNull PsiElement elementTarget, @Nullable Editor editor, @NotNull String newReferenceName) {
        if (elementTarget == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(7);
        }
        if (newReferenceName == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(8);
        }
        if (elementTarget instanceof JSReferenceExpression) {
            JSReferenceExpression replaceTarget = (JSReferenceExpression)elementTarget;
            if (replaceTarget.getQualifier() == null && newReferenceName.equals(replaceTarget.getReferenceName())) {
                return;
            }
            PsiFile dummy = ImportCommonJSModuleFix.createDummyFile(replaceTarget.getProject(), newReferenceName);
            JSExpression replace = replaceTarget.replace((JSExpression)PsiTreeUtil.findChildOfType((PsiElement)dummy, JSReferenceExpression.class));
            if (editor != null) {
                editor.getCaretModel().moveToOffset(replace.getTextRange().getEndOffset());
            }
        }
    }

    protected static PsiFile createDummyFile(Project project, String text) {
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)project);
        return psiFileFactory.createFileFromText("dummy.js", (FileType)JavaScriptFileType.INSTANCE, (CharSequence)text);
    }

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(9);
        }
        if (!this.myNeedHint) {
            return false;
        }
        PsiElement element = this.getStartElement();
        if (element == null || !element.isValid()) {
            return false;
        }
        Project project = editor.getProject();
        if (project == null) {
            return false;
        }
        PsiReference reference = element.getReference();
        if (reference == null) {
            return false;
        }
        PsiElement referenceElement = reference.getElement();
        TextRange rangeInElement = reference.getRangeInElement();
        int elOffset = referenceElement.getTextOffset();
        TextRange range = new TextRange(elOffset + rangeInElement.getStartOffset(), elOffset + rangeInElement.getEndOffset());
        String message = ShowAutoImportPass.getMessage((boolean)false, (String)this.getVarName());
        HintManager.getInstance().showQuestionHint(editor, message, range.getStartOffset(), range.getEndOffset(), () -> {
            if (project.isDisposed() || !element.isValid()) {
                return false;
            }
            TransactionGuard.submitTransaction((Disposable)JSDisposable.getInstance(project), () -> {
                Runnable runnable = () -> WriteAction.run(() -> this.invoke(project, editor, element.getContainingFile()));
                CommandProcessor.getInstance().executeCommand(project, runnable, this.getText(), (Object)this);
                this.myNeedHint = false;
            });
            return true;
        });
        return true;
    }

    @NotNull
    public String getPath() {
        List<JSImportDescriptor> descriptors = this.myCandidate.getDescriptors();
        if (descriptors.size() == 1) {
            String string = descriptors.get(0).getModuleName();
            if (string == null) {
                ImportCommonJSModuleFix.$$$reportNull$$$0(10);
            }
            return string;
        }
        return "";
    }

    private String getVarName() {
        if (this.myTail != null) {
            return this.myTail.getLast();
        }
        return this.myCandidate.getName();
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    protected String getQuote() {
        PsiElement element = this.getStartElement();
        return element != null ? JSCodeStyleSettings.getQuote(element) : "\"";
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(12);
        }
        if (startElement == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(13);
        }
        if (endElement == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(14);
        }
        this.invokeAction(startElement, null);
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        PriorityAction.Priority priority2 = PriorityAction.Priority.TOP;
        if (priority2 == null) {
            ImportCommonJSModuleFix.$$$reportNull$$$0(15);
        }
        return priority2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementTarget";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newReferenceName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPriority";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invokeAction";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithNewReference";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
            case 10: 
            case 15: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

