/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.ide.IdeBundle;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.modules.ImportCommonJSModuleFix;
import com.intellij.lang.javascript.modules.JSPlaceTail;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.validation.fixes.ES6ImportFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportES6ModuleFix
extends ImportCommonJSModuleFix
implements ES6ImportFix {
    private final NotNullLazyValue<String> myInsertedText;

    public ImportES6ModuleFix(@NotNull PsiElement node, @NotNull JSImportCandidate descriptor2, @Nullable JSPlaceTail tail, boolean needHint) {
        if (node == null) {
            ImportES6ModuleFix.$$$reportNull$$$0(0);
        }
        if (descriptor2 == null) {
            ImportES6ModuleFix.$$$reportNull$$$0(1);
        }
        super(node, descriptor2, tail, needHint);
        this.myInsertedText = NotNullLazyValue.createValue(() -> {
            PsiElement element;
            JSImportDescriptor descriptor2 = this.myCandidate.getSingleDescriptorOrNull();
            if (descriptor2 != null && (element = this.getStartElement()) != null) {
                return ES6ImportPsiUtil.createImportOrExportText(element, descriptor2, false);
            }
            return "import " + this.myCandidate.getName();
        });
    }

    @Override
    protected void executeImpl(@NotNull PsiElement element, @Nullable Editor editor, @NotNull PsiElement scope) {
        if (element == null) {
            ImportES6ModuleFix.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            ImportES6ModuleFix.$$$reportNull$$$0(3);
        }
        this.myCandidate.createExecutor(editor, element).createImports(this.myCandidate);
        this.replaceReferences(element, editor);
    }

    @NotNull
    private PsiElement correctReplaceTarget(@NotNull PsiElement reference) {
        if (reference == null) {
            ImportES6ModuleFix.$$$reportNull$$$0(4);
        }
        if (reference instanceof JSReferenceExpression) {
            PsiElement target;
            JSReferenceExpression replaceTarget = (JSReferenceExpression)reference;
            PsiElement psiElement = target = this.myTail == null ? null : this.myTail.getTailToReplaceReference();
            if (target == null) {
                while (replaceTarget.getQualifier() instanceof JSReferenceExpression) {
                    replaceTarget = (JSReferenceExpression)replaceTarget.getQualifier();
                }
            }
            JSReferenceExpression jSReferenceExpression = replaceTarget;
            if (jSReferenceExpression == null) {
                ImportES6ModuleFix.$$$reportNull$$$0(5);
            }
            return jSReferenceExpression;
        }
        PsiElement psiElement = reference;
        if (psiElement == null) {
            ImportES6ModuleFix.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    @Override
    protected void replaceReferences(PsiElement element, Editor editor) {
        String name;
        PsiElement replaceTarget = this.correctReplaceTarget(element);
        if (replaceTarget instanceof JSReferenceExpression && (name = ((JSReferenceExpression)replaceTarget).getReferenceName()) != null) {
            this.replaceWithNewReference(replaceTarget, editor, name);
        }
    }

    private String getInsertedText() {
        return (String)this.myInsertedText.getValue();
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("js.inspection.es6.modules.dependencies.family.name", new Object[0]);
        if (string == null) {
            ImportES6ModuleFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getText() {
        String wholeImportWrapQuote = ES6ImportPsiUtil.invertQuote(this.getQuote());
        String string = IdeBundle.message((String)"quickfix.text.insert.0", (Object[])new Object[]{wholeImportWrapQuote + this.getInsertedText() + wholeImportWrapQuote});
        if (string == null) {
            ImportES6ModuleFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/ImportES6ModuleFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/ImportES6ModuleFix";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "correctReplaceTarget";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "executeImpl";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "correctReplaceTarget";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

