/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.imports.providers;

import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryManager;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.modules.JSImportCandidateDescriptor;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportCandidatesBase;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.modules.imports.providers.JSCandidatesProcessor;
import com.intellij.lang.javascript.modules.imports.providers.JSImportCandidatesProvider;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeCoreModuleCandidatesProvider
extends JSImportCandidatesBase {
    @Nullable
    private final VirtualFile myModuleRoot;

    public NodeCoreModuleCandidatesProvider(@NotNull JSImportPlaceInfo placeInfo) {
        if (placeInfo == null) {
            NodeCoreModuleCandidatesProvider.$$$reportNull$$$0(0);
        }
        super(placeInfo);
        this.myModuleRoot = NodeModuleUtil.getMainModuleRoot(placeInfo.getPlace());
    }

    @Override
    public boolean processCandidates(@NotNull String ref, @NotNull JSCandidatesProcessor processor, boolean forCompletion) {
        if (ref == null) {
            NodeCoreModuleCandidatesProvider.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            NodeCoreModuleCandidatesProvider.$$$reportNull$$$0(2);
        }
        if (forCompletion) {
            return true;
        }
        VirtualFile coreModule = NodeCoreLibraryManager.getInstance(this.getProject()).findCoreModuleFileByName(ref);
        if (coreModule != null) {
            processor.processCandidate(new JSImportCandidateDescriptor(JSImportCandidate.SourceType.COMMONJS, coreModule.getNameWithoutExtension(), ref, null, ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT, (JSImportExportType)ES6ImportPsiUtil.ImportExportType.DEFAULT));
        } else if (!processor.hasElements()) {
            processor.processCandidate(this.processAsNodeModuleName(ref));
        }
        return true;
    }

    @Nullable
    private JSImportCandidate processAsNodeModuleName(@NotNull String referenceName) {
        if (referenceName == null) {
            NodeCoreModuleCandidatesProvider.$$$reportNull$$$0(3);
        }
        if (this.myModuleRoot == null) {
            return null;
        }
        VirtualFile file2 = NodeModuleUtil.getProjectChildModuleByName(this.getProject(), this.myModuleRoot, referenceName);
        if (file2 != null && file2.getNameWithoutExtension().equals(referenceName)) {
            return new JSImportCandidateDescriptor(JSImportCandidate.SourceType.COMMONJS, referenceName, referenceName, null, ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT, (JSImportExportType)ES6ImportPsiUtil.ImportExportType.DEFAULT);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/modules/imports/providers/NodeCoreModuleCandidatesProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processCandidates";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processAsNodeModuleName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MyFactory
    implements JSImportCandidatesProvider.CandidatesFactory {
        @Override
        @Nullable
        public JSImportCandidatesProvider createProvider(@NotNull JSImportPlaceInfo placeInfo) {
            if (placeInfo == null) {
                MyFactory.$$$reportNull$$$0(0);
            }
            if (placeInfo.importContext() != JSImportPlaceInfo.ImportContext.SIMPLE || DialectDetector.isTypeScript(placeInfo.getPlace()) || placeInfo.isStrictTypeContext()) {
                return null;
            }
            return new NodeCoreModuleCandidatesProvider(placeInfo);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeInfo", "com/intellij/lang/javascript/modules/imports/providers/NodeCoreModuleCandidatesProvider$MyFactory", "createProvider"));
        }
    }
}

