/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpressionKind;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSInheritedLanguagesConfigurableProvider {
    public static final LanguageExtension<JSInheritedLanguagesConfigurableProvider> INSTANCE = new LanguageExtension("JavaScript.inheritedLanguagesConfigurableProvider");

    public Language getLanguage() {
        return JavascriptLanguage.INSTANCE;
    }

    public boolean isBadExpressionStatement(@NotNull PsiElement element) {
        if (element == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(0);
        }
        return true;
    }

    public boolean isNeedToBeTerminated(@NotNull PsiElement element) {
        if (element == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(1);
        }
        return true;
    }

    public boolean isLHSExpression(@NotNull PsiElement element) {
        if (element == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(2);
        }
        return false;
    }

    public boolean isCaseStatementInterrupted(JSStatement statement) {
        return false;
    }

    public boolean forConditionShouldUseVariables() {
        return true;
    }

    public boolean constructorCallWithoutNewActual() {
        return true;
    }

    public boolean unnecessaryBlockStatement(@NotNull PsiElement element) {
        if (element == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(3);
        }
        return true;
    }

    public boolean hasNonBlockBranch(@NotNull PsiElement element) {
        if (element == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(4);
        }
        return false;
    }

    public boolean isRemoveUnnecessaryParenthesesEnabled(@NotNull PsiElement element) {
        if (element == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(5);
        }
        return true;
    }

    public boolean isSimplifyBooleanFixEnabled(@NotNull PsiElement element) {
        if (element == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(6);
        }
        return true;
    }

    public boolean shouldRenameFileWithClass(@NotNull PsiElement element) {
        if (element == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(7);
        }
        return true;
    }

    @Nullable
    protected ASTNode createNameIdentifierFromText(@NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(8);
        }
        if (context == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(9);
        }
        return JSChangeUtil.createNameIdentifierWithContext(text, context);
    }

    @Nullable
    public PsiElement createExpressionFromText(@NotNull String text, @NotNull PsiElement element) {
        ASTNode node;
        if (text == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(10);
        }
        if (element == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(11);
        }
        return (node = JSChangeUtil.createExpressionWithContext(text, element)) != null ? node.getPsi() : null;
    }

    public boolean isMultilineLiteral(@NotNull PsiElement element) {
        if (element == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(12);
        }
        return element instanceof JSStringTemplateExpression;
    }

    public String getMultilineLiteralContent(@NotNull PsiElement context, @NotNull String text) {
        if (context == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(13);
        }
        if (text == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(14);
        }
        return JSStringUtil.escapeTemplateStringChars(text, false, false, context);
    }

    public TextRange getRangeInElement(PsiElement element) {
        JSLiteralExpression literal = (JSLiteralExpression)element;
        int length = literal.getTextLength();
        if (literal.isQuotedLiteral() && length >= 2) {
            ASTNode quotedLiteralNode;
            ASTNode backquote;
            int startOffset = 1;
            if (element instanceof JSStringTemplateExpression && (backquote = (quotedLiteralNode = element.getNode()).findChildByType(JSTokenTypes.BACKQUOTE)) != null) {
                startOffset = backquote.getStartOffset() - quotedLiteralNode.getStartOffset() + 1;
            }
            return new TextRange(startOffset, length - 1);
        }
        return new TextRange(0, length);
    }

    public boolean supportsJavaScriptInjections() {
        return true;
    }

    @Nullable
    public JSLiteralExpressionKind getCustomLiteralKind(@NotNull JSLiteralExpression expression, @NotNull IElementType elementType) {
        if (expression == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(15);
        }
        if (elementType == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(16);
        }
        return null;
    }

    @Nullable
    public PsiElement createParameterOrVariableItem(@NotNull String destruct, @NotNull PsiElement parent) {
        if (destruct == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(17);
        }
        if (parent == null) {
            JSInheritedLanguagesConfigurableProvider.$$$reportNull$$$0(18);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destruct";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/JSInheritedLanguagesConfigurableProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isBadExpressionStatement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isNeedToBeTerminated";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isLHSExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "unnecessaryBlockStatement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasNonBlockBranch";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isRemoveUnnecessaryParenthesesEnabled";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isSimplifyBooleanFixEnabled";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldRenameFileWithClass";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createNameIdentifierFromText";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "createExpressionFromText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isMultilineLiteral";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getMultilineLiteralContent";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "getCustomLiteralKind";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "createParameterOrVariableItem";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

