/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

public enum JSLiteralExpressionKind {
    OCT,
    OCT_BIGINT,
    OBSOLETE_OCT,
    HEX,
    HEX_BIGINT,
    DEC,
    DEC_BIGINT,
    BIN,
    BIN_BIGINT,
    OTHER_NUMERIC,
    QUOTED,
    TEMPLATE_NO_ARGS,
    TEMPLATE_WITH_ARGS,
    REGEXP,
    XML,
    NULL,
    TRUE,
    FALSE,
    UNKNOWN;


    public boolean isOct() {
        return this == OCT_BIGINT || this == OCT || this == OBSOLETE_OCT;
    }

    public boolean isBin() {
        return this == BIN_BIGINT || this == BIN;
    }

    public boolean isHex() {
        return this == HEX_BIGINT || this == HEX;
    }

    public boolean isBigInteger() {
        return this == OCT_BIGINT || this == HEX_BIGINT || this == DEC_BIGINT || this == BIN_BIGINT;
    }

    public boolean isInteger() {
        return this == OCT || this == OBSOLETE_OCT || this == HEX || this == DEC || this == BIN || this.isBigInteger();
    }

    public boolean isNumeric() {
        return this == OTHER_NUMERIC || this.isInteger();
    }

    public boolean isBoolean() {
        return this == TRUE || this == FALSE;
    }

    public JSLiteralExpressionKind toBigInt() {
        switch (this) {
            case DEC: {
                return DEC_BIGINT;
            }
            case BIN: {
                return BIN_BIGINT;
            }
            case OCT: {
                return OCT_BIGINT;
            }
            case HEX: {
                return HEX_BIGINT;
            }
        }
        return this;
    }
}

