/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class JSQualifiedNameImpl
implements JSQualifiedName {
    private static final ThreadLocal<StringBuilder> BUILDER = new ThreadLocal();
    private static final ConcurrentMap<String, JSQualifiedNameImpl> NAMESPACES = ContainerUtil.createConcurrentWeakKeyWeakValueMap();
    public static final JSQualifiedNameImpl EMPTY = JSQualifiedNameImpl.create("", null);
    @NotNull
    private final String myName;
    @Nullable
    private final JSQualifiedNameImpl myParent;

    private JSQualifiedNameImpl(@NotNull String name, @Nullable JSQualifiedName parent) {
        if (name == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(0);
        }
        this.myName = name;
        this.myParent = (JSQualifiedNameImpl)parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static JSQualifiedNameImpl create(@NotNull String name, @Nullable JSQualifiedName parent) {
        if (name == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(1);
        }
        StringBuilder builder = JSQualifiedNameImpl.getBuilder();
        if (parent != null) {
            ((JSQualifiedNameImpl)parent).getQualifiedName(builder);
            builder.append(".");
        }
        builder.append(JSStringUtil.wrapQualifiedNameComponent(name));
        String fqn = builder.toString();
        JSQualifiedNameImpl oldValue = (JSQualifiedNameImpl)NAMESPACES.get(fqn);
        if (oldValue != null) {
            JSQualifiedNameImpl jSQualifiedNameImpl = oldValue;
            JSQualifiedNameImpl jSQualifiedNameImpl2 = jSQualifiedNameImpl;
            if (jSQualifiedNameImpl2 == null) {
                JSQualifiedNameImpl.$$$reportNull$$$0(2);
            }
            return jSQualifiedNameImpl2;
        }
        JSQualifiedNameImpl newName = new JSQualifiedNameImpl(name, parent);
        oldValue = NAMESPACES.putIfAbsent(fqn, newName);
        JSQualifiedNameImpl jSQualifiedNameImpl = newName = oldValue != null ? oldValue : newName;
        JSQualifiedNameImpl jSQualifiedNameImpl3 = jSQualifiedNameImpl;
        if (jSQualifiedNameImpl3 == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(3);
        }
        return jSQualifiedNameImpl3;
        finally {
            JSQualifiedNameImpl.clearBuilder(builder);
        }
    }

    @Nullable
    public static JSQualifiedNameImpl fromComponents(@NotNull List<String> components) {
        if (components == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(4);
        }
        JSQualifiedNameImpl result2 = null;
        for (String component : components) {
            result2 = JSQualifiedNameImpl.create(component, result2);
        }
        return result2;
    }

    @Nullable
    public static JSQualifiedNameImpl fromComponents(String ... components) {
        JSQualifiedNameImpl result2 = null;
        for (String component : components) {
            result2 = JSQualifiedNameImpl.create(component, result2);
        }
        return result2;
    }

    @NotNull
    public static JSQualifiedNameImpl fromQualifiedName(@NotNull String qualifiedName) {
        JSQualifiedNameImpl cached;
        if (qualifiedName == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(5);
        }
        if ((cached = (JSQualifiedNameImpl)NAMESPACES.get(qualifiedName)) != null) {
            JSQualifiedNameImpl jSQualifiedNameImpl = cached;
            if (jSQualifiedNameImpl == null) {
                JSQualifiedNameImpl.$$$reportNull$$$0(6);
            }
            return jSQualifiedNameImpl;
        }
        return JSQualifiedNameImpl.splitHonorQuotes(qualifiedName, ".");
    }

    @NotNull
    private static JSQualifiedNameImpl splitHonorQuotes(@NotNull String qualifiedName, @NotNull String separators) {
        if (qualifiedName == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(7);
        }
        if (separators == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(8);
        }
        ArrayList<String> split = new ArrayList<String>();
        StringBuilder builder = new StringBuilder(qualifiedName.length());
        boolean inQuotes = false;
        for (int i2 = 0; i2 < qualifiedName.length(); ++i2) {
            char c = qualifiedName.charAt(i2);
            if (StringUtil.containsChar((String)separators, (char)c) && !inQuotes) {
                if (builder.length() <= 0) continue;
                split.add(builder.toString());
                builder.setLength(0);
                continue;
            }
            if (!(c != '\"' && c != '\'' || i2 > 0 && qualifiedName.charAt(i2 - 1) == '\\')) {
                inQuotes = !inQuotes;
            }
            builder.append(c);
        }
        if (builder.length() > 0) {
            split.add(builder.toString());
        }
        JSQualifiedNameImpl result2 = null;
        for (String component : split) {
            result2 = JSQualifiedNameImpl.create(JSStringUtil.unwrapQualifiedNameComponent(component), result2);
        }
        JSQualifiedNameImpl jSQualifiedNameImpl = result2 == null ? EMPTY : result2;
        if (jSQualifiedNameImpl == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(9);
        }
        return jSQualifiedNameImpl;
    }

    @Contract(value="null, null -> null; !null, _ -> !null; _, !null -> !null")
    @Nullable
    public static JSQualifiedName concat(@Nullable JSQualifiedName qualifier, @Nullable JSQualifiedName tail) {
        if (qualifier == null) {
            return tail;
        }
        if (tail == null) {
            return qualifier;
        }
        SmartList components = new SmartList();
        for (JSQualifiedName parent = tail; parent != null; parent = parent.getParent()) {
            components.add(parent.getName());
        }
        JSQualifiedName result2 = qualifier;
        for (int i2 = components.size() - 1; i2 >= 0; --i2) {
            result2 = JSQualifiedNameImpl.create((String)components.get(i2), result2);
        }
        return result2;
    }

    @NotNull
    public static JSQualifiedNameImpl fromNamepath(@NotNull String namepath) {
        if (namepath == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(10);
        }
        if (StringUtil.indexOfAny((String)namepath, (String)"#~") == -1) {
            JSQualifiedNameImpl cached = (JSQualifiedNameImpl)NAMESPACES.get(namepath);
            if (cached != null) {
                JSQualifiedNameImpl jSQualifiedNameImpl = cached;
                if (jSQualifiedNameImpl == null) {
                    JSQualifiedNameImpl.$$$reportNull$$$0(11);
                }
                return jSQualifiedNameImpl;
            }
            return JSQualifiedNameImpl.fromQualifiedName(namepath);
        }
        return JSQualifiedNameImpl.splitHonorQuotes(namepath, ".#~");
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        if (this.getParent() == null) {
            String string = JSStringUtil.wrapQualifiedNameComponent(this.myName);
            if (string == null) {
                JSQualifiedNameImpl.$$$reportNull$$$0(13);
            }
            return string;
        }
        StringBuilder name = JSQualifiedNameImpl.getBuilder();
        this.getQualifiedName(name);
        String string = name.toString();
        String string2 = string;
        if (string2 == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(14);
        }
        return string2;
        finally {
            JSQualifiedNameImpl.clearBuilder(name);
        }
    }

    private void getQualifiedName(StringBuilder name) {
        if (this.myParent != null) {
            this.myParent.getQualifiedName(name);
            name.append(".");
        }
        name.append(JSStringUtil.wrapQualifiedNameComponent(this.myName));
    }

    @Override
    @Nullable
    public JSQualifiedName getParent() {
        return this.myParent;
    }

    public String toString() {
        return this.getQualifiedName();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JSQualifiedNameImpl)) {
            return false;
        }
        if (this.myParent == null != (((JSQualifiedNameImpl)obj).myParent == null)) {
            return false;
        }
        return this.myName.equals(((JSQualifiedNameImpl)obj).myName) && Objects.equals(this.myParent, ((JSQualifiedNameImpl)obj).myParent);
    }

    public int hashCode() {
        int result2 = this.myParent == null ? 0 : this.myParent.hashCode();
        result2 = result2 * 31 + this.myName.hashCode();
        return result2;
    }

    @Nullable
    public static JSQualifiedNameImpl fromQualifiedNamedElement(@NotNull JSElementBase element) {
        String name;
        if (element == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(15);
        }
        if ((name = element.getName()) == null) {
            return null;
        }
        return JSQualifiedNameImpl.create(name, element.getNamespace());
    }

    @Nullable
    public static JSQualifiedName buildProvidedNamespace(@NotNull JSElementBase element) {
        JSNamespace namespace;
        if (element == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(16);
        }
        return (namespace = JSNamedTypeFactory.buildProvidedNamespace(element, true, null)) != null && !namespace.isLocal() ? namespace.getQualifiedName() : null;
    }

    public static void serialize(@Nullable JSQualifiedName qualifiedName, StubOutputStream dataStream) throws IOException {
        if (qualifiedName == null) {
            DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)0);
            return;
        }
        List<String> components = qualifiedName.toComponents();
        DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)components.size());
        for (String component : components) {
            dataStream.writeName(component);
        }
    }

    @Nullable
    public static JSQualifiedNameImpl deserialize(StubInputStream dataStream) throws IOException {
        int componentsCount = DataInputOutputUtil.readINT((DataInput)dataStream);
        assert (componentsCount >= 0) : componentsCount;
        JSQualifiedNameImpl result2 = null;
        while (componentsCount-- > 0) {
            String ref = dataStream.readNameString();
            assert (ref != null) : result2;
            result2 = JSQualifiedNameImpl.create(ref, result2);
        }
        return result2;
    }

    public static void serialize(@Nullable JSQualifiedName qualifiedName, DataOutput dataStream) throws IOException {
        if (qualifiedName == null) {
            DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)0);
            return;
        }
        List<String> components = qualifiedName.toComponents();
        DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)components.size());
        for (String component : components) {
            IOUtil.writeUTF((DataOutput)dataStream, (String)component);
        }
    }

    @Nullable
    public static JSQualifiedNameImpl deserialize(DataInput dataStream) throws IOException {
        int componentsCount = DataInputOutputUtil.readINT((DataInput)dataStream);
        assert (componentsCount >= 0) : componentsCount;
        JSQualifiedNameImpl result2 = null;
        while (componentsCount-- > 0) {
            String name = IOUtil.readUTF((DataInput)dataStream);
            result2 = JSQualifiedNameImpl.create(name, result2);
        }
        return result2;
    }

    @Nullable
    public JSQualifiedName withoutInnermostComponent(@Nullable String innermostNameToRemove) {
        SmartList components = new SmartList();
        JSQualifiedName element = this;
        for (JSQualifiedName parent = element.getParent(); parent != null; parent = parent.getParent()) {
            components.add(element.getName());
            element = parent;
        }
        if (innermostNameToRemove != null && !innermostNameToRemove.equals(element.getName())) {
            return this;
        }
        JSQualifiedNameImpl result2 = null;
        for (int i2 = components.size() - 1; i2 >= 0; --i2) {
            result2 = JSQualifiedNameImpl.create((String)components.get(i2), result2);
        }
        return result2;
    }

    @Override
    @NotNull
    public List<String> toComponents() {
        return JSQualifiedNameImpl.toComponents(this);
    }

    public boolean matches(String ... components) {
        JSQualifiedName current = this;
        for (int i2 = components.length - 1; i2 >= 0; --i2) {
            if (current == null || !components[i2].equals(current.getName())) {
                return false;
            }
            current = current.getParent();
        }
        return true;
    }

    @NotNull
    static List<String> toComponents(JSQualifiedName qName) {
        ArrayList<String> components = new ArrayList<String>();
        for (JSQualifiedName current = qName; current != null; current = current.getParent()) {
            components.add(0, current.getName());
        }
        ArrayList<String> arrayList = components;
        if (arrayList == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @NotNull
    public static String getTopmostParent(@NotNull JSQualifiedName qualifiedName) {
        if (qualifiedName == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(18);
        }
        JSQualifiedName parent = qualifiedName;
        while ((parent = (qualifiedName = parent).getParent()) != null) {
        }
        String string = qualifiedName.getName();
        if (string == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(19);
        }
        return string;
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static String toString(@Nullable JSQualifiedName name) {
        return name != null ? name.getQualifiedName() : null;
    }

    private static void clearBuilder(StringBuilder builder) {
        builder.setLength(0);
    }

    @NotNull
    private static StringBuilder getBuilder() {
        if (BUILDER.get() == null) {
            BUILDER.set(new StringBuilder());
        }
        StringBuilder stringBuilder = BUILDER.get();
        if (stringBuilder == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(20);
        }
        return stringBuilder;
    }

    @TestOnly
    public static void clearNamespaces() {
        NAMESPACES.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/JSQualifiedNameImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 5: 
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separators";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namepath";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/JSQualifiedNameImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "fromQualifiedName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "splitHonorQuotes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "fromNamepath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "toComponents";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopmostParent";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 20: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fromComponents";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fromQualifiedName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "splitHonorQuotes";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fromNamepath";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fromQualifiedNamedElement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "buildProvidedNamespace";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostParent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

