/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.ecmascript6.EnumTypeConstValue;
import com.intellij.lang.javascript.ecmascript6.InvalidEnumConstantValue;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptFieldImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.stubs.JSVariableStub;
import com.intellij.lang.javascript.psi.stubs.TypeScriptEnumFieldStub;
import com.intellij.lang.javascript.psi.types.JSBigIntLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.util.ExpressionUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.ObjectUtils;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptEnumFieldImpl
extends TypeScriptFieldImpl
implements TypeScriptEnumField {
    private static final ParameterizedCachedValueProvider<Map<TypeScriptEnumField, EnumConstantValue>, TypeScriptEnum> VALUES_PROVIDER = param -> CachedValueProvider.Result.create(TypeScriptEnumFieldImpl.calculateConstantValuesImpl(param), (Object[])new Object[]{param});
    private static final Key<ParameterizedCachedValue<Map<TypeScriptEnumField, EnumConstantValue>, TypeScriptEnum>> CACHED_VALUE_KEY = Key.create((String)"enum.fields.values");

    public TypeScriptEnumFieldImpl(ASTNode node) {
        super(node);
    }

    public TypeScriptEnumFieldImpl(JSVariableStub<JSVariable> stub, JSStubElementType<JSVariableStub<JSVariable>, JSVariable> signature) {
        super(stub, signature);
    }

    @Override
    @Nullable
    public String getConstantValueDescription() {
        return this.getConstantValue().getDescription();
    }

    @Override
    @NotNull
    public EnumConstantValue getConstantValue() {
        TypeScriptEnumFieldStub stub = (TypeScriptEnumFieldStub)this.getGreenStub();
        if (stub != null) {
            EnumConstantValue enumConstantValue = stub.getConstantValue();
            if (enumConstantValue == null) {
                TypeScriptEnumFieldImpl.$$$reportNull$$$0(0);
            }
            return enumConstantValue;
        }
        return this.computeConstantValue();
    }

    @NotNull
    private EnumConstantValue computeConstantValue() {
        TypeScriptEnum owner = this.getOwner();
        if (owner == null) {
            EnumConstantValue enumConstantValue = InvalidEnumConstantValue.INSTANCE;
            if (enumConstantValue == null) {
                TypeScriptEnumFieldImpl.$$$reportNull$$$0(1);
            }
            return enumConstantValue;
        }
        Map<TypeScriptEnumField, EnumConstantValue> valueMap = TypeScriptEnumFieldImpl.calculateConstantValues(owner);
        EnumConstantValue value = valueMap.get(this);
        EnumConstantValue enumConstantValue = value == null ? InvalidEnumConstantValue.INSTANCE : value;
        if (enumConstantValue == null) {
            TypeScriptEnumFieldImpl.$$$reportNull$$$0(2);
        }
        return enumConstantValue;
    }

    @NotNull
    public static Map<TypeScriptEnumField, EnumConstantValue> calculateConstantValues(@NotNull TypeScriptEnum enumClass) {
        if (enumClass == null) {
            TypeScriptEnumFieldImpl.$$$reportNull$$$0(3);
        }
        Map map = (Map)CachedValuesManager.getManager((Project)enumClass.getProject()).getParameterizedCachedValue((UserDataHolder)enumClass, CACHED_VALUE_KEY, VALUES_PROVIDER, false, (Object)enumClass);
        if (map == null) {
            TypeScriptEnumFieldImpl.$$$reportNull$$$0(4);
        }
        return map;
    }

    @NotNull
    private static Map<TypeScriptEnumField, EnumConstantValue> calculateConstantValuesImpl(@NotNull TypeScriptEnum enumClass) {
        if (enumClass == null) {
            TypeScriptEnumFieldImpl.$$$reportNull$$$0(5);
        }
        List fields = Arrays.stream(enumClass.getFields()).filter(el -> el instanceof TypeScriptEnumField).map(el -> (TypeScriptEnumField)el).collect(Collectors.toList());
        HashMap<TypeScriptEnumField, EnumConstantValue> result2 = new HashMap<TypeScriptEnumField, EnumConstantValue>();
        HashMap<String, EnumConstantValue> processedValues = new HashMap<String, EnumConstantValue>();
        HashMap<String, Object> processedValueObjects = new HashMap<String, Object>();
        EnumConstantValue prevValue = null;
        for (TypeScriptEnumField field : fields) {
            String fieldName = field.getName();
            if (StringUtil.isEmpty((String)fieldName)) {
                result2.put(field, InvalidEnumConstantValue.INSTANCE);
                continue;
            }
            String text = field.getLiteralOrReferenceInitializerText();
            EnumConstantValue value = InvalidEnumConstantValue.INSTANCE;
            if (text != null || !field.hasInitializer()) {
                value = TypeScriptEnumFieldImpl.getValueForField(enumClass, field, text, processedValues, prevValue);
            } else {
                JSPrimitiveType type;
                Object initializerValue = TypeScriptEnumFieldImpl.calculateValue(field, processedValueObjects);
                if (initializerValue instanceof String) {
                    type = new JSStringLiteralTypeImpl((String)initializerValue, false, JSTypeSourceFactory.createTypeSource((PsiElement)field, true));
                    value = new EnumTypeConstValue(type);
                } else if (initializerValue instanceof BigInteger) {
                    type = new JSBigIntLiteralTypeImpl((BigInteger)initializerValue, false, JSTypeSourceFactory.createTypeSource((PsiElement)field, true), null);
                    value = new EnumTypeConstValue(type);
                } else if (initializerValue instanceof Number) {
                    type = new JSNumberLiteralTypeImpl(TypeScriptEnumFieldImpl.toDouble(initializerValue), false, JSTypeSourceFactory.createTypeSource((PsiElement)field, true), null);
                    value = new EnumTypeConstValue(type);
                } else {
                    JSExpression initializer = field.getInitializer();
                    if (initializer != null) {
                        JSTypeofTypeImpl type2 = new JSTypeofTypeImpl(initializer, JSTypeSourceFactory.createTypeSource((PsiElement)field, true));
                        value = new EnumTypeConstValue(type2);
                    }
                }
            }
            result2.put(field, value);
            processedValues.put(fieldName, value);
            processedValueObjects.put(fieldName, ObjectUtils.coalesce((Object)value.getNumericValue(), (Object)value.getBigIntValue(), (Object)value.getStringValue()));
            prevValue = value;
        }
        HashMap<TypeScriptEnumField, EnumConstantValue> hashMap = result2;
        if (hashMap == null) {
            TypeScriptEnumFieldImpl.$$$reportNull$$$0(6);
        }
        return hashMap;
    }

    private static double toDouble(Object value) {
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        if (value instanceof Long) {
            return ((Long)value).longValue();
        }
        return (Double)value;
    }

    private static Object calculateValue(@NotNull TypeScriptEnumField field, Map<String, Object> processedValueObjects) {
        if (field == null) {
            TypeScriptEnumFieldImpl.$$$reportNull$$$0(7);
        }
        return ExpressionUtil.computeConstantExpression(field.getInitializer(), processedValueObjects);
    }

    @NotNull
    private static EnumConstantValue getValueForField(@NotNull TypeScriptEnum enumClass, @NotNull TypeScriptEnumField field, @Nullable String valueText, @NotNull Map<String, EnumConstantValue> allPrevValues, @Nullable EnumConstantValue prevValue) {
        if (enumClass == null) {
            TypeScriptEnumFieldImpl.$$$reportNull$$$0(8);
        }
        if (field == null) {
            TypeScriptEnumFieldImpl.$$$reportNull$$$0(9);
        }
        if (allPrevValues == null) {
            TypeScriptEnumFieldImpl.$$$reportNull$$$0(10);
        }
        if (valueText != null) {
            String enumName;
            boolean isNumber;
            boolean isString = StringUtil.isQuotedString((String)valueText);
            boolean bl = isNumber = !isString && JSStringUtil.isNumericValueStart(valueText, true);
            if (isString || isNumber) {
                JSTypeSource source2 = JSTypeSourceFactory.createTypeSource((PsiElement)field, true);
                if (isNumber) {
                    BigInteger bigInt = JSNumberParser.tryParseBigInt(valueText);
                    if (bigInt != null) {
                        EnumTypeConstValue enumTypeConstValue = EnumTypeConstValue.createForBigInt(bigInt, valueText, (PsiElement)field);
                        if (enumTypeConstValue == null) {
                            TypeScriptEnumFieldImpl.$$$reportNull$$$0(11);
                        }
                        return enumTypeConstValue;
                    }
                    Double value = JSNumberParser.tryParseNumericValue(valueText, false);
                    if (value != null) {
                        EnumTypeConstValue enumTypeConstValue = EnumTypeConstValue.createForNumber(value, valueText, (PsiElement)field);
                        if (enumTypeConstValue == null) {
                            TypeScriptEnumFieldImpl.$$$reportNull$$$0(12);
                        }
                        return enumTypeConstValue;
                    }
                }
                return new EnumTypeConstValue(new JSStringLiteralTypeImpl(StringUtil.unquoteString((String)valueText), false, source2));
            }
            EnumConstantValue otherValue = allPrevValues.get(valueText);
            if (otherValue == null && (enumName = enumClass.getName()) != null) {
                String withoutEnumName = StringUtil.trimStart((String)valueText, (String)(enumName + "."));
                otherValue = allPrevValues.get(withoutEnumName);
            }
            EnumConstantValue enumConstantValue = otherValue != null && otherValue.isValid() ? otherValue : InvalidEnumConstantValue.INSTANCE;
            if (enumConstantValue == null) {
                TypeScriptEnumFieldImpl.$$$reportNull$$$0(13);
            }
            return enumConstantValue;
        }
        if (!field.hasInitializer()) {
            if (prevValue == null) {
                EnumTypeConstValue enumTypeConstValue = EnumTypeConstValue.createForNumber(0.0, "0", (PsiElement)field);
                if (enumTypeConstValue == null) {
                    TypeScriptEnumFieldImpl.$$$reportNull$$$0(14);
                }
                return enumTypeConstValue;
            }
            EnumConstantValue enumConstantValue = prevValue.increaseNumericDelta(1);
            if (enumConstantValue == null) {
                TypeScriptEnumFieldImpl.$$$reportNull$$$0(15);
            }
            return enumConstantValue;
        }
        EnumConstantValue enumConstantValue = InvalidEnumConstantValue.INSTANCE;
        if (enumConstantValue == null) {
            TypeScriptEnumFieldImpl.$$$reportNull$$$0(16);
        }
        return enumConstantValue;
    }

    @Override
    @Nullable
    public TypeScriptEnum getOwner() {
        JSClass aClass = JSUtils.getMemberContainingClass(this);
        return aClass instanceof TypeScriptEnum ? (TypeScriptEnum)aClass : null;
    }

    @Override
    public JSType calculateDeclarationTypeStubSafe() {
        TypeScriptEnum owner = this.getOwner();
        if (owner == null) {
            return null;
        }
        String enumName = owner.getName();
        if (enumName == null) {
            return null;
        }
        return JSNamedTypeFactory.createEnumLiteralType(enumName, this, JSTypeSourceFactory.createTypeSource(this, true)).copyWithAllowWidening(true);
    }

    @Override
    public boolean isOptional() {
        return false;
    }

    @Override
    public boolean isConst() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptEnumFieldImpl";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumClass";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allPrevValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstantValue";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "computeConstantValue";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptEnumFieldImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateConstantValues";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateConstantValuesImpl";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueForField";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calculateConstantValues";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calculateConstantValuesImpl";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "calculateValue";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getValueForField";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

