/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecmal4.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageWrapper;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSStubbedStatementImpl;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSPackageStatementStub;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPackageStatementImpl
extends JSStubbedStatementImpl<JSPackageStatementStub>
implements JSPackageStatement {
    public JSPackageStatementImpl(ASTNode node) {
        super(node);
    }

    public JSPackageStatementImpl(JSPackageStatementStub stub) {
        super(stub, JSStubElementTypes.PACKAGE_STATEMENT);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSPackageStatementImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSPackageStatement(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public String getName() {
        JSPackageStatementStub stub = (JSPackageStatementStub)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        ASTNode node = this.findNameIdentifier();
        if (node != null) {
            return ((JSReferenceExpression)node.getPsi()).getReferencedName();
        }
        return "";
    }

    @Override
    public String getQualifiedName() {
        JSPackageStatementStub stub = (JSPackageStatementStub)this.getGreenStub();
        if (stub != null) {
            return stub.getQualifiedName();
        }
        ASTNode node = this.findNameIdentifier();
        if (node != null) {
            return node.getText();
        }
        return null;
    }

    @Override
    public JSSourceElement[] getStatements() {
        return (JSSourceElement[])this.getStubOrPsiChildren(JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS, JSSourceElement.ARRAY_FACTORY);
    }

    @Override
    public void setQualifiedName(String expectedPackageNameFromFile) {
        JSPackageStatementImpl.doChangeName(this.getProject(), this, expectedPackageNameFromFile);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        JSReferenceExpression expr;
        PsiElement element;
        ASTNode child;
        VirtualFile virtualFile;
        String expectedPackageNameFromFile;
        if (name == null) {
            JSPackageStatementImpl.$$$reportNull$$$0(1);
        }
        if ((expectedPackageNameFromFile = JSResolveUtil.getExpectedPackageNameFromFile(virtualFile = this.getContainingFile().getVirtualFile(), this.getProject())) != null && expectedPackageNameFromFile.equals(this.getQualifiedName())) {
            try {
                JSPsiImplUtils.doRenameParentDirectoryIfNeeded(virtualFile, name, this);
            }
            catch (IOException e) {
                throw new IncorrectOperationException((Throwable)e);
            }
        }
        if ((child = this.findNameIdentifier()) != null && (element = (expr = (JSReferenceExpression)child.getPsi()).getReferenceNameElement()) != null) {
            JSChangeUtil.doIdentifierReplacement((PsiElement)expr, element, name);
        }
        return this;
    }

    @Override
    public ASTNode findNameIdentifier() {
        return this.getNode().findChildByType(JSElementTypes.REFERENCE_EXPRESSION);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState substitutor, PsiElement lastParent, @NotNull PsiElement place) {
        boolean b;
        ResolveProcessor.ProcessingOptions packageProcessingOptions;
        if (processor == null) {
            JSPackageStatementImpl.$$$reportNull$$$0(2);
        }
        if (substitutor == null) {
            JSPackageStatementImpl.$$$reportNull$$$0(3);
        }
        if (place == null) {
            JSPackageStatementImpl.$$$reportNull$$$0(4);
        }
        if ((packageProcessingOptions = processor instanceof ResolveProcessor ? ((ResolveProcessor)processor).getProcessingOptions() : ResolveProcessor.DEFAULT_RESOLVE).toProcessPackageContent(lastParent, this) && !(b = JSResolveUtil.processDeclarationsInScope(this, processor, ResolveState.initial(), lastParent, place))) {
            return false;
        }
        if (packageProcessingOptions.toProcessPackageImports(lastParent, this)) {
            processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
            return JSImportHandlingUtil.tryResolveImports(processor, this, place);
        }
        return true;
    }

    public PsiElement getNameIdentifier() {
        ASTNode node = this.findNameIdentifier();
        return node != null ? node.getPsi() : null;
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            JSPackageStatementImpl.$$$reportNull$$$0(5);
        }
        if (JSChangeUtil.isSourceElementOrComment(element)) {
            PsiElement insertedElement = JSChangeUtil.doAddBefore(this, element, anchor);
            CodeStyleManager.getInstance((Project)this.getProject()).reformatNewlyAddedElement(this.getNode(), insertedElement.getNode());
            return insertedElement;
        }
        return super.addBefore(element, anchor);
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            JSPackageStatementImpl.$$$reportNull$$$0(6);
        }
        if (JSChangeUtil.isSourceElementOrComment(element)) {
            PsiElement insertedElement = JSChangeUtil.doAddAfter(this, element, anchor);
            CodeStyleManager.getInstance((Project)this.getProject()).reformatNewlyAddedElement(this.getNode(), insertedElement.getNode());
            return insertedElement;
        }
        return super.addAfter(element, anchor);
    }

    public static void doChangeName(Project project, JSPackageStatement packageStatement, String expected) {
        if (expected == null) {
            return;
        }
        ASTNode node = packageStatement.findNameIdentifier();
        ASTNode parent = packageStatement.getNode();
        if (expected.length() == 0) {
            if (node != null) {
                ASTNode treeNext = node.getTreeNext();
                parent.removeChild(node);
                if (treeNext.getPsi() instanceof PsiWhiteSpace) {
                    parent.removeChild(treeNext);
                }
            }
        } else {
            ASTNode newNode = JSChangeUtil.createExpressionFromText(project, expected);
            if (node != null) {
                parent.replaceChild(node, newNode);
            } else {
                ASTNode packageNode = parent.findChildByType(JSTokenTypes.PACKAGE_KEYWORD);
                parent.addChild(newNode, packageNode.getTreeNext());
                parent.addChild(JSChangeUtil.createJSTreeFromText(project, " "), packageNode.getTreeNext());
            }
        }
    }

    public boolean isEquivalentTo(PsiElement another) {
        return JSPackageWrapper.isPackageReferenceOfSomeForm(this.getQualifiedName(), this.getProject(), this.getResolveScope(), another);
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        PsiElement parent;
        if (child == null) {
            JSPackageStatementImpl.$$$reportNull$$$0(7);
        }
        JSSourceElement[] statements = this.getStatements();
        boolean onlyImportStatementsLeftInPackage = true;
        for (JSSourceElement statement : statements) {
            if (statement instanceof JSImportStatement || statement.getNode() == child) continue;
            onlyImportStatementsLeftInPackage = false;
            break;
        }
        if (onlyImportStatementsLeftInPackage && (parent = this.getParent()) instanceof JSFile) {
            parent.delete();
            return;
        }
        super.deleteChildInternal(child);
    }

    @Override
    @Nullable
    public JSQualifiedName getNamespace() {
        return JSPsiImplUtils.buildNamespaceFromQualifiedName(this);
    }

    @Override
    public boolean isNamespaceExplicitlyDeclared() {
        return true;
    }

    @Override
    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PACKAGE_LOCAL;
        if (accessType == null) {
            JSPackageStatementImpl.$$$reportNull$$$0(8);
        }
        return accessType;
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    @NotNull
    public JSContext getJSContext() {
        JSContext jSContext = JSContext.UNKNOWN;
        if (jSContext == null) {
            JSPackageStatementImpl.$$$reportNull$$$0(9);
        }
        return jSContext;
    }

    @Override
    @NotNull
    public JSNamespace getJSNamespace() {
        JSNamespace jSNamespace = JSNamedTypeFactory.buildJSNamespace(this);
        if (jSNamespace == null) {
            JSPackageStatementImpl.$$$reportNull$$$0(10);
        }
        return jSNamespace;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/ecmal4/impl/JSPackageStatementImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/ecmal4/impl/JSPackageStatementImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSContext";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSNamespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

