/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.psi.impl.JSReferenceSetElement;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSReferenceSet {
    protected String myReferenceText;
    protected int myOffset;
    protected PsiReference[] myReferences;
    @NotNull
    private final PsiElement myElement;
    private final boolean isSoft;
    @Nullable
    LocalQuickFixProvider myLocalQuickFixProvider;

    public JSReferenceSet(@NotNull PsiElement element) {
        if (element == null) {
            JSReferenceSet.$$$reportNull$$$0(0);
        }
        this(element, true);
    }

    public JSReferenceSet(@NotNull PsiElement element, boolean soft) {
        if (element == null) {
            JSReferenceSet.$$$reportNull$$$0(1);
        }
        this(element, null, 0, soft);
    }

    public JSReferenceSet(@NotNull PsiElement element, @Nullable String text, int offset, boolean soft) {
        if (element == null) {
            JSReferenceSet.$$$reportNull$$$0(2);
        }
        this.myElement = element;
        this.isSoft = soft;
        this.myReferenceText = text;
        this.myOffset = offset;
        this.myReferences = text != null ? this.reparse(text, offset) : null;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            JSReferenceSet.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    public PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = this.myReferences == null ? PsiReference.EMPTY_ARRAY : this.myReferences;
        if (psiReferenceArray == null) {
            JSReferenceSet.$$$reportNull$$$0(4);
        }
        return psiReferenceArray;
    }

    public synchronized void update(String text, int offset) {
        if (this.myReferences != null && this.myReferenceText != null && this.myReferenceText.equals(text) && this.myOffset == offset) {
            return;
        }
        this.myReferenceText = text;
        this.myOffset = offset;
        boolean isTemplate = JSReferenceSet.isWellFormedTemplateLiteral(text);
        this.myReferences = JSStringUtil.isStartedWithQuote(text) || isTemplate ? this.reparse(JSReferenceSet.unquoteText(text, isTemplate), offset + 1) : PsiReference.EMPTY_ARRAY;
    }

    @NotNull
    private static String unquoteText(String text, boolean isTemplate) {
        if (isTemplate) {
            String string = JSStringUtil.unescapeStringLiteralValue(text.substring(1, text.length() - 1));
            if (string == null) {
                JSReferenceSet.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = JSStringUtil.unquoteAndUnescapeStringLiteralValue(text);
        if (string == null) {
            JSReferenceSet.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static boolean isWellFormedTemplateLiteral(String text) {
        return text.length() > 2 && text.charAt(0) == '`' && text.charAt(text.length() - 1) == '`';
    }

    protected PsiReference @NotNull [] reparse(@NotNull String value, int offset) {
        if (value == null) {
            JSReferenceSet.$$$reportNull$$$0(7);
        }
        ArrayList<JSReferenceSetElement> refs = new ArrayList<JSReferenceSetElement>(1);
        int lastPos = 0;
        int dotPos = this.findSeparatorPosition(value, lastPos);
        while (dotPos != -1) {
            String s = value.substring(lastPos, dotPos).trim();
            if (s.length() > 0) {
                refs.add(this.createTextReference(s, offset + lastPos));
            }
            lastPos = dotPos + 1;
            dotPos = this.findSeparatorPosition(value, lastPos);
        }
        int end = value.length();
        String substring = value.substring(lastPos, end);
        String s = substring.trim();
        if (s.length() > 0) {
            int index;
            for (index = 0; index < substring.length() && Character.isWhitespace(substring.charAt(index)); ++index) {
            }
            refs.add(this.createTextReference(s, offset + lastPos + index));
        }
        PsiReference[] psiReferenceArray = refs.size() > 0 ? refs.toArray(PsiReference.EMPTY_ARRAY) : PsiReference.EMPTY_ARRAY;
        if (psiReferenceArray == null) {
            JSReferenceSet.$$$reportNull$$$0(8);
        }
        return psiReferenceArray;
    }

    protected JSReferenceSetElement createTextReference(String s, int offset) {
        return new JSTextReference(this, s, offset);
    }

    protected int findSeparatorPosition(String s, int fromIndex) {
        if (StringUtil.isQuotedString((String)s)) {
            return -1;
        }
        return s.indexOf(46, fromIndex);
    }

    public boolean isSoft() {
        return this.isSoft;
    }

    public void setLocalQuickFixProvider(@Nullable LocalQuickFixProvider localQuickFixProvider) {
        this.myLocalQuickFixProvider = localQuickFixProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSReferenceSet";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSReferenceSet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "unquoteText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "reparse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reparse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

