/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.flex.JSResolveHelper;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationLogger;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSGlobalSymbolIndex;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSLocalNamespaceMembersIndex;
import com.intellij.lang.javascript.psi.stubs.JSNamespaceMembersIndex;
import com.intellij.lang.javascript.psi.stubs.JSQualifiedElementIndex;
import com.intellij.lang.javascript.psi.stubs.JSSymbolIndex2;
import com.intellij.lang.javascript.psi.stubs.JSSymbolQualifiedNamesIndex;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubIndexingUtils;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ComparatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSClassResolver {
    private static JSClassResolver INSTANCE = null;
    private static final Logger LOG = Logger.getInstance(JSClassResolver.class);

    protected JSClassResolver() {
    }

    public static JSClassResolver getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JSClassResolver();
        }
        return INSTANCE;
    }

    public static PsiElement findClassFromNamespace(@NotNull String qname, @NotNull PsiElement context) {
        if (qname == null) {
            JSClassResolver.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JSClassResolver.$$$reportNull$$$0(1);
        }
        return JSClassResolver.findClassFromNamespace(qname, context, JSResolveUtil.getResolveScope(context));
    }

    public static PsiElement findClassFromNamespace(@NotNull String qname, @NotNull PsiElement context, @NotNull GlobalSearchScope scope) {
        JSNamedElement localElement;
        DialectOptionHolder dialect;
        if (qname == null) {
            JSClassResolver.$$$reportNull$$$0(2);
        }
        if (context == null) {
            JSClassResolver.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(4);
        }
        if ((dialect = DialectDetector.dialectOfElement(context)) != null && (dialect.isJavaScript() || dialect.isTypeScript)) {
            return null;
        }
        VirtualFile vFile = context.getContainingFile().getVirtualFile();
        if (!"Object".equals(qname) && (vFile == null || scope.contains(vFile)) && (localElement = JSResolveUtil.findFileLocalElement(qname, context)) != null) {
            return localElement;
        }
        return JSDialectSpecificHandlersFactory.forElement(context).getClassResolver().findClassByQName(qname, scope);
    }

    public static long getResolveResultTimestamp(PsiElement candidate) {
        for (JSResolveHelper helper : JSResolveHelper.EP_NAME.getExtensionList()) {
            long result2 = helper.getResolveResultTimestamp(candidate);
            if (result2 == -1L) continue;
            return result2;
        }
        return -1L;
    }

    public PsiElement findClassByQName(@NotNull String link, @NotNull PsiElement context) {
        if (link == null) {
            JSClassResolver.$$$reportNull$$$0(5);
        }
        if (context == null) {
            JSClassResolver.$$$reportNull$$$0(6);
        }
        return this.doFindClassByQName(link, JSResolveUtil.getResolveScope(context), false);
    }

    @Nullable
    public PsiElement findClassByQName(@NotNull String link, @NotNull GlobalSearchScope scope) {
        if (link == null) {
            JSClassResolver.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(8);
        }
        return TypeScriptClassResolver.getInstance().findAnyClassByQName(link, scope);
    }

    protected PsiElement doFindClassByQName(@NotNull String link, GlobalSearchScope searchScope, boolean allowFileLocalSymbols) {
        if (link == null) {
            JSClassResolver.$$$reportNull$$$0(9);
        }
        Project project = searchScope.getProject();
        if (LOG.isTraceEnabled()) {
            LOG.trace("doFindClassByQName: " + link);
        }
        Collection candidates = StubIndex.getElements(JSQualifiedElementIndex.KEY, (Object)link.hashCode(), (Project)project, (GlobalSearchScope)searchScope, JSQualifiedNamedElement.class);
        for (JSQualifiedNamedElement clazz : candidates) {
            PsiFile file2;
            if (!link.equals(clazz.getQualifiedName()) || (file2 = clazz.getContainingFile()).getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4)) continue;
            return clazz;
        }
        return null;
    }

    @NotNull
    public List<JSClass> findClassesByQName(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        Project project;
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(11);
        }
        if ((project = scope.getProject()) == null) {
            if (scope != GlobalSearchScope.EMPTY_SCOPE) {
                Logger.getInstance(JSClassResolver.class).error("Incorrect scope: " + scope);
            }
            List<JSClass> list2 = Collections.emptyList();
            if (list2 == null) {
                JSClassResolver.$$$reportNull$$$0(12);
            }
            return list2;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("findClassesByQName: " + qName);
        }
        Collection candidates = StubIndex.getElements(JSQualifiedElementIndex.KEY, (Object)qName.hashCode(), (Project)project, (GlobalSearchScope)scope, JSQualifiedNamedElement.class);
        SmartList classes = new SmartList();
        for (Object _clazz : candidates) {
            JSClass clazz;
            if (!(_clazz instanceof JSClass) || !qName.equals((clazz = (JSClass)_clazz).getQualifiedName())) continue;
            classes.add((Object)clazz);
        }
        SmartList smartList = classes;
        if (smartList == null) {
            JSClassResolver.$$$reportNull$$$0(13);
        }
        return smartList;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public Collection<JSQualifiedNamedElement> findElementsByQName(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        Project project;
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(14);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(15);
        }
        return (project = scope.getProject()) != null ? this.findElementsByQName(qName, scope, project) : Collections.emptyList();
    }

    @NotNull
    public Collection<JSQualifiedNamedElement> findElementsByQName(@NotNull String qName, @NotNull GlobalSearchScope scope, @NotNull Project project) {
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(16);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(17);
        }
        if (project == null) {
            JSClassResolver.$$$reportNull$$$0(18);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("findElementsByQName: " + qName);
        }
        SmartList result2 = new SmartList();
        Processor processor = Processors.cancelableCollectProcessor((Collection)result2);
        scope = this.adjustScopeForQualifiedNameSearch(scope);
        StubIndex.getInstance().processElements(JSQualifiedElementIndex.KEY, (Object)qName.hashCode(), project, scope, JSQualifiedNamedElement.class, processor);
        Collections.sort(result2, JSResolveUtil.FILE_PATH_COMPARATOR);
        SmartList smartList = result2;
        if (smartList == null) {
            JSClassResolver.$$$reportNull$$$0(19);
        }
        return smartList;
    }

    @NotNull
    protected GlobalSearchScope adjustScopeForQualifiedNameSearch(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(20);
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            JSClassResolver.$$$reportNull$$$0(21);
        }
        return globalSearchScope;
    }

    @NotNull
    public Collection<JSPsiElementBase> findNamespaceMembers(@NotNull String namespace, @NotNull GlobalSearchScope scope) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(22);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(23);
        }
        Collection<JSPsiElementBase> collection = this.findNamespaceMembers(namespace, scope, null);
        if (collection == null) {
            JSClassResolver.$$$reportNull$$$0(24);
        }
        return collection;
    }

    public boolean processNamespaceMembers(@NotNull String namespace, @NotNull GlobalSearchScope scope, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(25);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(26);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(27);
        }
        return this.processNamespaceMembers(namespace, scope, (GlobalSearchScope)null, processor);
    }

    @NotNull
    public Collection<JSPsiElementBase> findNamespaceMembersIncludingLocal(@NotNull String namespace, @NotNull GlobalSearchScope scope) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(28);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(29);
        }
        SmartList result2 = new SmartList();
        Processor processor = Processors.cancelableCollectProcessor((Collection)result2);
        this.processNamespaceMembers(namespace, scope, scope, (Processor<? super JSPsiElementBase>)processor);
        SmartList smartList = result2;
        if (smartList == null) {
            JSClassResolver.$$$reportNull$$$0(30);
        }
        return smartList;
    }

    @NotNull
    public Collection<JSPsiElementBase> findNamespaceMembers(@NotNull String namespace, @NotNull GlobalSearchScope scope, @Nullable GlobalSearchScope scopeToIncludeLocal) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(31);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(32);
        }
        SmartList result2 = new SmartList();
        Processor processor = Processors.cancelableCollectProcessor((Collection)result2);
        this.processNamespaceMembers(namespace, scope, scopeToIncludeLocal, (Processor<? super JSPsiElementBase>)processor);
        SmartList smartList = result2;
        if (smartList == null) {
            JSClassResolver.$$$reportNull$$$0(33);
        }
        return smartList;
    }

    public boolean processNamespaceMembers(@NotNull String namespace, @NotNull PsiFile scope, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(34);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(35);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(36);
        }
        GlobalSearchScope fileScope = GlobalSearchScope.fileScope((PsiFile)scope);
        return this.processNamespaceMembers(namespace, fileScope, fileScope, processor);
    }

    public boolean processNamespaceMembers(@NotNull String namespace, @NotNull GlobalSearchScope scope, @Nullable PsiFile fileToIncludeLocal, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(37);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(38);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(39);
        }
        GlobalSearchScope localNsScope = fileToIncludeLocal != null ? GlobalSearchScope.fileScope((PsiFile)fileToIncludeLocal) : null;
        return this.processNamespaceMembers(namespace, scope, localNsScope, processor);
    }

    private boolean processNamespaceMembers(@NotNull String namespace, @NotNull GlobalSearchScope globalNsScope, @Nullable GlobalSearchScope localNsScope, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(40);
        }
        if (globalNsScope == null) {
            JSClassResolver.$$$reportNull$$$0(41);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(42);
        }
        JSQualifiedNameImpl namespaceQName = "".equals(namespace) ? null : JSQualifiedNameImpl.fromQualifiedName(namespace);
        Project project = globalNsScope.getProject();
        if (project == null) {
            return true;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("processNamespaceMembers: " + namespace);
        }
        Processor<JSElement> namespaceMembersProcessor = JSClassResolver.getNamespaceMembersProcessor(processor, namespaceQName);
        if (localNsScope != null && !StubIndex.getInstance().processElements(JSLocalNamespaceMembersIndex.KEY, (Object)namespace, project, localNsScope, JSElement.class, namespaceMembersProcessor)) {
            return false;
        }
        return StubIndex.getInstance().processElements(JSNamespaceMembersIndex.KEY, (Object)namespace, project, globalNsScope, JSElement.class, namespaceMembersProcessor);
    }

    @NotNull
    private static Processor<JSElement> getNamespaceMembersProcessor(@NotNull Processor<? super JSPsiElementBase> processor, JSQualifiedNameImpl namespaceQName) {
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(43);
        }
        Processor processor2 = element -> {
            Collection<JSImplicitElement> implicitElements;
            JSElementIndexingData data;
            boolean emptyImplicitElements = true;
            if (element instanceof JSImplicitElementProvider && (data = ((JSImplicitElementProvider)element).getIndexingData()) != null && (implicitElements = data.getImplicitElements()) != null) {
                emptyImplicitElements = false;
                for (JSImplicitElement implicitElement : implicitElements) {
                    if (!ComparatorUtil.equalsNullable((Object)namespaceQName, (Object)implicitElement.getNamespace()) || processor.process((Object)implicitElement)) continue;
                    return false;
                }
            }
            return !(element instanceof JSPsiElementBase) || !emptyImplicitElements && !ComparatorUtil.equalsNullable((Object)namespaceQName, (Object)((JSPsiElementBase)element).getNamespace()) || processor.process((Object)((JSPsiElementBase)element));
        };
        if (processor2 == null) {
            JSClassResolver.$$$reportNull$$$0(44);
        }
        return processor2;
    }

    @NotNull
    public Collection<JSPsiElementBase> findElementsByQNameIncludingImplicit(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(45);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(46);
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.processElementsByQNameIncludingImplicit(qName, scope, (Processor<? super JSPsiElementBase>)processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            JSClassResolver.$$$reportNull$$$0(47);
        }
        return collection;
    }

    @NotNull
    public List<JSPsiElementBase> findElementsByQNameIncludingImplicit(@NotNull String qName, @NotNull PsiFile scope) {
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(48);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(49);
        }
        ArrayList<JSPsiElementBase> result2 = new ArrayList<JSPsiElementBase>();
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor(result2);
        this.processElementsByQNameIncludingImplicit(qName, GlobalSearchScope.fileScope((PsiFile)scope), IncludeLocalMembersOptions.ALL, (Processor<? super JSPsiElementBase>)processor);
        ArrayList<JSPsiElementBase> arrayList = result2;
        if (arrayList == null) {
            JSClassResolver.$$$reportNull$$$0(50);
        }
        return arrayList;
    }

    public void processElementsByQNameIncludingImplicit(@NotNull String qName, @NotNull GlobalSearchScope scope, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(51);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(52);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(53);
        }
        this.processElementsByQNameIncludingImplicit(qName, scope, IncludeLocalMembersOptions.NONE, processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processElementsByQNameIncludingImplicit(@NotNull String qName, @NotNull GlobalSearchScope scope, @NotNull IncludeLocalMembersOptions includeLocalMembers, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(54);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(55);
        }
        if (includeLocalMembers == null) {
            JSClassResolver.$$$reportNull$$$0(56);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(57);
        }
        Project project = scope.getProject();
        assert (project != null);
        JSEvaluationLogger.getInstance().startTask(() -> "processElementsByQNameIncludingImplicit: " + qName);
        try {
            GlobalSearchScope scopeForSymbolQualifiedNamesIndex;
            Processor<JSElement> processorForQNameIncludingImplicit = JSClassResolver.getProcessorForQNameIncludingImplicit(qName, includeLocalMembers, processor);
            GlobalSearchScope scopeForGlobalSymbolIndex = includeLocalMembers.getScopeForGlobalSymbolIndex(qName, scope);
            if (scopeForGlobalSymbolIndex != null) {
                StubIndex.getInstance().processElements(JSGlobalSymbolIndex.KEY, (Object)qName, project, scopeForGlobalSymbolIndex, JSElement.class, processorForQNameIncludingImplicit);
            }
            if ((scopeForSymbolQualifiedNamesIndex = includeLocalMembers.getScopeForSymbolQualifiedNamesIndex(qName, scope)) != null) {
                StubIndex.getInstance().processElements(JSSymbolQualifiedNamesIndex.KEY, (Object)qName.hashCode(), project, scopeForSymbolQualifiedNamesIndex, JSElement.class, processorForQNameIncludingImplicit);
            }
        }
        finally {
            JSEvaluationLogger.getInstance().finishTask(null);
        }
    }

    @NotNull
    private static Processor<JSElement> getProcessorForQNameIncludingImplicit(@NotNull String qName, @NotNull IncludeLocalMembersOptions includeLocalMembers, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(58);
        }
        if (includeLocalMembers == null) {
            JSClassResolver.$$$reportNull$$$0(59);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(60);
        }
        Processor processor2 = element -> {
            if (element instanceof JSPsiElementBase) {
                String ns;
                PsiFile file2 = element.getContainingFile();
                Object processedElementQName = includeLocalMembers.myIncludeLocalAll || file2 != null && file2.equals(includeLocalMembers.myIncludeLocalInFile) ? ((ns = JSStubIndexingUtils.getNamespaceForIndexing(((JSPsiElementBase)element).getJSNamespace())) != null ? ns + "." + element.getName() : element.getName()) : ((JSPsiElementBase)element).getQualifiedName();
                if (qName.equals(processedElementQName) && !processor.process((Object)((JSPsiElementBase)element))) {
                    return false;
                }
            }
            if (element instanceof JSImplicitElementProvider) {
                JSElementIndexingData indexingData = ((JSImplicitElementProvider)element).getIndexingData();
                List<JSImplicitElement> elements = indexingData != null ? indexingData.findElementsByQualifiedName(qName) : Collections.emptyList();
                for (JSImplicitElement implicitElement : elements) {
                    if (processor.process((Object)implicitElement)) continue;
                    return false;
                }
            }
            return true;
        };
        if (processor2 == null) {
            JSClassResolver.$$$reportNull$$$0(61);
        }
        return processor2;
    }

    @NotNull
    public Collection<JSPsiElementBase> findElementsByNameIncludingImplicit(@NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            JSClassResolver.$$$reportNull$$$0(62);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(63);
        }
        return JSClassResolver.findElementsByNameIncludingImplicit(name, scope, false);
    }

    @NotNull
    public static Collection<JSPsiElementBase> findElementsByNameIncludingImplicit(@NotNull String name, @NotNull GlobalSearchScope scope, boolean justClasses) {
        if (name == null) {
            JSClassResolver.$$$reportNull$$$0(64);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(65);
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        JSClassResolver.processElementsByNameIncludingImplicit(name, scope, justClasses, (Processor<? super JSPsiElementBase>)processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            JSClassResolver.$$$reportNull$$$0(66);
        }
        return collection;
    }

    public static boolean processElementsByNameIncludingImplicit(@NotNull String name, @NotNull GlobalSearchScope scope, boolean justClasses, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (name == null) {
            JSClassResolver.$$$reportNull$$$0(67);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(68);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(69);
        }
        return JSClassResolver.processElementsByNameIncludingImplicit(name, scope, justClasses, JSSymbolIndex2.KEY, processor);
    }

    public static boolean processElementsByNameIncludingImplicit(@NotNull String name, @NotNull GlobalSearchScope scope, boolean justClasses, @NotNull StubIndexKey<String, JSElement> indexKey, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (name == null) {
            JSClassResolver.$$$reportNull$$$0(70);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(71);
        }
        if (indexKey == null) {
            JSClassResolver.$$$reportNull$$$0(72);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(73);
        }
        Project project = scope.getProject();
        assert (project != null);
        if (LOG.isTraceEnabled()) {
            LOG.trace("processElementsByNameIncludingImplicit: " + name);
        }
        return StubIndex.getInstance().processElements(indexKey, (Object)name, project, scope, JSElement.class, element -> {
            ProgressManager.checkCanceled();
            if (justClasses && !(element instanceof JSClass)) {
                return true;
            }
            return !(element instanceof JSPsiElementBase && name.equals(element.getName()) ? !processor.process((Object)((JSPsiElementBase)element)) : element instanceof JSImplicitElementProvider && !JSClassResolver.processImplicitElements(name, (Processor<? super JSImplicitElement>)processor, (JSImplicitElementProvider)element));
        });
    }

    public static boolean processImplicitElements(@NotNull String name, @NotNull Processor<? super JSImplicitElement> processor, @NotNull JSImplicitElementProvider element) {
        JSElementIndexingData data;
        Collection<JSImplicitElement> implicitElements;
        if (name == null) {
            JSClassResolver.$$$reportNull$$$0(74);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(75);
        }
        if (element == null) {
            JSClassResolver.$$$reportNull$$$0(76);
        }
        Collection<JSImplicitElement> collection = implicitElements = (data = element.getIndexingData()) != null ? data.getImplicitElements() : null;
        if (implicitElements != null) {
            for (JSImplicitElement implicitElement : implicitElements) {
                if (!name.equals(implicitElement.getName()) || processor.process((Object)implicitElement)) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 19: 
            case 21: 
            case 24: 
            case 30: 
            case 33: 
            case 44: 
            case 47: 
            case 50: 
            case 61: 
            case 66: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 19: 
            case 21: 
            case 24: 
            case 30: 
            case 33: 
            case 44: 
            case 47: 
            case 50: 
            case 61: 
            case 66: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qname";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 15: 
            case 17: 
            case 20: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 35: 
            case 38: 
            case 46: 
            case 49: 
            case 52: 
            case 55: 
            case 63: 
            case 65: 
            case 68: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 10: 
            case 14: 
            case 16: 
            case 45: 
            case 48: 
            case 51: 
            case 54: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 12: 
            case 13: 
            case 19: 
            case 21: 
            case 24: 
            case 30: 
            case 33: 
            case 44: 
            case 47: 
            case 50: 
            case 61: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSClassResolver";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 22: 
            case 25: 
            case 28: 
            case 31: 
            case 34: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 27: 
            case 36: 
            case 39: 
            case 42: 
            case 43: 
            case 53: 
            case 57: 
            case 60: 
            case 69: 
            case 73: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalNsScope";
                break;
            }
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeLocalMembers";
                break;
            }
            case 62: 
            case 64: 
            case 67: 
            case 70: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexKey";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSClassResolver";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesByQName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsByQName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustScopeForQualifiedNameSearch";
                break;
            }
            case 24: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "findNamespaceMembers";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "findNamespaceMembersIncludingLocal";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceMembersProcessor";
                break;
            }
            case 47: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsByQNameIncludingImplicit";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessorForQNameIncludingImplicit";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsByNameIncludingImplicit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findClassFromNamespace";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findClassByQName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doFindClassByQName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findClassesByQName";
                break;
            }
            case 12: 
            case 13: 
            case 19: 
            case 21: 
            case 24: 
            case 30: 
            case 33: 
            case 44: 
            case 47: 
            case 50: 
            case 61: 
            case 66: {
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findElementsByQName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "adjustScopeForQualifiedNameSearch";
                break;
            }
            case 22: 
            case 23: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findNamespaceMembers";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "processNamespaceMembers";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findNamespaceMembersIncludingLocal";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceMembersProcessor";
                break;
            }
            case 45: 
            case 46: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "findElementsByQNameIncludingImplicit";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "processElementsByQNameIncludingImplicit";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getProcessorForQNameIncludingImplicit";
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "findElementsByNameIncludingImplicit";
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "processElementsByNameIncludingImplicit";
                break;
            }
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "processImplicitElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 19: 
            case 21: 
            case 24: 
            case 30: 
            case 33: 
            case 44: 
            case 47: 
            case 50: 
            case 61: 
            case 66: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class IncludeLocalMembersOptions {
        public static final IncludeLocalMembersOptions ALL = new IncludeLocalMembersOptions(true, null);
        public static final IncludeLocalMembersOptions NONE = new IncludeLocalMembersOptions(false, null);
        private final boolean myIncludeLocalAll;
        @Nullable
        private final PsiFile myIncludeLocalInFile;

        private IncludeLocalMembersOptions(boolean includeLocalAll, @Nullable PsiFile includeLocalInFile) {
            this.myIncludeLocalAll = includeLocalAll;
            this.myIncludeLocalInFile = includeLocalInFile;
        }

        @NotNull
        public static IncludeLocalMembersOptions inFile(@Nullable PsiFile includeInFile) {
            IncludeLocalMembersOptions includeLocalMembersOptions = includeInFile != null ? new IncludeLocalMembersOptions(false, includeInFile) : NONE;
            if (includeLocalMembersOptions == null) {
                IncludeLocalMembersOptions.$$$reportNull$$$0(0);
            }
            return includeLocalMembersOptions;
        }

        @Nullable
        public GlobalSearchScope getScopeForGlobalSymbolIndex(@NotNull String qName, @NotNull GlobalSearchScope scope) {
            if (qName == null) {
                IncludeLocalMembersOptions.$$$reportNull$$$0(1);
            }
            if (scope == null) {
                IncludeLocalMembersOptions.$$$reportNull$$$0(2);
            }
            if (qName.contains(".")) {
                return null;
            }
            if (this.myIncludeLocalAll) {
                return null;
            }
            if (this.myIncludeLocalInFile != null) {
                return scope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)GlobalSearchScope.fileScope((PsiFile)this.myIncludeLocalInFile)));
            }
            return scope;
        }

        @Nullable
        public GlobalSearchScope getScopeForSymbolQualifiedNamesIndex(@NotNull String qName, @NotNull GlobalSearchScope scope) {
            if (qName == null) {
                IncludeLocalMembersOptions.$$$reportNull$$$0(3);
            }
            if (scope == null) {
                IncludeLocalMembersOptions.$$$reportNull$$$0(4);
            }
            if (qName.contains(".")) {
                return scope;
            }
            if (this.myIncludeLocalAll) {
                return scope;
            }
            if (this.myIncludeLocalInFile != null) {
                return GlobalSearchScope.fileScope((PsiFile)this.myIncludeLocalInFile).intersectWith(scope);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSClassResolver$IncludeLocalMembersOptions";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qName";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "inFile";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSClassResolver$IncludeLocalMembersOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getScopeForGlobalSymbolIndex";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getScopeForSymbolQualifiedNamesIndex";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

