/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.json.psi.JsonElement;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.ecmascript6.resolve.JSModuleElementsProcessor;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptModuleDeclarationsProcessor;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGlobalModuleExportDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorBase;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.processors.JSModuleElementsResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElementWithBackingItem;
import com.intellij.lang.javascript.psi.types.evaluable.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSQualifiedNameResolver {
    @NotNull
    protected final PsiElement myContext;
    protected final boolean myAcceptableObjectScope;

    public JSQualifiedNameResolver(@NotNull PsiElement context, boolean acceptObjectScopes) {
        if (context == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(0);
        }
        this.myContext = context;
        this.myAcceptableObjectScope = acceptObjectScopes;
    }

    @NotNull
    protected abstract JSQualifiedNameResolver createNestedResolver(@NotNull PsiElement var1);

    @NotNull
    public final Collection<PsiElement> resolveQualifiedName(@NotNull String qName) {
        JSQualifiedNameImpl name;
        List<String> components;
        if (qName == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(1);
        }
        if ((components = (name = JSQualifiedNameImpl.fromQualifiedName(qName)).toComponents()).isEmpty()) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(2);
            }
            return list2;
        }
        String topLevelName = (String)ContainerUtil.getFirstItem(components);
        if (topLevelName == null) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(3);
            }
            return list3;
        }
        boolean isUnqualifiedName = components.size() == 1;
        Collection<PsiElement> topLevelElements = this.getExpandedTopLevelElements(topLevelName, !isUnqualifiedName);
        if (isUnqualifiedName) {
            Collection<PsiElement> collection = this.postProcessResults(topLevelElements);
            if (collection == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(4);
            }
            return collection;
        }
        Collection<PsiElement> lastElements = topLevelElements;
        List<String> localReferences = components.subList(1, components.size());
        for (int i2 = 0; i2 < localReferences.size(); ++i2) {
            ProgressManager.checkCanceled();
            Object currentName = localReferences.get(i2);
            boolean isQualifier = localReferences.size() - 1 != i2;
            Collection<PsiElement> prevLastElements = lastElements;
            lastElements = this.getExpandedLocalElements((String)currentName, lastElements);
            if (!lastElements.isEmpty()) continue;
            while (lastElements.isEmpty() && isQualifier) {
                currentName = (String)currentName + "." + localReferences.get(i2 + 1);
                lastElements = this.getExpandedLocalElements((String)currentName, prevLastElements);
                isQualifier = localReferences.size() - 1 != ++i2;
            }
            if (!lastElements.isEmpty()) continue;
            List list4 = ContainerUtil.emptyList();
            if (list4 == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(5);
            }
            return list4;
        }
        Collection<PsiElement> collection = this.postProcessResults(lastElements);
        if (collection == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    public Collection<PsiElement> postProcessResults(@NotNull Collection<PsiElement> elements) {
        if (elements == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(7);
        }
        Collection<PsiElement> collection = elements;
        if (collection == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @NotNull
    public final Collection<PsiElement> getTopLevelElements(@NotNull String name, boolean isContainer) {
        if (name == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(9);
        }
        if (name.startsWith("import(")) {
            return this.getTopLevelForImportType(name);
        }
        if (name.startsWith("module:")) {
            Collection<PsiElement> collection = this.getTopLevelForModulePrefix(name);
            if (collection == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(10);
            }
            return collection;
        }
        Collection<PsiElement> collection = this.getTopLevelElementsWalkUp(name, isContainer);
        if (collection == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(11);
        }
        return collection;
    }

    @NotNull
    protected abstract Collection<PsiElement> getTopLevelForModulePrefix(@NotNull String var1);

    @NotNull
    protected abstract Collection<PsiElement> getTopLevelElementsWalkUp(@NotNull String var1, boolean var2);

    @NotNull
    private Collection<PsiElement> getExpandedTopLevelElements(String topLevelName, boolean isContainer) {
        return this.expandElements(this.getTopLevelElements(topLevelName, isContainer));
    }

    protected boolean isStrictTypeContext() {
        return false;
    }

    @NotNull
    public final Collection<PsiElement> getExpandedLocalElements(@NotNull String name, @NotNull Collection<? extends PsiElement> scopes) {
        if (name == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(12);
        }
        if (scopes == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(13);
        }
        return this.expandElements(this.getLocalElements(name, scopes));
    }

    @NotNull
    public final Collection<PsiElement> getLocalElements(@NotNull String name, @NotNull Collection<? extends PsiElement> scopes) {
        if (name == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(14);
        }
        if (scopes == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(15);
        }
        SmartList collectedElements = new SmartList();
        for (PsiElement psiElement : scopes) {
            Collection<? extends PsiElement> localElements = this.getLocalElements(name, psiElement);
            collectedElements.addAll(localElements);
        }
        SmartList smartList = collectedElements;
        if (smartList == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(16);
        }
        return smartList;
    }

    @NotNull
    public final Collection<PsiElement> expandElements(@NotNull Collection<? extends PsiElement> rawTopLevelElements) {
        if (rawTopLevelElements == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(17);
        }
        Collection collection = rawTopLevelElements.stream().distinct().map(this::expandElement).flatMap(el -> el.stream()).filter(el -> !this.isStrictTypeContext() || JSQualifiedNameResolver.isStrictTypeContextElement(el)).distinct().collect(Collectors.toList());
        if (collection == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(18);
        }
        return collection;
    }

    private static boolean isStrictTypeContextElement(@NotNull PsiElement el) {
        if (el == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(19);
        }
        return TypeScriptPsiUtil.isNamedTypeContainerDefinition(el) || TypeScriptPsiUtil.isNamedTypeDefinition(el);
    }

    @NotNull
    public final Collection<PsiElement> expandElement(@NotNull PsiElement element) {
        if (element == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(20);
        }
        ProgressManager.checkCanceled();
        Collection results = (Collection)RecursionManager.doPreventingRecursion((Object)element, (boolean)false, () -> {
            if (element instanceof TypeScriptImportStatement) {
                List<PsiElement> rawElements;
                Collection<PsiElement> elements;
                TypeScriptExternalModuleReference externalModuleReference = ((TypeScriptImportStatement)element).getExternalModuleReference();
                TypeScriptEntityName internalModuleReference = ((TypeScriptImportStatement)element).getInternalModuleReference();
                if (externalModuleReference != null) {
                    Collection<PsiElement> resolveResults = externalModuleReference.multiResolve();
                    return this.processExternalModules(resolveResults);
                }
                if (internalModuleReference != null && !(elements = this.processWithResolveImportReferences(rawElements = JSResolveResult.toElements(internalModuleReference.multiResolve(false)), new HashSet<PsiElement>())).isEmpty()) {
                    return elements;
                }
            } else if (JSQualifiedNameResolver.isImportOrReExport(element)) {
                Collection<PsiElement> resolvedImports = this.resolveImportOrReExport(element, new HashSet<PsiElement>());
                if (!resolvedImports.isEmpty()) {
                    return resolvedImports;
                }
            } else {
                if (element instanceof TypeScriptGlobalModuleExportDeclaration) {
                    return this.processExternalModules(((TypeScriptGlobalModuleExportDeclaration)element).getModules());
                }
                if (this.myAcceptableObjectScope && element instanceof JSVariable || element instanceof JSTypeOwner && ((JSTypeOwner)element).getJSType() instanceof JSRequireCallExpressionType) {
                    JSExpression initializer;
                    Object export = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(element);
                    if (export instanceof JSDefinitionExpression && (initializer = ((JSDefinitionExpression)export).getInitializerOrStub()) instanceof JSNamedExpression) {
                        export = initializer;
                    }
                    return Collections.singletonList(export);
                }
                if (element instanceof TypeScriptProxyImplicitElementWithBackingItem) {
                    return Collections.singletonList(((TypeScriptProxyImplicitElementWithBackingItem)element).getBackingElement());
                }
            }
            return Collections.singletonList(element);
        });
        Collection collection = results == null ? ContainerUtil.emptyList() : results;
        if (collection == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(21);
        }
        return collection;
    }

    @NotNull
    private Collection<PsiElement> processWithResolveImportReferences(@NotNull Collection<? extends PsiElement> elements, @Nullable Set<PsiElement> visited) {
        if (elements == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(22);
        }
        if (elements.isEmpty()) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(23);
            }
            return list2;
        }
        SmartList result2 = new SmartList();
        for (PsiElement psiElement : elements) {
            if (JSQualifiedNameResolver.isImportOrReExport(psiElement)) {
                Collection<PsiElement> resolved = this.resolveImportOrReExport(psiElement, visited);
                result2.addAll(resolved);
                continue;
            }
            result2.add(psiElement);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(24);
        }
        return smartList;
    }

    private static boolean isImportOrReExport(@Nullable PsiElement element) {
        return element instanceof ES6ImportExportSpecifier || element instanceof ES6ImportedExportedDefaultBinding || element instanceof TypeScriptImportStatement || element instanceof ES6ImportExportSpecifierAlias || element instanceof JSExportAssignment;
    }

    @NotNull
    private Collection<PsiElement> processExternalModules(@NotNull Collection<PsiElement> modules2) {
        if (modules2 == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(25);
        }
        if (modules2.isEmpty()) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(26);
            }
            return list2;
        }
        SmartList result2 = new SmartList();
        for (PsiElement element : modules2) {
            TypeScriptExportAssignment exportAssignment;
            if (TypeScriptPsiUtil.isTopLevelContainer(element) && (exportAssignment = TypeScriptPsiUtil.findExportAssignment(element)) != null) {
                result2.addAll(this.processAssignExpression(exportAssignment, new HashSet<PsiElement>()));
                continue;
            }
            result2.add(element);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(27);
        }
        return smartList;
    }

    @NotNull
    private Collection<PsiElement> processAssignExpression(@NotNull JSExportAssignment assignment, @Nullable Set<PsiElement> visited) {
        JSElement candidate;
        String referenceName;
        if (assignment == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(28);
        }
        if ((referenceName = assignment.getInitializerReference()) != null) {
            JSQualifiedNameResolver resolver = this.createNestedResolver((PsiElement)assignment);
            return this.processWithResolveImportReferences(resolver.resolveQualifiedName(referenceName), visited);
        }
        JSElement stubElement = assignment.getStubSafeElement();
        JSElement jSElement = candidate = stubElement == null ? (JSElement)AstLoadingFilter.forceAllowTreeLoading((PsiFile)assignment.getContainingFile(), () -> assignment.getExpression()) : stubElement;
        if (candidate instanceof JSClass || candidate instanceof JSFunctionExpression || candidate instanceof TypeScriptObjectType) {
            List<JSElement> list2 = Collections.singletonList(candidate);
            if (list2 == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(29);
            }
            return list2;
        }
        if (candidate instanceof JSReferenceExpression) {
            return this.processWithResolveImportReferences(JSResolveResult.toElements(((JSReferenceExpression)candidate).multiResolve(false)), null);
        }
        List list3 = ContainerUtil.emptyList();
        if (list3 == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(30);
        }
        return list3;
    }

    @NotNull
    protected final Collection<PsiElement> resolveImportOrReExport(@NotNull PsiElement element, @Nullable Set<PsiElement> visited) {
        if (element == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(31);
        }
        if (visited != null && !visited.add(element)) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(32);
            }
            return list2;
        }
        if (element instanceof TypeScriptImportStatement) {
            return this.processWithResolveImportReferences(((TypeScriptImportStatement)element).findReferencedElements(), visited);
        }
        if (element instanceof ES6ImportExportSpecifier) {
            return this.processWithResolveImportReferences(JSResolveResult.toElements(((ES6ImportExportSpecifier)element).resolveOverAliases()), visited);
        }
        if (element instanceof ES6ImportedExportedDefaultBinding) {
            return this.processWithResolveImportReferences(((ES6ImportedExportedDefaultBinding)element).findReferencedElements(), visited);
        }
        if (element instanceof ES6ImportExportSpecifierAlias) {
            ES6ImportExportSpecifier specifier = ((ES6ImportExportSpecifierAlias)element).findSpecifierElement();
            if (specifier != null) {
                return this.processWithResolveImportReferences(JSResolveResult.toElements(specifier.resolveOverAliases()), visited);
            }
        } else if (element instanceof JSExportAssignment) {
            return this.processAssignExpression((JSExportAssignment)element, visited);
        }
        List<PsiElement> list3 = Collections.singletonList(element);
        if (list3 == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(33);
        }
        return list3;
    }

    @NotNull
    protected final Collection<? extends PsiElement> getLocalElements(@NotNull String name, @NotNull PsiElement scopeElement) {
        if (name == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(34);
        }
        if (scopeElement == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(35);
        }
        if (scopeElement instanceof TypeScriptEnum) {
            for (JSField member : ((TypeScriptEnum)scopeElement).getFields()) {
                if (!name.equals(member.getName())) continue;
                Set<JSField> set = Collections.singleton(member);
                if (set == null) {
                    JSQualifiedNameResolver.$$$reportNull$$$0(36);
                }
                return set;
            }
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(37);
            }
            return list2;
        }
        if (ES6PsiUtil.isExportScope(scopeElement)) {
            TypeScriptModuleDeclarationsProcessor processor = new TypeScriptModuleDeclarationsProcessor(name, this.isStrictTypeContext(), true);
            JSQualifiedNameResolver.processES6DeclarationsInScope((JSElement)scopeElement, processor, true);
            List<PsiElement> list3 = processor.getResults();
            if (list3 == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(38);
            }
            return list3;
        }
        if (this.myAcceptableObjectScope || scopeElement instanceof JsonElement) {
            ResolveResult[] results = JSQualifiedNameResolver.processDeclarationsForScope(name, scopeElement, true);
            if (!this.myAcceptableObjectScope || results.length > 0 || !(scopeElement instanceof JSTypeOwner)) {
                List<PsiElement> list4 = JSResolveResult.toElements(results);
                if (list4 == null) {
                    JSQualifiedNameResolver.$$$reportNull$$$0(39);
                }
                return list4;
            }
            PsiElement element = JSQualifiedNameResolver.resolveFromType(name, ((JSTypeOwner)scopeElement).getJSType());
            if (element != null) {
                Set<PsiElement> set = Collections.singleton(element);
                if (set == null) {
                    JSQualifiedNameResolver.$$$reportNull$$$0(40);
                }
                return set;
            }
        }
        List list5 = ContainerUtil.emptyList();
        if (list5 == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(41);
        }
        return list5;
    }

    @Nullable
    @Contract(value="_, null -> null")
    private static PsiElement resolveFromType(@NotNull String name, @Nullable JSType type) {
        if (name == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(42);
        }
        if (type == null) {
            return null;
        }
        JSRecordType recordType = type.asRecordType();
        JSRecordType.PropertySignature signature = recordType.findPropertySignature(name);
        if (signature == null) {
            return null;
        }
        PsiElement sourceElement = (PsiElement)ObjectUtils.coalesce((Object)signature.getMemberSource().getSingleElement(), (Object)type.getSourceElement());
        if (sourceElement == null) {
            return null;
        }
        return new JSLocalImplicitElementImpl(signature.getMemberName(), signature.getJSType(), sourceElement, JSImplicitElement.Type.Property);
    }

    public static ResolveResult @NotNull [] processDeclarationsForScope(@NotNull String name, @NotNull PsiElement scopeElement, boolean statics) {
        if (name == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(43);
        }
        if (scopeElement == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(44);
        }
        ResolveResultSink sink = new ResolveResultSink(scopeElement, name, true);
        QualifiedItemProcessor<ResolveResultSink> processor = JSDialectSpecificHandlersFactory.forElement(scopeElement).createQualifiedItemProcessor(sink, scopeElement);
        processor.getAccessibilityProcessingHandler().setProcessStatics(statics);
        if (scopeElement instanceof JsonElement) {
            ES6PsiUtil.processDeclarationInJsonElement((JsonElement)scopeElement, processor);
        } else {
            if (statics && scopeElement instanceof JSClass && ((JSClass)scopeElement).isInterface()) {
                if (ResolveResult.EMPTY_ARRAY == null) {
                    JSQualifiedNameResolver.$$$reportNull$$$0(45);
                }
                return ResolveResult.EMPTY_ARRAY;
            }
            processor.setLocalResolve(true);
            scopeElement.processDeclarations(processor, ResolveState.initial(), scopeElement, scopeElement);
        }
        ResolveResult[] resolveResultArray = sink.getResultsAsResolveResults();
        if (resolveResultArray == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(46);
        }
        return resolveResultArray;
    }

    public static boolean processES6DeclarationsInScope(@NotNull JSElement scope, final @NotNull PsiScopeProcessor processor, final boolean exportedElements) {
        if (scope == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(47);
        }
        if (processor == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(48);
        }
        if ((scope = (JSElement)CompletionUtilCoreImpl.getOriginalElement((PsiElement)scope)) == null) {
            return true;
        }
        final Ref result2 = Ref.create((Object)true);
        JSResolveProcessorBase delegatingProcessor = new JSResolveProcessorBase(processor){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state2) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (exportedElements && element instanceof JSPsiElementBase && element.getParent() instanceof ES6ExportDefaultAssignment) {
                    return true;
                }
                if (!exportedElements && element instanceof ES6ExportSpecifier) {
                    return true;
                }
                result2.set((Object)(processor.execute(element, state2) && (Boolean)result2.get() != false ? 1 : 0));
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        JSStubBasedPsiTreeUtil.processDeclarationsInScope((PsiElement)scope, delegatingProcessor, false);
        if (!((Boolean)result2.get()).booleanValue()) {
            return false;
        }
        JSModuleElementsProcessor moduleElementsProcessor = processor instanceof JSModuleElementsResolveProcessor ? (JSModuleElementsProcessor)processor : new JSModuleElementsResolveProcessor(processor);
        return !exportedElements || ES6PsiUtil.processExportAllDeclarations(scope, moduleElementsProcessor, null);
    }

    @NotNull
    protected final Collection<PsiElement> getTopLevelForImportType(@NotNull String name) {
        if (name == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(49);
        }
        if (!name.endsWith(")")) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(50);
            }
            return list2;
        }
        String moduleRef = JSStringUtil.unquoteAndUnescapeString(name.substring("import(".length(), name.length() - 1));
        if (moduleRef.isEmpty()) {
            List<PsiElement> list3 = Collections.emptyList();
            if (list3 == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(51);
            }
            return list3;
        }
        PsiFile scope = this.myContext.getContainingFile();
        Collection<PsiElement> collection = JSFileReferencesUtil.resolveModuleReference((PsiElement)scope, moduleRef);
        if (collection == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(52);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: 
            case 46: 
            case 50: 
            case 51: 
            case 52: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: 
            case 46: 
            case 50: 
            case 51: 
            case 52: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: 
            case 46: 
            case 50: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver";
                break;
            }
            case 7: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 9: 
            case 12: 
            case 14: 
            case 34: 
            case 42: 
            case 43: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawTopLevelElements";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 20: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 35: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeElement";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveQualifiedName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "postProcessResults";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelElements";
                break;
            }
            case 16: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalElements";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "expandElements";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "expandElement";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "processWithResolveImportReferences";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "processExternalModules";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "processAssignExpression";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveImportOrReExport";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "processDeclarationsForScope";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelForImportType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolveQualifiedName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: 
            case 46: 
            case 50: 
            case 51: 
            case 52: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "postProcessResults";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelElements";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getExpandedLocalElements";
                break;
            }
            case 14: 
            case 15: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getLocalElements";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "expandElements";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isStrictTypeContextElement";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "expandElement";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processWithResolveImportReferences";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processExternalModules";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processAssignExpression";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "resolveImportOrReExport";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "resolveFromType";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsForScope";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "processES6DeclarationsInScope";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelForImportType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: 
            case 46: 
            case 50: 
            case 51: 
            case 52: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

