/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.ContainerUtil;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSTaggedResolveResult
implements Comparable<JSTaggedResolveResult> {
    @NotNull
    public final ResolveResult result;
    @NotNull
    public final EnumSet<ResolveResultTag> tags;
    public final int completeMatchLevel;
    private static final Integer POSITIVE = 1;
    private static final Integer NEGATIVE = -1;
    private static final Pair<ResolveResultTag, Integer> MATCH_LEVEL_PLACEHOLDER = new Pair(null, null);
    private static final Pair<ResolveResultTag, Integer> IS_VALID_RESOLVE_PLACEHOLDER = new Pair(null, null);
    private static final Pair<ResolveResultTag, Integer> CONTRADICTS_JSDOC_PLACEHOLDER = new Pair(null, null);
    private static final List<Pair<ResolveResultTag, Integer>> TAGS_SIGNIFICANCE_ORDER = ContainerUtil.newArrayList((Object[])new Pair[]{Pair.create((Object)((Object)ResolveResultTag.PARTIAL), (Object)NEGATIVE), IS_VALID_RESOLVE_PLACEHOLDER, Pair.create((Object)((Object)ResolveResultTag.NON_CONSTRUCTOR_DEFINITION), (Object)NEGATIVE), CONTRADICTS_JSDOC_PLACEHOLDER, MATCH_LEVEL_PLACEHOLDER, Pair.create((Object)((Object)ResolveResultTag.NOT_EXPORTED), (Object)NEGATIVE), Pair.create((Object)((Object)ResolveResultTag.NOT_IMPORTED), (Object)NEGATIVE), Pair.create((Object)((Object)ResolveResultTag.IS_ASSIGNMENT), (Object)NEGATIVE), Pair.create((Object)((Object)ResolveResultTag.MINOR_IMPORTANCE), (Object)NEGATIVE), Pair.create((Object)((Object)ResolveResultTag.HAS_JSDOC), (Object)POSITIVE), Pair.create((Object)((Object)ResolveResultTag.RECORD_TYPE_PROPERTY), (Object)NEGATIVE), Pair.create((Object)((Object)ResolveResultTag.SELF_DEFINITION), (Object)POSITIVE), Pair.create((Object)((Object)ResolveResultTag.CONTEXT_MATCHES), (Object)POSITIVE)});

    JSTaggedResolveResult(@NotNull ResolveResult result2, @NotNull EnumSet<ResolveResultTag> tags, int completeMatchLevel) {
        if (result2 == null) {
            JSTaggedResolveResult.$$$reportNull$$$0(0);
        }
        if (tags == null) {
            JSTaggedResolveResult.$$$reportNull$$$0(1);
        }
        this.result = result2;
        this.tags = tags;
        this.completeMatchLevel = completeMatchLevel;
    }

    @Override
    public int compareTo(@NotNull JSTaggedResolveResult o) {
        int priorityTo;
        if (o == null) {
            JSTaggedResolveResult.$$$reportNull$$$0(2);
        }
        if ((priorityTo = this.comparePriorityTo(o)) != 0) {
            return priorityTo;
        }
        if (this.tags.contains((Object)ResolveResultTag.CURRENT_FILE) && !o.tags.contains((Object)ResolveResultTag.CURRENT_FILE)) {
            return -1;
        }
        if (!this.tags.contains((Object)ResolveResultTag.CURRENT_FILE) && o.tags.contains((Object)ResolveResultTag.CURRENT_FILE)) {
            return 1;
        }
        return 0;
    }

    int comparePriorityTo(@NotNull JSTaggedResolveResult o) {
        if (o == null) {
            JSTaggedResolveResult.$$$reportNull$$$0(3);
        }
        boolean contradictsJSDoc1 = JSTaggedResolveResult.hasContradictsJSDocResolveError(this.result);
        boolean contradictsJSDoc2 = JSTaggedResolveResult.hasContradictsJSDocResolveError(o.result);
        return JSTaggedResolveResult.comparePriorities(this.tags, contradictsJSDoc1 || this.result.isValidResult(), contradictsJSDoc1, this.completeMatchLevel, o.tags, contradictsJSDoc2 || o.result.isValidResult(), contradictsJSDoc2, o.completeMatchLevel);
    }

    private static boolean hasContradictsJSDocResolveError(@NotNull ResolveResult result2) {
        if (result2 == null) {
            JSTaggedResolveResult.$$$reportNull$$$0(4);
        }
        return result2 instanceof JSResolveResult && (((JSResolveResult)result2).getResolveProblemKey() == "javascript.jsdoc.private.member.is.not.accessible.message" || ((JSResolveResult)result2).getResolveProblemKey() == "javascript.jsdoc.protected.member.is.not.accessible.message");
    }

    public static int comparePriorities(@NotNull EnumSet<ResolveResultTag> tags1, @NotNull EnumSet<ResolveResultTag> tags2) {
        if (tags1 == null) {
            JSTaggedResolveResult.$$$reportNull$$$0(5);
        }
        if (tags2 == null) {
            JSTaggedResolveResult.$$$reportNull$$$0(6);
        }
        return JSTaggedResolveResult.comparePriorities(tags1, true, false, 0, tags2, true, false, 0);
    }

    private static int comparePriorities(@NotNull EnumSet<ResolveResultTag> tags1, boolean isValid1, boolean contradictsJSDoc1, int matchLevel1, @NotNull EnumSet<ResolveResultTag> tags2, boolean isValid2, boolean contradictsJSDoc2, int matchLevel2) {
        if (tags1 == null) {
            JSTaggedResolveResult.$$$reportNull$$$0(7);
        }
        if (tags2 == null) {
            JSTaggedResolveResult.$$$reportNull$$$0(8);
        }
        for (Pair<ResolveResultTag, Integer> pair : TAGS_SIGNIFICANCE_ORDER) {
            if (pair == IS_VALID_RESOLVE_PLACEHOLDER) {
                if (isValid1 && !isValid2) {
                    return -1;
                }
                if (isValid1 || !isValid2) continue;
                return 1;
            }
            if (pair == CONTRADICTS_JSDOC_PLACEHOLDER) {
                if (contradictsJSDoc1 && !contradictsJSDoc2) {
                    return 1;
                }
                if (contradictsJSDoc1 || !contradictsJSDoc2) continue;
                return -1;
            }
            if (pair == MATCH_LEVEL_PLACEHOLDER) {
                if (matchLevel1 < matchLevel2) {
                    return -1;
                }
                if (matchLevel1 <= matchLevel2) continue;
                return 1;
            }
            int compare = JSTaggedResolveResult.compareByTag(pair, tags1, tags2);
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    private static int compareByTag(@NotNull Pair<ResolveResultTag, Integer> pair, @NotNull EnumSet<ResolveResultTag> tags1, @NotNull EnumSet<ResolveResultTag> tags2) {
        if (pair == null) {
            JSTaggedResolveResult.$$$reportNull$$$0(9);
        }
        if (tags1 == null) {
            JSTaggedResolveResult.$$$reportNull$$$0(10);
        }
        if (tags2 == null) {
            JSTaggedResolveResult.$$$reportNull$$$0(11);
        }
        if (!tags1.contains(pair.first) && tags2.contains(pair.first)) {
            return (Integer)pair.second;
        }
        if (tags1.contains(pair.first) && !tags2.contains(pair.first)) {
            return -((Integer)pair.second).intValue();
        }
        return 0;
    }

    public boolean hasTag(ResolveResultTag tag) {
        return this.tags.contains((Object)tag);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags1";
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags2";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSTaggedResolveResult";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "compareTo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "comparePriorityTo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasContradictsJSDocResolveError";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "comparePriorities";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "compareByTag";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum ResolveResultTag {
        PARTIAL,
        NOT_EXPORTED,
        NOT_IMPORTED,
        NON_CONSTRUCTOR_DEFINITION,
        IS_ASSIGNMENT,
        HAS_JSDOC,
        MINOR_IMPORTANCE,
        RECORD_TYPE_PROPERTY,
        CURRENT_FILE,
        CONTEXT_MATCHES,
        SELF_DEFINITION;

    }
}

