/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.index.JSLocalTypeEvaluator;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSEvaluableTypeBase;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.openapi.util.Segment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import java.text.CharacterIterator;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSTypeofTypeImpl
extends JSEvaluableTypeBase
implements JSTypeWithIncompleteSubstitution {
    @Nullable
    private final JSType myLocallyEvaluatedType;

    public JSTypeofTypeImpl(@NotNull JSExpression expression, @NotNull JSTypeSource source2) {
        if (expression == null) {
            JSTypeofTypeImpl.$$$reportNull$$$0(0);
        }
        if (source2 == null) {
            JSTypeofTypeImpl.$$$reportNull$$$0(1);
        }
        this((Segment)expression.getTextRange(), JSTypeofTypeImpl.calculateLocallyEvaluatedType(expression), source2);
    }

    JSTypeofTypeImpl(@NotNull JSTypeSource source2, @NotNull CharacterIterator inputStream) {
        if (source2 == null) {
            JSTypeofTypeImpl.$$$reportNull$$$0(2);
        }
        if (inputStream == null) {
            JSTypeofTypeImpl.$$$reportNull$$$0(3);
        }
        super(source2, inputStream);
        this.myLocallyEvaluatedType = JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.read(source2, inputStream);
    }

    private JSTypeofTypeImpl(@NotNull Segment range, @Nullable JSType locallyEvaluatedType, @NotNull JSTypeSource source2) {
        if (range == null) {
            JSTypeofTypeImpl.$$$reportNull$$$0(4);
        }
        if (source2 == null) {
            JSTypeofTypeImpl.$$$reportNull$$$0(5);
        }
        super(source2, range);
        this.myLocallyEvaluatedType = locallyEvaluatedType;
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSTypeofTypeImpl.$$$reportNull$$$0(6);
        }
        super.serialize(outputStream);
        JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.write(this.myLocallyEvaluatedType, outputStream);
    }

    @Nullable
    private static JSType calculateLocallyEvaluatedType(@NotNull JSExpression expression) {
        if (expression == null) {
            JSTypeofTypeImpl.$$$reportNull$$$0(7);
        }
        JSType locallyEvaluatedType = null;
        if (expression instanceof JSReferenceExpression && ((JSReferenceExpression)expression).getQualifier() == null) {
            locallyEvaluatedType = JSLocalTypeEvaluator.evaluateTypeLocally(expression);
        }
        return locallyEvaluatedType;
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSTypeofTypeImpl.$$$reportNull$$$0(8);
        }
        if (this.myLocallyEvaluatedType != null) {
            this.myLocallyEvaluatedType.accept(visitor);
        }
    }

    @Override
    protected String getPrefix() {
        return "#typeof";
    }

    @Override
    protected String getPostfix() {
        return "";
    }

    @NotNull
    private JSType evaluateTypeInRange(@Nullable Segment range, @Nullable Set<PsiElement> expandedElements) {
        PsiElement parent;
        JSAnyType defaultType = JSAnyType.getWithLanguage(this.getSource().getLanguage(), false);
        PsiElement toProcess = this.findElementToProcess(range);
        if (toProcess == null) {
            JSAnyType jSAnyType = defaultType;
            if (jSAnyType == null) {
                JSTypeofTypeImpl.$$$reportNull$$$0(9);
            }
            return jSAnyType;
        }
        JSType type = this.processElement(toProcess, defaultType, expandedElements);
        if (type instanceof JSFunctionTypeImpl && toProcess instanceof JSCallLikeExpression && (parent = toProcess.getContext()) instanceof JSVariable && ((JSVariable)parent).getInitializerOrStub() == toProcess) {
            JSType jSType = type.withNewSource(JSTypeSourceFactory.createTypeSource(parent, type.isSourceStrict()));
            if (jSType == null) {
                JSTypeofTypeImpl.$$$reportNull$$$0(10);
            }
            return jSType;
        }
        JSType jSType = type;
        if (jSType == null) {
            JSTypeofTypeImpl.$$$reportNull$$$0(11);
        }
        return jSType;
    }

    @Override
    protected boolean isElementAcceptable(@NotNull PsiElement element) {
        if (element == null) {
            JSTypeofTypeImpl.$$$reportNull$$$0(12);
        }
        return element instanceof JSExpression;
    }

    @NotNull
    private JSType processElement(@NotNull PsiElement psiElement, @NotNull JSType defaultType, @Nullable Set<PsiElement> expandedElements) {
        JSType exprType;
        if (psiElement == null) {
            JSTypeofTypeImpl.$$$reportNull$$$0(13);
        }
        if (defaultType == null) {
            JSTypeofTypeImpl.$$$reportNull$$$0(14);
        }
        JSExpression element = (JSExpression)psiElement;
        if (expandedElements != null) {
            if (expandedElements.contains(element)) {
                JSType jSType = defaultType;
                if (jSType == null) {
                    JSTypeofTypeImpl.$$$reportNull$$$0(15);
                }
                return jSType;
            }
            expandedElements.add((PsiElement)element);
        }
        if ((exprType = JSResolveUtil.getExpressionJSType(element)) != null) {
            JSTypeSource exprTypeSource = exprType.getSource();
            boolean isStrict = this.isSourceStrict() && exprTypeSource.isStrict();
            exprType = JSTypeUtils.copyWithStrict(exprType, isStrict);
        }
        JSType jSType = exprType != null ? exprType : defaultType;
        if (jSType == null) {
            JSTypeofTypeImpl.$$$reportNull$$$0(16);
        }
        return jSType;
    }

    @Override
    @NotNull
    protected JSTypeofTypeImpl copyWithNewSource(@NotNull JSTypeSource source2) {
        if (source2 == null) {
            JSTypeofTypeImpl.$$$reportNull$$$0(17);
        }
        PsiFile scope = this.getSource().getScope();
        assert (scope != null);
        return new JSTypeofTypeImpl(this.myRange, this.myLocallyEvaluatedType, source2);
    }

    @Nullable
    public String getTypeofDesc(@NotNull PsiElement context) {
        PsiElement sourceElement;
        if (context == null) {
            JSTypeofTypeImpl.$$$reportNull$$$0(18);
        }
        if ((sourceElement = this.getSourceElement()) == null) {
            return null;
        }
        PsiElement element = this.findElementToProcess(this.myRange);
        if (!(element instanceof JSReferenceExpression)) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof JSParameter && ((JSParameter)parent).getInitializer() == element) {
            return null;
        }
        PsiElement resolved = ((JSReferenceExpression)element).resolve();
        if (!(resolved instanceof JSFieldVariable)) {
            return null;
        }
        LocalSearchScope scope = (LocalSearchScope)ObjectUtils.tryCast((Object)resolved.getUseScope(), LocalSearchScope.class);
        if (scope != null && scope.getScope().length == 1 && PsiTreeUtil.isAncestor((PsiElement)scope.getScope()[0], (PsiElement)context, (boolean)true)) {
            return "typeof " + ((JSFieldVariable)resolved).getQualifiedName();
        }
        return null;
    }

    @Override
    @NotNull
    public JSType substituteCompletely() {
        JSType type = this.substitute();
        JSType jSType = type == this ? JSAnyType.get(this.getSource()) : type;
        if (jSType == null) {
            JSTypeofTypeImpl.$$$reportNull$$$0(19);
        }
        return jSType;
    }

    @Override
    public JSType substituteImpl(@NotNull JSTypeSubstitutionContext context) {
        PsiElement toProcess;
        if (context == null) {
            JSTypeofTypeImpl.$$$reportNull$$$0(20);
        }
        if ((toProcess = this.findElementToProcess(this.myRange)) == null) {
            return null;
        }
        return this.evaluateTypeInRange(this.getSegment(), new HashSet<PsiElement>());
    }

    @Nullable
    public JSType getLocallyEvaluatedType() {
        return this.myLocallyEvaluatedType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultType";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateTypeInRange";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "processElement";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteCompletely";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "calculateLocallyEvaluatedType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isElementAcceptable";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTypeofDesc";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "substituteImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

