/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptFieldImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeGuardEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSBigIntLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSPsiBasedTypeOfType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeGuard;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.guard.operations.JSApplyTypeOperationContext;
import com.intellij.lang.javascript.psi.types.primitives.JSBigIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.Predicate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSTypeGuardUtil {
    @NotNull
    public static JSType appendProperty(@NotNull JSType type, @NotNull String name, @Nullable PsiElement navigationElement, @NotNull PsiElement context) {
        if (type == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(0);
        }
        if (name == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(1);
        }
        if (context == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(2);
        }
        if (!JSTypeGuardUtil.isTypeCanBeExtended(type, name)) {
            JSType jSType = type;
            if (jSType == null) {
                JSTypeGuardUtil.$$$reportNull$$$0(3);
            }
            return jSType;
        }
        JSRecordTypeImpl.PropertySignatureImpl signature = new JSRecordTypeImpl.PropertySignatureImpl(name, null, false, false, navigationElement);
        JSTypeSource source2 = JSTypeSourceFactory.createTypeSource(context, false);
        ImmutableList types2 = ContainerUtil.immutableList((Object[])new JSType[]{new JSRecordTypeImpl(source2, Collections.singletonList(signature)), type});
        return JSTypeGuardUtil.getUnionType((Collection<? extends JSType>)types2, source2);
    }

    private static boolean isTypeCanBeExtended(@NotNull JSType type, @NotNull String name) {
        if (type == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(4);
        }
        if (name == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(5);
        }
        if (type instanceof JSRecordType) {
            JSRecordType recordType = type.asRecordType();
            return recordType.findPropertySignature(name) == null;
        }
        return true;
    }

    public static boolean isSourceTypeAnyAndTargetTypeFunctionOrObject(@Nullable JSType type, @Nullable JSType guardType) {
        return type instanceof JSAnyType && (guardType instanceof JSPrimitiveFunctionType || guardType instanceof JSObjectType);
    }

    @NotNull
    public static JSType getUnionType(@NotNull Collection<? extends JSType> types2, @NotNull JSTypeSource source2) {
        if (types2 == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(6);
        }
        if (source2 == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(7);
        }
        JSType jSType = TypeScriptTypeRelations.getUnionType(types2, source2);
        if (jSType == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(8);
        }
        return jSType;
    }

    public static boolean isPrimitiveType(@NotNull String name) {
        if (name == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(9);
        }
        return ArrayUtil.contains((String)name, (String[])JSCommonTypeNames.TYPEOF_VALUES);
    }

    @Nullable
    public static JSExpression getReferenceCandidate(@Nullable JSExpression expression) {
        if (expression instanceof JSParenthesizedExpression) {
            return JSTypeGuardUtil.getReferenceCandidate(((JSParenthesizedExpression)expression).getInnerExpression());
        }
        if (expression instanceof JSBinaryExpression) {
            IElementType sign = ((JSBinaryExpression)expression).getOperationSign();
            if (sign == JSTokenTypes.EQ) {
                return JSTypeGuardUtil.getReferenceCandidate(((JSBinaryExpression)expression).getLOperand());
            }
            if (sign == JSTokenTypes.COMMA) {
                return JSTypeGuardUtil.getReferenceCandidate(((JSBinaryExpression)expression).getROperand());
            }
        }
        return expression;
    }

    public static JSType replacePrimitivesWithLiterals(@Nullable JSType typeWithPrimitives, @Nullable JSType typeWithLiterals, @NotNull PsiElement context) {
        if (context == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(10);
        }
        if (typeWithPrimitives == null || typeWithLiterals == null) {
            return typeWithPrimitives;
        }
        if (!JSTypeUtils.hasTypes(typeWithLiterals, JSNumberLiteralTypeImpl.class, JSBigIntLiteralTypeImpl.class, JSStringLiteralTypeImpl.class)) {
            return typeWithPrimitives;
        }
        JSType numberLiterals = TypeScriptTypeRelations.filterType(typeWithLiterals, (Predicate<? super JSType>)((Predicate)t -> t instanceof JSNumberType), context);
        JSType bigIntLiterals = TypeScriptTypeRelations.filterType(typeWithLiterals, (Predicate<? super JSType>)((Predicate)t -> t instanceof JSBigIntType), context);
        JSType stringLiterals = TypeScriptTypeRelations.filterType(typeWithLiterals, (Predicate<? super JSType>)((Predicate)t -> t instanceof JSStringType), context);
        if (numberLiterals instanceof TypeScriptNeverJSTypeImpl && stringLiterals instanceof TypeScriptNeverJSTypeImpl && bigIntLiterals instanceof TypeScriptNeverJSTypeImpl) {
            return typeWithPrimitives;
        }
        return typeWithPrimitives.transformTypeHierarchy((Function<? super JSType, ? extends JSType>)((Function)toProcess -> {
            if (!(toProcess instanceof JSLiteralType)) {
                if (toProcess instanceof JSNumberType) {
                    return numberLiterals;
                }
                if (toProcess instanceof JSBigIntType) {
                    return bigIntLiterals;
                }
                if (toProcess instanceof JSStringType) {
                    return stringLiterals;
                }
            }
            return toProcess;
        }));
    }

    @Contract(value="null->null; !null->!null")
    @Nullable
    public static JSType getBaseTypeOfLiteralType(@Nullable JSType type) {
        JSResolvedTypeInfo resolvedType;
        if (type == null) {
            return null;
        }
        if ((type = JSTypeUtils.unwrapType(type)) instanceof JSResolvableType && type.isTypeScript() && (resolvedType = ((JSResolvableType)type).resolveType()).isEnumLiteral()) {
            return TypeScriptUtil.getBaseTypeOfEnumLiteralType((JSResolvableType)type);
        }
        if (type instanceof JSLiteralType) {
            return ((JSLiteralType)type).asPrimitiveType();
        }
        if (type instanceof JSUnionType) {
            return ((JSUnionType)type).transformTypes((NullableFunction<? super JSType, JSType>)((NullableFunction)JSTypeGuardUtil::getBaseTypeOfLiteralType));
        }
        return type;
    }

    @Nullable
    public static JSExpression getInitializerExpression(@Nullable PsiElement element) {
        if (element instanceof JSAssignmentExpression) {
            element = ((JSAssignmentExpression)element).getDefinitionExpression();
        }
        if (element instanceof JSInitializerOwner) {
            return ((JSInitializerOwner)element).getInitializer();
        }
        return null;
    }

    public static boolean isDiscriminantType(@Nullable JSType rawType) {
        if (rawType == null) {
            return false;
        }
        if (JSTypeGuardUtil.isUnitType(rawType = JSTypeUtils.unwrapType(rawType))) {
            return true;
        }
        if (rawType instanceof JSUnionType) {
            List<JSType> types2 = ((JSUnionType)rawType).getTypes();
            boolean hasUnit = false;
            for (JSType type : types2) {
                if (JSTypeGuardUtil.isUnitType(type)) {
                    hasUnit = true;
                }
                if (!TypeScriptTypeRelations.isInstantiable(type)) continue;
                return false;
            }
            return hasUnit;
        }
        return false;
    }

    public static boolean isUnitType(@Nullable JSType rawType) {
        return (rawType = JSTypeUtils.unwrapType(rawType)) instanceof JSLiteralType || rawType instanceof JSUndefinedType || rawType instanceof JSNullType || JSTypeUtils.isEnumLiteral(rawType) && rawType.isSourceStrict();
    }

    public static boolean checkReferenceDiscriminantType(@NotNull JSApplyTypeOperationContext context, @NotNull JSType type, @NotNull JSType topOwnerType, @Nullable String propertyName) {
        if (context == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(11);
        }
        if (type == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(12);
        }
        if (topOwnerType == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(13);
        }
        if (propertyName == null) {
            return false;
        }
        if ((topOwnerType = JSTypeUtils.unwrapType(topOwnerType)) instanceof JSUnionType) {
            return JSTypeGuardUtil.isDiscriminantProperty(context, type, topOwnerType, propertyName);
        }
        return false;
    }

    public static boolean isDiscriminantProperty(@NotNull JSApplyTypeOperationContext context, @Nullable JSType type, @Nullable JSType topOwnerType, @NotNull String propertyName) {
        if (context == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(14);
        }
        if (propertyName == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(15);
        }
        JSType jSType = topOwnerType = context.strictNullChecks() ? topOwnerType : JSTypeUtils.removeNullableComponents(topOwnerType);
        if (!(topOwnerType instanceof JSUnionType) || type == null) {
            return false;
        }
        JSRecordType recordType = (type = JSTypeUtils.removeNullableComponents(type)).asRecordType();
        JSRecordType.PropertySignature signature = recordType.findPropertySignature(propertyName);
        if (signature != null) {
            JSRecordType.MemberSource source2 = signature.getMemberSource();
            if (type instanceof JSUnionType && !source2.isEmpty() && !source2.isUnion()) {
                return false;
            }
            JSType signatureType = JSTypeGuardChecker.getExactType(signature.getJSType());
            return JSTypeGuardUtil.isDiscriminantType(signatureType);
        }
        return false;
    }

    @NotNull
    public static JSType getOperationType(@NotNull JSExpression expression) {
        if (expression == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(16);
        }
        return new JSPsiBasedTypeOfType((PsiElement)expression, false);
    }

    @Nullable
    public static JSType getTypeIfAffectedByTypeGuard(@NotNull JSReferenceExpression expression) {
        PsiElement resolve;
        if (expression == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(17);
        }
        if ((resolve = expression.resolve()) instanceof JSTypeOwner && !(resolve instanceof TypeScriptEnumField)) {
            JSType typeFromTypeGuard;
            JSType type = JSTypeUtils.getTypeOfElement(resolve);
            if (type != null && resolve instanceof JSOptionalOwner && ((JSOptionalOwner)resolve).isOptional() && TypeScriptConfigUtil.strictNullChecks(resolve)) {
                type = TypeScriptTypeGuard.wrapWithUndefined(type, type.getSource());
            }
            if ((typeFromTypeGuard = JSTypeGuardEvaluator.applyToExpressionType(type, expression, resolve, new JSEvaluateContext(expression.getContainingFile()))) != null && JSTypeGuardUtil.isDistinct(type, typeFromTypeGuard) && JSTypeGuardUtil.isDistinct(TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type), typeFromTypeGuard)) {
                return JSResolveUtil.getExpressionJSType(expression);
            }
        }
        return null;
    }

    private static boolean isDistinct(JSType type, JSType typeFromTypeGuard) {
        JSType fromGuardWithoutUndefined = JSTypeGuardUtil.stripUndefined(typeFromTypeGuard);
        return !(typeFromTypeGuard.isEquivalentTo(type, null) || fromGuardWithoutUndefined != typeFromTypeGuard && fromGuardWithoutUndefined.isEquivalentTo(type, null) || JSTypeGuardUtil.areSameComponentUnionsOrIntersections(type, typeFromTypeGuard) || fromGuardWithoutUndefined != typeFromTypeGuard && JSTypeGuardUtil.areSameComponentUnionsOrIntersections(type, fromGuardWithoutUndefined));
    }

    private static boolean areSameComponentUnionsOrIntersections(JSType type, JSType fromTypeGuard) {
        ProcessingContext ctx = new ProcessingContext();
        if (!(type instanceof JSUnionOrIntersectionType) || !(fromTypeGuard instanceof JSUnionOrIntersectionType)) {
            return false;
        }
        if (type.getClass() != fromTypeGuard.getClass()) {
            return false;
        }
        List<JSType> types1 = ((JSUnionOrIntersectionType)type).getTypes();
        List<JSType> types2 = ((JSUnionOrIntersectionType)fromTypeGuard).getTypes();
        if (types1.size() != types2.size()) {
            return false;
        }
        for (JSType type1 : types1) {
            boolean hadEquivalent = false;
            for (JSType type2 : types2) {
                if (!type2.isEquivalentTo(type1, ctx, true)) continue;
                hadEquivalent = true;
                break;
            }
            if (hadEquivalent) continue;
            return false;
        }
        return true;
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    private static JSType stripUndefined(@Nullable JSType type) {
        return type instanceof JSUnionType ? ((JSUnionType)type).transformTypes((NullableFunction<? super JSType, JSType>)((NullableFunction)t -> t instanceof JSUndefinedType ? null : t)) : type;
    }

    @Nullable
    public static Pair<Boolean, Boolean> getAutoTypeStates(@NotNull PsiElement resolveResult) {
        if (resolveResult == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(18);
        }
        if (!JSTypeGuardUtil.isElementAcceptableForAutoTypes(resolveResult)) {
            return null;
        }
        JSVariable variable = (JSVariable)resolveResult;
        JSExpression initializer = variable.getInitializer();
        boolean useAutoVariableType = !variable.isConst() && (initializer == null || JSTypeGuardChecker.isUndefinedOrNullExpression(initializer));
        boolean useAutoArrayType = !useAutoVariableType && JSTypeGuardUtil.isEmptyArrayExpression(initializer);
        return Pair.create((Object)useAutoVariableType, (Object)useAutoArrayType);
    }

    public static boolean isElementAcceptableForAutoTypes(@NotNull PsiElement resolveResult) {
        if (resolveResult == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(19);
        }
        if (resolveResult instanceof JSField) {
            return JSTypeGuardUtil.isAutoTypeField(resolveResult);
        }
        if (!(resolveResult instanceof JSVariable) || resolveResult instanceof JSParameter) {
            return false;
        }
        if (JSDestructuringUtil.isDestructuring(resolveResult.getParent())) {
            return false;
        }
        JSVariable result2 = (JSVariable)resolveResult;
        if (result2.getTypeElement() != null) {
            return false;
        }
        JSAttributeList list2 = result2.getAttributeList();
        if (list2 != null && list2.hasModifier(JSAttributeList.ModifierType.EXPORT)) {
            return false;
        }
        return !TypeScriptPsiUtil.isAmbientDeclaration(resolveResult);
    }

    public static boolean isAcceptableForTypeGuard(@Nullable PsiElement element) {
        return JSTypeGuardUtil.isPossibleAutoTypeDeclaration(element) || element instanceof JSReferenceExpression;
    }

    public static boolean isPossibleAutoTypeDeclaration(@Nullable PsiElement element) {
        return element instanceof JSField;
    }

    public static boolean isAutoTypeField(@Nullable PsiElement element) {
        if (!(element instanceof JSField)) {
            return false;
        }
        JSField field = (JSField)element;
        PsiFile file2 = field.getContainingFile();
        TypeScriptConfig config2 = TypeScriptConfigUtil.getConfigForPsiFile(file2);
        if (config2 == null || TypeScriptUtil.isDefinitionFile(file2)) {
            return false;
        }
        return field instanceof TypeScriptFieldImpl && !(field instanceof TypeScriptEnumField) && !field.hasModifier(JSAttributeList.ModifierType.STATIC) && field.getJSType() == null && field.getInitializer() == null && config2.noImplicitAny();
    }

    public static boolean isEmptyArrayExpression(@Nullable JSExpression expression) {
        return expression instanceof JSArrayLiteralExpression && ((JSArrayLiteralExpression)expression).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/JSTypeGuardUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topOwnerType";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/JSTypeGuardUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "appendProperty";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnionType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "appendProperty";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isTypeCanBeExtended";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getUnionType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isPrimitiveType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "replacePrimitivesWithLiterals";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkReferenceDiscriminantType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isDiscriminantProperty";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getOperationType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTypeIfAffectedByTypeGuard";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAutoTypeStates";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isElementAcceptableForAutoTypes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

