/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard.operations;

import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.guard.operations.JSChainedTypeOperationBase;
import com.intellij.lang.javascript.psi.types.guard.operations.JSTypeOperation;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class JSNarrowTypeBySwitchOperationBase
extends JSChainedTypeOperationBase {
    @NotNull
    protected final List<JSType> myAllClauseTypes;
    protected final boolean myHasDefaultClause;
    protected final boolean myIsSyntheticDefault;
    protected final int myClauseStart;
    protected final int myClauseEnd;

    public JSNarrowTypeBySwitchOperationBase(@NotNull JSTypeOperation prev, @NotNull JSSwitchStatement statement, @NotNull List<JSType> clauseTypes, int clauseStart, int clauseEnd) {
        if (prev == null) {
            JSNarrowTypeBySwitchOperationBase.$$$reportNull$$$0(0);
        }
        if (statement == null) {
            JSNarrowTypeBySwitchOperationBase.$$$reportNull$$$0(1);
        }
        if (clauseTypes == null) {
            JSNarrowTypeBySwitchOperationBase.$$$reportNull$$$0(2);
        }
        super(prev);
        assert (clauseStart <= clauseEnd);
        this.myClauseStart = clauseStart;
        this.myClauseEnd = clauseEnd;
        this.myAllClauseTypes = clauseTypes;
        this.myIsSyntheticDefault = clauseStart == -1 && clauseEnd == -1;
        this.myHasDefaultClause = this.myIsSyntheticDefault || JSNarrowTypeBySwitchOperationBase.hasDefaultSwitchBranch(statement.getCaseClauses(), clauseStart, clauseEnd);
    }

    private static boolean hasDefaultSwitchBranch(JSCaseClause @NotNull [] clauses, int clauseStart, int clauseEnd) {
        if (clauses == null) {
            JSNarrowTypeBySwitchOperationBase.$$$reportNull$$$0(3);
        }
        for (int i2 = clauseStart; i2 < clauseEnd + 1; ++i2) {
            if (!clauses[i2].isDefault()) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clauseTypes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clauses";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/operations/JSNarrowTypeBySwitchOperationBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasDefaultSwitchBranch";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

