/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.primitives;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSForInStringType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSUintType;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import org.jetbrains.annotations.NotNull;

public class JSNumberType
extends JSPrimitiveType {
    private static final String DEFAULT_VALUE = "0";

    public JSNumberType(boolean primitive, @NotNull JSTypeSource source2, @NotNull JSTypeContext staticOrInstance) {
        if (source2 == null) {
            JSNumberType.$$$reportNull$$$0(0);
        }
        if (staticOrInstance == null) {
            JSNumberType.$$$reportNull$$$0(1);
        }
        super(primitive, source2, staticOrInstance);
    }

    public JSNumberType(@NotNull JSTypeSource typeSource, @NotNull CharacterIterator inputStream) {
        if (typeSource == null) {
            JSNumberType.$$$reportNull$$$0(2);
        }
        if (inputStream == null) {
            JSNumberType.$$$reportNull$$$0(3);
        }
        super(typeSource, inputStream);
    }

    @Override
    @NotNull
    public String getClassTypeText() {
        return "Number";
    }

    @Override
    @NotNull
    public String getPrimitiveTypeText() {
        return "number";
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSNumberType.$$$reportNull$$$0(4);
        }
        if (processingContext == null) {
            JSNumberType.$$$reportNull$$$0(5);
        }
        if (elementType instanceof JSResolvableType) {
            JSResolvedTypeInfo resolvedType = ((JSResolvableType)elementType).resolveType();
            if (resolvedType.isEnumLiteral()) {
                return TypeScriptTypeRelations.checkEnumTypeForPrimitive(resolvedType, JSNumberType.class);
            }
            if (resolvedType.isEnum()) {
                JSType literals = JSCompositeTypeImpl.optimizeTypeIfComposite(TypeScriptTypeRelations.getAsUnionTypeIfEnumWithLiterals(elementType));
                return literals == elementType || this.isDirectlyAssignableType(literals, processingContext);
            }
        }
        if (elementType instanceof JSIntType) {
            return true;
        }
        if (elementType instanceof JSUintType) {
            return true;
        }
        if (elementType instanceof JSNumberType) {
            return true;
        }
        if (this.isJavaScript() && elementType instanceof JSForInStringType) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    @NotNull
    public String getDefaultValue() {
        return DEFAULT_VALUE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticOrInstance";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/types/primitives/JSNumberType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

