/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.json.psi.impl.JsonPropertyNameReference;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.findUsages.JSUsageViewElementsListener;
import com.intellij.lang.javascript.frameworks.react.references.JSXNamespaceReference;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptImplicitOverloadedAliasElement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.ES6ChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSDestructuringPropertyReference;
import com.intellij.lang.javascript.psi.impl.JSLiteralTextReference;
import com.intellij.lang.javascript.psi.impl.JSPropertyNameReference;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.TypeScriptLiteralBasedPropertyElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSRenameExtension;
import com.intellij.lang.javascript.refactoring.rename.JSInplaceRenameHandler;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.components.JBList;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewTypeLocation;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDefaultRenameProcessor
extends RenamePsiElementProcessor {
    public static final Key<Long> FORCE_SEARCH_FOR_FILE_REFERENCES_KEY = new Key("js.rename.force.search.for.file.references");
    public static final boolean SEARCH_FOR_DYNAMIC_DEFAULT = false;
    public static final boolean SEARCH_FOR_JAVASCRIPT_DEFAULT = true;
    public static final boolean SEARCH_IN_STRINGS_AND_COMMENTS_DEFAULT_VALUE = false;
    public static final String SEARCH_IN_COMMENTS = "js.rename.search.in.comments";
    public static final String SEARCH_FOR_TEXT_OCCURRENCES = "js.rename.search.for.text.occurrences";
    public static final String SEARCH_FOR_JAVASCRIPT_OCCURRENCES = "ts.rename.search.for.js.occurrences";
    public static final String SEARCH_FOR_DYNAMIC_OCCURRENCES = "ts.rename.search.for.dynamic.occurrences";
    private boolean myForceShowPreview;

    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof JSNamedElement || element instanceof TypeScriptLiteralBasedPropertyElement;
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames, @NotNull SearchScope scope) {
        String newFileName;
        PsiFile containingFile;
        VirtualFile virtualFile;
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(1);
        }
        if (newName == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(2);
        }
        if (allRenames == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(4);
        }
        super.prepareRenaming(element, newName, allRenames, scope);
        if (element instanceof TypeScriptFunction) {
            Collection<TypeScriptFunction> overloads = TypeScriptPsiUtil.getAllOverloadsWithImplementation((TypeScriptFunction)element);
            overloads.forEach(el -> allRenames.put((PsiElement)el, newName));
        }
        VirtualFile virtualFile2 = virtualFile = (containingFile = element.getContainingFile()) != null ? containingFile.getVirtualFile() : null;
        if (!StringUtil.isEmpty((String)newName) && element instanceof JSNamedElement && !DialectDetector.isActionScript(element) && virtualFile != null && JSDefaultRenameProcessor.isTopLevelElementInMatchingFile((JSNamedElement)element) && (newFileName = JSNameSuggestionsUtil.fileNameFromElementName((JSNamedElement)element, newName)) != null && !StringUtil.equals((CharSequence)newFileName, (CharSequence)virtualFile.getNameWithoutExtension())) {
            boolean renameContainingFile;
            String newFileNameWithExtension = newFileName + "." + virtualFile.getExtension();
            String message = JavaScriptBundle.message("javascript.rename.containing.file.message", newFileNameWithExtension);
            boolean bl = renameContainingFile = Messages.showYesNoDialog((Project)element.getProject(), (String)message, (String)JavaScriptBundle.message("javascript.rename.file.with.related.title", new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
            if (renameContainingFile) {
                long count = PsiModificationTracker.SERVICE.getInstance((Project)containingFile.getProject()).getModificationCount();
                containingFile.putUserData(FORCE_SEARCH_FOR_FILE_REFERENCES_KEY, (Object)count);
                allRenames.put((PsiElement)containingFile, newFileNameWithExtension);
                for (JSRenameExtension extension : (JSRenameExtension[])JSRenameExtension.EP_NAME.getExtensions()) {
                    Map<PsiFile, String> files = extension.getAdditionalFilesToRename(element, containingFile, newFileName);
                    for (Map.Entry<PsiFile, String> entry : files.entrySet()) {
                        entry.getKey().putUserData(FORCE_SEARCH_FOR_FILE_REFERENCES_KEY, (Object)count);
                        allRenames.put((PsiElement)entry.getKey(), entry.getValue());
                    }
                }
            }
        }
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts, @NotNull Map<PsiElement, String> allRenames) {
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(5);
        }
        if (newName == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(6);
        }
        if (conflicts == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(7);
        }
        if (allRenames == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(8);
        }
        for (Map.Entry<PsiElement, String> entry : allRenames.entrySet()) {
            this.findExistingNameConflicts(entry.getKey(), entry.getValue(), conflicts);
        }
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(9);
        }
        if (newName == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(10);
        }
        if (conflicts == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(11);
        }
        boolean processStatics = element instanceof JSAttributeListOwner && JSPsiImplUtils.hasModifier((JSAttributeListOwner)element, JSAttributeList.ModifierType.STATIC);
        JSElement scope = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSExecutionScope.class, JSClass.class, JSObjectLiteralExpression.class});
        PsiElement existing = (PsiElement)ContainerUtil.getFirstItem(JSRefactoringUtil.findExistingInScope(newName, (PsiElement)scope, processStatics));
        if (!(existing == null || existing == element || existing instanceof JSInitializerOwner && ((JSInitializerOwner)existing).getInitializer() == element)) {
            conflicts.putValue((Object)existing, (Object)JSRefactoringUtil.getMemberAlreadyExistsMessage(existing));
        }
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        boolean isTypeScript;
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(12);
        }
        if (searchScope == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(13);
        }
        ReferencesType refType = (isTypeScript = DialectDetector.isTypeScript(element)) && !JSDefaultRenameProcessor.getSearchJavaScriptReferences(element) ? ReferencesType.TS : ReferencesType.ALL;
        return JSDefaultRenameProcessor.getReferences(element, searchScope, searchInCommentsAndStrings, refType);
    }

    @NotNull
    public static Collection<PsiReference> getReferences(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings, @NotNull ReferencesType type) {
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(14);
        }
        if (searchScope == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(15);
        }
        if (type == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(16);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection<PsiReference> collection = JSDefaultRenameProcessor.findReferencesForScope(element, searchInCommentsAndStrings, JSDefaultRenameProcessor.getScope(element, type).intersectWith(searchScope));
        if (collection == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(17);
        }
        return collection;
    }

    @NotNull
    public static SearchScope getScope(@NotNull PsiElement element, @NotNull ReferencesType type) {
        SearchScope defaultScope;
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(18);
        }
        if (type == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(19);
        }
        if (!((defaultScope = element.getUseScope()) instanceof GlobalSearchScope) || type == ReferencesType.ALL) {
            SearchScope searchScope = defaultScope;
            if (searchScope == null) {
                JSDefaultRenameProcessor.$$$reportNull$$$0(20);
            }
            return searchScope;
        }
        final boolean useJS = type == ReferencesType.JS;
        return new DelegatingGlobalSearchScope((GlobalSearchScope)defaultScope){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!super.contains(file2)) {
                    return false;
                }
                return useJS == DialectDetector.JAVASCRIPT_FILE_TYPES.contains(file2.getFileType());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor$1", "contains"));
            }
        };
    }

    public static Collection<PsiReference> findReferencesForScope(PsiElement element, boolean searchInCommentsAndStrings, SearchScope useScope) {
        return JSDefaultRenameProcessor.findReferencesForScope(element, searchInCommentsAndStrings, useScope, -1L);
    }

    @NotNull
    public static Collection<PsiReference> findReferencesForScope(PsiElement element, boolean searchInCommentsAndStrings, SearchScope useScope, long timeoutMs) {
        List<PsiReference> result2 = Collections.synchronizedList(new ArrayList());
        if (timeoutMs > 0L) {
            ProgressIndicatorUtils.withTimeout((long)timeoutMs, () -> {
                JSDefaultRenameProcessor.doFindReferencesForScope(element, searchInCommentsAndStrings, useScope, result2);
                return null;
            });
        } else {
            JSDefaultRenameProcessor.doFindReferencesForScope(element, searchInCommentsAndStrings, useScope, result2);
        }
        List<PsiReference> list2 = result2;
        if (list2 == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(21);
        }
        return list2;
    }

    private static void doFindReferencesForScope(final PsiElement element, final boolean searchInCommentsAndStrings, SearchScope useScope, @NotNull Collection<PsiReference> outResult) {
        DialectOptionHolder holder;
        if (outResult == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(22);
        }
        final boolean checkStrict = (holder = DialectDetector.dialectOfElement(element)) != null && holder.isTypeScript && !JSDefaultRenameProcessor.getSearchDynamicReferences(element);
        final boolean hasES6Imports = holder != null && (holder.isTypeScript || holder.isECMA6);
        ReferencesSearch.search((PsiElement)element, (SearchScope)useScope).forEach((Processor)new CommonProcessors.CollectProcessor<PsiReference>(outResult){

            protected boolean accept(PsiReference psiReference) {
                return JSDefaultRenameProcessor.acceptReference(psiReference, searchInCommentsAndStrings, hasES6Imports, element, checkStrict);
            }
        });
    }

    public static boolean acceptReference(@NotNull PsiReference psiReference, boolean searchInCommentsAndStrings, boolean hasES6Imports, PsiElement renameTarget, boolean checkStrictness) {
        PsiElement resolve;
        String elementName;
        if (psiReference == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(23);
        }
        if (!JSDefaultRenameProcessor.isStrictEnoughReference(psiReference)) {
            return searchInCommentsAndStrings;
        }
        if (checkStrictness && !JSResolveUtil.isResolveStrict(psiReference)) {
            return false;
        }
        PsiElement referenceElement = psiReference.getElement();
        if (JSResolveUtil.isSelfReference(renameTarget, referenceElement)) {
            return false;
        }
        if (!hasES6Imports) {
            return true;
        }
        if (renameTarget instanceof ES6ImportExportSpecifierAlias) {
            return true;
        }
        String string = elementName = renameTarget instanceof JSNamedElement ? ((JSNamedElement)renameTarget).getName() : null;
        if (referenceElement instanceof ES6ImportExportSpecifier && "default".equals(((ES6ImportExportSpecifier)referenceElement).getReferenceName())) {
            return false;
        }
        if (referenceElement instanceof JSReferenceExpression && ((JSReferenceExpression)referenceElement).getQualifier() == null || referenceElement instanceof ES6ImportExportSpecifier) {
            PsiElement item;
            ResolveResult[] results = ((PsiPolyVariantReference)referenceElement).multiResolve(false);
            if (results.length == 1 && (renameTarget.isEquivalentTo(item = results[0].getElement()) || item instanceof TypeScriptProxyImplicitElement && renameTarget.isEquivalentTo(((TypeScriptProxyImplicitElement)item).getExplicitElement()))) {
                return true;
            }
            for (ResolveResult result2 : results) {
                if (!JSDefaultRenameProcessor.importDefinesLocalName(result2.getElement(), elementName)) continue;
                return false;
            }
        }
        if (JSDefaultRenameProcessor.importDefinesLocalName(referenceElement, elementName)) {
            return false;
        }
        if (referenceElement instanceof JSXmlLiteralExpression && DialectDetector.isJSX(renameTarget) && (resolve = psiReference.resolve()) != null) {
            if (renameTarget.isEquivalentTo(resolve)) {
                return true;
            }
            if (JSDefaultRenameProcessor.importDefinesLocalName(resolve, elementName)) {
                return false;
            }
        }
        return true;
    }

    private static boolean importDefinesLocalName(@Nullable PsiElement importElement, String elementName) {
        if (importElement instanceof TypeScriptImplicitOverloadedAliasElement) {
            importElement = ((TypeScriptImplicitOverloadedAliasElement)importElement).getAliasElement();
        }
        if (importElement instanceof ES6ImportedBinding) {
            return !StringUtil.equals((CharSequence)((ES6ImportedBinding)importElement).getName(), (CharSequence)elementName);
        }
        return importElement instanceof ES6ImportExportSpecifierAlias || importElement instanceof TypeScriptImportStatement;
    }

    public static boolean isStrictEnoughReference(@NotNull PsiReference psiReference) {
        if (psiReference == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(24);
        }
        if (psiReference instanceof JSXNamespaceReference) {
            return true;
        }
        PsiElement element = psiReference.getElement();
        if (psiReference instanceof JsonPropertyNameReference) {
            return false;
        }
        if (psiReference instanceof JSLiteralTextReference) {
            return !((JSLiteralTextReference)psiReference).isTextOnlyReference();
        }
        if (!(element instanceof JSLiteralExpression) || !psiReference.isSoft()) {
            return true;
        }
        return element.getParent() instanceof JSIndexedPropertyAccessExpression;
    }

    public boolean isToSearchInComments(@NotNull PsiElement element) {
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(25);
        }
        return PropertiesComponent.getInstance().getBoolean(SEARCH_IN_COMMENTS, false);
    }

    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(26);
        }
        PropertiesComponent.getInstance().setValue(SEARCH_IN_COMMENTS, String.valueOf(enabled));
        super.setToSearchInComments(element, enabled);
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(27);
        }
        return PropertiesComponent.getInstance().getBoolean(SEARCH_FOR_TEXT_OCCURRENCES);
    }

    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element, @Nullable Editor editor) {
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(28);
        }
        if (element instanceof ImplicitJSVariableImpl) {
            return null;
        }
        element = JSDefaultRenameProcessor.substituteOverload(element);
        if ((element = this.substituteDestructuringShorthanding(element, editor, null)) == null) {
            return null;
        }
        return this.substituteShorthandedProperty(element, editor, null);
    }

    public void substituteElementToRename(@NotNull PsiElement element, @NotNull Editor editor, @NotNull Pass<PsiElement> renameCallback) {
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(29);
        }
        if (editor == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(30);
        }
        if (renameCallback == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(31);
        }
        element = JSDefaultRenameProcessor.substituteOverload(element);
        if ((element = this.substituteDestructuringShorthanding(element, editor, renameCallback)) == null) {
            return;
        }
        if ((element = this.substituteShorthandedProperty(element, editor, renameCallback)) == null) {
            return;
        }
        renameCallback.pass((Object)element);
    }

    @Nullable
    private PsiElement substituteShorthandedProperty(@NotNull PsiElement element, @Nullable Editor editor, @Nullable Pass<PsiElement> callback) {
        PsiElement valueResolveResult;
        ES6Property property;
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(32);
        }
        ES6Property eS6Property = property = element instanceof ES6Property ? (ES6Property)element : null;
        if (property == null || !property.isShorthanded() || property.getValue() == null) {
            return element;
        }
        PsiReference reference = editor != null ? TargetElementUtil.findReference((Editor)editor) : null;
        ES6Property atCaret = reference != null ? (ES6Property)PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), ES6Property.class, (boolean)false) : null;
        JSReferenceExpression referenceExpression = property.getValue() instanceof JSReferenceExpression ? (JSReferenceExpression)property.getValue() : null;
        PsiElement propertyResolveResult = (PsiElement)ObjectUtils.coalesce((Object)new PsiMultiReference(property.getReferences(), (PsiElement)property).resolve(), (Object)property);
        if (atCaret == property && referenceExpression != null && (valueResolveResult = referenceExpression.resolve()) != null) {
            String valueDescription = ElementDescriptionUtil.getElementDescription((PsiElement)valueResolveResult, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE);
            String title = JavaScriptBundle.message("javascript.rename.shorthand.target.dialog.title", valueDescription);
            String message = JavaScriptBundle.message("javascript.rename.choose.target.message", new Object[0]);
            String propertyDescription = JavaScriptBundle.message("javascript.rename.shorthand.property.description", new Object[0]);
            return this.substituteWithPopup(editor, callback, title, message, valueResolveResult, StringUtil.capitalize((String)valueDescription), propertyResolveResult, propertyDescription);
        }
        return propertyResolveResult;
    }

    @NotNull
    private static PsiElement substituteOverload(PsiElement element) {
        TypeScriptFunction impl;
        TypeScriptFunction func;
        if (element instanceof TypeScriptFunction && (func = (TypeScriptFunction)element).isOverloadDeclaration() && (impl = TypeScriptPsiUtil.getOverloadImplementation(func)) != null) {
            TypeScriptFunction typeScriptFunction = impl;
            if (typeScriptFunction == null) {
                JSDefaultRenameProcessor.$$$reportNull$$$0(33);
            }
            return typeScriptFunction;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(34);
        }
        return psiElement;
    }

    @Nullable
    private PsiElement substituteDestructuringShorthanding(@NotNull PsiElement element, @Nullable Editor editor, @Nullable Pass<PsiElement> renameCallback) {
        PsiElement shorthandedPropertyResolve;
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(35);
        }
        if (!(element instanceof JSVariable)) {
            return element;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof JSDestructuringShorthandedProperty)) {
            return element;
        }
        PsiReference propertyRef = parent.getReference();
        PsiElement psiElement = shorthandedPropertyResolve = propertyRef instanceof JSDestructuringPropertyReference ? propertyRef.resolve() : null;
        if (shorthandedPropertyResolve != null) {
            String description2 = ElementDescriptionUtil.getElementDescription((PsiElement)shorthandedPropertyResolve, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE);
            String title = JavaScriptBundle.message("javascript.rename.destructuring.target.dialog.title", description2);
            String message = JavaScriptBundle.message("javascript.rename.choose.target.message", new Object[0]);
            String initializer = JavaScriptBundle.message("javascript.destructuring.initializer", description2);
            String variable = JavaScriptBundle.message("javascript.destructuring.variable.only", new Object[0]);
            return this.substituteWithPopup(editor, renameCallback, title, message, shorthandedPropertyResolve, initializer, element, variable);
        }
        return element;
    }

    @Nullable
    @Contract(value="null,null,_,_,_,_,_,_ -> fail")
    protected PsiElement substituteWithPopup(@Nullable Editor editor, @Nullable Pass<PsiElement> renameCallback, @NlsContexts.DialogTitle @NotNull String title, @NlsContexts.DialogMessage @Nullable String message, @NotNull PsiElement defaultElement, @NlsContexts.Button @NotNull String defaultElementLabel, @NotNull PsiElement otherElement, @NlsContexts.Button @NotNull String otherElementLabel) {
        if (title == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(36);
        }
        if (defaultElement == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(37);
        }
        if (defaultElementLabel == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(38);
        }
        if (otherElement == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(39);
        }
        if (otherElementLabel == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(40);
        }
        if (defaultElement == otherElement) {
            return this.processSubstituted(defaultElement, editor, renameCallback);
        }
        if (renameCallback == null || ApplicationManager.getApplication().isUnitTestMode()) {
            boolean isOk = ((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.okCancel((String)title, (String)(message == null ? "" : message)).yesText(defaultElementLabel)).noText(otherElementLabel)).ask(defaultElement.getProject());
            return this.processSubstituted(isOk ? defaultElement : otherElement, editor, renameCallback);
        }
        assert (editor != null) : "editor must be provided for inplace rename";
        JBList list2 = new JBList((Object[])new String[]{defaultElementLabel, otherElementLabel});
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list2).setTitle(title).setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(() -> {
            String value = (String)list2.getSelectedValue();
            if (value != null) {
                PsiElement method = value.equals(defaultElementLabel) ? defaultElement : otherElement;
                this.processSubstituted(method, editor, renameCallback);
            }
        }).createPopup().showInBestPositionFor(editor);
        return null;
    }

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, final @NotNull PsiElement element, PsiElement nameSuggestionContext, Editor editor) {
        if (project == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(41);
        }
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(42);
        }
        boolean isContextTypeScript = nameSuggestionContext != null && DialectDetector.isTypeScript(nameSuggestionContext);
        boolean isElementToRenameTypeScript = DialectDetector.isTypeScript(element);
        this.myForceShowPreview = JSDefaultRenameProcessor.forcesShowPreview(element);
        if (!isContextTypeScript) {
            if (isElementToRenameTypeScript) {
                JSDefaultRenameProcessor.setSearchJavaScriptReferences(element, true);
            }
            RenameDialog renameDialog = super.createRenameDialog(project, element, nameSuggestionContext, editor);
            if (renameDialog == null) {
                JSDefaultRenameProcessor.$$$reportNull$$$0(43);
            }
            return renameDialog;
        }
        return new RenameDialog(project, element, nameSuggestionContext, editor){
            private JCheckBox myCbSearchForJSReferences;
            private JCheckBox myCbSearchForDynamicReferences;

            protected void createCheckboxes(JPanel panel2, GridBagConstraints gbConstraints) {
                gbConstraints.insets = JBUI.insetsBottom((int)4);
                gbConstraints.gridwidth = 1;
                gbConstraints.gridx = 0;
                gbConstraints.weighty = 0.0;
                gbConstraints.weightx = 1.0;
                gbConstraints.fill = 1;
                this.myCbSearchForJSReferences = new NonFocusableCheckBox(JavaScriptBundle.message("typescript.rename.javascript.references", new Object[0]));
                this.myCbSearchForJSReferences.setSelected(JSDefaultRenameProcessor.getSearchJavaScriptReferences(element));
                panel2.add((Component)this.myCbSearchForJSReferences, gbConstraints);
                this.myCbSearchForDynamicReferences = new NonFocusableCheckBox(JavaScriptBundle.message("typescript.rename.dynamic.references", new Object[0]));
                this.myCbSearchForDynamicReferences.setSelected(JSDefaultRenameProcessor.getSearchDynamicReferences(element));
                panel2.add((Component)this.myCbSearchForDynamicReferences, gbConstraints);
                super.createCheckboxes(panel2, gbConstraints);
                JCheckBox comments = this.getCbSearchInComments();
                panel2.remove(comments);
                gbConstraints.insets = JBUI.insets((int)0, (int)10, (int)4, (int)0);
                gbConstraints.gridwidth = 0;
                gbConstraints.gridx = 1;
                gbConstraints.weightx = 1.0;
                gbConstraints.fill = 1;
                panel2.add((Component)comments, gbConstraints);
            }

            protected void doAction() {
                JSDefaultRenameProcessor.setSearchJavaScriptReferences(element, this.myCbSearchForJSReferences.isSelected());
                JSDefaultRenameProcessor.setSearchDynamicReferences(element, this.myCbSearchForDynamicReferences.isSelected());
                super.doAction();
            }
        };
    }

    @Nullable
    protected PsiElement processSubstituted(@NotNull PsiElement psiElement, Editor editor, @Nullable Pass<PsiElement> renameCallback) {
        if (psiElement == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(44);
        }
        if (!PsiElementRenameHandler.canRename((Project)psiElement.getProject(), (Editor)editor, (PsiElement)psiElement)) {
            return null;
        }
        if (renameCallback != null) {
            renameCallback.pass((Object)super.substituteElementToRename(psiElement, editor));
            return null;
        }
        return psiElement;
    }

    public void renameElement(@NotNull PsiElement element, @NotNull String newName, UsageInfo @NotNull [] usages, @Nullable RefactoringElementListener listener2) throws IncorrectOperationException {
        JSDestructuringProperty destructuringProperty;
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(45);
        }
        if (newName == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(46);
        }
        if (usages == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(47);
        }
        if (element instanceof ImplicitJSVariableImpl) {
            return;
        }
        PsiElement parent = element.getParent();
        JSDestructuringProperty jSDestructuringProperty = destructuringProperty = element instanceof JSVariable && parent instanceof JSDestructuringProperty ? (JSDestructuringProperty)parent : null;
        if (destructuringProperty != null) {
            destructuringProperty = destructuringProperty.setDestructuringElementName(newName);
            element = destructuringProperty.getDestructuringElement();
        }
        JSDefaultRenameProcessor.processShorthandProperties(element, newName, usages);
        super.renameElement(element, newName, usages, listener2);
    }

    private static boolean isTopLevelElementInMatchingFile(@NotNull JSNamedElement element) {
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(48);
        }
        JSSourceElement sourceElement = null;
        if (element instanceof JSVariable) {
            sourceElement = ((JSVariable)element).getStatement();
        } else if (element.getContext() instanceof ES6ExportDefaultAssignment) {
            sourceElement = (ES6ExportDefaultAssignment)element.getContext();
        } else if (element instanceof JSSourceElement) {
            sourceElement = (JSSourceElement)((Object)element);
        }
        return sourceElement != null && sourceElement.getParent() instanceof JSFile && JSNameSuggestionsUtil.matchesFileNameRelaxed(element);
    }

    private static void processShorthandProperties(@NotNull PsiElement element, String newName, UsageInfo @NotNull [] usages) {
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(49);
        }
        if (usages == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(50);
        }
        if (element instanceof ES6Property && ((ES6Property)element).isShorthanded()) {
            ES6ChangeUtil.expandShorthandPropertyWithName((ES6Property)element, newName);
        }
        boolean isTypeMemberOrRequiresQualifiedAccess = element instanceof ES6Property || element instanceof TypeScriptTypeMember || JSUtils.isMember(element);
        List<ES6Property> shorthandUsages = JSDefaultRenameProcessor.collectShorthandPropertyUsages(ContainerUtil.mapNotNull((Object[])usages, UsageInfo::getReference));
        if (isTypeMemberOrRequiresQualifiedAccess) {
            for (ES6Property usage : shorthandUsages) {
                ES6ChangeUtil.expandShorthandPropertyWithName(usage, newName);
            }
        } else {
            for (ES6Property usage : shorthandUsages) {
                ES6ChangeUtil.expandShorthandPropertyWithValue(usage, newName);
            }
        }
    }

    @NotNull
    public UsageInfo createUsageInfo(@NotNull PsiElement element, @NotNull PsiReference ref, @NotNull PsiElement referenceElement) {
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(51);
        }
        if (ref == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(52);
        }
        if (referenceElement == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(53);
        }
        MoveRenameUsageInfo result2 = new MoveRenameUsageInfo(referenceElement, ref, ref.getRangeInElement().getStartOffset(), ref.getRangeInElement().getEndOffset(), element, JSDefaultRenameProcessor.isNonCodeUsage(ref));
        if (JSDefaultRenameProcessor.isTypeScriptMergedTypeUsage(element, ref)) {
            result2.setDynamicUsage(false);
        } else if (JSUsageViewElementsListener.checkIfJavaScriptDynamicUsage((UsageInfo)result2, Collections.singleton(element))) {
            result2.setDynamicUsage(true);
        }
        MoveRenameUsageInfo moveRenameUsageInfo = result2;
        if (moveRenameUsageInfo == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(54);
        }
        return moveRenameUsageInfo;
    }

    private static boolean isNonCodeUsage(@NotNull PsiReference ref) {
        if (ref == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(55);
        }
        if (!JSDefaultRenameProcessor.isStrictEnoughReference(ref)) {
            return true;
        }
        return ref.resolve() == null && (!(ref instanceof PsiPolyVariantReference) || ((PsiPolyVariantReference)ref).multiResolve(true).length <= 0);
    }

    private static boolean isTypeScriptMergedTypeUsage(@NotNull PsiElement element, @NotNull PsiReference ref) {
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(56);
        }
        if (ref == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(57);
        }
        if (DialectDetector.isTypeScript(element) && ref instanceof PsiPolyVariantReference) {
            ResolveResult[] resolveResults = ((PsiPolyVariantReference)ref).multiResolve(true);
            return resolveResults.length > 0 && Arrays.stream(resolveResults).allMatch(r -> r.getElement() instanceof TypeScriptProxyImplicitElement);
        }
        return false;
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(58);
        }
        PropertiesComponent.getInstance().setValue(SEARCH_FOR_TEXT_OCCURRENCES, String.valueOf(enabled));
        super.setToSearchForTextOccurrences(element, enabled);
    }

    private static boolean forcesShowPreview(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(59);
        }
        if (DialectDetector.isTypeScript(psiElement) || DialectDetector.isActionScript(psiElement)) {
            return false;
        }
        PsiFile file2 = psiElement.getContainingFile();
        return file2 != null && !JSInplaceRenameHandler.isSuitableForInplaceRename(psiElement, file2);
    }

    public boolean showRenamePreviewButton(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(60);
        }
        return !JSDefaultRenameProcessor.forcesShowPreview(psiElement);
    }

    public boolean forcesShowPreview() {
        return this.myForceShowPreview;
    }

    public static boolean getSearchJavaScriptReferences(PsiElement element) {
        return JSDefaultRenameProcessor.getSearchJavaScriptReferences(element.getProject());
    }

    public static boolean getSearchJavaScriptReferences(Project project) {
        return PropertiesComponent.getInstance((Project)project).getBoolean(SEARCH_FOR_JAVASCRIPT_OCCURRENCES, true);
    }

    public static void setSearchJavaScriptReferences(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(61);
        }
        JSDefaultRenameProcessor.setSearchJavaScriptReferences(element.getProject(), enabled);
    }

    public static void setSearchJavaScriptReferences(Project project, boolean enabled) {
        PropertiesComponent.getInstance((Project)project).setValue(SEARCH_FOR_JAVASCRIPT_OCCURRENCES, enabled, true);
    }

    public static boolean getSearchDynamicReferences(PsiElement project) {
        return PropertiesComponent.getInstance((Project)project.getProject()).getBoolean(SEARCH_FOR_DYNAMIC_OCCURRENCES, false);
    }

    public static void setSearchDynamicReferences(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(62);
        }
        Project project = element.getProject();
        JSDefaultRenameProcessor.setSearchDynamicReferences(project, enabled);
    }

    public static void setSearchDynamicReferences(@NotNull Project project, boolean enabled) {
        if (project == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(63);
        }
        PropertiesComponent.getInstance((Project)project).setValue(SEARCH_FOR_DYNAMIC_OCCURRENCES, enabled, false);
    }

    @NotNull
    public static List<ES6Property> collectShorthandPropertyUsages(@NotNull Collection<? extends PsiReference> refs) {
        if (refs == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(64);
        }
        ArrayList<ES6Property> results = new ArrayList<ES6Property>();
        for (PsiReference psiReference : refs) {
            PsiElement element = psiReference instanceof JSPropertyNameReference ? psiReference.getElement() : psiReference.getElement().getParent();
            ES6Property property = element instanceof ES6Property ? (ES6Property)element : null;
            if (property == null || !property.isShorthanded()) continue;
            results.add(property);
        }
        ArrayList<ES6Property> arrayList = results;
        if (arrayList == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(65);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 20: 
            case 21: 
            case 33: 
            case 34: 
            case 43: 
            case 54: 
            case 65: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 20: 
            case 21: 
            case 33: 
            case 34: 
            case 43: 
            case 54: 
            case 65: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 17: 
            case 20: 
            case 21: 
            case 33: 
            case 34: 
            case 43: 
            case 54: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outResult";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiReference";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renameCallback";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultElement";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultElementLabel";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherElement";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherElementLabel";
                break;
            }
            case 41: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 44: 
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 52: 
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferencesForScope";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteOverload";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenameDialog";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageInfo";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "collectShorthandPropertyUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenaming";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findExistingNameConflicts";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 17: 
            case 20: 
            case 21: 
            case 33: 
            case 34: 
            case 43: 
            case 54: 
            case 65: {
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "doFindReferencesForScope";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "acceptReference";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isStrictEnoughReference";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchInComments";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setToSearchInComments";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchForTextOccurrences";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "substituteElementToRename";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "substituteShorthandedProperty";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "substituteDestructuringShorthanding";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "substituteWithPopup";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createRenameDialog";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "processSubstituted";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "renameElement";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevelElementInMatchingFile";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "processShorthandProperties";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "createUsageInfo";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isNonCodeUsage";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isTypeScriptMergedTypeUsage";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "setToSearchForTextOccurrences";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "forcesShowPreview";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "showRenamePreviewButton";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "setSearchJavaScriptReferences";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "setSearchDynamicReferences";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "collectShorthandPropertyUsages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 20: 
            case 21: 
            case 33: 
            case 34: 
            case 43: 
            case 54: 
            case 65: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ReferencesType {
        ALL,
        TS,
        JS;

    }
}

