/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSuggestionProvider
implements NameSuggestionProvider {
    public SuggestedNameInfo getSuggestedNames(@NotNull PsiElement element, @Nullable PsiElement nameSuggestionContext, @NotNull Set<String> result2) {
        if (element == null) {
            JSSuggestionProvider.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            JSSuggestionProvider.$$$reportNull$$$0(1);
        }
        if (!(element instanceof JSVariable)) {
            return null;
        }
        PsiElement nameIdentifier = ((JSVariable)element).getNameIdentifier();
        if (nameIdentifier == null) {
            return null;
        }
        if (nameIdentifier instanceof JSExpression) {
            boolean transformToFieldName = JSResolveUtil.findParent(element) instanceof JSClass;
            for (String s : JSNameSuggestionsUtil.generateVariableNamesFromExpression((JSExpression)nameIdentifier, nameSuggestionContext, Collections.emptyList())) {
                if (transformToFieldName) {
                    s = JSRefactoringUtil.transformAccessorNameToPropertyName(s, element);
                }
                result2.add(s);
            }
        } else {
            JSType type = ((JSVariable)element).getJSType();
            if (type != null) {
                PsiElement typeElement = ((JSVariable)element).getTypeElement();
                if (typeElement instanceof JSReferenceExpression) {
                    result2.addAll(JSNameSuggestionsUtil.generateVariableNamesFromExpression((JSExpression)typeElement, nameSuggestionContext, result2));
                } else if (nameSuggestionContext != null) {
                    result2.addAll(JSNameSuggestionsUtil.generateVariableNamesFromType(type, nameSuggestionContext, Collections.emptyList()));
                }
            }
        }
        HashSet<String> names = new HashSet<String>();
        names.add(((JSVariable)element).getName());
        result2.addAll(JSNameSuggestionsUtil.generateVariableNamesAtPlace(element, names));
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/refactoring/JSSuggestionProvider";
        objectArray[2] = "getSuggestedNames";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

