/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.convertToClass;

import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.refactoring.convertToClass.JSItemToClassConvertor;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSToClassConversionConstructorFunction {
    @NotNull
    private final JSFunction myFunction;
    @NotNull
    private final String myFunctionName;
    private final Map<String, JSAssignmentExpression> myInnerProperties;
    private final Map<JSReferenceExpression, JSAssignmentExpression> myParameterAssignments;

    public JSToClassConversionConstructorFunction(@NotNull JSFunction function2, @Nullable String name) {
        if (function2 == null) {
            JSToClassConversionConstructorFunction.$$$reportNull$$$0(0);
        }
        this.myInnerProperties = new HashMap<String, JSAssignmentExpression>();
        this.myFunction = function2;
        this.myFunctionName = name == null ? StringUtil.notNullize((String)function2.getName()) : name;
        this.myParameterAssignments = new HashMap<JSReferenceExpression, JSAssignmentExpression>();
        JSBlockStatement constructorBlock = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)function2, JSBlockStatement.class);
        if (constructorBlock != null) {
            Collection assignments = PsiTreeUtil.findChildrenOfType((PsiElement)constructorBlock, JSAssignmentExpression.class);
            for (JSAssignmentExpression expression : assignments) {
                PsiElement element;
                if (expression.getDefinitionExpression() == null || !this.isThisMember((PsiElement)expression.getDefinitionExpression())) continue;
                this.myInnerProperties.put(JSPsiImplUtils.getNameOrComputedPropertyName(expression.getDefinitionExpression(), false), expression);
                JSExpression initializer = expression.getDefinitionExpression().getInitializer();
                if (!(initializer instanceof JSReferenceExpression) || (element = ((JSReferenceExpression)initializer).resolve()) == null || !element.isValid() || !(element instanceof JSParameter) || !(element.getParent() instanceof JSParameterList) || !this.myFunction.equals(element.getParent().getParent())) continue;
                this.myParameterAssignments.put((JSReferenceExpression)initializer, expression);
            }
        }
    }

    public Collection<JSAssignmentExpression> getOnlyPropertyDefinitions() {
        return ContainerUtil.filter(this.myInnerProperties.values(), assignment -> !(assignment.getDefinitionExpression().getInitializer() instanceof JSFunction));
    }

    public Collection<JSAssignmentExpression> getOnlyFunctions() {
        return ContainerUtil.filter(this.myInnerProperties.values(), assignment -> assignment.getDefinitionExpression().getInitializer() instanceof JSFunction);
    }

    @Nullable
    public JSAssignmentExpression getInnerProperty(@NotNull String key) {
        if (key == null) {
            JSToClassConversionConstructorFunction.$$$reportNull$$$0(1);
        }
        return this.myInnerProperties.get(key);
    }

    public boolean isEmpty() {
        return this.myInnerProperties.isEmpty();
    }

    @NotNull
    public String getFunctionName() {
        String string = this.myFunctionName;
        if (string == null) {
            JSToClassConversionConstructorFunction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public JSFunction getFunction() {
        JSFunction jSFunction = this.myFunction;
        if (jSFunction == null) {
            JSToClassConversionConstructorFunction.$$$reportNull$$$0(3);
        }
        return jSFunction;
    }

    private boolean isThisMember(PsiElement element) {
        if (!(element instanceof JSElementBase)) {
            return false;
        }
        JSElementBase base = (JSElementBase)element;
        return base.getNamespace() != null && (this.myFunctionName.equals(base.getNamespace().getName()) || "constructor".equals(this.myFunctionName) && this.myFunction.getParent() instanceof ES6Class && Objects.equals(((ES6Class)this.myFunction.getParent()).getName(), base.getNamespace().getName()));
    }

    public void replaceUsedParameters() {
        JSParameterListElement[] parameters;
        for (JSParameterListElement parameter : parameters = this.myFunction.getParameters()) {
            if (parameter.getName() == null) continue;
            Ref existingRebindTarget = new Ref();
            JSChangeUtil.rebindIfThereAreUsages((PsiElement)parameter, (PsiElement)this.myFunction, (Convertor<? super Collection<PsiReference>, ? extends PsiElement>)((Convertor)references -> {
                for (Object reference : references) {
                    JSAssignmentExpression expression;
                    if (!(reference instanceof PsiElement) || (expression = this.myParameterAssignments.get(reference)) == null) continue;
                    existingRebindTarget.set((Object)expression.getDefinitionExpression());
                    break;
                }
                boolean toReplace = false;
                block1: for (PsiReference reference : references) {
                    for (JSAssignmentExpression assignmentExpression : this.getOnlyFunctions()) {
                        JSExpression initializer;
                        JSExpression jSExpression = initializer = assignmentExpression.getDefinitionExpression() == null ? null : assignmentExpression.getDefinitionExpression().getInitializer();
                        if (initializer != null && reference instanceof PsiElement && PsiTreeUtil.isAncestor((PsiElement)initializer, (PsiElement)((PsiElement)reference), (boolean)false)) {
                            toReplace = true;
                            continue block1;
                        }
                        if (!toReplace) continue;
                        continue block1;
                    }
                }
                if (!toReplace) {
                    return null;
                }
                String innerName = JSCodeStyleSettings.getSettings((PsiElement)this.myFunction).FIELD_PREFIX + parameter.getName();
                return !existingRebindTarget.isNull() ? (PsiElement)existingRebindTarget.get() : JSItemToClassConvertor.addPropertyAssignment((PsiElement)this.myFunction, innerName, parameter.getName());
            }), (Processor<? super PsiReference>)((Processor)reference -> existingRebindTarget.isNull() || !reference.equals(((JSDefinitionExpression)existingRebindTarget.get()).getInitializer())));
        }
    }

    public void removeInnerProperty(@NotNull String name) {
        if (name == null) {
            JSToClassConversionConstructorFunction.$$$reportNull$$$0(4);
        }
        this.myInnerProperties.remove(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/convertToClass/JSToClassConversionConstructorFunction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/convertToClass/JSToClassConversionConstructorFunction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInnerProperty";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeInnerProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

