/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceVariable;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.refactoring.introduce.BaseIntroduceSettings;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceDialog;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.annotations.Nullable;

public abstract class JSVariableInplaceIntroducerBase
extends JSBaseInplaceIntroducer<BaseIntroduceSettings> {
    protected final boolean myIntroducingExpressionStatement;
    protected final boolean myParenthesizedExpressionStatement;
    @Nullable
    protected final DialectOptionHolder myDialectOptionHolder;

    public JSVariableInplaceIntroducerBase(Project project, Editor editor, JSExpression[] occurrences, FileType fileType, JSBaseIntroduceHandler<? extends JSElement, BaseIntroduceSettings, ? extends JSBaseIntroduceDialog> handler, JSBaseIntroduceHandler.BaseIntroduceContext<BaseIntroduceSettings> context) {
        super(project, editor, (JSExpression)context.expressionDescriptor.first, occurrences, fileType, handler, context);
        this.myIntroducingExpressionStatement = ((JSExpression)context.expressionDescriptor.first).getParent() instanceof JSExpressionStatement;
        this.myParenthesizedExpressionStatement = this.myIntroducingExpressionStatement && context.expressionDescriptor.first instanceof JSParenthesizedExpression;
        this.myDialectOptionHolder = DialectDetector.dialectOfElement((PsiElement)context.expressionDescriptor.first);
    }

    protected int getCaretOffset() {
        JSVariable variable;
        if (this.myIntroducingExpressionStatement && (variable = this.getVariable()) != null) {
            return variable.getTextOffset();
        }
        return super.getCaretOffset();
    }

    @Nullable
    public JSExpression getExpr() {
        if (this.myIntroducingExpressionStatement) {
            return null;
        }
        return (JSExpression)super.getExpr();
    }

    protected void deleteTemplateField(JSVariable psiField) {
        if (this.myIntroducingExpressionStatement) {
            JSExpressionStatement exprStatement;
            JSExpression initializer = psiField.getInitializer();
            assert (initializer != null);
            Object text = initializer.getText();
            if (this.myParenthesizedExpressionStatement) {
                text = "(" + (String)text + ")";
            }
            LOG.assertTrue((exprStatement = JSPsiElementFactory.createJSStatement((String)text, (PsiElement)initializer, JSExpressionStatement.class)).getExpression() != null, text);
            exprStatement.getExpression().replace(initializer);
            exprStatement = (JSExpressionStatement)psiField.getParent().replace((PsiElement)exprStatement);
            this.myExpr = exprStatement.getExpression();
        } else {
            JSInitializerOwner[] declarations;
            SmartPsiElementPointer pointer = SmartPointerManager.createPointer((PsiElement)((JSExpression)this.myExpr));
            PsiElement wsToDelete = null;
            JSVarStatement statement = psiField.getStatement();
            if (statement != null && (declarations = statement.getDeclarations()).length == 1 && declarations[0] == psiField) {
                wsToDelete = statement.getNextSibling();
            }
            psiField.delete();
            if (wsToDelete != null) {
                wsToDelete.delete();
            }
            this.myExpr = pointer.getElement();
        }
        this.myExprMarker = this.createMarker(this.myExpr);
        LOG.assertTrue(((JSExpression)this.myExpr).isValid());
        this.restoreRangesForSubexpression();
    }
}

