/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSLanguageServiceExecutor;
import com.intellij.lang.javascript.service.JSLanguageServiceProcessConnector;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceToolWindowInfoReporter;
import com.intellij.lang.javascript.service.JSLanguageServiceUsagesCollector;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.ThreeState;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class JSAsyncLanguageServiceBase
implements Disposable {
    public static final long ALIVE_CHECK_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    private static final int ALIVE_CHECK_COUNT_BEFORE_LONG_WAITING = 5;
    public static final String CONSOLE_ID = "Console";
    public static final String DEFAULT_TOOLWINDOW_NAME = "Language";
    @NotNull
    protected final Project myProject;
    @Nullable
    protected final JSLanguageServiceToolWindowManager myToolWindowManager;
    protected final AtomicLong myFailCount;
    @NotNull
    protected final Alarm myCheckAliveAlarm;
    private final String myDebugName;
    @NotNull
    private volatile ThreeState myCanStartProcess;
    @Nullable
    protected volatile JSLanguageServiceExecutor myExecutor;
    @NotNull
    private final Object myLock;
    @NotNull
    private final AtomicNullableLazyValue<Void> myInitialization;
    @Nullable
    protected final JSLanguageServiceQueue.ProcessConnector myProcessConnector;

    public JSAsyncLanguageServiceBase(@NotNull Project project) {
        if (project == null) {
            JSAsyncLanguageServiceBase.$$$reportNull$$$0(0);
        }
        this(project, CONSOLE_ID);
    }

    public JSAsyncLanguageServiceBase(@NotNull Project project, @NotNull String consoleId) {
        if (project == null) {
            JSAsyncLanguageServiceBase.$$$reportNull$$$0(1);
        }
        if (consoleId == null) {
            JSAsyncLanguageServiceBase.$$$reportNull$$$0(2);
        }
        this.myFailCount = new AtomicLong();
        this.myDebugName = StringUtil.trimEnd((String)StringUtil.trimEnd((String)this.getClass().getSimpleName(), (String)"Service", (boolean)true), (String)DEFAULT_TOOLWINDOW_NAME, (boolean)true);
        this.myCanStartProcess = ThreeState.UNSURE;
        this.myLock = new Object();
        this.myInitialization = AtomicNullableLazyValue.createValue(() -> {
            this.initializeOnce();
            return null;
        });
        this.myProject = project;
        this.myToolWindowManager = this.createToolWindow(project);
        this.myCheckAliveAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.myProcessConnector = this.myToolWindowManager != null ? new JSLanguageServiceProcessConnector(project, consoleId, this.myToolWindowManager) : null;
    }

    @NotNull
    public ThreeState getCanStartProcessState() {
        ThreeState threeState = this.myCanStartProcess;
        if (threeState == null) {
            JSAsyncLanguageServiceBase.$$$reportNull$$$0(3);
        }
        return threeState;
    }

    public void setCanStartProcessState(@NotNull ThreeState canStartProcess) {
        if (canStartProcess == null) {
            JSAsyncLanguageServiceBase.$$$reportNull$$$0(4);
        }
        this.myCanStartProcess = canStartProcess;
    }

    @NotNull
    protected JSLanguageServiceInfoReporter createDefaultReporter() {
        if (this.myToolWindowManager != null) {
            return new JSLanguageServiceToolWindowInfoReporter(this.myProject, this.getProcessName(), this.myToolWindowManager, false);
        }
        final String serviceDebugName = this.getDebugName();
        return new JSLanguageServiceInfoReporter(){

            @Override
            public void logCurrentErrors(@Nullable VirtualFile virtualFile, @NotNull List<JSAnnotationError> results) {
                if (results == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            @Override
            @NotNull
            public String getPresentableServiceName() {
                String string = serviceDebugName;
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            public void startingError(@NotNull String errorText) {
                if (errorText == null) {
                    1.$$$reportNull$$$0(2);
                }
            }

            @Override
            public void setProcess(@Nullable String text) {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "results";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/service/JSAsyncLanguageServiceBase$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorText";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/service/JSAsyncLanguageServiceBase$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentableServiceName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "logCurrentErrors";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "startingError";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    protected long getAliveCheckTimeout() {
        return ALIVE_CHECK_TIMEOUT;
    }

    protected long getAliveCheckLongTimeout() {
        return this.getAliveCheckTimeout() * 10L;
    }

    protected int getAliveCheckCount() {
        return 5;
    }

    protected void initializeOnce() {
        JSLanguageServiceQueue.LOGGER.debug("Run initialize once");
        JSLanguageServiceUsagesCollector.triggerServiceUsed(this.myProject, this.getClass());
        this.createAliveChecker().run();
        this.initToolWindow();
    }

    public final void initialize() {
        ReadAction.run(() -> {
            Object object = this.myLock;
            synchronized (object) {
                this.myInitialization.getValue();
            }
        });
    }

    @NotNull
    protected final Runnable createAliveChecker() {
        return new Runnable(){

            @Override
            public void run() {
                JSAsyncLanguageServiceBase.this.checkAlive(this);
            }
        };
    }

    @NotNull
    protected String getProcessName() {
        return DEFAULT_TOOLWINDOW_NAME;
    }

    @NotNull
    protected final String getDebugName() {
        String string = this.myDebugName;
        if (string == null) {
            JSAsyncLanguageServiceBase.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    protected abstract JSLanguageServiceExecutor createLanguageServiceQueue();

    protected final void checkAlive(@NotNull Runnable self) {
        if (self == null) {
            JSAsyncLanguageServiceBase.$$$reportNull$$$0(6);
        }
        if (this.myCheckAliveAlarm.isDisposed() || this.myProject.isDisposed()) {
            return;
        }
        JSLanguageServiceQueue.LOGGER.trace("Check alive is called");
        JSLanguageServiceExecutor serviceQueue = this.myExecutor;
        if (serviceQueue != null) {
            ReadAction.run(() -> {
                Object object = this.myLock;
                synchronized (object) {
                    JSLanguageServiceExecutor serviceExecutor = this.myExecutor;
                    if (serviceExecutor != null && !this.checkServiceQueueAliveUnderLock(serviceExecutor)) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            JSLanguageServiceQueue.LOGGER.debug("Dispose by alive checker");
                            this.terminateStartedProcessImpl(false, false);
                        });
                    }
                }
            });
        } else if (!this.checkCanUseService()) {
            if (this.myCanStartProcess == ThreeState.NO) {
                this.myFailCount.incrementAndGet();
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                JSLanguageServiceQueue.LOGGER.debug("Initialize by alive checker");
                this.initializeServiceQueue();
            });
        }
        if (this.myCheckAliveAlarm.isDisposed() || this.myProject.isDisposed()) {
            return;
        }
        long timeout = this.getAliveCheckTimeout();
        if (this.myFailCount.get() > (long)this.getAliveCheckCount()) {
            timeout = this.getAliveCheckLongTimeout();
        }
        this.myCheckAliveAlarm.addRequest(self, timeout);
    }

    protected boolean checkServiceQueueAliveUnderLock(@NotNull JSLanguageServiceExecutor serviceQueue) {
        if (serviceQueue == null) {
            JSAsyncLanguageServiceBase.$$$reportNull$$$0(7);
        }
        JSLanguageServiceQueue.LOGGER.trace("Check alive process queue " + serviceQueue.hashCode());
        JSLanguageServiceExecutor.State state2 = serviceQueue.getState();
        if (!serviceQueue.isValid()) {
            this.myFailCount.incrementAndGet();
            return false;
        }
        if (state2 == JSLanguageServiceExecutor.State.STARTED) {
            this.myFailCount.set(0L);
        }
        return true;
    }

    protected abstract boolean needInitToolWindow();

    @Nullable
    protected JSLanguageServiceToolWindowManager createToolWindow(Project project) {
        return null;
    }

    @Nullable
    protected JSLanguageServiceExecutor getProcess() {
        JSLanguageServiceExecutor toReturn = this.myExecutor;
        if (toReturn != null) {
            return toReturn;
        }
        return (JSLanguageServiceExecutor)ReadAction.compute(() -> {
            Object object = this.myLock;
            synchronized (object) {
                return this.computeProcessUnderLocks();
            }
        });
    }

    @Nullable
    protected final JSLanguageServiceExecutor computeProcessUnderLocks() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        JSLanguageServiceQueue.LOGGER.debug("Run compute process under locks");
        JSLanguageServiceExecutor executor = this.myExecutor;
        if (executor == null) {
            if (this.myProject.isDisposed()) {
                return null;
            }
            this.myInitialization.getValue();
            this.myExecutor = executor = this.createLanguageServiceQueue();
        }
        return executor;
    }

    protected final void initializeServiceQueue() {
        this.getProcess();
    }

    @TestOnly
    protected JSLanguageServiceExecutor getLSProcess() {
        return this.myExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public final void setLanguageService(@Nullable JSLanguageServiceExecutor executor) {
        Object object = this.myLock;
        synchronized (object) {
            this.myExecutor = executor;
        }
    }

    public final void terminateStartedProcess(boolean recreateToolWindow) {
        this.terminateStartedProcess(recreateToolWindow, false);
    }

    public final void terminateStartedProcess(boolean recreateToolWindow, boolean closeAssociatedConsoleView) {
        this.resetState();
        this.terminateStartedProcessImpl(recreateToolWindow, closeAssociatedConsoleView);
    }

    protected void initToolWindow() {
        if (this.myToolWindowManager == null || this.myProject.isDisposed() || !this.myProject.isOpen() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.myToolWindowManager.lazyInit((Condition<? super JSLanguageServiceToolWindowManager>)((Condition)el -> this.needInitToolWindow()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateStartedProcessImpl(boolean recreateToolWindow, boolean closeAssociatedConsoleView) {
        Object object = this.myLock;
        synchronized (object) {
            JSLanguageServiceToolWindowManager manager2 = this.myToolWindowManager;
            if (this.myProcessConnector != null) {
                this.myProcessConnector.disconnectFromProcessHandler(closeAssociatedConsoleView);
                JSLanguageServiceExecutor executor = this.myExecutor;
                if (manager2 != null && executor != null && executor.getState() == JSLanguageServiceExecutor.State.STARTED) {
                    manager2.cleanErrorsPanel();
                }
            }
            if (manager2 != null) {
                if (recreateToolWindow) {
                    manager2.resetToolWindow();
                } else {
                    manager2.partiallyResetToolWindow();
                }
            }
            this.disposeQueue();
            this.initToolWindow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeQueue() {
        Object object = this.myLock;
        synchronized (object) {
            JSLanguageServiceExecutor executor = this.myExecutor;
            if (executor != null) {
                if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
                    String message = String.format("Dispose queue %s with hashCode %s by terminateStartedProcess call.", this.getDebugName(), executor.hashCode());
                    JSLanguageServiceQueue.LOGGER.debug(message, new Throwable());
                }
                this.myExecutor = null;
                this.myCanStartProcess = ThreeState.UNSURE;
                Runnable disposeAction = () -> {
                    Disposer.dispose((Disposable)executor);
                    if (!this.myProject.isDisposed()) {
                        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
                    }
                };
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    disposeAction.run();
                } else {
                    ApplicationManager.getApplication().executeOnPooledThread(disposeAction);
                }
            }
        }
    }

    public boolean checkCanUseService() {
        return this.myCanStartProcess != ThreeState.NO && this.myFailCount.get() < (long)this.getAliveCheckCount();
    }

    protected void resetState() {
        this.myFailCount.set(0L);
        this.myCanStartProcess = ThreeState.UNSURE;
    }

    public void dispose() {
        JSLanguageServiceExecutor queue = this.myExecutor;
        if (queue != null) {
            Disposer.dispose((Disposable)queue);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleId";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/JSAsyncLanguageServiceBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canStartProcess";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/JSAsyncLanguageServiceBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanStartProcessState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setCanStartProcessState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkAlive";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkServiceQueueAliveUnderLock";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface JSLanguageServiceInfoReporter
    extends JSLanguageServiceQueue.ServiceInfoReporter {
        public void logCurrentErrors(@Nullable VirtualFile var1, @NotNull List<JSAnnotationError> var2);
    }
}

