/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.ecmascript6.TypeScriptTypeGuardFixHelper;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.highlighting.TypeGuardSurroundKind;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeAssignableErrorMessage;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTemplateLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCache;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSStubBasedExpressionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeGuard;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.types.TypeFromUsageDetector;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.lang.javascript.validation.fixes.ChangeJSDocTypeFix;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class JSTypeChecker {
    @NotNull
    protected final JSProblemReporter<?> myReporter;
    private static final int ERROR_COUNT_LIMIT = 3;

    public JSTypeChecker(@NotNull JSProblemReporter<?> reporter) {
        if (reporter == null) {
            JSTypeChecker.$$$reportNull$$$0(0);
        }
        this.myReporter = reporter;
    }

    public final void registerProblem(PsiElement place, @NotNull @InspectionMessage String message, @Nullable ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
        if (message == null) {
            JSTypeChecker.$$$reportNull$$$0(1);
        }
        this.myReporter.registerProblem(place, null, message, highlightType, fixes);
    }

    public final void registerProblem(PsiElement place, TextRange rangeWithin, @NotNull @InspectionMessage String message, @Nullable ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
        if (message == null) {
            JSTypeChecker.$$$reportNull$$$0(2);
        }
        this.myReporter.registerProblem(place, rangeWithin, message, highlightType, fixes);
    }

    public final void checkExpressionIsAssignableToTypeAndReportError(@Nullable JSExpression expr, @Nullable String type, @NotNull String problemKey, @Nullable PsiElement typeOwner, boolean widenLiteralTypes) {
        if (problemKey == null) {
            JSTypeChecker.$$$reportNull$$$0(3);
        }
        if ("*".equals(type) || type == null || expr == null) {
            return;
        }
        this.checkExpressionIsAssignableToTypeAndReportError(expr, JSTypeParser.createType(expr.getProject(), type, JSTypeSourceFactory.createTypeSource((PsiElement)expr)), problemKey, typeOwner, widenLiteralTypes);
    }

    public final boolean checkExpressionIsAssignableToTypeAndReportError(@Nullable JSExpression expr, @Nullable JSType jsType2, @NotNull String problemKey, @Nullable PsiElement typeOwner, boolean widenLiteralTypes) {
        if (problemKey == null) {
            JSTypeChecker.$$$reportNull$$$0(4);
        }
        ProcessingContext context = JSTypeComparingContextService.createProcessingContextWithCache((PsiElement)expr);
        return this.checkExpressionIsAssignableToTypeAndReportError(expr, jsType2, typeOwner, problemKey, context, widenLiteralTypes);
    }

    public boolean checkExpressionIsAssignableToTypeAndReportError(@Nullable JSExpression expr, @Nullable JSType jsType2, @Nullable PsiElement typeOwner, @NotNull String problemKey, @Nullable ProcessingContext context, boolean widenLiteralTypes) {
        if (problemKey == null) {
            JSTypeChecker.$$$reportNull$$$0(5);
        }
        if (this.canSkipTypeChecking((PsiElement)expr, jsType2)) {
            return true;
        }
        JSType expressionJSType = this.getExpressionTypeForChecking(expr, widenLiteralTypes);
        return this.checkExpressionIsAssignableToTypeAndReportError(expr, jsType2, typeOwner, problemKey, context, expressionJSType);
    }

    public boolean checkExpressionIsAssignableToTypeAndReportError(JSExpression expr, @Nullable JSType jsType2, @Nullable PsiElement typeOwner, @NotNull String problemKey, @Nullable ProcessingContext context, @Nullable JSType expressionJSType) {
        PsiElement typeOfTarget;
        String typeOfImmediateTarget;
        boolean isActionScript;
        if (problemKey == null) {
            JSTypeChecker.$$$reportNull$$$0(6);
        }
        if (expressionJSType == null) {
            return true;
        }
        if (this.skipByExpressionType(expr, expressionJSType)) {
            return true;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)expr);
        boolean isTypescript = holder != null && holder.isTypeScript;
        boolean bl = isActionScript = holder != null && holder.isECMA4;
        if (!isTypescript && expressionJSType instanceof JSNamedType && ((JSNamedType)expressionJSType).isStaticOrInstance() == JSContext.STATIC) {
            return true;
        }
        if (!expressionJSType.isSourceStrict() && !isActionScript) {
            return true;
        }
        if (JSResolveUtil.isAssignableJSType(jsType2, expressionJSType, context)) {
            if (isActionScript && jsType2 != null && ValidateTypesUtil.checkIfNullIsAssignedToNumeric(expr, jsType2, expressionJSType)) {
                this.registerProblem((PsiElement)expr, JavaScriptBundle.message("javascript.expression.type.implicitly.coerced.to.unrelated.type", jsType2.getTypeText(JSType.TypeTextFormat.PRESENTABLE), expressionJSType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, JSTypeChecker.getFixes(expr, jsType2, typeOwner, expressionJSType, context, holder).toArray(LocalQuickFix.EMPTY_ARRAY));
                return false;
            }
            return true;
        }
        if (holder != null && holder.isJavaScript() && JSResolveUtil.isPredefinedExtensibleType(expressionJSType) && JSResolveUtil.isAssignableJSType(expressionJSType, jsType2, context)) {
            return true;
        }
        PsiElement expressionTypeSource = expressionJSType.getSourceElement();
        PsiElement parent = JSUtils.getParentSkipParentheses(expressionTypeSource);
        if (expressionTypeSource instanceof JSObjectLiteralExpression && !(parent instanceof JSArgumentList) && !(parent instanceof JSReturnStatement) && !(parent instanceof JSFunctionExpression) && ((JSObjectLiteralExpression)expressionTypeSource).getFirstProperty() == null && JSTypeUtils.getValuableType(jsType2) instanceof JSRecordType) {
            return true;
        }
        JSExpression exprToCheckForProxy = expr;
        if (exprToCheckForProxy instanceof JSCallExpression) {
            exprToCheckForProxy = ((JSCallExpression)exprToCheckForProxy).getMethodExpression();
            if (expr instanceof JSNewExpression && exprToCheckForProxy instanceof JSArrayLiteralExpression) {
                exprToCheckForProxy = null;
            }
        }
        if (exprToCheckForProxy instanceof JSReferenceExpression) {
            exprToCheckForProxy = ((JSReferenceExpression)exprToCheckForProxy).getQualifier();
        }
        if (exprToCheckForProxy != null && !(exprToCheckForProxy instanceof JSLiteralExpression) && !isTypescript && (typeOfImmediateTarget = ActionScriptResolveUtil.getQualifiedExpressionType(exprToCheckForProxy, expr.getContainingFile())) != null && (typeOfTarget = JSResolveUtil.findType(typeOfImmediateTarget, (PsiElement)exprToCheckForProxy, true)) instanceof JSClass) {
            if ("XML".equals(typeOfImmediateTarget) || "XMLList".equals(typeOfImmediateTarget) || (holder == null || holder.isJavaScript()) && typeOfTarget instanceof XmlBackedJSClass && expr instanceof JSThisExpression) {
                return true;
            }
            JSClassResolver resolver = JSDialectSpecificHandlersFactory.forLanguage(JavaScriptSupportLoader.ECMA_SCRIPT_L4).getClassResolver();
            PsiElement parentClass = resolver.findClassByQName("flash.utils.Proxy", typeOfTarget.getResolveScope());
            if (parentClass instanceof JSClass && JSInheritanceUtil.isParentClass((JSClass)typeOfTarget, (JSClass)parentClass, false)) {
                return true;
            }
        }
        AssignableInfoData infoData = JSTypeChecker.buildAssignableErrorMessage((PsiElement)expr, jsType2, expressionJSType, holder, problemKey, context);
        String message = infoData.message;
        Collection<LocalQuickFix> fixes = JSTypeChecker.getFixes(expr, jsType2, typeOwner, expressionJSType, context, holder);
        this.registerProblem((PsiElement)expr, infoData.range, message, ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)expr), (LocalQuickFix[])ArrayUtil.mergeCollections(fixes, infoData.fixes, LocalQuickFix[]::new));
        return false;
    }

    public boolean checkTypeIsAssignableToTypeAndReportError(@NotNull PsiElement element, @NotNull JSType target, @NotNull JSType source2, @NotNull String problemKey) {
        if (element == null) {
            JSTypeChecker.$$$reportNull$$$0(7);
        }
        if (target == null) {
            JSTypeChecker.$$$reportNull$$$0(8);
        }
        if (source2 == null) {
            JSTypeChecker.$$$reportNull$$$0(9);
        }
        if (problemKey == null) {
            JSTypeChecker.$$$reportNull$$$0(10);
        }
        if (this.canSkipTypeChecking(element, target)) {
            return true;
        }
        ProcessingContext context = JSTypeComparingContextService.createProcessingContextWithCache(element);
        if (JSResolveUtil.isAssignableJSType(target, source2, context)) {
            return true;
        }
        AssignableInfoData infoData = JSTypeChecker.buildAssignableErrorMessage(element, target, source2, DialectDetector.dialectOfElement(element), problemKey, context);
        this.registerProblem(element, null, infoData.message, ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem(element), new LocalQuickFix[0]);
        return false;
    }

    protected boolean skipByExpressionType(@NotNull JSExpression expr, @Nullable JSType expressionJSType) {
        if (expr == null) {
            JSTypeChecker.$$$reportNull$$$0(11);
        }
        return false;
    }

    @Nullable
    private JSType getExpressionTypeForChecking(@Nullable JSExpression expr, boolean widenLiteralTypes) {
        JSType expressionJSType = this.getExpressionType(expr);
        if (expr != null && widenLiteralTypes) {
            JSType contextual = JSDialectSpecificHandlersFactory.findExpectedType(expr, JSExpectedTypeKind.CONTEXTUAL);
            return JSTypeUtils.expandEnumAndLiteralTypeByExpectedType(expressionJSType, contextual);
        }
        return expressionJSType;
    }

    @Nullable
    protected JSType getExpressionType(JSExpression expr) {
        JSType evaluatedType = JSResolveUtil.getExpressionJSType(expr);
        return JSCompositeTypeImpl.optimizeTypeIfComposite(evaluatedType);
    }

    protected boolean canSkipTypeChecking(@Nullable PsiElement element, @Nullable JSType jsType2) {
        if (jsType2 == null || element == null || jsType2 instanceof JSAnyType || jsType2 instanceof JSStubBasedExpressionType && ((JSStubBasedExpressionType)jsType2).findAssociatedExpression() == element) {
            return true;
        }
        if (jsType2.isJavaScript() && (jsType2 instanceof JSNullType || jsType2 instanceof JSUndefinedType)) {
            return true;
        }
        if (jsType2 instanceof JSNamedType && ((JSNamedType)jsType2).isStaticOrInstance() == JSContext.STATIC) {
            return true;
        }
        return !jsType2.isEcma() && !jsType2.isSourceStrict() && !JSTypeUtils.hasFunctionType(jsType2, false, element);
    }

    public void checkIfProperTypeReference(JSExpression rOperand) {
    }

    @NotNull
    private static Collection<LocalQuickFix> getFixes(JSExpression expr, @NotNull JSType declaredJSType, @Nullable PsiElement elementToChangeTypeOf, @NotNull JSType expressionJSType, ProcessingContext context, @Nullable DialectOptionHolder holder) {
        JSType promiseArg;
        if (declaredJSType == null) {
            JSTypeChecker.$$$reportNull$$$0(12);
        }
        if (expressionJSType == null) {
            JSTypeChecker.$$$reportNull$$$0(13);
        }
        if (expr instanceof JSSpreadExpression) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSTypeChecker.$$$reportNull$$$0(14);
            }
            return list2;
        }
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        String expressionType = JSTypeChecker.formatTypeForFix(expressionJSType, holder);
        String declaredTypeText = JSTypeChecker.formatTypeForFix(declaredJSType, holder);
        if (holder != null && (holder.isTypeScript && declaredJSType instanceof JSNamedType && !(declaredJSType instanceof JSPrimitiveLiteralType) || holder.isECMA4)) {
            LocalQuickFix insertCastFix = ValidateTypesUtil.jsInsertCastFix(declaredTypeText, expr);
            if (holder.isTypeScript) {
                if (declaredJSType.isDirectlyAssignableType(expressionJSType, context) || expressionJSType.isDirectlyAssignableType(declaredJSType, context)) {
                    fixes.add(insertCastFix);
                    fixes.add(JSFixFactory.getInstance().createInsertTypeGuardFix((PsiElement)expr, declaredJSType, new TypeScriptTypeGuardFixHelper.JSTypeGuardFixData(TypeGuardSurroundKind.IfStatement, null, null, false, true)));
                    fixes.add(JSFixFactory.getInstance().createInsertTypeGuardFix((PsiElement)expr, declaredJSType, new TypeScriptTypeGuardFixHelper.JSTypeGuardFixData(TypeGuardSurroundKind.Ternary, null, null, false, true)));
                } else if (declaredJSType instanceof JSPrimitiveType && !(declaredJSType instanceof JSLiteralType) && expressionJSType instanceof JSPrimitiveType) {
                    fixes.add(JSFixFactory.getInstance().jsInsertPrimitiveWrapperFix(declaredTypeText, expr));
                }
                if (expressionJSType instanceof JSUnionType) {
                    List<JSType> types2 = ((JSUnionType)expressionJSType).getTypes();
                    boolean hasNullOrUndefined = false;
                    boolean hasOurType = false;
                    boolean hasOtherTypes = false;
                    for (JSType part : types2) {
                        if (part.isEquivalentTo(declaredJSType, null, true)) {
                            hasOurType = true;
                            continue;
                        }
                        if (part instanceof JSNullType || part instanceof JSUndefinedType) {
                            hasNullOrUndefined = true;
                            continue;
                        }
                        hasOtherTypes = true;
                    }
                    if (hasNullOrUndefined && hasOurType && !hasOtherTypes) {
                        fixes.add(JSFixFactory.getInstance().createInsertTypeGuardFix((PsiElement)expr, new JSNullType(expressionJSType.getSource()), new TypeScriptTypeGuardFixHelper.JSTypeGuardFixData(TypeGuardSurroundKind.IfStatement, null, null, true, TypeScriptTypeGuardFixHelper.canSimplifyNullCheck(Collections.singletonList(declaredJSType)))));
                    }
                }
            } else {
                fixes.add(insertCastFix);
            }
        }
        if (holder != null && holder.isTypeScript && expr instanceof JSObjectLiteralExpression && !(declaredJSType instanceof JSPrimitiveType)) {
            if (declaredJSType.asRecordType().getProperties().stream().anyMatch(p -> p.isOptional())) {
                fixes.add(JSFixFactory.getInstance().createImplementMembersFix(expr, true));
            }
            fixes.add(JSFixFactory.getInstance().createImplementMembersFix(expr, false));
        }
        if (expressionJSType instanceof JSGenericTypeImpl && JSTypeUtils.isExactlyPromiseLikeType(expressionJSType) && (promiseArg = JSTypeUtils.getSingleGenericArgTypeFromGenericType((JSGenericTypeImpl)expressionJSType, t -> true, false)) != null && declaredJSType.isDirectlyAssignableType(promiseArg, context)) {
            fixes.add(JSFixFactory.getInstance().createInsertAwaitFix(expr, false));
        }
        ContainerUtil.addIfNotNull(fixes, (Object)ValidateTypesUtil.tryCreateInheritanceFix(declaredTypeText, expressionType, (PsiElement)expr));
        boolean hasTypes = DialectDetector.hasFeature(elementToChangeTypeOf, JSLanguageFeature.TYPES);
        if (elementToChangeTypeOf instanceof JSVariable) {
            if (expressionJSType instanceof JSVoidType) {
                ArrayList<LocalQuickFix> arrayList = fixes;
                if (arrayList == null) {
                    JSTypeChecker.$$$reportNull$$$0(15);
                }
                return arrayList;
            }
            JSVariable variable = (JSVariable)elementToChangeTypeOf;
            boolean hasJSDoc = variable.hasJSDoc();
            if (elementToChangeTypeOf instanceof JSParameter) {
                JSParameter parameter = (JSParameter)elementToChangeTypeOf;
                JSFunction function2 = parameter.getDeclaringFunction();
                if (function2 != null) {
                    boolean bl = hasJSDoc = hasJSDoc || function2.hasJSDoc();
                    if (hasTypes) {
                        if (expr.getParent() instanceof JSArgumentList) {
                            fixes.add(JSFixFactory.getInstance().changeSignatureFix(function2, (JSArgumentList)expr.getParent()));
                        } else {
                            fixes.add(JSTypeChecker.changeSignatureForSingleParameterFix(function2, parameter.getName(), expressionType));
                        }
                    }
                }
            } else if (hasTypes) {
                fixes.add(ValidateTypesUtil.changeTypeFix(variable, expressionType, "javascript.fix.change.type"));
            }
            if (!hasTypes && declaredJSType.isSourceStrict() && hasJSDoc) {
                fixes.add((LocalQuickFix)new ChangeJSDocTypeFix((JSVariable)elementToChangeTypeOf, expressionJSType));
            }
        } else if (elementToChangeTypeOf instanceof JSFunction) {
            JSFunction function3 = (JSFunction)elementToChangeTypeOf;
            JSType typeToUse = TypeFromUsageDetector.getReturnTypeInContext(expressionJSType, null, null, function3);
            if (typeToUse instanceof JSNullType || typeToUse instanceof JSUndefinedType) {
                typeToUse = JSCompositeTypeFactory.createUnionType(typeToUse.getSource(), declaredJSType, typeToUse);
            }
            if (hasTypes) {
                if (JSInheritanceUtil.participatesInMemberHierarchy(function3.getParent() instanceof JSField ? (JSField)function3.getParent() : function3)) {
                    fixes.add(JSFixFactory.getInstance().changeSignatureFix(function3, Collections.emptyMap(), JSTypeChecker.formatTypeForFix(typeToUse, holder)));
                } else {
                    fixes.add(ValidateTypesUtil.changeTypeFix(function3, JSTypeChecker.formatTypeForFix(typeToUse, holder), "javascript.fix.set.method.return.type"));
                }
            } else if (function3.hasJSDoc()) {
                fixes.add((LocalQuickFix)new ChangeJSDocTypeFix(function3, typeToUse));
            }
        }
        ArrayList<LocalQuickFix> arrayList = fixes;
        if (arrayList == null) {
            JSTypeChecker.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    public boolean checkExpressionIsAssignableToVariable(JSVariable p, @Nullable JSExpression expr, @PropertyKey(resourceBundle="messages.JavaScriptBundle") @PropertyKey(resourceBundle="messages.JavaScriptBundle") String problemKey) {
        if (!p.requiresTypeChecking()) {
            return true;
        }
        JSType variableType = p.getJSType();
        if (p instanceof JSOptionalOwner && ((JSOptionalOwner)((Object)p)).isOptional()) {
            variableType = TypeScriptTypeGuard.wrapWithUndefined(variableType, null);
        }
        return this.checkExpressionIsAssignableToTypeAndReportError(expr, variableType, problemKey, (PsiElement)p, true);
    }

    public void checkTemplateLiteralTypeSpansAssignability(@NotNull TypeScriptTemplateLiteralType literalType) {
        if (literalType == null) {
            JSTypeChecker.$$$reportNull$$$0(17);
        }
        JSType constraint = TypeScriptTypeRelations.createTemplateLiteralConstraintType(JSTypeSourceFactory.createTypeSource((PsiElement)literalType, true));
        for (TypeScriptType type : literalType.getTypes()) {
            JSType sourceType = JSTypeWithIncompleteSubstitution.substituteCompletely(type.getJSType());
            this.checkTypeIsAssignableToTypeAndReportError((PsiElement)type, constraint, sourceType, "typescript.validate.template.literal.types");
        }
    }

    public void checkTypesInReturnStatement(@NotNull JSElement returnStatementOrShorthandArrowFunctionExpression) {
        JSType actualType;
        JSExpression expression;
        JSType iterableComponentType;
        JSFunction fun;
        if (returnStatementOrShorthandArrowFunctionExpression == null) {
            JSTypeChecker.$$$reportNull$$$0(18);
        }
        if ((fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)returnStatementOrShorthandArrowFunctionExpression, JSFunction.class)) == null) {
            return;
        }
        JSType returnType = JSFunctionImpl.evaluateReturnTypeFromHierarchy(fun);
        if (returnType == null || !fun.hasExplicitlyDeclaredReturnType() && returnType == fun.getReturnType()) {
            return;
        }
        if (fun.isGenerator() && (iterableComponentType = JSTypeUtils.getIterableComponentType(returnType)) != null) {
            returnType = iterableComponentType;
        }
        if (fun.isAsync()) {
            returnType = JSTypeChecker.getAsyncFunctionReturnTypeForValidation(fun, returnType);
        }
        if (returnStatementOrShorthandArrowFunctionExpression instanceof JSReturnStatement) {
            expression = ((JSReturnStatement)returnStatementOrShorthandArrowFunctionExpression).getExpression();
            if (expression == null) {
                this.checkEmptyReturnStatement((JSReturnStatement)returnStatementOrShorthandArrowFunctionExpression, fun, returnType);
                return;
            }
        } else {
            expression = (JSExpression)returnStatementOrShorthandArrowFunctionExpression;
        }
        if (returnType instanceof JSVoidType && (actualType = JSResolveUtil.getExpressionJSType(expression)) != null && !(actualType instanceof JSVoidType)) {
            this.registerProblem((PsiElement)returnStatementOrShorthandArrowFunctionExpression, JavaScriptBundle.message("javascript.cannot.return.expression.from.function.with.void.result.type", new Object[0]), ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)returnStatementOrShorthandArrowFunctionExpression), ValidateTypesUtil.removeASTNodeFix((PsiElement)expression, "javascript.cannot.return.expression.from.function.with.void.result.type.fix"), ValidateTypesUtil.changeTypeFix(fun, actualType.getTypeText(JSType.TypeTextFormat.CODE), "javascript.fix.set.method.return.type"));
            return;
        }
        this.checkExpressionIsAssignableToTypeAndReportError(expression, returnType, "javascript.returned.expression.type.mismatch", (PsiElement)fun, true);
    }

    private void checkEmptyReturnStatement(@NotNull JSReturnStatement node, @NotNull JSFunction function2, @NotNull JSType returnType) {
        if (node == null) {
            JSTypeChecker.$$$reportNull$$$0(19);
        }
        if (function2 == null) {
            JSTypeChecker.$$$reportNull$$$0(20);
        }
        if (returnType == null) {
            JSTypeChecker.$$$reportNull$$$0(21);
        }
        if (!ValidateTypesUtil.emptyReturnIsAcceptable(function2, returnType)) {
            String message = JavaScriptBundle.message("javascript.validation.message.return.value.of.type.is.required", returnType.getTypeText(JSType.TypeTextFormat.PRESENTABLE));
            ProblemHighlightType highlightType = ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)node);
            this.registerProblem((PsiElement)node, message, highlightType, new LocalQuickFix[0]);
        }
    }

    @NotNull
    protected static JSType getAsyncFunctionReturnTypeForValidation(@NotNull JSFunction function2, @NotNull JSType declaredType) {
        if (function2 == null) {
            JSTypeChecker.$$$reportNull$$$0(22);
        }
        if (declaredType == null) {
            JSTypeChecker.$$$reportNull$$$0(23);
        }
        declaredType = JSTypeUtils.getValuableType(declaredType);
        JSTypeSource typeSource = declaredType.getSource();
        JSType componentType = JSTypeUtils.getPromiseComponentTypeOrNull(declaredType);
        if (componentType == null) {
            componentType = JSAnyType.get((PsiElement)function2, typeSource.isStrict());
        }
        JSType jSType = JSCompositeTypeFactory.createUnionType(typeSource, declaredType, componentType);
        if (jSType == null) {
            JSTypeChecker.$$$reportNull$$$0(24);
        }
        return jSType;
    }

    @NotNull
    public static String formatTypeForFix(@NotNull JSType jsType2, @NotNull PsiElement context) {
        if (jsType2 == null) {
            JSTypeChecker.$$$reportNull$$$0(25);
        }
        if (context == null) {
            JSTypeChecker.$$$reportNull$$$0(26);
        }
        return JSTypeChecker.formatTypeForFix(jsType2, DialectDetector.dialectOfElement(context));
    }

    @NotNull
    private static String formatTypeForFix(@NotNull JSType jsType2, @Nullable DialectOptionHolder holder) {
        if (jsType2 == null) {
            JSTypeChecker.$$$reportNull$$$0(27);
        }
        if (holder != null && holder.isECMA4) {
            String string = jsType2.getResolvedTypeText();
            if (string == null) {
                JSTypeChecker.$$$reportNull$$$0(28);
            }
            return string;
        }
        String string = jsType2.getTypeText(JSType.TypeTextFormat.CODE);
        if (string == null) {
            JSTypeChecker.$$$reportNull$$$0(29);
        }
        return string;
    }

    public void checkTypesInForIn(@NotNull JSForInStatement node) {
        if (node == null) {
            JSTypeChecker.$$$reportNull$$$0(30);
        }
    }

    @NotNull
    private static AssignableInfoData buildAssignableErrorMessage(@NotNull PsiElement element, @NotNull JSType jsType2, @NotNull JSType elementType, @Nullable DialectOptionHolder holder, @NotNull String problemKey, @Nullable ProcessingContext context) {
        if (element == null) {
            JSTypeChecker.$$$reportNull$$$0(31);
        }
        if (jsType2 == null) {
            JSTypeChecker.$$$reportNull$$$0(32);
        }
        if (elementType == null) {
            JSTypeChecker.$$$reportNull$$$0(33);
        }
        if (problemKey == null) {
            JSTypeChecker.$$$reportNull$$$0(34);
        }
        Project project = element.getProject();
        String jsTypeText = jsType2.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        String elementTypeText = elementType.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        String message = JavaScriptBundle.message(problemKey, jsTypeText, elementTypeText);
        if (holder == null || holder.isECMA4 || holder.isTypeScript && TypeScriptCompilerSettings.getSettings(project).useService() && !ApplicationManager.getApplication().isUnitTestMode() || jsType2.isJavaScript() && elementType.isJavaScript()) {
            return new AssignableInfoData(message);
        }
        ProcessingContext newContext = context == null ? new ProcessingContext() : JSTypeBaseImpl.copyProcessingContextWithoutComparingCache(context);
        JSTypeAssignableErrorMessage.startTracking(newContext);
        newContext.put(JSTypeComparingContextService.TYPE_COMPARATOR, (Object)new JSTypeComparingCache());
        if (JSResolveUtil.isAssignableJSType(jsType2, elementType, newContext)) {
            Logger.getInstance(JSTypeChecker.class).error("Comparing returned different value without cache in " + element.getContainingFile().getVirtualFile().getPath() + ": " + jsTypeText + ", " + elementTypeText);
            return new AssignableInfoData(message);
        }
        List texts = (List)newContext.get(JSTypeAssignableErrorMessage.NOT_ASSIGNABLE_CHAIN_KEY);
        if (texts == null || texts.isEmpty()) {
            return new AssignableInfoData(message);
        }
        String tautologyMessage = JavaScriptBundle.message("javascript.type.is.not.assignable.to.type", jsTypeText, elementTypeText);
        Stream<@InspectionMessage String> distinct = ContainerUtil.reverse((List)texts).stream().limit(3L).map(el -> el.getText()).filter(s -> !s.equals(tautologyMessage)).distinct();
        HtmlBuilder builder = new HtmlBuilder();
        builder.append(message);
        if (texts.size() > 4) {
            builder.append((HtmlChunk)HtmlChunk.br()).append("...");
        }
        IntRef spacesCount = new IntRef(1);
        distinct.forEach(el -> {
            builder.append((HtmlChunk)HtmlChunk.br()).append(HtmlChunk.nbsp((int)(spacesCount.get() * 2))).append(el);
            spacesCount.inc();
        });
        SmartList fixes = new SmartList();
        for (JSTypeAssignableErrorMessage text : texts) {
            Pair<String, String[]> keyAndArgs = text.getProblemKeyAndArgs();
            if (keyAndArgs == null) continue;
            JSTypeChecker.addFixesByInfoKey(jsType2, element, (List<LocalQuickFix>)fixes, (String)keyAndArgs.first, (String[])keyAndArgs.second);
        }
        return new AssignableInfoData(builder.wrapWith("html").toString(), texts.size() == 1 ? ((JSTypeAssignableErrorMessage)texts.get(0)).getCustomErrorRange(element) : null, (List<LocalQuickFix>)fixes);
    }

    private static void addFixesByInfoKey(@NotNull JSType jsType2, @NotNull PsiElement element, List<LocalQuickFix> fixes, @PropertyKey(resourceBundle="messages.JavaScriptBundle") @PropertyKey(resourceBundle="messages.JavaScriptBundle") String key, String[] second) {
        if (jsType2 == null) {
            JSTypeChecker.$$$reportNull$$$0(35);
        }
        if (element == null) {
            JSTypeChecker.$$$reportNull$$$0(36);
        }
        switch (key) {
            case "javascript.known.props.only": {
                if (!(element instanceof JSObjectLiteralExpression) || second.length != 1) {
                    return;
                }
                String desc = second[0];
                List names = ContainerUtil.map((Collection)StringUtil.split((String)desc, (String)","), s -> StringUtil.unquoteString((String)s.trim(), (char)'\''));
                JSType valuableType = JSTypeUtils.getValuableType(jsType2);
                List<JSType> allTypes = valuableType instanceof JSUnionOrIntersectionType ? ((JSUnionOrIntersectionType)valuableType).getTypes() : Collections.singletonList(valuableType);
                for (JSType type : allTypes) {
                    Collection<JSClass> classes;
                    if (type instanceof JSGenericTypeImpl) {
                        type = ((JSGenericTypeImpl)type).getType();
                    }
                    if (!(type instanceof JSResolvableType) || (classes = ((JSResolvableType)type).resolveType().getDeclarationsOfType(JSClass.class)).size() != 1 || classes.iterator().next() instanceof TypeScriptTypeAlias) continue;
                    fixes.add(JSFixFactory.getInstance().createAddTypeMembersByLiteralFix((JSObjectLiteralExpression)element, names, classes.iterator().next()));
                }
                break;
            }
        }
    }

    private static LocalQuickFix changeSignatureForSingleParameterFix(JSFunction function2, String name, String type) {
        Map parameters = ContainerUtil.newHashMap((Pair)Pair.create((Object)name, (Object)type), (Pair[])new Pair[0]);
        return JSFixFactory.getInstance().changeSignatureFix(function2, parameters, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 24: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 24: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemKey";
                break;
            }
            case 7: 
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredJSType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionJSType";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 24: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/JSTypeChecker";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnStatementOrShorthandArrowFunctionExpression";
                break;
            }
            case 19: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredType";
                break;
            }
            case 25: 
            case 27: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsType";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/JSTypeChecker";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsyncFunctionReturnTypeForValidation";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTypeForFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkExpressionIsAssignableToTypeAndReportError";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkTypeIsAssignableToTypeAndReportError";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "skipByExpressionType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFixes";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 24: 
            case 28: 
            case 29: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkTemplateLiteralTypeSpansAssignability";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkTypesInReturnStatement";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkEmptyReturnStatement";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAsyncFunctionReturnTypeForValidation";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "formatTypeForFix";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "checkTypesInForIn";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "buildAssignableErrorMessage";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addFixesByInfoKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 24: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class AssignableInfoData {
        @NotNull
        final @InspectionMessage String message;
        @Nullable
        final TextRange range;
        @NotNull
        final List<LocalQuickFix> fixes;

        private AssignableInfoData(@NotNull @InspectionMessage String message) {
            if (message == null) {
                AssignableInfoData.$$$reportNull$$$0(0);
            }
            this(message, null, Collections.emptyList());
        }

        private AssignableInfoData(@NotNull @InspectionMessage String message, @Nullable TextRange range, @NotNull List<LocalQuickFix> fixes) {
            if (message == null) {
                AssignableInfoData.$$$reportNull$$$0(1);
            }
            if (fixes == null) {
                AssignableInfoData.$$$reportNull$$$0(2);
            }
            this.message = message;
            this.range = range;
            this.fixes = fixes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fixes";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/validation/JSTypeChecker$AssignableInfoData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

