/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.ui.TypeScriptServerServiceSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptCompilerSettingsTracker
implements ModificationTracker {
    @NotNull
    private final Project myProject;
    @Nullable
    private volatile TypeScriptCompilerSettings mySettings;
    private final NotNullLazyValue<List<TypeScriptServerServiceSettings>> myAdditionalSettings;

    public static TypeScriptCompilerSettingsTracker getInstance(@NotNull Project project) {
        if (project == null) {
            TypeScriptCompilerSettingsTracker.$$$reportNull$$$0(0);
        }
        return (TypeScriptCompilerSettingsTracker)project.getService(TypeScriptCompilerSettingsTracker.class);
    }

    public TypeScriptCompilerSettingsTracker(@NotNull Project project) {
        if (project == null) {
            TypeScriptCompilerSettingsTracker.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myAdditionalSettings = NotNullLazyValue.atomicLazy(() -> TypeScriptCompilerSettingsTracker.getAdditionalSettings(this.myProject));
    }

    @NotNull
    private TypeScriptCompilerSettings getSettings() {
        TypeScriptCompilerSettings settings = this.mySettings;
        if (settings == null) {
            this.mySettings = settings = TypeScriptCompilerSettings.getSettings(this.myProject);
        }
        TypeScriptCompilerSettings typeScriptCompilerSettings = settings;
        if (typeScriptCompilerSettings == null) {
            TypeScriptCompilerSettingsTracker.$$$reportNull$$$0(2);
        }
        return typeScriptCompilerSettings;
    }

    public long getModificationCount() {
        long result2 = this.getSettings().getModificationCount();
        long additional = 0L;
        if (!((List)this.myAdditionalSettings.getValue()).isEmpty()) {
            additional = ((List)this.myAdditionalSettings.getValue()).stream().mapToLong(el -> el.getModificationTracker().getModificationCount()).sum();
        }
        return result2 + additional;
    }

    @NotNull
    public static List<TypeScriptServerServiceSettings> getAdditionalSettings(@NotNull Project project) {
        if (project == null) {
            TypeScriptCompilerSettingsTracker.$$$reportNull$$$0(3);
        }
        if (project.isDefault()) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                TypeScriptCompilerSettingsTracker.$$$reportNull$$$0(4);
            }
            return list2;
        }
        List list3 = StreamEx.of(TypeScriptCompilerService.getAll(project)).map(el -> el.getServiceSettings()).nonNull().toList();
        if (list3 == null) {
            TypeScriptCompilerSettingsTracker.$$$reportNull$$$0(5);
        }
        return list3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/TypeScriptCompilerSettingsTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/TypeScriptCompilerSettingsTracker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

