/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.library;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptServiceDirectoryWatcher {
    public static final String TS_EXTERNAL_DIRECTORY_PATH = "ts.external.directory.path";
    @NotNull
    private final Project myProject;
    @NotNull
    private final TypeScriptCompilerSettings mySettings;
    @NotNull
    private final List<Listener> myListeners;

    @NotNull
    public static TypeScriptServiceDirectoryWatcher getService(@NotNull Project project) {
        if (project == null) {
            TypeScriptServiceDirectoryWatcher.$$$reportNull$$$0(0);
        }
        TypeScriptServiceDirectoryWatcher typeScriptServiceDirectoryWatcher = (TypeScriptServiceDirectoryWatcher)project.getService(TypeScriptServiceDirectoryWatcher.class);
        if (typeScriptServiceDirectoryWatcher == null) {
            TypeScriptServiceDirectoryWatcher.$$$reportNull$$$0(1);
        }
        return typeScriptServiceDirectoryWatcher;
    }

    public TypeScriptServiceDirectoryWatcher(@NotNull Project project) {
        if (project == null) {
            TypeScriptServiceDirectoryWatcher.$$$reportNull$$$0(2);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project;
        this.mySettings = TypeScriptCompilerSettings.getSettings(project);
    }

    @Nullable
    public String getCachedCustomServiceDirectory() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.myProject.isDefault() || this.useDefaultService() && !ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        String value = PropertiesComponent.getInstance((Project)this.myProject).getValue(TS_EXTERNAL_DIRECTORY_PATH);
        return value != null && VirtualFileManager.extractProtocol((String)value) == null ? FileUtil.toSystemDependentName((String)value) : value;
    }

    @NotNull
    public String calcServiceDirectoryAndRefresh() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        String path2 = this.calcServiceDirectoryImpl();
        return this.refreshAndCacheValue(path2);
    }

    @NotNull
    public String getDefaultServicePath() {
        String string = TypeScriptCompilerSettings.getOSDependTypeScriptServicesPathByDirectory(this.mySettings.getDefaultTypeScriptServiceDirectory());
        if (string == null) {
            TypeScriptServiceDirectoryWatcher.$$$reportNull$$$0(3);
        }
        return string;
    }

    private boolean useDefaultService() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.myProject.isDisposed() || this.myProject.isDefault() || !this.mySettings.useService()) {
            return true;
        }
        return this.mySettings.getVersionType() == TypeScriptCompilerSettings.TypeScriptCompilerVersionType.EMBEDDED;
    }

    @NotNull
    private String refreshAndCacheValue(@NotNull String pathOrUrl) {
        if (pathOrUrl == null) {
            TypeScriptServiceDirectoryWatcher.$$$reportNull$$$0(4);
        }
        if (this.myProject.isDefault()) {
            String string = pathOrUrl;
            if (string == null) {
                TypeScriptServiceDirectoryWatcher.$$$reportNull$$$0(5);
            }
            return string;
        }
        String cachedCustomServiceDirectory = this.getCachedCustomServiceDirectory();
        if (!pathOrUrl.equals(cachedCustomServiceDirectory)) {
            PropertiesComponent.getInstance((Project)this.myProject).setValue(TS_EXTERNAL_DIRECTORY_PATH, pathOrUrl);
            ApplicationManager.getApplication().invokeLater(() -> this.update(), this.myProject.getDisposed());
        }
        String string = pathOrUrl;
        if (string == null) {
            TypeScriptServiceDirectoryWatcher.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private String calcServiceDirectoryImpl() {
        if (this.useDefaultService()) {
            String string = this.getDefaultServicePath();
            if (string == null) {
                TypeScriptServiceDirectoryWatcher.$$$reportNull$$$0(7);
            }
            return string;
        }
        String directory = TypeScriptLanguageServiceUtil.getActualLibDirectory(this.myProject, this.mySettings);
        if (!StringUtil.isEmpty((String)directory)) {
            String string = FileUtil.toSystemDependentName((String)directory);
            if (string == null) {
                TypeScriptServiceDirectoryWatcher.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = this.getDefaultServicePath();
        if (string == null) {
            TypeScriptServiceDirectoryWatcher.$$$reportNull$$$0(9);
        }
        return string;
    }

    public void update() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myListeners.forEach(Listener::updated);
    }

    public void addListener(@NotNull Listener listener2) {
        if (listener2 == null) {
            TypeScriptServiceDirectoryWatcher.$$$reportNull$$$0(10);
        }
        this.myListeners.add(listener2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/library/TypeScriptServiceDirectoryWatcher";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathOrUrl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/library/TypeScriptServiceDirectoryWatcher";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultServicePath";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshAndCacheValue";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "calcServiceDirectoryImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getService";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndCacheValue";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface Listener {
        public void updated();
    }
}

