/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.typescript.resolve.GlobalSearchScopeWithIdFilter;
import com.intellij.lang.typescript.tsconfig.JSConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigsChangedListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.indexing.IdFilter;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TypeScriptConfigService
extends JSConfigService {
    public boolean isAccessible(@NotNull VirtualFile var1, @NotNull VirtualFile var2);

    @NotNull
    public Condition<VirtualFile> getAccessScope(@NotNull VirtualFile var1);

    @NotNull
    public IntPredicate getFilterId(@NotNull VirtualFile var1);

    @Nullable
    public TypeScriptConfig getPreferableConfig(@Nullable VirtualFile var1);

    @Nullable
    @ApiStatus.Experimental
    public TypeScriptConfig getPreferableOrParentConfig(@Nullable VirtualFile var1);

    @Nullable
    @ApiStatus.Experimental
    public TypeScriptConfig getDirectIncludePreferableConfig(@Nullable VirtualFile var1);

    @NotNull
    public List<VirtualFile> getRootConfigFiles();

    default public boolean configGraphIncludesFile(@NotNull VirtualFile file2, @NotNull TypeScriptConfig tsConfig) {
        if (file2 == null) {
            TypeScriptConfigService.$$$reportNull$$$0(0);
        }
        if (tsConfig == null) {
            TypeScriptConfigService.$$$reportNull$$$0(1);
        }
        return tsConfig.getInclude().accept(file2);
    }

    @Nullable
    public TypeScriptConfig parseConfigFile(@Nullable VirtualFile var1);

    @NotNull
    public ModificationTracker getConfigTracker(@Nullable VirtualFile var1);

    @NotNull
    public ModificationTracker getTracker();

    public boolean isImplicitIncludedNodeModulesFile(@NotNull Project var1, @NotNull VirtualFile var2, @NotNull VirtualFile var3);

    @NotNull
    public Set<VirtualFile> getIncludedFiles(@NotNull VirtualFile var1);

    @Deprecated
    @NotNull
    public List<VirtualFile> getConfigFiles();

    @Deprecated
    public void addChangeListener(@NotNull TypeScriptConfigsChangedListener var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "tsConfig";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigService";
        objectArray[2] = "configGraphIncludesFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Provider {
        public static boolean isAccessible(@NotNull Project project, @NotNull VirtualFile scope, @NotNull VirtualFile referencedFile) {
            if (project == null) {
                Provider.$$$reportNull$$$0(0);
            }
            if (scope == null) {
                Provider.$$$reportNull$$$0(1);
            }
            if (referencedFile == null) {
                Provider.$$$reportNull$$$0(2);
            }
            TypeScriptConfigService service = Provider.get(project);
            return service.isAccessible(scope, referencedFile);
        }

        @NotNull
        public static TypeScriptConfigService get(@NotNull Project project) {
            if (project == null) {
                Provider.$$$reportNull$$$0(3);
            }
            TypeScriptConfigService typeScriptConfigService = (TypeScriptConfigService)project.getService(TypeScriptConfigService.class);
            if (typeScriptConfigService == null) {
                Provider.$$$reportNull$$$0(4);
            }
            return typeScriptConfigService;
        }

        public static boolean isAccessible(@NotNull PsiElement source2, @NotNull PsiElement reference) {
            if (source2 == null) {
                Provider.$$$reportNull$$$0(5);
            }
            if (reference == null) {
                Provider.$$$reportNull$$$0(6);
            }
            VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)source2);
            VirtualFile ref = PsiUtilCore.getVirtualFile((PsiElement)reference);
            if (file2 == null || ref == null) {
                return true;
            }
            return Provider.isAccessible(source2.getProject(), file2, ref);
        }

        public static GlobalSearchScope getConfigResolveScope(@NotNull PsiElement context) {
            if (context == null) {
                Provider.$$$reportNull$$$0(7);
            }
            Project project = context.getProject();
            GlobalSearchScope defaultScope = JSResolveUtil.getResolveScope(context);
            if (!Provider.checkProject(project)) {
                return defaultScope;
            }
            TypeScriptConfigService service = Provider.get(project);
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)context);
            if (virtualFile == null) {
                return defaultScope;
            }
            final IntPredicate predicate = service.getFilterId(virtualFile);
            IdFilter filter = new IdFilter(){

                public boolean containsFileId(int id) {
                    return predicate.contains(id);
                }
            };
            return new GlobalSearchScopeWithIdFilter(defaultScope, filter);
        }

        private static boolean checkProject(@Nullable Project project) {
            return project != null && !project.isDefault() && !project.isDisposed();
        }

        public static TypeScriptConfig parseConfigFile(Project project, @Nullable VirtualFile file2) {
            if (file2 == null || !Provider.checkProject(project)) {
                return null;
            }
            TypeScriptConfigService service = Provider.get(project);
            return service.parseConfigFile(file2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referencedFile";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigService$Provider";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigService$Provider";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isAccessible";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
                case 4: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getConfigResolveScope";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @FunctionalInterface
    public static interface IntPredicate {
        public boolean contains(int var1);
    }
}

