/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig.graph;

import com.intellij.lang.typescript.tsconfig.TypeScriptFileImports;
import com.intellij.lang.typescript.tsconfig.graph.TypeScriptConfigGraphCache;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.graph.Graph;
import com.intellij.util.keyFMap.KeyFMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptImportGraph
implements Graph<VirtualFile> {
    private int[] myRootNodes;
    private KeyFMap myUserData;
    @NotNull
    private final Int2ObjectMap<IntList> myOutEdges;
    @NotNull
    private final Int2ObjectMap<IntList> myInEdges;
    @NotNull
    private final Int2ObjectMap<VirtualFile> myIds;
    @NotNull
    private final TypeScriptFileImports mySearcher;
    private final AtomicBoolean myInitialized;
    private final ReentrantReadWriteLock myLock;

    public TypeScriptImportGraph(@NotNull TypeScriptFileImports searcher) {
        if (searcher == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(0);
        }
        this.myInitialized = new AtomicBoolean(false);
        this.myLock = new ReentrantReadWriteLock();
        this.myOutEdges = new Int2ObjectOpenHashMap();
        this.myInEdges = new Int2ObjectOpenHashMap();
        this.mySearcher = searcher;
        this.myIds = new Int2ObjectOpenHashMap();
        this.myUserData = KeyFMap.EMPTY_MAP;
    }

    public TypeScriptImportGraph initialize() {
        this.initialize(false);
        return this;
    }

    public boolean initialize(boolean tryOnly) {
        if (this.myInitialized.get()) {
            return true;
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.myLock.writeLock();
        if (tryOnly) {
            if (!writeLock.tryLock()) {
                return false;
            }
            return this.runUnderWriteLock(writeLock);
        }
        ProgressIndicatorUtils.awaitWithCheckCanceled((Lock)writeLock, (int)10, (TimeUnit)TimeUnit.MILLISECONDS);
        return this.runUnderWriteLock(writeLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void putUserData(@NotNull Key<T> key, @NotNull T value) {
        if (key == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(1);
        }
        if (value == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(2);
        }
        ReentrantReadWriteLock.WriteLock lock = this.myLock.writeLock();
        lock.lock();
        try {
            this.myUserData = this.myUserData.plus(key, value);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(3);
        }
        ReentrantReadWriteLock.ReadLock lock = this.myLock.readLock();
        lock.lock();
        try {
            Object object = this.myUserData.get(key);
            return (T)object;
        }
        finally {
            lock.unlock();
        }
    }

    private boolean runUnderWriteLock(@NotNull Lock writeLock) {
        if (writeLock == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(4);
        }
        try {
            if (this.myInitialized.get()) {
                boolean bl = true;
                return bl;
            }
            TypeScriptImportGraph.logStartGraphBuilding(this.mySearcher);
            Set<VirtualFile> files = this.mySearcher.getRootFiles();
            this.myRootNodes = TypeScriptImportGraph.extractIdsForFiles(files);
            ProgressManager.checkCanceled();
            this.add(files, true);
            this.myInitialized.set(true);
            TypeScriptImportGraph.logEndGraphBuilding(this);
        }
        catch (ProcessCanceledException e) {
            this.resetGraph();
            throw e;
        }
        finally {
            writeLock.unlock();
        }
        return false;
    }

    private static int[] extractIdsForFiles(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(5);
        }
        return StreamEx.of(files).mapToInt(TypeScriptImportGraph::getFileId).toArray();
    }

    @NotNull
    public Collection<VirtualFile> getRoots() {
        this.initialize();
        ReentrantReadWriteLock.ReadLock lock = this.myLock.readLock();
        lock.lock();
        Set<VirtualFile> set = this.copyAsFiles(this.myRootNodes);
        Set<VirtualFile> set2 = set;
        if (set2 == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(6);
        }
        return set2;
        finally {
            lock.unlock();
        }
    }

    @NotNull
    private Set<VirtualFile> copyAsFiles(int @NotNull [] elements) {
        if (elements == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(7);
        }
        Set<VirtualFile> set = IntStream.of(elements).mapToObj(el -> this.getNode(el)).collect(Collectors.toSet());
        if (set == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    private Set<VirtualFile> copyAsFiles(IntCollection elements) {
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>(elements.size());
        IntIterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            result2.add(this.getNode(iterator.nextInt()));
        }
        HashSet<VirtualFile> hashSet = result2;
        if (hashSet == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(9);
        }
        return hashSet;
    }

    @NotNull
    public Set<VirtualFile> getNodes() {
        this.initialize();
        ReentrantReadWriteLock.ReadLock lock = this.myLock.readLock();
        lock.lock();
        Set<VirtualFile> set = this.copyAsFiles((IntCollection)this.myIds.keySet());
        Set<VirtualFile> set2 = set;
        if (set2 == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(10);
        }
        return set2;
        finally {
            lock.unlock();
        }
    }

    public boolean isInitialized() {
        return this.myInitialized.get();
    }

    public boolean containsFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(11);
        }
        return this.containsId(TypeScriptImportGraph.getFileId(file2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsId(int fileId) {
        this.initialize();
        ReentrantReadWriteLock.ReadLock lock = this.myLock.readLock();
        lock.lock();
        try {
            boolean bl = this.myIds.containsKey(fileId);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public void recalculateEdges(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(12);
        }
        TypeScriptImportGraph.logStartGraphUpdating(this, file2);
        this.initialize();
        this.validate(file2);
        Set<VirtualFile> newFiles = this.mySearcher.getOutFiles(file2);
        this.recalculateEdges(file2, newFiles);
        TypeScriptImportGraph.logEndGraphUpdating(this);
    }

    @NotNull
    public Iterator<VirtualFile> getIn(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(13);
        }
        this.initialize();
        Iterator<VirtualFile> iterator = this.getValueUnderLock(file2, this.myInEdges).iterator();
        if (iterator == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(14);
        }
        return iterator;
    }

    @NotNull
    public Iterator<VirtualFile> getOut(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(15);
        }
        this.initialize();
        Iterator<VirtualFile> iterator = this.getValueUnderLock(file2, this.myOutEdges).iterator();
        if (iterator == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(16);
        }
        return iterator;
    }

    @NotNull
    public TypeScriptFileImports getFileImports() {
        TypeScriptFileImports typeScriptFileImports = this.mySearcher;
        if (typeScriptFileImports == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(17);
        }
        return typeScriptFileImports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Set<VirtualFile> getValueUnderLock(@NotNull VirtualFile file2, Int2ObjectMap<IntList> mapFrom) {
        if (file2 == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(18);
        }
        ReentrantReadWriteLock.ReadLock lock = this.myLock.readLock();
        lock.lock();
        Set<VirtualFile> set = this.copyAsFiles((IntCollection)TypeScriptImportGraph.getOrDefault(mapFrom, TypeScriptImportGraph.getFileId(file2)));
        Set<VirtualFile> set2 = set;
        if (set2 == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(19);
        }
        return set2;
        finally {
            lock.unlock();
        }
    }

    public boolean includesInPattern(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(20);
        }
        return this.mySearcher.includesInPattern(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalculateEdges(@NotNull VirtualFile file2, @NotNull Set<VirtualFile> newOutFiles) {
        if (file2 == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(21);
        }
        if (newOutFiles == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(22);
        }
        int fileId = TypeScriptImportGraph.getFileId(file2);
        Set<VirtualFile> oldOutFiles = this.getValueUnderLock(file2, this.myOutEdges);
        if (oldOutFiles.size() == newOutFiles.size() && newOutFiles.containsAll(oldOutFiles)) {
            return;
        }
        ReentrantReadWriteLock.WriteLock lock = this.myLock.writeLock();
        lock.lock();
        try {
            this.removeOutNodesRecursive(fileId);
            this.add(file2, newOutFiles);
            this.removeNotAvailableFromRoots();
            this.myUserData = KeyFMap.EMPTY_MAP;
            assert (this.myIds.size() >= this.myRootNodes.length);
        }
        finally {
            lock.unlock();
        }
    }

    private void add(@NotNull VirtualFile file2, @NotNull Collection<VirtualFile> newOutFiles) {
        if (file2 == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(23);
        }
        if (newOutFiles == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(24);
        }
        int fileId = TypeScriptImportGraph.getFileId(file2);
        this.myIds.put(fileId, (Object)file2);
        TypeScriptImportGraph.addEdges(this.myOutEdges, file2, newOutFiles);
        ArrayList<VirtualFile> toCheck = new ArrayList<VirtualFile>(newOutFiles.size());
        newOutFiles.forEach(el -> {
            toCheck.add((VirtualFile)el);
            TypeScriptImportGraph.addEdge(this.myInEdges, el, fileId);
        });
        this.add(toCheck, false);
    }

    @NotNull
    private static IntList getOrDefault(@NotNull Int2ObjectMap<IntList> map, int value) {
        IntList list2;
        if (map == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(25);
        }
        Object object = (list2 = (IntList)map.get(value)) == null ? IntLists.EMPTY_LIST : list2;
        if (object == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(26);
        }
        return object;
    }

    private void removeOutNodesRecursive(int fileId) {
        IntList oldOut = TypeScriptImportGraph.getOrDefault(this.myOutEdges, fileId);
        IntListIterator iterator = oldOut.iterator();
        while (iterator.hasNext()) {
            int oldDestination = iterator.nextInt();
            IntList inForOldValue = TypeScriptImportGraph.getOrDefault(this.myInEdges, oldDestination);
            int index = inForOldValue.indexOf(fileId);
            if (index == -1) {
                VirtualFile node = this.getNode(oldDestination);
                assert (node != null);
                VirtualFile fileNode = this.getNode(fileId);
                assert (fileNode != null);
                throw new IllegalStateException("Inconsistent graph in: " + fileNode.getPath() + " out: " + node.getPath());
            }
            inForOldValue.removeInt(index);
        }
        if (oldOut.size() > 0) {
            oldOut.clear();
        }
    }

    private void removeNotAvailableFromRoots() {
        Set<VirtualFile> availableFromRoot = this.getAvailableFromRoots();
        if (availableFromRoot.size() == this.myIds.size()) {
            return;
        }
        HashSet<VirtualFile> toRemove = new HashSet<VirtualFile>(this.copyAsFiles((IntCollection)this.myIds.keySet()));
        toRemove.removeAll(availableFromRoot);
        toRemove.forEach(el -> {
            int elId = TypeScriptImportGraph.getFileId(el);
            this.myOutEdges.remove(elId);
            this.myInEdges.remove(elId);
        });
        toRemove.forEach(el -> this.myIds.remove(TypeScriptImportGraph.getFileId(el)));
    }

    private void validate(@NotNull VirtualFile file2) throws IllegalArgumentException {
        if (file2 == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(27);
        }
        if (!this.myInitialized.get()) {
            throw new IllegalStateException("The graph is not initialized");
        }
        if (!this.myIds.containsKey(TypeScriptImportGraph.getFileId(file2))) {
            throw new IllegalStateException("No such node present in the graph");
        }
    }

    @Nullable
    private VirtualFile getNode(int id) {
        return (VirtualFile)this.myIds.get(id);
    }

    @NotNull
    Set<VirtualFile> getAvailableFromRoots() {
        this.initialize();
        ArrayDeque<VirtualFile> toCheck = new ArrayDeque<VirtualFile>(this.copyAsFiles(this.myRootNodes));
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
        while (!toCheck.isEmpty()) {
            VirtualFile pop = (VirtualFile)toCheck.pop();
            if (!result2.add(pop)) continue;
            IntList out = TypeScriptImportGraph.getOrDefault(this.myOutEdges, TypeScriptImportGraph.getFileId(pop));
            IntListIterator iterator = out.iterator();
            while (iterator.hasNext()) {
                int el = iterator.nextInt();
                VirtualFile node = this.getNode(el);
                if (node == null) {
                    throw new IllegalStateException("Graph is inconsistent. Out edges are missing");
                }
                toCheck.add(node);
            }
        }
        HashSet<VirtualFile> hashSet = result2;
        if (hashSet == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(28);
        }
        return hashSet;
    }

    private void add(@NotNull Collection<VirtualFile> toProcess, boolean checkCanceled) {
        if (toProcess == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(29);
        }
        ArrayDeque<VirtualFile> toCheck = new ArrayDeque<VirtualFile>(toProcess);
        while (!toCheck.isEmpty()) {
            VirtualFile file2;
            int fileId;
            if (checkCanceled) {
                ProgressManager.checkCanceled();
            }
            if (this.myIds.containsKey(fileId = TypeScriptImportGraph.getFileId(file2 = (VirtualFile)toCheck.pop()))) continue;
            this.myIds.put(fileId, (Object)file2);
            Set<VirtualFile> outFiles = this.mySearcher.getOutFiles(file2);
            TypeScriptImportGraph.addEdges(this.myOutEdges, file2, outFiles);
            outFiles.forEach(el -> {
                toCheck.add((VirtualFile)el);
                TypeScriptImportGraph.addEdge(this.myInEdges, el, fileId);
            });
        }
    }

    private static void addEdge(@NotNull Int2ObjectMap<IntList> map, @NotNull VirtualFile key, int valueId) {
        if (map == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(30);
        }
        if (key == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(31);
        }
        TypeScriptImportGraph.getOrInitMapFor(map, key).add(valueId);
    }

    @NotNull
    private static IntList getOrInitMapFor(@NotNull Int2ObjectMap<IntList> map, @NotNull VirtualFile key) {
        if (map == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(32);
        }
        if (key == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(33);
        }
        IntList intList = (IntList)map.computeIfAbsent(TypeScriptImportGraph.getFileId(key), __ -> new IntArrayList());
        if (intList == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(34);
        }
        return intList;
    }

    private static void addEdges(@NotNull Int2ObjectMap<IntList> map, @NotNull VirtualFile key, @NotNull Collection<VirtualFile> values) {
        if (map == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(35);
        }
        if (key == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(36);
        }
        if (values == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(37);
        }
        IntList arr = TypeScriptImportGraph.getOrInitMapFor(map, key);
        arr.addAll((IntList)IntArrayList.wrap((int[])values.stream().mapToInt(el -> TypeScriptImportGraph.getFileId(el)).toArray()));
    }

    private static void logStartGraphBuilding(TypeScriptFileImports references) {
        if (!TypeScriptConfigGraphCache.LOG.isTraceEnabled()) {
            return;
        }
        TypeScriptConfigGraphCache.LOG.debug("Start building tsconfig graph. Refs: " + references.hashCode());
    }

    public void resetGraph() {
        ReentrantReadWriteLock.WriteLock lock = this.myLock.writeLock();
        lock.lock();
        try {
            this.myInitialized.set(false);
            this.myIds.clear();
            this.myOutEdges.clear();
            this.myInEdges.clear();
            this.myRootNodes = null;
            this.myUserData = KeyFMap.EMPTY_MAP;
        }
        finally {
            lock.unlock();
        }
    }

    private static void logEndGraphBuilding(@NotNull TypeScriptImportGraph graph) {
        if (graph == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(38);
        }
        if (!TypeScriptConfigGraphCache.LOG.isDebugEnabled()) {
            return;
        }
        TypeScriptConfigGraphCache.LOG.debug("End building tsconfig graph");
        TypeScriptImportGraph.logGraphState(graph);
    }

    static void logStartGraphUpdating(@NotNull TypeScriptImportGraph graph, @NotNull VirtualFile file2) {
        if (graph == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(39);
        }
        if (file2 == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(40);
        }
        if (!TypeScriptConfigGraphCache.LOG.isDebugEnabled()) {
            return;
        }
        TypeScriptConfigGraphCache.LOG.debug("Start updating tsconfig graph. Source: " + file2.getName() + ". Nodes: " + graph.getNodes().size());
    }

    static void logEndGraphUpdating(@NotNull TypeScriptImportGraph graph) {
        if (graph == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(41);
        }
        if (!TypeScriptConfigGraphCache.LOG.isDebugEnabled()) {
            return;
        }
        TypeScriptConfigGraphCache.LOG.debug("End updating tsconfig graph");
        TypeScriptImportGraph.logGraphState(graph);
    }

    private static void logGraphState(@NotNull TypeScriptImportGraph graph) {
        if (graph == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(42);
        }
        if (TypeScriptConfigGraphCache.LOG.isTraceEnabled()) {
            TypeScriptConfigGraphCache.LOG.trace("Graph roots: " + graph.getRoots().size() + ", nodes: " + graph.getNodes().size() + ", available from roots: " + graph.getAvailableFromRoots().size());
        }
    }

    public static int getFileId(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(43);
        }
        if (file2 instanceof VirtualFileWithId) {
            return ((VirtualFileWithId)file2).getId();
        }
        return file2.getPath().hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 26: 
            case 28: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 26: 
            case 28: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searcher";
                break;
            }
            case 1: 
            case 3: 
            case 31: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writeLock";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 26: 
            case 28: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/tsconfig/graph/TypeScriptImportGraph";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 27: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newOutFiles";
                break;
            }
            case 25: 
            case 30: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toProcess";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 38: 
            case 39: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/graph/TypeScriptImportGraph";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "copyAsFiles";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getIn";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOut";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileImports";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueUnderLock";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrDefault";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableFromRoots";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrInitMapFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runUnderWriteLock";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractIdsForFiles";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 26: 
            case 28: 
            case 34: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyAsFiles";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "containsFile";
                break;
            }
            case 12: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "recalculateEdges";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getIn";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getOut";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getValueUnderLock";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "includesInPattern";
                break;
            }
            case 23: 
            case 24: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getOrDefault";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addEdge";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getOrInitMapFor";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "addEdges";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "logEndGraphBuilding";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "logStartGraphUpdating";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "logEndGraphUpdating";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "logGraphState";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getFileId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 26: 
            case 28: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

