/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.confusing;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.inspections.JSInspectionUiService;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class OverlyComplexArithmeticExpressionJSInspection
extends JavaScriptInspection {
    private static final int TERM_LIMIT = 6;
    public int m_limit = 6;

    private int getLimit() {
        return this.m_limit;
    }

    public JComponent createOptionsPanel() {
        return JSInspectionUiService.getInstance().createSingleIntegerFieldOptionsPanel(InspectionJSBundle.message("maximum.number.of.terms.parameter", new Object[0]), (InspectionProfileEntry)this, "m_limit");
    }

    @Override
    @InspectionMessage
    @NotNull
    protected String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("overly.complex.arithmetic.expression.error.string", new Object[0]);
        if (string == null) {
            OverlyComplexArithmeticExpressionJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/confusing/OverlyComplexArithmeticExpressionJSInspection", "buildErrorString"));
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private final Set<IElementType> arithmeticTokens = new HashSet<IElementType>(5);

        private Visitor() {
            this.arithmeticTokens.add(JSTokenTypes.PLUS);
            this.arithmeticTokens.add(JSTokenTypes.MINUS);
            this.arithmeticTokens.add(JSTokenTypes.MULT);
            this.arithmeticTokens.add(JSTokenTypes.DIV);
            this.arithmeticTokens.add(JSTokenTypes.PERC);
        }

        @Override
        public void visitJSBinaryExpression(@NotNull JSBinaryExpression expression) {
            if (expression == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitJSBinaryExpression(expression);
            this.checkExpression(expression);
        }

        @Override
        public void visitJSPrefixExpression(@NotNull JSPrefixExpression expression) {
            if (expression == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super.visitJSPrefixExpression(expression);
            this.checkExpression(expression);
        }

        @Override
        public void visitJSParenthesizedExpression(JSParenthesizedExpression expression) {
            super.visitJSParenthesizedExpression(expression);
            this.checkExpression(expression);
        }

        private void checkExpression(JSExpression expression) {
            if (this.isParentArithmetic(expression)) {
                return;
            }
            if (!this.isArithmetic(expression)) {
                return;
            }
            if (this.containsStringConcatenation(expression)) {
                return;
            }
            int numTerms = this.countTerms(expression);
            if (numTerms <= OverlyComplexArithmeticExpressionJSInspection.this.getLimit()) {
                return;
            }
            this.registerError((PsiElement)expression);
        }

        private int countTerms(JSExpression expression) {
            if (expression == null) {
                return 0;
            }
            if (!this.isArithmetic(expression)) {
                return 1;
            }
            if (expression instanceof JSBinaryExpression) {
                JSBinaryExpression binaryExpression = (JSBinaryExpression)expression;
                JSExpression lhs = binaryExpression.getLOperand();
                JSExpression rhs = binaryExpression.getROperand();
                return this.countTerms(lhs) + this.countTerms(rhs);
            }
            if (expression instanceof JSPrefixExpression) {
                JSPrefixExpression prefixExpression = (JSPrefixExpression)expression;
                JSExpression operand = prefixExpression.getExpression();
                return this.countTerms(operand);
            }
            if (expression instanceof JSParenthesizedExpression) {
                JSParenthesizedExpression parenthesizedExpression = (JSParenthesizedExpression)expression;
                JSExpression contents = parenthesizedExpression.getInnerExpression();
                return this.countTerms(contents);
            }
            return 1;
        }

        private boolean isParentArithmetic(JSExpression expression) {
            PsiElement parent = expression.getParent();
            if (!(parent instanceof JSExpression)) {
                return false;
            }
            return this.isArithmetic((JSExpression)parent);
        }

        private boolean isArithmetic(JSExpression expression) {
            if (expression instanceof JSBinaryExpression) {
                JSBinaryExpression binaryExpression = (JSBinaryExpression)expression;
                IElementType sign = binaryExpression.getOperationSign();
                return this.arithmeticTokens.contains(sign);
            }
            if (expression instanceof JSPrefixExpression) {
                JSPrefixExpression prefixExpression = (JSPrefixExpression)expression;
                IElementType sign = prefixExpression.getOperationSign();
                return this.arithmeticTokens.contains(sign);
            }
            if (expression instanceof JSParenthesizedExpression) {
                JSParenthesizedExpression parenthesizedExpression = (JSParenthesizedExpression)expression;
                JSExpression contents = parenthesizedExpression.getInnerExpression();
                return this.isArithmetic(contents);
            }
            return false;
        }

        private boolean containsStringConcatenation(JSExpression expression) {
            if (this.isStringLiteral(expression)) {
                return true;
            }
            if (expression instanceof JSBinaryExpression) {
                JSBinaryExpression binaryExpression = (JSBinaryExpression)expression;
                JSExpression lhs = binaryExpression.getLOperand();
                if (this.containsStringConcatenation(lhs)) {
                    return true;
                }
                JSExpression rhs = binaryExpression.getROperand();
                return this.containsStringConcatenation(rhs);
            }
            if (expression instanceof JSPrefixExpression) {
                JSPrefixExpression prefixExpression = (JSPrefixExpression)expression;
                IElementType sign = prefixExpression.getOperationSign();
                return this.arithmeticTokens.contains(sign);
            }
            if (expression instanceof JSParenthesizedExpression) {
                JSParenthesizedExpression parenthesizedExpression = (JSParenthesizedExpression)expression;
                JSExpression contents = parenthesizedExpression.getInnerExpression();
                return this.containsStringConcatenation(contents);
            }
            return false;
        }

        private boolean isStringLiteral(JSExpression expression) {
            JSExpression initializer;
            JSVariable variable;
            JSReferenceExpression reference;
            PsiElement referent;
            if (expression instanceof JSLiteralExpression) {
                JSLiteralExpression literal = (JSLiteralExpression)expression;
                String text = literal.getText();
                return text.startsWith("'") || text.startsWith("\"");
            }
            if (expression instanceof JSReferenceExpression && (referent = (reference = (JSReferenceExpression)expression).resolve()) instanceof JSVariable && (variable = (JSVariable)referent).isConst() && (initializer = variable.getInitializer()) != null) {
                String text = initializer.getText();
                return text.startsWith("'") || text.startsWith("\"");
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/sixrr/inspectjs/confusing/OverlyComplexArithmeticExpressionJSInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSBinaryExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSPrefixExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

