/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.utils.EquivalenceChecker;
import org.jetbrains.annotations.NotNull;

public class ConditionalExpressionWithIdenticalBranchesJSInspection
extends JavaScriptInspection
implements CleanupLocalInspectionTool {
    private final InspectionJSFix fix = new CollapseConditional();

    @Override
    @InspectionMessage
    @NotNull
    public String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("conditional.expression.with.identical.branches.error.string", new Object[0]);
        if (string == null) {
            ConditionalExpressionWithIdenticalBranchesJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return this.fix;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConditionalExpressionWithIdenticalBranchesVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/ConditionalExpressionWithIdenticalBranchesJSInspection", "buildErrorString"));
    }

    private static class ConditionalExpressionWithIdenticalBranchesVisitor
    extends BaseInspectionVisitor {
        private ConditionalExpressionWithIdenticalBranchesVisitor() {
        }

        @Override
        public void visitJSConditionalExpression(JSConditionalExpression expression) {
            super.visitJSConditionalExpression(expression);
            JSExpression thenExpression = expression.getThen();
            JSExpression elseExpression = expression.getElse();
            if (EquivalenceChecker.expressionsAreEquivalent(thenExpression, elseExpression)) {
                this.registerError((PsiElement)expression);
            }
        }
    }

    private static class CollapseConditional
    extends InspectionJSFix {
        private CollapseConditional() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("collapse.conditional.expression.fix", new Object[0]);
            if (string == null) {
                CollapseConditional.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            JSConditionalExpression expression = (JSConditionalExpression)descriptor2.getPsiElement();
            JSExpression thenExpression = expression.getThen();
            assert (thenExpression != null);
            String bodyText = thenExpression.getText();
            CollapseConditional.replaceExpression(expression, bodyText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/ConditionalExpressionWithIdenticalBranchesJSInspection$CollapseConditional", "getFamilyName"));
        }
    }
}

