/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.inspections.JSInspectionUiService;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.utils.BoolUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ForLoopReplaceableByWhileJSInspection
extends JavaScriptInspection {
    public boolean m_ignoreLoopsWithoutConditions = false;

    @Override
    @NotNull
    @InspectionMessage
    protected String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("for.loop.replaceable.by.while.problem.descriptor", new Object[0]);
        if (string == null) {
            ForLoopReplaceableByWhileJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return JSInspectionUiService.getInstance().createSingleCheckboxOptionsPanel(InspectionJSBundle.message("for.loop.replaceable.by.while.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreLoopsWithoutConditions");
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return new ReplaceForByWhileFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ForLoopReplaceableByWhileVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/ForLoopReplaceableByWhileJSInspection", "buildErrorString"));
    }

    private class ForLoopReplaceableByWhileVisitor
    extends BaseInspectionVisitor {
        private ForLoopReplaceableByWhileVisitor() {
        }

        @Override
        public void visitJSForStatement(@NotNull JSForStatement statement) {
            if (statement == null) {
                ForLoopReplaceableByWhileVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSForStatement(statement);
            JSVarStatement varStatement = statement.getVarDeclaration();
            if (varStatement != null) {
                return;
            }
            JSExpression initialization = statement.getInitialization();
            if (initialization != null) {
                return;
            }
            JSExpression update2 = statement.getUpdate();
            if (update2 != null) {
                return;
            }
            if (ForLoopReplaceableByWhileJSInspection.this.m_ignoreLoopsWithoutConditions && BoolUtils.isTrueLiteral(statement.getCondition())) {
                return;
            }
            this.registerStatementError(statement, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/control/ForLoopReplaceableByWhileJSInspection$ForLoopReplaceableByWhileVisitor", "visitJSForStatement"));
        }
    }

    private static class ReplaceForByWhileFix
    extends InspectionJSFix {
        private ReplaceForByWhileFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("for.loop.replaceable.by.while.replace.quickfix", new Object[0]);
            if (string == null) {
                ReplaceForByWhileFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement forKeywordElement = descriptor2.getPsiElement();
            JSForStatement forStatement = (JSForStatement)forKeywordElement.getParent();
            assert (forStatement != null);
            JSExpression condition = forStatement.getCondition();
            JSStatement body = forStatement.getBody();
            String bodyText = body == null ? "" : body.getText();
            String whileStatement = condition == null ? "while(true)" + bodyText : "while(" + condition.getText() + ")" + bodyText;
            ReplaceForByWhileFix.replaceStatement(forStatement, whileStatement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/ForLoopReplaceableByWhileJSInspection$ReplaceForByWhileFix", "getFamilyName"));
        }
    }
}

