/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.util.VariableAccessUtil;
import com.intellij.psi.PsiElement;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public class ForLoopThatDoesntUseLoopVariableJSInspection
extends JavaScriptInspection {
    @Override
    @NotNull
    @InspectionMessage
    public String buildErrorString(Object ... args) {
        boolean condition = (Boolean)args[0];
        boolean update2 = (Boolean)args[1];
        if (condition && update2) {
            String string = InspectionJSBundle.message("for.loop.not.use.loop.variable.problem.descriptor.both.condition.and.update", new Object[0]);
            if (string == null) {
                ForLoopThatDoesntUseLoopVariableJSInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (condition) {
            String string = InspectionJSBundle.message("for.loop.not.use.loop.variable.problem.descriptor.condition", new Object[0]);
            if (string == null) {
                ForLoopThatDoesntUseLoopVariableJSInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionJSBundle.message("for.loop.not.use.loop.variable.problem.descriptor.update", new Object[0]);
        if (string == null) {
            ForLoopThatDoesntUseLoopVariableJSInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ForLoopThatDoesntUseLoopVariableVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/ForLoopThatDoesntUseLoopVariableJSInspection", "buildErrorString"));
    }

    private static class ForLoopThatDoesntUseLoopVariableVisitor
    extends BaseInspectionVisitor {
        private ForLoopThatDoesntUseLoopVariableVisitor() {
        }

        @Override
        public void visitJSForStatement(@NotNull JSForStatement statement) {
            if (statement == null) {
                ForLoopThatDoesntUseLoopVariableVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSForStatement(statement);
            if (!JSInheritedLanguagesHelper.forConditionShouldUseVariables((PsiElement)statement)) {
                return;
            }
            if (ForLoopThatDoesntUseLoopVariableVisitor.conditionUsesInitializer(statement)) {
                if (!ForLoopThatDoesntUseLoopVariableVisitor.updateUsesInitializer(statement)) {
                    this.registerStatementError(statement, Boolean.FALSE, Boolean.TRUE);
                }
            } else if (ForLoopThatDoesntUseLoopVariableVisitor.updateUsesInitializer(statement)) {
                this.registerStatementError(statement, Boolean.TRUE, Boolean.FALSE);
            } else {
                this.registerStatementError(statement, Boolean.TRUE, Boolean.TRUE);
            }
        }

        private static boolean conditionUsesInitializer(JSForStatement statement) {
            JSExpression condition = statement.getCondition();
            if (condition == null) {
                return true;
            }
            JSVarStatement initialization = statement.getVarDeclaration();
            if (initialization == null) {
                return true;
            }
            JSVariable[] variables = initialization.getVariables();
            boolean result2 = false;
            for (JSVariable v : variables) {
                result2 |= ForLoopThatDoesntUseLoopVariableVisitor.expressionUsesVariable(condition, v);
            }
            return result2;
        }

        private static boolean updateUsesInitializer(JSForStatement statement) {
            JSExpression update2 = statement.getUpdate();
            if (update2 == null) {
                return true;
            }
            JSVarStatement initialization = statement.getVarDeclaration();
            if (initialization == null) {
                return true;
            }
            JSVariable[] variables = initialization.getVariables();
            boolean result2 = false;
            for (JSVariable v : variables) {
                result2 |= ForLoopThatDoesntUseLoopVariableVisitor.expressionUsesVariable(update2, v);
            }
            return result2;
        }

        private static boolean expressionUsesVariable(JSExpression expression, JSVariable localVar) {
            return VariableAccessUtil.isLocalVariableUsed(localVar, (PsiElement)expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/control/ForLoopThatDoesntUseLoopVariableJSInspection$ForLoopThatDoesntUseLoopVariableVisitor", "visitJSForStatement"));
        }
    }
}

